/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.List;
import mondrian.olap.Hierarchy;
import mondrian.olap.Larders;
import mondrian.olap.Level;
import mondrian.olap.OlapElementBase;
import mondrian.olap.Util;
import mondrian.resource.MondrianResource;

public abstract class LevelBase
extends OlapElementBase
implements Level {
    public final Hierarchy hierarchy;
    protected final String name;
    protected final String uniqueName;
    protected final int depth;
    protected int approxRowCount;

    protected LevelBase(Hierarchy hierarchy, String name, boolean visible, int depth) {
        assert (hierarchy != null);
        assert (name != null);
        assert (depth >= 0);
        this.hierarchy = hierarchy;
        this.name = name;
        this.visible = visible;
        this.uniqueName = Util.makeFqName(hierarchy, name);
        this.depth = depth;
    }

    public void setApproxRowCount(int approxRowCount) {
        this.approxRowCount = approxRowCount;
    }

    public String getQualifiedName() {
        return MondrianResource.instance().MdxLevelName.str(this.getUniqueName());
    }

    public String getUniqueName() {
        return this.uniqueName;
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return Larders.getDescription(this.getLarder());
    }

    public int getDepth() {
        return this.depth;
    }

    public Level getChildLevel() {
        int childDepth = this.depth + 1;
        List<? extends Level> levels = this.hierarchy.getLevelList();
        return childDepth < levels.size() ? levels.get(childDepth) : null;
    }

    public Level getParentLevel() {
        int parentDepth = this.depth - 1;
        List<? extends Level> levels = this.hierarchy.getLevelList();
        return parentDepth >= 0 ? levels.get(parentDepth) : null;
    }
}

