/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.ArrayList;
import java.util.List;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Larders;
import mondrian.olap.Level;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.resource.MondrianResource;
import mondrian.spi.MemberFormatter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class MemberBase
extends OlapElementBase
implements Member {
    protected Member parentMember;
    protected final Level level;
    protected String uniqueName;
    protected final int flags;
    public static final int FLAG_TYPE_MASK = 7;
    private static final int FLAG_HIDDEN = 8;
    public static final int FLAG_ALL = 16;
    public static final int FLAG_NULL = 32;
    public static final int FLAG_CALCULATED = 64;
    public static final int FLAG_MEASURE = 128;
    public static final Member.MemberType[] MEMBER_TYPE_VALUES = Member.MemberType.values();

    protected MemberBase(Member parentMember, Level level, Member.MemberType memberType) {
        this.parentMember = parentMember;
        this.level = level;
        this.flags = memberType.ordinal() | (memberType == Member.MemberType.ALL ? 16 : 0) | (memberType == Member.MemberType.NULL ? 32 : 0) | (this.computeCalculated(memberType) ? 64 : 0) | (level.getHierarchy().getDimension().isMeasures() ? 128 : 0);
    }

    protected MemberBase() {
        this.flags = 0;
        this.level = null;
    }

    @Override
    public String getQualifiedName() {
        return MondrianResource.instance().MdxMemberName.str(this.getUniqueName());
    }

    public abstract String getName();

    @Override
    public String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public String getCaption() {
        MemberFormatter mf = this.getLevel().getMemberFormatter();
        if (mf != null) {
            return mf.formatMember(this);
        }
        return super.getCaption();
    }

    @Override
    public String getParentUniqueName() {
        return this.parentMember == null ? null : this.parentMember.getUniqueName();
    }

    @Override
    public Dimension getDimension() {
        return this.level.getDimension();
    }

    @Override
    public Hierarchy getHierarchy() {
        return this.level.getHierarchy();
    }

    @Override
    public Level getLevel() {
        return this.level;
    }

    @Override
    public Member.MemberType getMemberType() {
        return MEMBER_TYPE_VALUES[this.flags & 7];
    }

    @Override
    public String getDescription() {
        return Larders.getDescription(this.getLarder());
    }

    @Override
    public boolean isMeasure() {
        return (this.flags & 0x80) != 0;
    }

    @Override
    public boolean isAll() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public boolean isNull() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    public boolean isCalculated() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public boolean isEvaluated() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment childName, MatchType matchType) {
        return schemaReader.lookupMemberChildByName(this, childName, matchType);
    }

    @Override
    public Member getParentMember() {
        return this.parentMember;
    }

    @Override
    public boolean isChildOrEqualTo(Member member) {
        return member != null && this.isChildOrEqualTo(member.getUniqueName());
    }

    public boolean isChildOrEqualTo(String uniqueName) {
        if (uniqueName == null) {
            return false;
        }
        return MemberBase.isChildOrEqualTo(this, uniqueName);
    }

    private static boolean isChildOrEqualTo(Member member, String uniqueName) {
        do {
            String thisUniqueName;
            if (!(thisUniqueName = member.getUniqueName()).equals(uniqueName)) continue;
            return true;
        } while ((member = member.getParentMember()) != null);
        return false;
    }

    protected boolean computeCalculated(Member.MemberType memberType) {
        return this.isCalculatedInQuery() || memberType == Member.MemberType.FORMULA;
    }

    @Override
    public int getSolveOrder() {
        return -1;
    }

    @Override
    public Exp getExpression() {
        return null;
    }

    @Override
    public List<Member> getAncestorMembers() {
        SchemaReader schemaReader = this.getDimension().getSchema().getSchemaReader();
        ArrayList<Member> ancestorList = new ArrayList<Member>();
        schemaReader.getMemberAncestors(this, ancestorList);
        return ancestorList;
    }

    @Override
    public int getOrdinal() {
        return -1;
    }

    @Override
    public Comparable getOrderKey() {
        return null;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public Member getDataMember() {
        return null;
    }

    protected Property lookupProperty(String propertyName, boolean matchCase) {
        return Property.lookup(propertyName, matchCase);
    }

    @Override
    public final Object getPropertyValue(String propertyName) {
        return this.getPropertyValue(propertyName, true);
    }

    @Override
    public final Object getPropertyValue(String propertyName, boolean matchCase) {
        Property property = this.lookupProperty(propertyName, matchCase);
        if (property == null) {
            return null;
        }
        return this.getPropertyValue(property);
    }

    @Override
    public final String getPropertyFormattedValue(String propertyName) {
        Property property = this.lookupProperty(propertyName, true);
        if (property == null) {
            return "";
        }
        return this.getPropertyFormattedValue(property);
    }

    @Override
    public String getPropertyFormattedValue(Property property) {
        return this.getPropertyValue(property).toString();
    }

    @Override
    public boolean isParentChildLeaf() {
        return false;
    }
}

