/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import mondrian.olap.Access;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Role;
import mondrian.olap.Schema;
import mondrian.olap.UnionRoleImpl;
import mondrian.olap.Util;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RoleImpl
implements Role {
    private boolean mutable = true;
    private final Map<Schema, Access> schemaGrants = new HashMap<Schema, Access>();
    private final Map<Cube, Access> cubeGrants = new HashMap<Cube, Access>();
    private final Map<Dimension, Access> dimensionGrants = new HashMap<Dimension, Access>();
    private final Map<Hierarchy, HierarchyAccessImpl> hierarchyGrants = new HashMap<Hierarchy, HierarchyAccessImpl>();

    protected RoleImpl clone() {
        RoleImpl role = new RoleImpl();
        role.mutable = this.mutable;
        role.schemaGrants.putAll(this.schemaGrants);
        role.cubeGrants.putAll(this.cubeGrants);
        role.dimensionGrants.putAll(this.dimensionGrants);
        for (Map.Entry<Hierarchy, HierarchyAccessImpl> entry : this.hierarchyGrants.entrySet()) {
            role.hierarchyGrants.put(entry.getKey(), (HierarchyAccessImpl)entry.getValue().clone());
        }
        return role;
    }

    public RoleImpl makeMutableClone() {
        RoleImpl role = this.clone();
        role.mutable = true;
        return role;
    }

    public void makeImmutable() {
        this.mutable = false;
    }

    public boolean isMutable() {
        return this.mutable;
    }

    public void grant(Schema schema, Access access) {
        assert (schema != null);
        assert (this.isMutable());
        this.schemaGrants.put(schema, access);
    }

    @Override
    public Access getAccess(Schema schema) {
        assert (schema != null);
        Access schemaAccess = this.schemaGrants.get(schema);
        if (schemaAccess == null) {
            return Access.CUSTOM;
        }
        return schemaAccess;
    }

    private static Access toAccess(Access access) {
        return access == null ? Access.NONE : access;
    }

    public void grant(Cube cube, Access access) {
        Util.assertPrecondition(cube != null, "cube != null");
        assert (access == Access.ALL || access == Access.NONE || access == Access.CUSTOM);
        Util.assertPrecondition(this.isMutable(), "isMutable()");
        this.cubeGrants.put(cube, access);
        Access schemaAccess = this.getAccess(cube.getSchema());
        if (schemaAccess == Access.NONE) {
            this.grant(cube.getSchema(), Access.CUSTOM);
        }
    }

    @Override
    public Access getAccess(Cube cube) {
        assert (cube != null);
        Access access = this.cubeGrants.get(cube);
        if (access != null) {
            return access;
        }
        access = this.schemaGrants.get(cube.getSchema());
        if (access == Access.ALL) {
            return Access.ALL;
        }
        return Access.NONE;
    }

    public void grant(Dimension dimension, Access access) {
        assert (dimension != null);
        assert (access == Access.ALL || access == Access.NONE || access == Access.CUSTOM);
        Util.assertPrecondition(this.isMutable(), "isMutable()");
        this.dimensionGrants.put(dimension, access);
    }

    @Override
    public Access getAccess(Dimension dimension) {
        assert (dimension != null);
        Access access = this.getDimensionGrant(dimension);
        if (access == Access.CUSTOM) {
            Util.deprecated("TODO Remove for Mondrian 4.0", false);
            boolean canAccess = false;
            for (Hierarchy hierarchy : dimension.getHierarchyList()) {
                HierarchyAccessImpl hierarchyAccess = this.hierarchyGrants.get(hierarchy);
                if (hierarchyAccess == null || hierarchyAccess.access == Access.NONE) continue;
                canAccess = true;
            }
            if (canAccess) {
                return Access.CUSTOM;
            }
            return Access.NONE;
        }
        if (access != null) {
            return access;
        }
        access = this.checkDimensionAccessByCubeInheritance(dimension);
        if (access != Access.NONE) {
            return access;
        }
        switch (this.getAccess(dimension.getSchema())) {
            case ALL: {
                return Access.ALL;
            }
            case ALL_DIMENSIONS: {
                if (access != Access.NONE) {
                    return Access.ALL;
                }
                return Access.NONE;
            }
        }
        return Access.NONE;
    }

    private Access getDimensionGrant(Dimension dimension) {
        if (dimension.isMeasures()) {
            for (Dimension key : this.dimensionGrants.keySet()) {
                if (key != dimension) continue;
                return this.dimensionGrants.get(key);
            }
            return null;
        }
        return this.dimensionGrants.get(dimension);
    }

    private Access checkDimensionAccessByCubeInheritance(Dimension dimension) {
        assert (!this.dimensionGrants.containsKey(dimension) || dimension.isMeasures());
        for (Map.Entry<Cube, Access> cubeGrant : this.cubeGrants.entrySet()) {
            Access access = RoleImpl.toAccess(cubeGrant.getValue());
            if (access == Access.NONE || access == Access.CUSTOM) continue;
            for (Dimension dimension2 : cubeGrant.getKey().getDimensionList()) {
                if (dimension == dimension2) {
                    return cubeGrant.getValue();
                }
                if (dimension instanceof RolapCubeDimension && dimension.equals(dimension2) && !((RolapCubeDimension)dimension2).getCube().equals(cubeGrant.getKey()) || !(cubeGrant.getKey() instanceof RolapCube) || !((RolapCube)cubeGrant.getKey()).isVirtual() || !dimension.equals(dimension2)) continue;
                return cubeGrant.getValue();
            }
        }
        return Access.NONE;
    }

    public void grant(Hierarchy hierarchy, Access access, Level topLevel, Level bottomLevel, Role.RollupPolicy rollupPolicy) {
        assert (hierarchy != null);
        assert (access != null);
        assert (access == Access.CUSTOM || topLevel == null && bottomLevel == null);
        assert (topLevel == null || topLevel.getHierarchy() == hierarchy);
        assert (bottomLevel == null || bottomLevel.getHierarchy() == hierarchy);
        assert (this.isMutable());
        assert (rollupPolicy != null);
        this.hierarchyGrants.put(hierarchy, new HierarchyAccessImpl(this, hierarchy, access, topLevel, bottomLevel, rollupPolicy));
        Access dimAccess = this.dimensionGrants.get(hierarchy.getDimension());
        if (dimAccess == Access.NONE) {
            dimAccess = Access.CUSTOM;
        }
        if (dimAccess == null && hierarchy instanceof RolapCubeHierarchy) {
            RolapCube cube = ((RolapCubeHierarchy)hierarchy).getCube();
            dimAccess = this.cubeGrants.get(cube);
        }
        if (dimAccess == null) {
            dimAccess = Access.ALL;
        }
        this.grant(hierarchy.getDimension(), dimAccess);
    }

    @Override
    public Access getAccess(Hierarchy hierarchy) {
        assert (hierarchy != null);
        HierarchyAccessImpl hierarchyAccess = this.hierarchyGrants.get(hierarchy);
        if (hierarchyAccess != null) {
            return hierarchyAccess.access;
        }
        Access access = this.getAccess(hierarchy.getDimension());
        if (access == Access.ALL) {
            return Access.ALL;
        }
        return Access.NONE;
    }

    @Override
    public Role.HierarchyAccess getAccessDetails(Hierarchy hierarchy) {
        Util.assertPrecondition(hierarchy != null, "hierarchy != null");
        if (this.hierarchyGrants.containsKey(hierarchy)) {
            return this.hierarchyGrants.get(hierarchy);
        }
        Access schemaGrant = this.schemaGrants.get(hierarchy.getDimension().getSchema());
        Access hierarchyAccess = schemaGrant != null ? (schemaGrant == Access.ALL ? Access.ALL : Access.NONE) : Access.ALL;
        return new HierarchyAccessImpl(this, hierarchy, hierarchyAccess, hierarchy.getLevelList().get(0), Util.last(hierarchy.getLevelList()), Role.RollupPolicy.HIDDEN);
    }

    @Override
    public Access getAccess(Level level) {
        assert (level != null);
        HierarchyAccessImpl hierarchyAccess = this.hierarchyGrants.get(level.getHierarchy());
        if (hierarchyAccess != null && hierarchyAccess.access != Access.NONE && RoleImpl.checkLevelIsOkWithRestrictions(hierarchyAccess, level)) {
            return hierarchyAccess.access;
        }
        return this.getAccess(level.getDimension());
    }

    private static boolean checkLevelIsOkWithRestrictions(HierarchyAccessImpl hierarchyAccess, Level level) {
        if (level.getDepth() < hierarchyAccess.topLevel.getDepth()) {
            return false;
        }
        return level.getDepth() <= hierarchyAccess.bottomLevel.getDepth();
    }

    public void grant(Member member, Access access) {
        Util.assertPrecondition(member != null, "member != null");
        assert (this.isMutable());
        assert (this.getAccess(member.getHierarchy()) == Access.CUSTOM);
        HierarchyAccessImpl hierarchyAccess = this.hierarchyGrants.get(member.getHierarchy());
        assert (hierarchyAccess != null);
        assert (hierarchyAccess.access == Access.CUSTOM);
        hierarchyAccess.grant(this, member, access);
    }

    @Override
    public Access getAccess(Member member) {
        assert (member != null);
        if (member.isCalculatedInQuery()) {
            return Access.ALL;
        }
        HierarchyAccessImpl hierarchyAccess = this.hierarchyGrants.get(member.getHierarchy());
        if (hierarchyAccess != null) {
            return hierarchyAccess.getAccess(member);
        }
        return this.getAccess(member.getLevel());
    }

    @Override
    public Access getAccess(NamedSet set) {
        Util.assertPrecondition(set != null, "set != null");
        return Access.ALL;
    }

    @Override
    public boolean canAccess(OlapElement olapElement) {
        Util.assertPrecondition(olapElement != null, "olapElement != null");
        if (olapElement instanceof Member) {
            return this.getAccess((Member)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Level) {
            return this.getAccess((Level)olapElement) != Access.NONE;
        }
        if (olapElement instanceof NamedSet) {
            return this.getAccess((NamedSet)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Hierarchy) {
            return this.getAccess((Hierarchy)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Cube) {
            return this.getAccess((Cube)olapElement) != Access.NONE;
        }
        if (olapElement instanceof Dimension) {
            return this.getAccess((Dimension)olapElement) != Access.NONE;
        }
        return false;
    }

    public static Role.HierarchyAccess createAllAccess(Hierarchy hierarchy) {
        List<? extends Level> levels = hierarchy.getLevelList();
        return new HierarchyAccessImpl(Util.createRootRole(hierarchy.getDimension().getSchema()), hierarchy, Access.ALL, levels.get(0), Util.last(levels), Role.RollupPolicy.FULL);
    }

    public static Role union(List<Role> roleList) {
        assert (roleList.size() > 0);
        return new UnionRoleImpl(roleList);
    }

    static class CachingHierarchyAccess
    extends DelegatingHierarchyAccess {
        private final Map<Member, Access> memberAccessMap = new WeakHashMap<Member, Access>();
        private Role.RollupPolicy rollupPolicy;
        private Map<Member, Boolean> inaccessibleDescendantsMap = new WeakHashMap<Member, Boolean>();
        private Integer topLevelDepth;
        private Integer bottomLevelDepth;

        public CachingHierarchyAccess(Role.HierarchyAccess hierarchyAccess) {
            super(hierarchyAccess);
        }

        public Access getAccess(Member member) {
            Access access = this.memberAccessMap.get(member);
            if (access != null) {
                return access;
            }
            access = this.hierarchyAccess.getAccess(member);
            this.memberAccessMap.put(member, access);
            return access;
        }

        public int getTopLevelDepth() {
            if (this.topLevelDepth == null) {
                this.topLevelDepth = this.hierarchyAccess.getTopLevelDepth();
            }
            return this.topLevelDepth;
        }

        public int getBottomLevelDepth() {
            if (this.bottomLevelDepth == null) {
                this.bottomLevelDepth = this.hierarchyAccess.getBottomLevelDepth();
            }
            return this.bottomLevelDepth;
        }

        public Role.RollupPolicy getRollupPolicy() {
            if (this.rollupPolicy == null) {
                this.rollupPolicy = this.hierarchyAccess.getRollupPolicy();
            }
            return this.rollupPolicy;
        }

        public boolean hasInaccessibleDescendants(Member member) {
            Boolean b = this.inaccessibleDescendantsMap.get(member);
            if (b == null) {
                b = this.hierarchyAccess.hasInaccessibleDescendants(member);
                this.inaccessibleDescendantsMap.put(member, b);
            }
            return b;
        }
    }

    public static abstract class DelegatingHierarchyAccess
    implements Role.HierarchyAccess {
        protected final Role.HierarchyAccess hierarchyAccess;

        public DelegatingHierarchyAccess(Role.HierarchyAccess hierarchyAccess) {
            assert (hierarchyAccess != null);
            this.hierarchyAccess = hierarchyAccess;
        }

        public Access getAccess(Member member) {
            return this.hierarchyAccess.getAccess(member);
        }

        public int getTopLevelDepth() {
            return this.hierarchyAccess.getTopLevelDepth();
        }

        public int getBottomLevelDepth() {
            return this.hierarchyAccess.getBottomLevelDepth();
        }

        public Role.RollupPolicy getRollupPolicy() {
            return this.hierarchyAccess.getRollupPolicy();
        }

        public boolean hasInaccessibleDescendants(Member member) {
            return this.hierarchyAccess.hasInaccessibleDescendants(member);
        }
    }

    private static class MemberAccess {
        private final Member member;
        private final Access access;
        private final Map<String, Boolean> parentsCache = new HashMap<String, Boolean>();

        public MemberAccess(Member member, Access access) {
            this.member = member;
            this.access = access;
        }

        private boolean isSubGrant(Member parentMember) {
            boolean disableCaching = MondrianProperties.instance().DisableCaching.get();
            if (!disableCaching && this.parentsCache.containsKey(parentMember.getUniqueName())) {
                return this.parentsCache.get(parentMember.getUniqueName());
            }
            boolean foundParent = false;
            for (Member m = this.member; m != null; m = m.getParentMember()) {
                if (!m.equals(parentMember)) continue;
                foundParent = true;
                break;
            }
            if (!disableCaching) {
                this.parentsCache.put(parentMember.getUniqueName(), foundParent);
            }
            return foundParent;
        }
    }

    private static class HierarchyAccessImpl
    implements Role.HierarchyAccess {
        private final Hierarchy hierarchy;
        private final Level topLevel;
        private final Access access;
        private final Level bottomLevel;
        private final Map<String, MemberAccess> memberGrants = new HashMap<String, MemberAccess>();
        private final Role.RollupPolicy rollupPolicy;
        private final Role role;

        HierarchyAccessImpl(Role role, Hierarchy hierarchy, Access access, Level topLevel, Level bottomLevel, Role.RollupPolicy rollupPolicy) {
            assert (role != null);
            assert (hierarchy != null);
            assert (access != null);
            assert (rollupPolicy != null);
            this.role = role;
            this.hierarchy = hierarchy;
            this.access = access;
            this.rollupPolicy = rollupPolicy;
            this.topLevel = topLevel == null ? hierarchy.getLevelList().get(0) : topLevel;
            this.bottomLevel = bottomLevel == null ? Util.last(hierarchy.getLevelList()) : bottomLevel;
        }

        public Role.HierarchyAccess clone() {
            HierarchyAccessImpl hierarchyAccess = new HierarchyAccessImpl(this.role, this.hierarchy, this.access, this.topLevel, this.bottomLevel, this.rollupPolicy);
            hierarchyAccess.memberGrants.putAll(this.memberGrants);
            return hierarchyAccess;
        }

        void grant(RoleImpl role, Member member, Access access) {
            MemberAccess mAccess;
            Member m;
            Util.assertTrue(member.getHierarchy() == this.hierarchy);
            Iterator<MemberAccess> memberIter = this.memberGrants.values().iterator();
            while (memberIter.hasNext()) {
                Member m2 = memberIter.next().member;
                if (!m2.isChildOrEqualTo(member)) continue;
                memberIter.remove();
            }
            this.memberGrants.put(member.getUniqueName(), new MemberAccess(member, access));
            if (access == Access.NONE) {
                for (m = member.getParentMember(); m != null; m = m.getParentMember()) {
                    Access memberAccess;
                    mAccess = this.memberGrants.get(m.getUniqueName());
                    Access access2 = memberAccess = mAccess == null ? null : mAccess.access;
                    if (memberAccess != Access.NONE || !RoleImpl.checkLevelIsOkWithRestrictions(this, m.getLevel())) continue;
                    this.memberGrants.put(m.getUniqueName(), new MemberAccess(m, Access.CUSTOM));
                }
            } else {
                for (m = member.getParentMember(); m != null; m = m.getParentMember()) {
                    Access parentAccess;
                    if (!RoleImpl.checkLevelIsOkWithRestrictions(this, m.getLevel()) || (parentAccess = RoleImpl.toAccess((mAccess = this.memberGrants.get(m.getUniqueName())) == null ? null : mAccess.access)) != Access.NONE) continue;
                    this.memberGrants.put(m.getUniqueName(), new MemberAccess(m, Access.CUSTOM));
                }
                Access hierarchyAccess = role.getAccess(member.getLevel().getHierarchy());
                if (hierarchyAccess == Access.NONE) {
                    role.grant(this.hierarchy, Access.CUSTOM, this.topLevel, this.bottomLevel, this.rollupPolicy);
                }
            }
        }

        public Access getAccess(Member member) {
            Access access;
            if (this.access != Access.CUSTOM) {
                return this.access;
            }
            MemberAccess mAccess = this.memberGrants.get(member.getUniqueName());
            Access access2 = access = mAccess == null ? null : mAccess.access;
            if (access == Access.NONE) {
                return Access.NONE;
            }
            if (access == Access.ALL || access == Access.CUSTOM) {
                return access;
            }
            if (!RoleImpl.checkLevelIsOkWithRestrictions(this, member.getLevel())) {
                return Access.NONE;
            }
            for (Member m = member.getParentMember(); m != null; m = m.getParentMember()) {
                Access parentAccess;
                MemberAccess pAccess = this.memberGrants.get(m.getUniqueName());
                Access access3 = parentAccess = pAccess == null ? null : pAccess.access;
                if (parentAccess == null) continue;
                if (parentAccess == Access.NONE || parentAccess == Access.CUSTOM) {
                    return Access.NONE;
                }
                return Access.ALL;
            }
            access = this.role.getAccess(member.getLevel());
            if (access == Access.ALL) {
                return Access.ALL;
            }
            if (this.memberGrants.size() == 0 && RoleImpl.checkLevelIsOkWithRestrictions(this, member.getLevel())) {
                return Access.ALL;
            }
            return Access.NONE;
        }

        public final int getTopLevelDepth() {
            return this.topLevel.getDepth();
        }

        public final int getBottomLevelDepth() {
            return this.bottomLevel.getDepth();
        }

        public Role.RollupPolicy getRollupPolicy() {
            return this.rollupPolicy;
        }

        public boolean hasInaccessibleDescendants(Member member) {
            for (MemberAccess access : this.memberGrants.values()) {
                switch (access.access) {
                    case NONE: 
                    case CUSTOM: {
                        if (!access.isSubGrant(member)) break;
                        return true;
                    }
                }
            }
            return false;
        }
    }
}

