/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.SchemaReader;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.MultiResolver;
import mondrian.olap.fun.Resolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.Type;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class AddCalculatedMembersFunDef
extends FunDefBase {
    private static final AddCalculatedMembersFunDef instance = new AddCalculatedMembersFunDef();
    public static final Resolver resolver = new ResolverImpl();
    private static final String FLAG = "fxx";

    private AddCalculatedMembersFunDef() {
        super("AddCalculatedMembers", "Adds calculated members to a set.", FLAG);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        return new AbstractListCalc(call, new Calc[]{listCalc}){

            public TupleList evaluateList(Evaluator evaluator) {
                TupleList list = listCalc.evaluateList(evaluator);
                return new UnaryTupleList(AddCalculatedMembersFunDef.this.addCalculatedMembers(list.slice(0), evaluator));
            }
        };
    }

    private List<Member> addCalculatedMembers(List<Member> memberList, Evaluator evaluator) {
        LinkedHashSet<Level> levels = new LinkedHashSet<Level>();
        Hierarchy hierarchy = null;
        for (Member member : memberList) {
            if (hierarchy == null) {
                hierarchy = member.getHierarchy();
            } else if (hierarchy != member.getHierarchy()) {
                throw AddCalculatedMembersFunDef.newEvalException(this, "Only members from the same hierarchy are allowed in the AddCalculatedMembers set: " + hierarchy + " vs " + member.getHierarchy());
            }
            levels.add(member.getLevel());
        }
        ArrayList<Member> workingList = new ArrayList<Member>(memberList);
        SchemaReader schemaReader = evaluator.getQuery().getSchemaReader(true);
        for (Level level : levels) {
            List<Member> calcMemberList = schemaReader.getCalculatedMembers(level);
            workingList.addAll(calcMemberList);
        }
        return workingList;
    }

    private static class ResolverImpl
    extends MultiResolver {
        public ResolverImpl() {
            super(instance.getName(), instance.getSignature(), instance.getDescription(), new String[]{AddCalculatedMembersFunDef.FLAG});
        }

        protected FunDef createFunDef(Exp[] args, FunDef dummyFunDef) {
            Exp arg;
            Type type1;
            if (args.length == 1 && (type1 = (arg = args[0]).getType()) instanceof SetType) {
                SetType type = (SetType)type1;
                if (type.getElementType() instanceof MemberType) {
                    return instance;
                }
                throw ResolverImpl.newEvalException(instance, "Only single dimension members allowed in set for AddCalculatedMembers");
            }
            return null;
        }
    }
}

