/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import java.util.ArrayList;
import java.util.List;
import mondrian.calc.Calc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleCollections;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.Member;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;
import mondrian.olap.fun.Resolver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class ExistsFunDef
extends FunDefBase {
    static final Resolver resolver = new ReflectiveMultiResolver("Exists", "Exists(<Set1>, <Set2>])", "Returns the the set of tuples of the first set that exist with one or more tuples of the second set.", new String[]{"fxxx"}, ExistsFunDef.class);

    public ExistsFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    @Override
    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc1 = compiler.compileList(call.getArg(0));
        final ListCalc listCalc2 = compiler.compileList(call.getArg(1));
        return new AbstractListCalc(call, new Calc[]{listCalc1, listCalc2}){

            public TupleList evaluateList(Evaluator evaluator) {
                TupleList leftTuples = listCalc1.evaluateList(evaluator);
                if (leftTuples.isEmpty()) {
                    return TupleCollections.emptyList(leftTuples.getArity());
                }
                TupleList rightTuples = listCalc2.evaluateList(evaluator);
                if (rightTuples.isEmpty()) {
                    return TupleCollections.emptyList(leftTuples.getArity());
                }
                TupleList result = TupleCollections.createList(leftTuples.getArity());
                List leftDims = ExistsFunDef.getHierarchies((List)leftTuples.get(0));
                List rightDims = ExistsFunDef.getHierarchies((List)rightTuples.get(0));
                block0: for (List leftTuple : leftTuples) {
                    for (List rightTuple : rightTuples) {
                        if (!ExistsFunDef.this.existsInTuple(leftTuple, rightTuple, leftDims, rightDims)) continue;
                        result.add(leftTuple);
                        continue block0;
                    }
                }
                return result;
            }
        };
    }

    private static boolean isOnSameHierarchyChain(Member mA, Member mB) {
        return FunUtil.isAncestorOf(mA, mB, false) || FunUtil.isAncestorOf(mB, mA, false);
    }

    private boolean existsInTuple(List<Member> leftTuple, List<Member> rightTuple, List<Hierarchy> leftHierarchies, List<Hierarchy> rightHierarchies) {
        ArrayList<Member> checkedMembers = new ArrayList<Member>();
        for (Member leftMember : leftTuple) {
            Member rightMember = this.getCorrespondingMember(leftMember, rightTuple, rightHierarchies);
            checkedMembers.add(rightMember);
            if (ExistsFunDef.isOnSameHierarchyChain(leftMember, rightMember)) continue;
            return false;
        }
        for (Member rightMember : rightTuple) {
            Member leftMember;
            if (checkedMembers.contains(rightMember) || ExistsFunDef.isOnSameHierarchyChain(leftMember = this.getCorrespondingMember(rightMember, leftTuple, leftHierarchies), rightMember)) continue;
            return false;
        }
        return true;
    }

    private Member getCorrespondingMember(Member member, List<Member> tuple, List<Hierarchy> tupleHierarchies) {
        assert (tuple.size() == tupleHierarchies.size());
        int dimPos = tupleHierarchies.indexOf(member.getHierarchy());
        if (dimPos >= 0) {
            return tuple.get(dimPos);
        }
        return member.getHierarchy().getDefaultMember();
    }

    private static List<Hierarchy> getHierarchies(List<Member> members) {
        ArrayList<Hierarchy> hierarchies = new ArrayList<Hierarchy>();
        for (Member member : members) {
            hierarchies.add(member.getHierarchy());
        }
        return hierarchies;
    }
}

