/*
 * Decompiled with CFR 0.152.
 */
package mondrian.olap.fun;

import mondrian.calc.Calc;
import mondrian.calc.DoubleCalc;
import mondrian.calc.ExpCompiler;
import mondrian.calc.ListCalc;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractDoubleCalc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Evaluator;
import mondrian.olap.FunDef;
import mondrian.olap.Hierarchy;
import mondrian.olap.fun.AbstractAggregateFunDef;
import mondrian.olap.fun.FunUtil;
import mondrian.olap.fun.ReflectiveMultiResolver;

class PercentileFunDef
extends AbstractAggregateFunDef {
    static final ReflectiveMultiResolver Resolver = new ReflectiveMultiResolver("Percentile", "Percentile(<Set>, <Numeric Expression>, <Percent>)", "Returns the value of the tuple that is at a given percentile of a set.", new String[]{"fnxnn"}, PercentileFunDef.class);

    public PercentileFunDef(FunDef dummyFunDef) {
        super(dummyFunDef);
    }

    public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
        final ListCalc listCalc = compiler.compileList(call.getArg(0));
        final Calc calc = compiler.compileScalar(call.getArg(1), true);
        final DoubleCalc percentCalc = compiler.compileDouble(call.getArg(2));
        return new AbstractDoubleCalc(call, new Calc[]{listCalc, calc, percentCalc}){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public double evaluateDouble(Evaluator evaluator) {
                TupleList list = AbstractAggregateFunDef.evaluateCurrentList(listCalc, evaluator);
                double percent = percentCalc.evaluateDouble(evaluator) * 0.01;
                int savepoint = evaluator.savepoint();
                try {
                    double percentile;
                    evaluator.setNonEmpty(false);
                    double d = percentile = FunUtil.percentile(evaluator, list, calc, percent);
                    return d;
                }
                finally {
                    evaluator.restore(savepoint);
                }
            }

            public boolean dependsOn(Hierarchy hierarchy) {
                return 1.anyDependsButFirst(this.getCalcs(), hierarchy);
            }
        };
    }
}

