/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.sql.DataSource;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianException;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaLoader;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.TimeColumnRole;
import mondrian.server.Execution;
import mondrian.server.Locus;
import mondrian.spi.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DateTableBuilder
implements RolapSchema.PhysTable.Hook {
    private final Map<String, TimeColumnRole.Struct> columnRoleMap;
    private final List<MondrianDef.RealOrCalcColumnDef> xmlColumnDefs;
    private final Date startDate;
    private final Date endDate;

    DateTableBuilder(Map<String, TimeColumnRole.Struct> columnRoleMap, List<MondrianDef.RealOrCalcColumnDef> xmlColumnDefs, Date startDate, Date endDate) {
        this.columnRoleMap = columnRoleMap;
        this.xmlColumnDefs = xmlColumnDefs;
        this.startDate = startDate;
        this.endDate = endDate;
    }

    @Override
    public boolean apply(RolapSchema.PhysTable table, RolapConnection connection) {
        boolean tableExists = this.tableExists(connection, table);
        if (tableExists) {
            return false;
        }
        DataSource dataSource = connection.getDataSource();
        Dialect dialect = connection.getSchema().getDialect();
        String ddl = this.generateDdl(table, dialect);
        this.createTable(dataSource, ddl);
        String insert = this.generateInsert(table.schemaName, table.name, dialect, this.xmlColumnDefs.size());
        this.populateTable(table, dataSource, insert);
        return true;
    }

    private String generateInsert(String schemaName, String name, Dialect dialect, int columnCount) {
        StringBuilder buf = new StringBuilder();
        buf.append("INSERT INTO ");
        dialect.quoteIdentifier(buf, schemaName, name);
        buf.append(" VALUES (");
        for (int i = 0; i < columnCount; ++i) {
            if (i > 0) {
                buf.append(", ");
            }
            buf.append("?");
        }
        buf.append(")");
        return buf.toString();
    }

    private void createTable(DataSource dataSource, String ddl) {
        Connection connection = null;
        Statement statement = null;
        try {
            connection = dataSource.getConnection();
            statement = connection.createStatement();
            statement.executeUpdate(ddl);
        }
        catch (SQLException e) {
            throw Util.newError(e, "Error while creating date dimension table; DDL=[" + ddl + "]");
        }
        finally {
            Util.close(null, statement, connection);
        }
    }

    private void populateTable(RolapSchema.PhysTable table, DataSource dataSource, String insert) {
        Connection connection = null;
        PreparedStatement pstmt = null;
        try {
            connection = dataSource.getConnection();
            pstmt = connection.prepareStatement(insert);
            ArrayList<TimeColumnRole.Struct> roles = new ArrayList<TimeColumnRole.Struct>();
            for (MondrianDef.RealOrCalcColumnDef xmlColumnDef : this.xmlColumnDefs) {
                roles.add(this.columnRoleMap.get(xmlColumnDef.name));
            }
            DateTableBuilder.populate(roles, pstmt, this.startDate, this.endDate, Locale.getDefault());
        }
        catch (SQLException e) {
            try {
                throw Util.newError(e, "Error while creating date dimension table; DDL=[" + insert + "]");
            }
            catch (Throwable throwable) {
                Util.close(null, pstmt, connection);
                throw throwable;
            }
        }
        Util.close(null, pstmt, connection);
    }

    public static void populate(List<TimeColumnRole.Struct> roles, PreparedStatement pstmt, Date startDate, Date endDate, Locale locale) throws SQLException {
        Object[] states = new Object[roles.size() + 1];
        for (int j = 0; j < roles.size(); ++j) {
            states[j + 1] = roles.get(j).initialize(locale);
        }
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(startDate);
        while (calendar.getTime().compareTo(endDate) < 0) {
            int rolesSize = roles.size();
            for (int i = 0; i < rolesSize; ++i) {
                TimeColumnRole.Struct role = roles.get(i);
                role.bind(states, i + 1, calendar, pstmt);
            }
            pstmt.execute();
            calendar.add(5, 1);
        }
    }

    private String generateDdl(RolapSchema.PhysTable table, Dialect dialect) {
        StringBuilder buf = new StringBuilder();
        buf.append("CREATE TABLE ");
        dialect.quoteIdentifier(buf, table.schemaName, table.name);
        buf.append(" (\n");
        int i = 0;
        RolapSchema.PhysKey primaryKey = (RolapSchema.PhysKey)table.keysByName.get("primary");
        String singletonKey = primaryKey != null && primaryKey.columnList.size() == 1 ? primaryKey.columnList.get((int)0).name : null;
        for (MondrianDef.RealOrCalcColumnDef xmlColumnDef : this.xmlColumnDefs) {
            if (i++ > 0) {
                buf.append(",\n");
            }
            buf.append("    ");
            dialect.quoteIdentifier(buf, xmlColumnDef.name);
            buf.append(" ");
            buf.append(dialect.datatypeToString(RolapSchemaLoader.toType(xmlColumnDef.type), 20, 0));
            buf.append(" NOT NULL");
            if (!xmlColumnDef.name.equals(singletonKey)) continue;
            buf.append(" PRIMARY KEY");
        }
        buf.append(")");
        return buf.toString();
    }

    private boolean tableExists(RolapConnection connection, RolapSchema.PhysTable table) {
        DataSource dataSource = connection.getDataSource();
        Dialect dialect = connection.getSchema().getDialect();
        StringBuilder buf = new StringBuilder();
        buf.append("select count(*) from ");
        dialect.quoteIdentifier(buf, table.schemaName, table.name);
        SqlStatement sqlStatement = null;
        try {
            sqlStatement = RolapUtil.executeQuery(dataSource, buf.toString(), new Locus(new Execution(connection.getInternalStatement(), 0L), "Auto-create date table: existence check", null));
            ResultSet resultSet = sqlStatement.getResultSet();
            if (resultSet.next()) {
                int n = resultSet.getInt(1);
            }
            resultSet.close();
            boolean bl = true;
            return bl;
        }
        catch (SQLException e) {
            throw Util.newError(e, "While validating auto-create table");
        }
        catch (MondrianException e) {
            if (e.getCause() instanceof SQLException) {
                boolean bl = false;
                return bl;
            }
            throw e;
        }
        finally {
            if (sqlStatement != null) {
                sqlStatement.close();
            }
        }
    }
}

