/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.CacheControl;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Member;
import mondrian.olap.OlapElement;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.VisualTotalsFunDef;
import mondrian.resource.MondrianResource;
import mondrian.rolap.BitKey;
import mondrian.rolap.CacheControlImpl;
import mondrian.rolap.CellReader;
import mondrian.rolap.RestrictedMemberReader;
import mondrian.rolap.RolapCacheRegion;
import mondrian.rolap.RolapCell;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.CellRequest;
import mondrian.rolap.agg.DrillThroughCellRequest;
import mondrian.rolap.agg.PredicateColumn;
import mondrian.rolap.agg.Predicates;
import mondrian.rolap.agg.ValueColumnPredicate;
import mondrian.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class RolapAggregationManager {
    protected RolapAggregationManager() {
    }

    public static CellRequest makeRequest(Member[] members) {
        return RolapAggregationManager.makeCellRequest(members, false, false, null, null, null);
    }

    public static DrillThroughCellRequest makeDrillThroughRequest(List<RolapMember> members, boolean extendedContext, RolapCube cube, List<Exp> fieldsList) {
        assert (cube != null);
        return (DrillThroughCellRequest)RolapAggregationManager.makeCellRequest(members, true, extendedContext, cube, fieldsList, null);
    }

    public static CellRequest makeRequest(RolapEvaluator evaluator) {
        Member[] currentMembers = evaluator.getNonAllMembers();
        List<List<List<Member>>> aggregationLists = evaluator.getAggregationLists();
        RolapStoredMeasure measure = (RolapStoredMeasure)((Object)currentMembers[0]);
        RolapStar.Measure starMeasure = measure.getStarMeasure();
        assert (starMeasure != null);
        RolapStar star = starMeasure.getStar();
        int starColumnCount = star.getColumnCount();
        CellRequest request = RolapAggregationManager.makeCellRequest(currentMembers, false, false, null, null, (Evaluator)evaluator);
        if (aggregationLists == null) {
            return request;
        }
        for (List<List<Member>> aggregationList : aggregationLists) {
            BitKey compoundBitKey = BitKey.Factory.makeBitKey(starColumnCount);
            LinkedHashMap<BitKey, List<RolapMember[]>> compoundGroupMap = new LinkedHashMap<BitKey, List<RolapMember[]>>();
            ArrayList<List<RolapMember>> rolapAggregationList = new ArrayList<List<RolapMember>>();
            for (List<Member> members : aggregationList) {
                List rolapMembers = Util.cast(members);
                rolapAggregationList.add(rolapMembers);
            }
            RolapMeasureGroup measureGroup = measure.getMeasureGroup();
            boolean unsatisfiable = RolapAggregationManager.makeCompoundGroup(starColumnCount, measureGroup, rolapAggregationList, compoundGroupMap);
            if (unsatisfiable) {
                return null;
            }
            StarPredicate compoundPredicate = RolapAggregationManager.makeCompoundPredicate(compoundGroupMap, measureGroup);
            if (compoundPredicate == null) continue;
            for (BitKey bitKey : compoundGroupMap.keySet()) {
                compoundBitKey = compoundBitKey.or(bitKey);
            }
            request.addAggregateList(compoundBitKey, compoundPredicate);
        }
        return request;
    }

    private static CellRequest makeCellRequest(Member[] members, boolean drillThrough, boolean extendedContext, RolapCube cube, List<Exp> fieldsList, Evaluator evaluator) {
        ArrayList<Member> rolapMembers = new ArrayList<Member>(Arrays.asList(members));
        return RolapAggregationManager.makeCellRequest(rolapMembers, drillThrough, extendedContext, cube, fieldsList, evaluator);
    }

    private static CellRequest makeCellRequest(List<RolapMember> memberList, boolean drillThrough, boolean extendedContext, RolapCube cube, List<Exp> fieldsList, Evaluator evaluator) {
        RolapStoredMeasure measure;
        assert (drillThrough == (cube != null));
        if (extendedContext) assert (drillThrough);
        if (drillThrough) {
            if ((cube = RolapCell.chooseDrillThroughCube(memberList, cube)) == null) {
                return null;
            }
            measure = memberList.size() > 0 && memberList.get(0) instanceof RolapStoredMeasure ? (RolapStoredMeasure)((Object)memberList.get(0)) : (RolapStoredMeasure)cube.getMeasures().get(0);
        } else if (memberList.size() > 0 && memberList.get(0) instanceof RolapStoredMeasure) {
            measure = (RolapStoredMeasure)((Object)memberList.get(0));
        } else {
            return null;
        }
        RolapMeasureGroup measureGroup = measure.getMeasureGroup();
        RolapStar.Measure starMeasure = measure.getStarMeasure();
        assert (starMeasure != null);
        if (drillThrough) {
            DrillThroughCellRequest request = new DrillThroughCellRequest(starMeasure, extendedContext);
            if (fieldsList != null && fieldsList.size() > 0) {
                SchemaReader reader = cube.getSchemaReader().withLocus();
                for (Exp exp : fieldsList) {
                    OlapElement member = reader.lookupCompound(cube, Util.parseIdentifier(exp.toString()), false, 0);
                    if (member == null) {
                        throw MondrianResource.instance().DrillthroughUnknownMemberInReturnClause.ex(exp.toString());
                    }
                    RolapAggregationManager.addDrillthroughColumn(member, measureGroup, request);
                }
            }
            Collections.sort(memberList, new CubeOrderedMemberLevelComparator(cube.getDimensionList()));
            for (RolapMember member : memberList) {
                if (member.getHierarchy().getRolapHierarchy().closureFor != null) continue;
                RolapCubeLevel level = member.getLevel();
                boolean needToReturnNull = level.getLevelReader().constrainRequest(member, measureGroup, request);
                if (needToReturnNull) {
                    return null;
                }
                if (fieldsList != null && fieldsList.size() != 0) continue;
                if (member.getDimension().isMeasures()) {
                    if (member.isCalculated()) continue;
                    request.addDrillThroughMeasure(((RolapStoredMeasure)((Object)member)).getStarMeasure(), member.getName());
                    continue;
                }
                if (level.isAll()) continue;
                RolapAggregationManager.addNonConstrainingColumns(level, measureGroup, request);
                if (!extendedContext) continue;
                while (level.getChildLevel() != null) {
                    level = level.getChildLevel();
                    RolapAggregationManager.addNonConstrainingColumns(level, measureGroup, request);
                }
            }
            return request;
        }
        CellRequest request = new CellRequest(starMeasure, extendedContext, drillThrough);
        for (RolapMember member : Util.subList(memberList, 1)) {
            RolapCubeLevel level;
            boolean needToReturnNull;
            if (member instanceof RestrictedMemberReader.MultiCardinalityDefaultMember || !(needToReturnNull = (level = member.getLevel()).getLevelReader().constrainRequest(member, measureGroup, request)) || evaluator != null && evaluator.mightReturnNullForUnrelatedDimension() && !evaluator.needToReturnNullForUnrelatedDimension(new Member[]{member})) continue;
            return null;
        }
        return request;
    }

    private static void addNonConstrainingColumns(RolapCubeLevel level, RolapMeasureGroup measureGroup, CellRequest request) {
        ArrayList<RolapCubeLevel> levels = new ArrayList<RolapCubeLevel>();
        if (request.extendedContext) {
            do {
                levels.add(level);
            } while ((level = level.getChildLevel()) != null);
        } else {
            levels.add(level);
        }
        for (RolapCubeLevel currentLevel : levels) {
            for (RolapSchema.PhysColumn column : currentLevel.attribute.getKeyList()) {
                RolapStar.Column starColumn = measureGroup.getRolapStarColumn(currentLevel.cubeDimension, column);
                if (starColumn != null) {
                    request.addConstrainedColumn(starColumn, null);
                }
                if (!(request instanceof DrillThroughCellRequest)) continue;
                ((DrillThroughCellRequest)request).addDrillThroughColumn(starColumn, currentLevel.getName());
            }
        }
    }

    private static void addDrillthroughColumn(OlapElement element, RolapMeasureGroup measureGroup, DrillThroughCellRequest request) {
        RolapCubeHierarchy hierarchy;
        RolapCubeLevel level;
        if (element.getDimension().isMeasures()) {
            request.addDrillThroughMeasure(((RolapStoredMeasure)element).getStarMeasure(), element.getName());
            return;
        }
        if (element instanceof RolapCubeLevel) {
            level = (RolapCubeLevel)element;
        } else if (element instanceof RolapCubeDimension) {
            hierarchy = (RolapCubeHierarchy)element.getHierarchy();
            level = hierarchy.getLevelList().get(0).isAll() ? hierarchy.getLevelList().get(1) : hierarchy.getLevelList().get(0);
        } else if (element instanceof RolapCubeHierarchy) {
            hierarchy = (RolapCubeHierarchy)element;
            level = hierarchy.getLevelList().get(0).isAll() ? hierarchy.getLevelList().get(1) : hierarchy.getLevelList().get(0);
        } else if (element instanceof RolapMember) {
            level = ((RolapMember)element).getLevel();
        } else {
            throw MondrianResource.instance().DrillthroughInvalidMemberInReturnClause.ex(element.getUniqueName(), element.getClass().getName());
        }
        if (level.getHierarchy().closureFor != null) {
            return;
        }
        for (RolapSchema.PhysColumn column : level.attribute.getKeyList()) {
            RolapStar.Column starColumn = measureGroup.getRolapStarColumn(level.cubeDimension, column);
            if (starColumn == null) continue;
            request.addConstrainedColumn(starColumn, null);
            request.addDrillThroughColumn(starColumn, level.getName());
        }
    }

    private static boolean makeCompoundGroup(int starColumnCount, RolapMeasureGroup measureGroup, List<List<RolapMember>> aggregationList, Map<BitKey, List<RolapMember[]>> compoundGroupMap) {
        int unsatisfiableTupleCount = 0;
        for (List<RolapMember> aggregation : aggregationList) {
            if (aggregation.size() == 0) {
                ++unsatisfiableTupleCount;
                continue;
            }
            BitKey bitKey = BitKey.Factory.makeBitKey(starColumnCount);
            RolapMember[] tuple = new RolapMember[aggregation.size()];
            int i = 0;
            for (RolapMember member : aggregation) {
                tuple[i] = member instanceof VisualTotalsFunDef.VisualTotalMember ? ((VisualTotalsFunDef.VisualTotalMember)member).getMember() : member;
                ++i;
            }
            boolean tupleUnsatisfiable = false;
            for (RolapMember member : tuple) {
                tupleUnsatisfiable = RolapAggregationManager.makeCompoundGroupForMember(member, measureGroup, bitKey);
                if (!tupleUnsatisfiable) continue;
                ++unsatisfiableTupleCount;
                break;
            }
            if (tupleUnsatisfiable || bitKey.isEmpty()) continue;
            RolapAggregationManager.addTupleToCompoundGroupMap(tuple, bitKey, compoundGroupMap);
        }
        return unsatisfiableTupleCount == aggregationList.size();
    }

    private static void addTupleToCompoundGroupMap(RolapMember[] tuple, BitKey bitKey, Map<BitKey, List<RolapMember[]>> compoundGroupMap) {
        List<RolapMember[]> compoundGroup = compoundGroupMap.get(bitKey);
        if (compoundGroup == null) {
            compoundGroup = new ArrayList<RolapMember[]>();
            compoundGroupMap.put(bitKey, compoundGroup);
        }
        compoundGroup.add(tuple);
    }

    private static boolean makeCompoundGroupForMember(RolapMember member, RolapMeasureGroup measureGroup, BitKey bitKey) {
        assert (measureGroup != null);
        RolapCubeLevel level = member.getLevel();
        for (RolapSchema.PhysColumn key : level.getAttribute().getKeyList()) {
            RolapStar.Column column = measureGroup.getRolapStarColumn(level.getDimension(), key);
            if (column == null) {
                return true;
            }
            bitKey.set(column.getBitPosition());
        }
        return false;
    }

    static StarPredicate makeCompoundPredicate(Map<BitKey, List<RolapMember[]>> compoundGroupMap, RolapMeasureGroup measureGroup) {
        ArrayList<StarPredicate> compoundPredicateList = new ArrayList<StarPredicate>();
        ArrayList<RolapSchema.PhysRouter> routers = new ArrayList<RolapSchema.PhysRouter>();
        int count = -1;
        for (List<RolapMember[]> group : compoundGroupMap.values()) {
            ++count;
            StarPredicate compoundGroupPredicate = null;
            for (RolapMember[] tuple : group) {
                StarPredicate tuplePredicate = null;
                for (int i = 0; i < tuple.length; ++i) {
                    RolapSchema.PhysRouter router;
                    RolapMember member = tuple[i];
                    if (count == 0) {
                        router = new RolapSchema.CubeRouter(measureGroup, member.getDimension());
                        routers.add(router);
                    } else {
                        router = (RolapSchema.PhysRouter)routers.get(i);
                    }
                    tuplePredicate = RolapAggregationManager.makeCompoundPredicateForMember(router, member, tuplePredicate);
                }
                if (tuplePredicate == null) continue;
                if (compoundGroupPredicate == null) {
                    compoundGroupPredicate = tuplePredicate;
                    continue;
                }
                compoundGroupPredicate = compoundGroupPredicate.or(tuplePredicate);
            }
            if (compoundGroupPredicate == null) continue;
            compoundPredicateList.add(compoundGroupPredicate);
        }
        return Predicates.or(compoundPredicateList);
    }

    private static StarPredicate makeCompoundPredicateForMember(RolapSchema.PhysRouter router, RolapMember member, StarPredicate memberPredicate) {
        RolapCubeLevel level = member.getLevel();
        List<RolapSchema.PhysColumn> keyList = level.attribute.getKeyList();
        List<Comparable> valueList = member.getKeyAsList();
        for (Pair<RolapSchema.PhysColumn, Comparable> pair : Pair.iterate(keyList, valueList)) {
            ValueColumnPredicate predicate = new ValueColumnPredicate(new PredicateColumn(router, (RolapSchema.PhysColumn)pair.left), (Comparable)pair.right);
            if (memberPredicate == null) {
                memberPredicate = predicate;
                continue;
            }
            memberPredicate = memberPredicate.and(predicate);
        }
        return memberPredicate;
    }

    public abstract Object getCellFromCache(CellRequest var1);

    public abstract Object getCellFromCache(CellRequest var1, PinSet var2);

    public abstract String getDrillThroughSql(DrillThroughCellRequest var1, StarPredicate var2, List<Exp> var3, boolean var4);

    public static RolapCacheRegion makeCacheRegion(RolapMeasureGroup measureGroup, CacheControl.CellRegion region) {
        Util.deprecated("not used -- remove", true);
        List<Member> measureList = CacheControlImpl.findMeasures(region);
        ArrayList<RolapStar.Measure> starMeasureList = new ArrayList<RolapStar.Measure>();
        RolapStar star = measureGroup.getStar();
        for (Member measure : measureList) {
            if (!(measure instanceof RolapStoredMeasure)) continue;
            RolapStoredMeasure storedMeasure = (RolapStoredMeasure)measure;
            RolapStar.Measure starMeasure = storedMeasure.getStarMeasure();
            assert (starMeasure != null);
            if (star != starMeasure.getStar()) continue;
            assert (measureGroup == storedMeasure.getMeasureGroup());
            starMeasureList.add(starMeasure);
        }
        RolapCacheRegion cacheRegion = new RolapCacheRegion(star, starMeasureList);
        if (region instanceof CacheControlImpl.CrossjoinCellRegion) {
            CacheControlImpl.CrossjoinCellRegion crossjoin = (CacheControlImpl.CrossjoinCellRegion)region;
            for (CacheControl.CellRegion component : crossjoin.getComponents()) {
                RolapAggregationManager.constrainCacheRegion(cacheRegion, measureGroup, component);
            }
        } else {
            RolapAggregationManager.constrainCacheRegion(cacheRegion, measureGroup, region);
        }
        return cacheRegion;
    }

    private static void constrainCacheRegion(RolapCacheRegion cacheRegion, RolapMeasureGroup measureGroup, CacheControl.CellRegion region) {
        if (region instanceof CacheControlImpl.MemberCellRegion) {
            CacheControlImpl.MemberCellRegion memberCellRegion = (CacheControlImpl.MemberCellRegion)region;
            List<Member> memberList = memberCellRegion.getMemberList();
            for (Member member : memberList) {
                if (member.isMeasure()) continue;
                RolapMember rolapMember = (RolapMember)member;
                rolapMember.getLevel().getLevelReader().constrainRegion(Predicates.memberPredicate(new RolapSchema.CubeRouter(measureGroup, rolapMember.getDimension()), rolapMember), measureGroup, cacheRegion);
            }
        } else if (region instanceof CacheControlImpl.MemberRangeCellRegion) {
            CacheControlImpl.MemberRangeCellRegion rangeRegion = (CacheControlImpl.MemberRangeCellRegion)region;
            RolapCubeLevel level = (RolapCubeLevel)rangeRegion.getLevel();
            level.getLevelReader().constrainRegion(Predicates.rangePredicate(new RolapSchema.CubeRouter(measureGroup, level.cubeDimension), rangeRegion.getLowerInclusive(), rangeRegion.getLowerBound(), rangeRegion.getUpperInclusive(), rangeRegion.getUpperBound()), measureGroup, cacheRegion);
        } else {
            throw new UnsupportedOperationException();
        }
    }

    public CellReader getCacheCellReader() {
        return new CellReader(){

            public Object get(RolapEvaluator evaluator) {
                CellRequest request = RolapAggregationManager.makeRequest(evaluator);
                if (request == null || request.isUnsatisfiable()) {
                    return Util.nullValue;
                }
                return RolapAggregationManager.this.getCellFromCache(request);
            }

            public int getMissCount() {
                return 0;
            }

            public boolean isDirty() {
                return false;
            }
        };
    }

    public abstract PinSet createPinSet();

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CubeOrderedMemberLevelComparator
    implements Comparator<Member> {
        private final List<RolapCubeLevel> orderedLevels = new ArrayList<RolapCubeLevel>();

        public CubeOrderedMemberLevelComparator(List<? extends RolapCubeDimension> dimList) {
            for (RolapCubeDimension rolapCubeDimension : dimList) {
                for (RolapCubeHierarchy hier : rolapCubeDimension.getHierarchyList()) {
                    this.orderedLevels.addAll(hier.getLevelList());
                }
            }
        }

        @Override
        public int compare(Member o1, Member o2) {
            return this.orderedLevels.indexOf(o1.getLevel()) - this.orderedLevels.indexOf(o2.getLevel());
        }
    }

    public static interface PinSet {
    }
}

