/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapStar;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.Predicates;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapCacheRegion {
    private final RolapStar star;
    private final BitKey bitKey;
    private Map<BitKey, StarPredicate> predicates = new HashMap<BitKey, StarPredicate>();

    public RolapCacheRegion(RolapStar star, List<RolapStar.Measure> starMeasureList) {
        this.star = star;
        this.bitKey = BitKey.Factory.makeBitKey(star.getColumnCount());
        for (RolapStar.Measure measure : starMeasureList) {
            this.bitKey.set(measure.getBitPosition());
        }
    }

    public BitKey getConstrainedColumnsBitKey() {
        return this.bitKey;
    }

    public StarColumnPredicate getPredicate(int columnOrdinal) {
        Util.deprecated("review: what if there's more than one? what if there are predicates that cross other columns?", false);
        int count = 0;
        StarColumnPredicate columnPredicate = null;
        for (Map.Entry<BitKey, StarPredicate> entry : this.predicates.entrySet()) {
            if (!entry.getKey().get(columnOrdinal)) continue;
            ++count;
            if (!(entry.getValue() instanceof StarColumnPredicate)) continue;
            columnPredicate = (StarColumnPredicate)entry.getValue();
        }
        assert (count <= 1);
        return columnPredicate;
    }

    public void addPredicate(StarPredicate predicate) {
        BitKey predicateBitKey = Predicates.getBitKey(predicate, this.star);
        this.predicates.put(predicateBitKey, predicate);
        this.bitKey.or(predicateBitKey);
    }

    public Collection<StarPredicate> getPredicates() {
        return this.predicates.values();
    }

    public Collection<StarColumnPredicate> getColumnPredicates() {
        ArrayList<StarColumnPredicate> list = new ArrayList<StarColumnPredicate>();
        for (StarPredicate predicate : this.predicates.values()) {
            if (!(predicate instanceof StarColumnPredicate)) continue;
            list.add((StarColumnPredicate)predicate);
        }
        return list;
    }
}

