/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mondrian.olap.MondrianProperties;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStar;
import mondrian.util.Pair;
import org.apache.log4j.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapGalaxy {
    private final RolapCube cube;
    private final Map<RolapStar, StarInfo> starMap = new HashMap<RolapStar, StarInfo>();
    private final StarInfo[] sortedStarInfos;
    private final Map<Object, Integer> columnMap = new HashMap<Object, Integer>();
    final Map<RolapSchema.PhysExpr, RolapStar.Measure> starMeasureRefs = new HashMap<RolapSchema.PhysExpr, RolapStar.Measure>();
    private final BitKey prototypeBitKey;
    private final BitKey nonAdditiveMeasuresBitKey;
    private Map<RolapStar.Measure, BitKey> nonAdditiveMeasureSafeToRollup = new HashMap<RolapStar.Measure, BitKey>();
    private static final Logger LOGGER = Logger.getLogger(RolapStar.class);

    RolapGalaxy(RolapCube cube) {
        int n;
        this.cube = cube;
        LinkedHashMap stars = new LinkedHashMap();
        for (RolapMeasureGroup rolapMeasureGroup : cube.getMeasureGroups()) {
            for (RolapMeasureGroup.RolapMeasureRef measureRef : rolapMeasureGroup.measureRefList) {
                this.starMeasureRefs.put(measureRef.aggColumn, measureRef.measure.getStarMeasure());
            }
            Util.putMulti(stars, rolapMeasureGroup.getStar(), rolapMeasureGroup);
        }
        for (Map.Entry entry : stars.entrySet()) {
            RolapStar star = (RolapStar)entry.getKey();
            List measureGroups = (List)entry.getValue();
            this.starMap.put(star, new StarInfo(this, star, measureGroups));
        }
        this.sortedStarInfos = this.starMap.values().toArray(new StarInfo[this.starMap.size()]);
        Arrays.sort(this.sortedStarInfos, new Comparator<StarInfo>(){

            @Override
            public int compare(StarInfo o1, StarInfo o2) {
                int compare = Util.compare(o1.cost, o2.cost);
                if (compare != 0) {
                    return compare;
                }
                return o1.star.getFactTable().getRelation().getAlias().compareTo(o2.star.getFactTable().getRelation().getAlias());
            }
        });
        do {
            n = 0;
            for (StarInfo starInfo : this.starMap.values()) {
                n += starInfo.copyColumns(this.starMap.values());
            }
        } while (n != 0);
        for (StarInfo starInfo : this.starMap.values()) {
            starInfo.addReachableColumns();
        }
        int columnCount = this.columnMap.size();
        this.prototypeBitKey = BitKey.Factory.makeBitKey(columnCount);
        this.nonAdditiveMeasuresBitKey = this.prototypeBitKey.emptyCopy();
        for (StarInfo starInfo : this.starMap.values()) {
            starInfo.init(this);
        }
        for (StarInfo starInfo : this.starMap.values()) {
            starInfo.init2(this);
        }
        assert (columnCount == this.columnMap.size());
        assert (this.prototypeBitKey.isEmpty());
    }

    public RolapMeasureGroup findAgg(RolapStar star, BitKey levelBitKey, BitKey measureBitKey, boolean[] rollupOut) {
        if (!MondrianProperties.instance().ReadAggregates.get() || !MondrianProperties.instance().UseAggregates.get()) {
            return null;
        }
        StarInfo starInfo = this.starMap.get(star);
        BitKey measuresGlobalBitKey = this.toGlobal(measureBitKey, starInfo);
        BitKey levelsGlobalBitKey = this.toGlobal(levelBitKey, starInfo);
        StarInfo betterStarInfo = null;
        for (StarInfo starInfo1 : this.sortedStarInfos) {
            if (!starInfo1.measuresGlobalBitKey.isSuperSetOf(measuresGlobalBitKey) || !starInfo1.levelsGlobalBitKey.isSuperSetOf(levelsGlobalBitKey)) continue;
            betterStarInfo = starInfo1;
            break;
        }
        if (betterStarInfo == null || betterStarInfo.star == star || betterStarInfo.cost >= star.getCost()) {
            return null;
        }
        rollupOut[0] = !betterStarInfo.star.areRowsUnique() || !betterStarInfo.levelsGlobalBitKey.equals(levelsGlobalBitKey);
        boolean rollup = rollupOut[0];
        if (rollup && measuresGlobalBitKey.intersects(this.nonAdditiveMeasuresBitKey)) {
            BitKey safeRollupBitKey = null;
            for (int i : measuresGlobalBitKey.and(this.nonAdditiveMeasuresBitKey)) {
                RolapStar.Measure measure = (RolapStar.Measure)betterStarInfo.localColumns.get(i);
                RolapStar.Measure baseStarMeasure = this.starMeasureRefs.get(measure.getExpression());
                BitKey measureSafeRollupBitKey = this.nonAdditiveMeasureSafeToRollup.get(baseStarMeasure);
                if (safeRollupBitKey == null) {
                    safeRollupBitKey = measureSafeRollupBitKey;
                    continue;
                }
                safeRollupBitKey = safeRollupBitKey.and(measureSafeRollupBitKey);
            }
            assert (safeRollupBitKey != null);
            BitKey rollupBitKey = betterStarInfo.levelsGlobalBitKey.andNot(levelsGlobalBitKey);
            if (!safeRollupBitKey.isSuperSetOf(rollupBitKey)) {
                return null;
            }
        }
        return (RolapMeasureGroup)betterStarInfo.measureGroups.get(0);
    }

    private int globalOrdinal(RolapStar.Column column, boolean add) {
        Object key;
        if (column instanceof RolapStar.Measure) {
            RolapStar.Measure measure = (RolapStar.Measure)column;
            LOGGER.debug((Object)("testing " + column));
            RolapStar.Measure baseMeasure = this.starMeasureRefs.get(measure.getExpression());
            if (baseMeasure != null) {
                measure = baseMeasure;
            }
            key = Arrays.asList(measure.getTable(), measure.getAggregator(), measure.getExpression());
        } else {
            key = column.getExpression();
        }
        Integer integer = this.columnMap.get(key);
        if (integer == null) {
            if (!add) {
                return -1;
            }
            integer = this.columnMap.size();
            this.columnMap.put(key, integer);
            assert (integer == this.columnMap.size() - 1);
            LOGGER.debug((Object)("adding " + column + " as " + integer));
        }
        return integer;
    }

    private BitKey toGlobal(BitKey measureBitKey, StarInfo starInfo) {
        BitKey globalMeasureBitKey = this.prototypeBitKey.emptyCopy();
        for (int measureOrdinal : measureBitKey) {
            int measureGlobalOrdinal = (Integer)starInfo.globalOrdinals.get(measureOrdinal);
            globalMeasureBitKey.set(measureGlobalOrdinal);
        }
        return globalMeasureBitKey;
    }

    public RolapStar.Column getEquivalentColumn(RolapStar.Column column, RolapStar toStar) {
        int fromBit = column.getBitPosition();
        return this.getEquivalentColumn(fromBit, column.getStar(), toStar);
    }

    public RolapStar.Column getEquivalentColumn(int fromBit, RolapStar fromStar, RolapStar toStar) {
        StarInfo fromStarInfo = this.starMap.get(fromStar);
        StarInfo toStarInfo = this.starMap.get(toStar);
        Integer globalOrdinal = (Integer)fromStarInfo.globalOrdinals.get(fromBit);
        return (RolapStar.Column)toStarInfo.localColumns.get(globalOrdinal);
    }

    public int getEquivalentBit(int fromBit, RolapStar fromStar, RolapStar toStar) {
        return this.getEquivalentColumn(fromBit, fromStar, toStar).getBitPosition();
    }

    static List<RolapStar.Table> starTables(RolapStar star) {
        ArrayList<RolapStar.Table> tables = new ArrayList<RolapStar.Table>();
        RolapGalaxy.collectTables(star.getFactTable(), tables);
        return tables;
    }

    static void collectTables(RolapStar.Table table, List<RolapStar.Table> tables) {
        tables.add(table);
        for (RolapStar.Table childTable : table.getChildren()) {
            RolapGalaxy.collectTables(childTable, tables);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class StarInfo {
        private final Map<Integer, Integer> globalOrdinals = new HashMap<Integer, Integer>();
        private final Map<Integer, RolapStar.Column> localColumns = new HashMap<Integer, RolapStar.Column>();
        private final RolapStar star;
        private final List<RolapMeasureGroup> measureGroups;
        private final int cost;
        private BitKey measuresGlobalBitKey;
        private BitKey levelsGlobalBitKey;

        StarInfo(RolapGalaxy galaxy, RolapStar star, List<RolapMeasureGroup> measureGroups) {
            this.star = star;
            this.measureGroups = measureGroups;
            this.cost = star.getCost();
            Set set = Util.newIdentityHashSet();
            for (RolapMeasureGroup group : measureGroups) {
                for (RolapStar.Column c : Pair.leftIter(group.copyColumnList)) {
                    set.add(c);
                }
            }
            LOGGER.debug((Object)("galaxy " + galaxy + ": initializing star " + star));
            for (RolapStar.Table table : RolapGalaxy.starTables(star)) {
                Iterator<RolapStar.Column> i$ = table.getColumns().iterator();
                while (i$.hasNext()) {
                    RolapStar.Column column;
                    boolean add = !set.contains(column = i$.next());
                    int globalOrdinal = galaxy.globalOrdinal(column, add);
                    if (globalOrdinal < 0) continue;
                    this.globalOrdinals.put(column.getBitPosition(), globalOrdinal);
                    this.localColumns.put(globalOrdinal, column);
                }
            }
        }

        void init(RolapGalaxy galaxy) {
            this.measuresGlobalBitKey = galaxy.prototypeBitKey.emptyCopy();
            this.levelsGlobalBitKey = galaxy.prototypeBitKey.emptyCopy();
        }

        void init2(RolapGalaxy galaxy) {
            for (Map.Entry<Integer, RolapStar.Column> entry : this.localColumns.entrySet()) {
                RolapStar.Column column = entry.getValue();
                int globalOrdinal = entry.getKey();
                if (column instanceof RolapStar.Measure) {
                    this.measuresGlobalBitKey.set(globalOrdinal);
                    RolapStar.Measure measure = (RolapStar.Measure)column;
                    if (!measure.getAggregator().isDistinct()) continue;
                    galaxy.nonAdditiveMeasuresBitKey.set(globalOrdinal);
                    galaxy.nonAdditiveMeasureSafeToRollup.put(measure, this.dependentGlobalBitKey(galaxy, measure));
                    continue;
                }
                this.levelsGlobalBitKey.set(globalOrdinal);
            }
        }

        private BitKey dependentGlobalBitKey(RolapGalaxy galaxy, RolapStar.Measure measure) {
            BitKey bitKey = galaxy.prototypeBitKey.emptyCopy();
            List<RolapSchema.PhysColumn> key = Collections.singletonList(measure.getExpression());
            for (RolapStar.Table table : this.star.getFactTable().getChildren()) {
                if (!table.getPath().getLinks().get((int)0).columnList.equals(key)) continue;
                this.setTransitive(table, bitKey);
            }
            return bitKey;
        }

        private void setTransitive(RolapStar.Table table, BitKey bitKey) {
            for (RolapStar.Column column : table.getColumns()) {
                bitKey.set(this.globalOrdinals.get(column.getBitPosition()));
            }
            for (RolapStar.Table childTable : table.getChildren()) {
                this.setTransitive(childTable, bitKey);
            }
        }

        int copyColumns(Collection<StarInfo> starInfos) {
            int n = 0;
            for (RolapMeasureGroup measureGroup : this.measureGroups) {
                for (Pair<RolapStar.Column, RolapSchema.PhysColumn> pair : measureGroup.copyColumnList) {
                    RolapSchema.PhysColumn physColumn = (RolapSchema.PhysColumn)pair.right;
                    RolapStar.Column starColumn = (RolapStar.Column)pair.left;
                    for (StarInfo starInfo : starInfos) {
                        if (starInfo == this) continue;
                        for (Map.Entry<Integer, RolapStar.Column> entry : starInfo.localColumns.entrySet()) {
                            RolapStar.Column column = entry.getValue();
                            Integer globalOrdinal = entry.getKey();
                            if (column instanceof RolapStar.Measure || !column.getExpression().equals(physColumn) || this.localColumns.containsKey(globalOrdinal)) continue;
                            LOGGER.debug((Object)("copy: globalOrdinal=" + globalOrdinal + ", starColumn=" + starColumn + ", physColumn=" + physColumn + ", column=" + column));
                            this.localColumns.put(globalOrdinal, starColumn);
                            this.globalOrdinals.put(starColumn.getBitPosition(), globalOrdinal);
                            ++n;
                        }
                    }
                }
            }
            return n;
        }

        public void addReachableColumns() {
            LinkedHashSet physColumns = new LinkedHashSet();
            LinkedHashSet<RolapSchema.PhysRelation> physTables = new LinkedHashSet<RolapSchema.PhysRelation>();
            for (RolapMeasureGroup measureGroup : this.measureGroups) {
                for (Pair<RolapStar.Column, RolapSchema.PhysColumn> pair : measureGroup.copyColumnList) {
                    physColumns.add(pair.right);
                    physTables.add(((RolapSchema.PhysColumn)pair.right).relation);
                }
            }
            Util.discard(physColumns);
            Util.discard(physTables);
        }
    }
}

