/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import mondrian.calc.Calc;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Annotation;
import mondrian.olap.Exp;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Larder;
import mondrian.olap.Larders;
import mondrian.olap.Level;
import mondrian.olap.LocalizedProperty;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MemberBase;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.AggregateFunDef;
import mondrian.olap.fun.VisualTotalsFunDef;
import mondrian.resource.MondrianResource;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapEvaluatorRoot;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMeasure;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.ScenarioImpl;
import mondrian.server.Locus;
import mondrian.spi.MemberFormatter;
import mondrian.spi.PropertyFormatter;
import org.apache.commons.collections.map.Flat3Map;
import org.apache.log4j.Logger;
import org.olap4j.metadata.Dimension;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapMemberBase
implements RolapMember {
    protected RolapMember parentMember;
    protected final RolapCubeLevel level;
    private String uniqueName;
    private Comparable orderKey;
    protected int flags;
    private static final int LEAF_MASK = 768;
    private static final int LEAF_YES = 768;
    private static final int LEAF_NO = 256;
    private static final int AGG_FUN_MASK = 3072;
    private static final int AGG_FUN_YES = 3072;
    private static final int AGG_FUN_NO = 1024;
    private static final Logger LOGGER = Logger.getLogger(RolapMember.class);
    private static final Object[] EMPTY_OBJECT_ARRAY = new Object[0];
    private int ordinal;
    private final Comparable key;
    protected Larder larder;

    public RolapMemberBase(RolapMember parentMember, RolapCubeLevel level, Comparable key, Member.MemberType memberType, String uniqueName, Larder larder) {
        assert (RolapMember.Key.isValid(key, level, memberType)) : "invalid key " + key + " for level " + level;
        assert (larder != null);
        this.parentMember = parentMember;
        this.level = level;
        this.flags = memberType.ordinal() | (memberType == Member.MemberType.ALL ? 16 : 0) | (memberType == Member.MemberType.NULL ? 32 : 0) | (this.computeCalculated(memberType) ? 64 : 0) | (level.isMeasure() ? 128 : 0);
        this.key = key;
        this.ordinal = -1;
        this.larder = larder;
        this.uniqueName = uniqueName;
    }

    @Override
    public String getQualifiedName() {
        return MondrianResource.instance().MdxMemberName.str(this.getUniqueName());
    }

    @Override
    public final String getUniqueName() {
        return this.uniqueName;
    }

    @Override
    public String getCaption() {
        MemberFormatter mf = this.getLevel().getMemberFormatter();
        if (mf != null) {
            return mf.formatMember(this);
        }
        return Larders.getCaption(this, this.getLarder());
    }

    void setParentMember(RolapMember parentMember) {
        RolapMember previousParentMember = this.getParentMember();
        if (previousParentMember.getLevel() != parentMember.getLevel()) {
            throw new IllegalArgumentException("new parent belongs to different level than old");
        }
        this.parentMember = parentMember;
    }

    @Override
    public String getParentUniqueName() {
        return this.parentMember == null ? null : this.parentMember.getUniqueName();
    }

    @Override
    public Member.MemberType getMemberType() {
        return MemberBase.MEMBER_TYPE_VALUES[this.flags & 7];
    }

    @Override
    public String getDescription() {
        return Larders.getDescription(this.getLarder());
    }

    @Override
    public boolean isMeasure() {
        return (this.flags & 0x80) != 0;
    }

    @Override
    public boolean isAll() {
        return (this.flags & 0x10) != 0;
    }

    @Override
    public boolean isNull() {
        return (this.flags & 0x20) != 0;
    }

    @Override
    public boolean isCalculated() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public boolean isEvaluated() {
        return (this.flags & 0x40) != 0;
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment childName, MatchType matchType) {
        return schemaReader.lookupMemberChildByName(this, childName, matchType);
    }

    @Override
    public boolean isChildOrEqualTo(Member member) {
        return member != null && this.isChildOrEqualTo(member.getUniqueName());
    }

    public boolean isChildOrEqualTo(String uniqueName) {
        if (uniqueName == null) {
            return false;
        }
        return RolapMemberBase.isChildOrEqualTo(this, uniqueName);
    }

    private static boolean isChildOrEqualTo(RolapMember member, String uniqueName) {
        do {
            String thisUniqueName;
            if (!(thisUniqueName = member.getUniqueName()).equals(uniqueName)) continue;
            return true;
        } while ((member = member.getParentMember()) != null);
        return false;
    }

    protected boolean computeCalculated(Member.MemberType memberType) {
        return this.isCalculatedInQuery() || memberType == Member.MemberType.FORMULA;
    }

    @Override
    public int getSolveOrder() {
        return -1;
    }

    @Override
    public Exp getExpression() {
        return null;
    }

    @Override
    public List<Member> getAncestorMembers() {
        SchemaReader schemaReader = this.getDimension().getSchema().getSchemaReader();
        ArrayList<Member> ancestorList = new ArrayList<Member>();
        schemaReader.getMemberAncestors(this, ancestorList);
        return ancestorList;
    }

    @Override
    public RolapMember getDataMember() {
        return null;
    }

    protected Property lookupProperty(String propertyName, boolean matchCase) {
        Property prop = Property.lookup(propertyName, matchCase);
        if (prop == null && this.getLevel().getProperties() != null) {
            for (RolapProperty matchProp : this.getLevel().getProperties()) {
                if (!(matchCase ? matchProp.getName().equals(propertyName) : matchProp.getName().equalsIgnoreCase(propertyName))) continue;
                return matchProp;
            }
        }
        return prop;
    }

    @Override
    public final Object getPropertyValue(String propertyName) {
        return this.getPropertyValue(propertyName, true);
    }

    @Override
    public final Object getPropertyValue(String propertyName, boolean matchCase) {
        Property property = this.lookupProperty(propertyName, matchCase);
        if (property == null) {
            return null;
        }
        return this.getPropertyValue(property);
    }

    @Override
    public final String getPropertyFormattedValue(String propertyName) {
        Property property = this.lookupProperty(propertyName, true);
        if (property == null) {
            return "";
        }
        return this.getPropertyFormattedValue(property);
    }

    protected Logger getLogger() {
        return LOGGER;
    }

    @Override
    public final RolapCube getCube() {
        return this.level.cube;
    }

    @Override
    public RolapCubeDimension getDimension() {
        return this.level.cubeDimension;
    }

    @Override
    public boolean isVisible() {
        return true;
    }

    @Override
    public final RolapCubeLevel getLevel() {
        return this.level;
    }

    @Override
    public final RolapCubeHierarchy getHierarchy() {
        return this.level.cubeHierarchy;
    }

    @Override
    public final RolapMember getParentMember() {
        return this.parentMember;
    }

    @Override
    public Larder getLarder() {
        return this.larder;
    }

    public String toString() {
        return this.getUniqueName();
    }

    public int hashCode() {
        return this.getUniqueName().hashCode();
    }

    public boolean equals(Object o) {
        return o == this || o instanceof RolapMemberBase && this.equals((RolapMemberBase)o);
    }

    public boolean equals(OlapElement o) {
        return o instanceof RolapMemberBase && this.equals((RolapMemberBase)o);
    }

    private boolean equals(RolapMemberBase that) {
        assert (that != null);
        return this.getUniqueName().equals(that.getUniqueName());
    }

    protected void setUniqueName(String string) {
        this.uniqueName = string;
    }

    protected String computeUniqueName(Object key) {
        String name = RolapMemberBase.keyToString(key);
        if (this.parentMember == null || this.parentMember.isAll() && (!this.isCalculated() || this instanceof VisualTotalsFunDef.VisualTotalMember || this.getDataMember() != null)) {
            RolapCubeLevel level = this.getLevel();
            RolapCubeHierarchy hierarchy = level.cubeHierarchy;
            RolapCubeDimension dimension = hierarchy.getDimension();
            if (dimension.getDimensionType() == Dimension.Type.MEASURE && hierarchy.getName().equals(dimension.getName())) {
                return Util.makeFqName(dimension, name);
            }
            if (name.equals(level.getName())) {
                return Util.makeFqName(Util.makeFqName(hierarchy.getUniqueName(), level.getName()), name);
            }
            return Util.makeFqName(hierarchy, name);
        }
        return Util.makeFqName(this.parentMember, name);
    }

    protected static String deriveUniqueName(RolapMember parentMember, String name) {
        assert (parentMember != null && !parentMember.isAll());
        assert (name != null);
        return Util.makeFqName(parentMember, name);
    }

    public static String deriveUniqueName(RolapMember parentMember, RolapCubeLevel level, String name, boolean calc) {
        assert (name != null);
        return Util.makeFqName(RolapMemberBase.deriveRootUniqueName(parentMember, level, name, calc), name);
    }

    private static OlapElement deriveRootUniqueName(RolapMember parentMember, RolapLevel level, String name, boolean calc) {
        if (parentMember == null || parentMember.isAll() && !calc) {
            RolapHierarchy hierarchy = level.getHierarchy();
            RolapDimension dimension = hierarchy.getDimension();
            if (dimension.isMeasures()) {
                return dimension;
            }
            if (name.equals(level.getName())) {
                return level;
            }
            return hierarchy;
        }
        return parentMember;
    }

    @Override
    public boolean isCalculatedInQuery() {
        return false;
    }

    public String getName() {
        String name = (String)this.getPropertyValue(Property.NAME);
        return name != null ? name : RolapMemberBase.keyToString(this.key);
    }

    @Override
    public void setName(String name) {
        throw new Error("unsupported");
    }

    @Override
    public final void setProperty(String propertyName, Object value) {
        Property property = this.lookupProperty(propertyName, true);
        if (property != null) {
            this.setProperty(property, value);
        }
    }

    @Override
    public synchronized void setProperty(Property property, Object value) {
        assert (property != Property.NAME);
        if (property == Property.MEMBER_ORDINAL) {
            String ordinal = (String)value;
            if (ordinal.startsWith("\"") && ordinal.endsWith("\"")) {
                ordinal = ordinal.substring(1, ordinal.length() - 1);
            }
            double d = Double.parseDouble(ordinal);
            this.setOrdinal((int)d);
            if (this.isMeasure()) {
                this.setOrderKey(Integer.valueOf((int)d));
            }
        }
        this.larder = Larders.set(this.larder, property, value);
    }

    @Override
    public Object getPropertyValue(Property property) {
        if (property != null) {
            switch (property.ordinal) {
                case 2: {
                    break;
                }
                case 3: {
                    return this.getCaption();
                }
                case 27: {
                    return this.getDescription();
                }
                case 4: {
                    ArrayList<RolapMember> list = new ArrayList<RolapMember>();
                    this.getHierarchy().getMemberReader().getMemberChildren(this, list);
                    return list;
                }
                case 10: {
                    break;
                }
                case 11: {
                    return this.getHierarchy().getDimension().getSchema().getName();
                }
                case 12: {
                    break;
                }
                case 13: {
                    return this.getHierarchy().getDimension().getUniqueName();
                }
                case 14: {
                    return this.getHierarchy().getUniqueName();
                }
                case 15: {
                    return this.getLevel().getUniqueName();
                }
                case 16: {
                    return this.getLevel().getDepth();
                }
                case 19: {
                    return this.getUniqueName();
                }
                case 18: {
                    return this.getName();
                }
                case 20: {
                    return this.getMemberType().ordinal();
                }
                case 21: {
                    return null;
                }
                case 22: {
                    return this.getCaption();
                }
                case 17: {
                    return this.getOrdinal();
                }
                case 23: {
                    return Locus.execute(this.level.getDimension().getSchema().getInternalConnection(), "Member.CHILDREN_CARDINALITY", new Locus.Action<Integer>(){

                        @Override
                        public Integer execute() {
                            if (RolapMemberBase.this.isAll() && RolapMemberBase.this.childLevelHasApproxRowCount()) {
                                return RolapMemberBase.this.getLevel().getChildLevel().getApproxRowCount();
                            }
                            ArrayList<RolapMember> list = new ArrayList<RolapMember>();
                            RolapMemberBase.this.getHierarchy().getMemberReader().getMemberChildren(RolapMemberBase.this, list);
                            return list.size();
                        }
                    });
                }
                case 24: {
                    RolapMember parentMember = this.getParentMember();
                    return parentMember == null ? 0 : parentMember.getLevel().getDepth();
                }
                case 25: {
                    RolapMember parentMember = this.getParentMember();
                    return parentMember == null ? null : parentMember.getUniqueName();
                }
                case 26: {
                    RolapMember parentMember = this.getParentMember();
                    return parentMember == null ? 0 : 1;
                }
                case 28: {
                    break;
                }
                case 45: 
                case 46: {
                    return this == this.getHierarchy().getAllMember() ? Integer.valueOf(0) : this.getKey();
                }
                case 48: {
                    return ScenarioImpl.forMember(this);
                }
            }
        }
        return this.getPropertyFromMap(property);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Object getPropertyFromMap(Property property) {
        RolapMemberBase rolapMemberBase = this;
        synchronized (rolapMemberBase) {
            return this.larder.get(property);
        }
    }

    @Override
    public String getLocalized(LocalizedProperty prop, Locale locale) {
        String resource;
        List<Larders.Resource> resources = this.getResources();
        if (resources != null && (resource = Larders.Resource.lookup(prop, locale, resources)) != null) {
            return resource;
        }
        if (this.getLevel() != null && this.getLevel().getMemberFormatter() != null) {
            return this.getLevel().getMemberFormatter().formatMember(this);
        }
        return Larders.get(this, this.getLarder(), prop, locale);
    }

    private List<Larders.Resource> getResources() {
        Map<String, List<Larders.Resource>> map;
        Map<String, List<Larders.Resource>> map2 = map = this.level.resourceMap != null ? this.level.resourceMap : this.level.getRolapLevel().resourceMap;
        if (map != null) {
            List<Larders.Resource> resource = map.get(this.getCube() + "." + this.uniqueName + ".member");
            return resource != null ? resource : map.get(this.uniqueName + ".member");
        }
        return null;
    }

    protected boolean childLevelHasApproxRowCount() {
        return this.getLevel().getChildLevel().getApproxRowCount() > Integer.MIN_VALUE;
    }

    @Override
    public Property[] getProperties() {
        return this.getLevel().getInheritedProperties();
    }

    @Override
    public int getOrdinal() {
        return this.ordinal;
    }

    @Override
    public Comparable getOrderKey() {
        return this.orderKey;
    }

    public void setOrdinal(int ordinal) {
        if (this.ordinal == -1) {
            this.ordinal = ordinal;
        }
    }

    public void setOrderKey(Comparable orderKey) {
        if (!this.level.isMeasure() ? !$assertionsDisabled && RolapMemberBase.arity(orderKey) != this.level.getOrderByKeyArity() : !$assertionsDisabled && RolapMemberBase.arity(orderKey) != 1) {
            throw new AssertionError();
        }
        this.orderKey = orderKey;
    }

    private void resetOrdinal() {
        this.ordinal = -1;
    }

    @Override
    public Comparable getKey() {
        return this.key;
    }

    @Override
    public Comparable getKeyCompact() {
        return this.key;
    }

    @Override
    public List<Comparable> getKeyAsList() {
        return RolapMemberBase.asList(this.getKey());
    }

    private static List<Comparable> asList(Comparable key) {
        if (key instanceof List) {
            return (List)((Object)key);
        }
        return Collections.singletonList(key);
    }

    @Override
    public Object[] getKeyAsArray() {
        return RolapMemberBase.asArray(this.getKey());
    }

    private static Object[] asArray(Object key) {
        if (key == null) {
            return EMPTY_OBJECT_ARRAY;
        }
        if (key instanceof List) {
            return ((List)key).toArray();
        }
        return new Object[]{key};
    }

    private static int arity(Object key) {
        if (key instanceof List) {
            return ((List)key).size();
        }
        return 1;
    }

    public int compareTo(Object o) {
        RolapMember other = (RolapMember)o;
        if (this.key == null || other.getKey() == null) {
            if (this.key != null) {
                return 1;
            }
            if (other.getKey() != null) {
                return -1;
            }
            return this.getUniqueName().compareTo(other.getUniqueName());
        }
        if (this.key == RolapUtil.sqlNullValue || other.getKey() == RolapUtil.sqlNullValue) {
            return this.getUniqueName().compareTo(other.getUniqueName());
        }
        if (this.key.getClass().equals(other.getKey().getClass())) {
            if (this.key instanceof String) {
                return Util.caseSensitiveCompareName((String)((Object)this.key), (String)((Object)other.getKey()));
            }
            return Util.compareKey(this.key, other.getKey());
        }
        return this.getUniqueName().compareTo(other.getUniqueName());
    }

    @Override
    public boolean isHidden() {
        RolapCubeLevel rolapLevel = this.getLevel();
        switch (rolapLevel.getHideMemberCondition()) {
            case Never: {
                return false;
            }
            case IfBlankName: {
                String name = this.getName();
                return name.equals(RolapUtil.mdxNullLiteral()) || Util.isBlank(name);
            }
            case IfParentsName: {
                RolapMember parentMember = this.getParentMember();
                if (parentMember == null) {
                    return false;
                }
                String parentName = parentMember.getName();
                String name = this.getName();
                return (parentName == null ? "" : parentName).equals(name == null ? "" : name);
            }
        }
        throw Util.badValue(rolapLevel.getHideMemberCondition());
    }

    @Override
    public int getDepth() {
        if (this.parentMember != null) {
            return this.getParentMember().getDepth() + 1;
        }
        return this.getLevel().getDepth();
    }

    @Override
    public String getPropertyFormattedValue(Property property) {
        Object val = this.getPropertyValue(property);
        PropertyFormatter pf = property.getFormatter();
        if (pf != null) {
            return pf.formatProperty(this, property.name, val);
        }
        if (val != null && val instanceof Number) {
            val = new BigDecimal(((Number)val).doubleValue());
        }
        return val == null ? "" : val.toString();
    }

    @Override
    public boolean isParentChildLeaf() {
        if ((this.flags & 0x300) == 0) {
            boolean isParentChildLeaf = this.getLevel().isParentChild() && this.getDimension().getSchema().getSchemaReader().getMemberChildren(this).size() == 0;
            this.flags |= isParentChildLeaf ? 768 : 256;
            return isParentChildLeaf;
        }
        return (this.flags & 0x300) == 768;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<List<Member>> getAllMembers(SchemaReader schemaReader, Hierarchy hierarchy) {
        long start = System.currentTimeMillis();
        try {
            ArrayList<List<Member>> list = new ArrayList<List<Member>>();
            for (Level level : hierarchy.getLevelList()) {
                List<Member> members = schemaReader.getLevelMembers(level, true);
                if (members == null) continue;
                list.add(members);
            }
            ArrayList<List<Member>> arrayList = list;
            return arrayList;
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                long l = System.currentTimeMillis();
                LOGGER.debug((Object)("RolapMember.getAllMembers: time=" + (l - start)));
            }
        }
    }

    public static int getHierarchyCardinality(SchemaReader schemaReader, Hierarchy hierarchy) {
        int cardinality = 0;
        for (Level level : hierarchy.getLevelList()) {
            cardinality += schemaReader.getLevelCardinality(level, true, true);
        }
        return cardinality;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void setOrdinals(SchemaReader schemaReader, Member seedMember) {
        long start = System.currentTimeMillis();
        try {
            Hierarchy hierarchy = seedMember.getHierarchy();
            int ordinal = hierarchy.hasAll() ? 1 : 0;
            List<List<Member>> levelMembers = RolapMemberBase.getAllMembers(schemaReader, hierarchy);
            List<Member> leafMembers = levelMembers.get(levelMembers.size() - 1);
            levelMembers = levelMembers.subList(0, levelMembers.size() - 1);
            for (Member child : leafMembers) {
                ordinal = RolapMemberBase.bottomUpSetParentOrdinals(ordinal, child);
                ordinal = RolapMemberBase.setOrdinal(child, ordinal);
            }
            boolean needsFullTopDown = RolapMemberBase.needsFullTopDown(levelMembers);
            if (needsFullTopDown) {
                for (List<Member> members : levelMembers) {
                    for (Member member : members) {
                        if (!(member instanceof RolapMemberBase)) continue;
                        ((RolapMemberBase)member).resetOrdinal();
                    }
                }
                RolapMemberBase.setOrdinalsTopDown(schemaReader, seedMember);
            }
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                LOGGER.debug((Object)("RolapMember.setOrdinals: time=" + (end - start)));
            }
        }
    }

    private static boolean needsFullTopDown(List<List<Member>> levelMembers) {
        for (List<Member> members : levelMembers) {
            for (Member member : members) {
                if (member.getOrdinal() != -1) continue;
                return true;
            }
        }
        return false;
    }

    private static int bottomUpSetParentOrdinals(int ordinal, Member child) {
        Member parent = child.getParentMember();
        if (parent != null && parent.getOrdinal() == -1) {
            ordinal = RolapMemberBase.bottomUpSetParentOrdinals(ordinal, parent);
            ordinal = RolapMemberBase.setOrdinal(parent, ordinal);
        }
        return ordinal;
    }

    private static int setOrdinal(Member member, int ordinal) {
        if (member instanceof RolapMemberBase) {
            ((RolapMemberBase)member).setOrdinal(ordinal++);
        } else {
            LOGGER.warn((Object)("RolapMember.setAllChildren: NOT RolapMember member.name=" + member.getName() + ", member.class=" + member.getClass().getName() + ", ordinal=" + ordinal));
            ++ordinal;
        }
        return ordinal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setOrdinalsTopDown(SchemaReader schemaReader, Member member) {
        long start = System.currentTimeMillis();
        try {
            Member parent = schemaReader.getMemberParent(member);
            if (parent == null) {
                int ordinal = 0;
                List<Member> siblings = schemaReader.getHierarchyRootMembers(member.getHierarchy());
                for (Member sibling : siblings) {
                    ordinal = RolapMemberBase.setAllChildren(ordinal, schemaReader, sibling);
                }
            } else {
                RolapMemberBase.setOrdinalsTopDown(schemaReader, parent);
            }
        }
        finally {
            if (LOGGER.isDebugEnabled()) {
                long end = System.currentTimeMillis();
                LOGGER.debug((Object)("RolapMember.setOrdinalsTopDown: time=" + (end - start)));
            }
        }
    }

    private static int setAllChildren(int ordinal, SchemaReader schemaReader, Member member) {
        ordinal = RolapMemberBase.setOrdinal(member, ordinal);
        List<Member> children = schemaReader.getMemberChildren(member);
        for (Member child : children) {
            ordinal = RolapMemberBase.setAllChildren(ordinal, schemaReader, child);
        }
        return ordinal;
    }

    protected static String keyToString(Object key) {
        if (key == null || key == RolapUtil.sqlNullValue) {
            return RolapUtil.mdxNullLiteral();
        }
        if (key instanceof List) {
            List list = (List)key;
            return RolapMemberBase.keyToString(list.get(list.size() - 1));
        }
        if (key instanceof Id.NameSegment) {
            return ((Id.NameSegment)key).name;
        }
        if (key instanceof Number) {
            String name = key.toString();
            if (name.endsWith(".0")) {
                name = name.substring(0, name.length() - 2);
            }
            return name;
        }
        return key.toString();
    }

    @Override
    public Map<String, Annotation> getAnnotationMap() {
        return this.getLarder().getAnnotationMap();
    }

    @Override
    public boolean containsAggregateFunction() {
        if ((this.flags & 0xC00) == 0) {
            boolean containsAggregateFunction = RolapMemberBase.foundAggregateFunction(this.getExpression());
            this.flags |= containsAggregateFunction ? 3072 : 1024;
            return containsAggregateFunction;
        }
        return (this.flags & 0xC00) == 3072;
    }

    private static boolean foundAggregateFunction(Exp exp) {
        if (exp instanceof ResolvedFunCall) {
            ResolvedFunCall resolvedFunCall = (ResolvedFunCall)exp;
            if (resolvedFunCall.getFunDef() instanceof AggregateFunDef) {
                return true;
            }
            for (Exp argExp : resolvedFunCall.getArgs()) {
                if (!RolapMemberBase.foundAggregateFunction(argExp)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public Calc getCompiledExpression(RolapEvaluatorRoot root) {
        return root.getCompiled(this.getExpression(), true, null);
    }

    @Override
    public int getHierarchyOrdinal() {
        return this.getHierarchy().getOrdinalInCube();
    }

    @Override
    public void setContextIn(RolapEvaluator evaluator) {
        RolapMember defaultMember = evaluator.root.defaultMembers[this.getHierarchyOrdinal()];
        evaluator.setContext(defaultMember);
        evaluator.setExpanding(this);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class DefaultPropertyValueMapFactory
    implements PropertyValueMapFactory {
        @Override
        public Map<Property, Object> create(Member member) {
            assert (member != null);
            Property[] props = member.getProperties();
            if (member instanceof RolapMeasure || props == null || props.length > 3) {
                return new HashMap<Property, Object>();
            }
            return new Flat3Map();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PropertyValueMapFactory {
        public Map<Property, Object> create(Member var1);
    }
}

