/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import mondrian.olap.Dimension;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.olap.fun.NonEmptyCrossJoinFunDef;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.MemberListCrossJoinArg;
import mondrian.rolap.sql.TupleConstraint;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapNativeCrossJoin
extends RolapNativeSet {
    public RolapNativeCrossJoin() {
        super.setEnabled(MondrianProperties.instance().EnableNativeCrossJoin.get());
    }

    @Override
    protected boolean restrictMemberTypes() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    NativeEvaluator createEvaluator(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        if (!this.isEnabled()) {
            return null;
        }
        RolapCube cube = evaluator.getCube();
        List<CrossJoinArg[]> allArgs = this.crossJoinArgFactory().checkCrossJoin(evaluator, fun, args, false);
        if (allArgs == null || allArgs.isEmpty() || allArgs.get(0) == null) {
            this.alertCrossJoinNonNative(evaluator, fun, "arguments not supported");
            return null;
        }
        CrossJoinArg[] cjArgs = allArgs.get(0);
        int countNonNativeInputArg = 0;
        for (CrossJoinArg arg : cjArgs) {
            if (!(arg instanceof MemberListCrossJoinArg)) continue;
            CrossJoinArg cjArg = (MemberListCrossJoinArg)arg;
            if (((MemberListCrossJoinArg)cjArg).hasAllMember() || ((MemberListCrossJoinArg)cjArg).isEmptyCrossJoinArg()) {
                ++countNonNativeInputArg;
            }
            if (!((MemberListCrossJoinArg)cjArg).hasCalcMembers()) continue;
            countNonNativeInputArg = cjArgs.length;
            break;
        }
        if (countNonNativeInputArg == cjArgs.length) {
            this.alertCrossJoinNonNative(evaluator, fun, "either all arguments contain the ALL member, or empty member lists, or one has a calculated member");
            return null;
        }
        if (this.isPreferInterpreter(cjArgs, true)) {
            return null;
        }
        ArrayList<RolapCubeLevel> levels = new ArrayList<RolapCubeLevel>();
        for (CrossJoinArg cjArg : cjArgs) {
            RolapCubeLevel rolapCubeLevel = cjArg.getLevel();
            if (rolapCubeLevel == null) continue;
            levels.add(rolapCubeLevel);
        }
        if (cube.getMeasureGroups().size() > 1 && !evaluator.getQuery().nativeCrossJoinVirtualCube()) {
            this.alertCrossJoinNonNative(evaluator, fun, "not all functions on [Measures] dimension supported");
            return null;
        }
        ArrayList<RolapMeasureGroup> measureGroupList = new ArrayList<RolapMeasureGroup>();
        if (!SqlContextConstraint.checkValidContext(evaluator, false, levels, this.restrictMemberTypes(), measureGroupList)) {
            return null;
        }
        if (!evaluator.isNonEmpty()) {
            return null;
        }
        LOGGER.debug((Object)"using native crossjoin");
        int savepoint = evaluator.savepoint();
        try {
            Member[] evalMembers = (Member[])evaluator.getMembers().clone();
            block5: for (RolapLevel rolapLevel : levels) {
                RolapHierarchy hierarchy = rolapLevel.getHierarchy();
                for (int i = 0; i < evalMembers.length; ++i) {
                    Dimension evalMemberDimension = evalMembers[i].getHierarchy().getDimension();
                    if (evalMemberDimension != hierarchy.getDimension() || evalMembers[i].isAll()) continue;
                    evalMembers[i] = hierarchy.getAllMember();
                    continue block5;
                }
            }
            evaluator.setContext(evalMembers);
            CrossJoinArg[] cargs = this.combineArgs(allArgs);
            TupleConstraint tupleConstraint = this.buildConstraint(evaluator, fun, cargs, measureGroupList);
            SchemaReader schemaReader = evaluator.getSchemaReader();
            RolapNativeSet.SetEvaluator setEvaluator = new RolapNativeSet.SetEvaluator(cjArgs, schemaReader, tupleConstraint);
            return setEvaluator;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    CrossJoinArg[] combineArgs(List<CrossJoinArg[]> allArgs) {
        CrossJoinArg[] predicateArgs;
        CrossJoinArg[] cjArgs = allArgs.get(0);
        if (allArgs.size() == 2 && (predicateArgs = allArgs.get(1)) != null) {
            return Util.appendArrays(cjArgs, new CrossJoinArg[][]{predicateArgs});
        }
        return cjArgs;
    }

    private TupleConstraint buildConstraint(RolapEvaluator evaluator, FunDef fun, CrossJoinArg[] cargs, List<RolapMeasureGroup> measureGroupList) {
        CrossJoinArg[] myArgs = this.safeToConstrainByOtherAxes(fun) ? this.buildArgs(evaluator, cargs) : cargs;
        return new NonEmptyCrossJoinConstraint(myArgs, evaluator, measureGroupList);
    }

    private CrossJoinArg[] buildArgs(RolapEvaluator evaluator, CrossJoinArg[] cargs) {
        Set<CrossJoinArg> joinArgs = this.crossJoinArgFactory().buildConstraintFromAllAxes(evaluator);
        joinArgs.addAll(Arrays.asList(cargs));
        return joinArgs.toArray(new CrossJoinArg[joinArgs.size()]);
    }

    private boolean safeToConstrainByOtherAxes(FunDef fun) {
        return !(fun instanceof NonEmptyCrossJoinFunDef);
    }

    private void alertCrossJoinNonNative(RolapEvaluator evaluator, FunDef fun, String reason) {
        if (!(fun instanceof NonEmptyCrossJoinFunDef)) {
            return;
        }
        if (!evaluator.getQuery().shouldAlertForNonNative(fun)) {
            return;
        }
        RolapUtil.alertNonNative("NonEmptyCrossJoin", reason);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class NonEmptyCrossJoinConstraint
    extends RolapNativeSet.SetConstraint {
        NonEmptyCrossJoinConstraint(CrossJoinArg[] args, RolapEvaluator evaluator, List<RolapMeasureGroup> measureGroupList) {
            super(args, evaluator, measureGroupList, false);
        }

        public RolapMember findMember(Object keys) {
            for (CrossJoinArg arg : this.args) {
                if (!(arg instanceof MemberListCrossJoinArg)) continue;
                MemberListCrossJoinArg crossJoinArg = (MemberListCrossJoinArg)arg;
                List<RolapMember> memberList = crossJoinArg.getMembers();
                for (RolapMember rolapMember : memberList) {
                    if (!keys.equals(rolapMember.getKeyCompact())) continue;
                    return rolapMember;
                }
            }
            return null;
        }

        @Override
        public boolean isJoinRequired() {
            return true;
        }
    }
}

