/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.Level;
import mondrian.olap.Member;
import mondrian.olap.MondrianProperties;
import mondrian.olap.NativeEvaluator;
import mondrian.olap.SchemaReader;
import mondrian.olap.Util;
import mondrian.rolap.RestrictedMemberReader;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapNativeSet;
import mondrian.rolap.RolapNativeSql;
import mondrian.rolap.RolapStarSet;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.SqlContextConstraint;
import mondrian.rolap.sql.CrossJoinArg;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.SqlQueryBuilder;

public class RolapNativeFilter
extends RolapNativeSet {
    public RolapNativeFilter() {
        super.setEnabled(MondrianProperties.instance().EnableNativeFilter.get());
    }

    protected boolean restrictMemberTypes() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NativeEvaluator createEvaluator(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        Exp filterExpr;
        if (!this.isEnabled()) {
            return null;
        }
        ArrayList<RolapMeasureGroup> measureGroupList = new ArrayList<RolapMeasureGroup>();
        if (!SqlContextConstraint.checkValidContext(evaluator, true, Collections.<RolapCubeLevel>emptyList(), this.restrictMemberTypes(), measureGroupList)) {
            return null;
        }
        String funName = fun.getName();
        if (!"Filter".equalsIgnoreCase(funName)) {
            return null;
        }
        if (args.length != 2) {
            return null;
        }
        List<CrossJoinArg[]> allArgs = this.crossJoinArgFactory().checkCrossJoinArg(evaluator, args[0]);
        if (allArgs == null || allArgs.isEmpty() || allArgs.get(0) == null) {
            return null;
        }
        CrossJoinArg[] cjArgs = allArgs.get(0);
        if (this.isPreferInterpreter(cjArgs, false)) {
            return null;
        }
        SqlQuery sqlQuery = SqlQuery.newQuery(evaluator.getDialect(), "NativeFilter");
        RolapNativeSql sql = new RolapNativeSql(sqlQuery, null, evaluator, cjArgs[0].getLevel());
        String filterExprStr = sql.generateFilterCondition(filterExpr = args[1]);
        if (filterExprStr == null) {
            return null;
        }
        if (SqlConstraintUtils.containsCalculatedMember(evaluator.getNonAllMembers())) {
            return null;
        }
        LOGGER.debug((Object)"using native filter");
        int savepoint = evaluator.savepoint();
        try {
            CrossJoinArg[] predicateArgs;
            this.overrideContext(evaluator, cjArgs, sql.getStoredMeasure());
            CrossJoinArg[] combinedArgs = cjArgs;
            if (allArgs.size() == 2 && (predicateArgs = allArgs.get(1)) != null) {
                combinedArgs = Util.appendArrays(cjArgs, new CrossJoinArg[][]{predicateArgs});
            }
            FilterConstraint constraint = new FilterConstraint(combinedArgs, evaluator, measureGroupList, filterExpr);
            RolapNativeSet.SetEvaluator setEvaluator = new RolapNativeSet.SetEvaluator(cjArgs, evaluator.getSchemaReader(), constraint);
            return setEvaluator;
        }
        finally {
            evaluator.restore(savepoint);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class FilterConstraint
    extends RolapNativeSet.SetConstraint {
        Exp filterExpr;

        public FilterConstraint(CrossJoinArg[] args, RolapEvaluator evaluator, List<RolapMeasureGroup> measureGroupList, Exp filterExpr) {
            super(args, evaluator, measureGroupList, true);
            this.filterExpr = filterExpr;
        }

        @Override
        public boolean isJoinRequired() {
            final AtomicBoolean mustJoin = new AtomicBoolean(false);
            this.filterExpr.accept(new MdxVisitorImpl(){

                public Object visit(MemberExpr memberExpr) {
                    if (memberExpr.getMember().isMeasure()) {
                        mustJoin.set(true);
                        return null;
                    }
                    return super.visit(memberExpr);
                }
            });
            return mustJoin.get() || this.getEvaluator().isNonEmpty() && super.isJoinRequired();
        }

        @Override
        public void addConstraint(SqlQueryBuilder queryBuilder, RolapStarSet starSet) {
            RolapNativeSql sql = new RolapNativeSql(queryBuilder.sqlQuery, starSet.getAggStar(), this.getEvaluator(), this.args[0].getLevel());
            String filterSql = sql.generateFilterCondition(this.filterExpr);
            queryBuilder.sqlQuery.addHaving(filterSql);
            if (this.getEvaluator().isNonEmpty() || this.isJoinRequired()) {
                super.addConstraint(queryBuilder, starSet);
            }
        }

        @Override
        public Object getCacheKey() {
            ArrayList<Object> key = new ArrayList<Object>();
            key.add(super.getCacheKey());
            if (this.filterExpr != null) {
                key.add(this.filterExpr.toString());
            }
            key.add(this.getEvaluator().isNonEmpty());
            if (this.getEvaluator() instanceof RolapEvaluator) {
                key.add(((RolapEvaluator)this.getEvaluator()).getSlicerMembers());
            }
            SchemaReader schemaReader = this.getEvaluator().getSchemaReader();
            Member[] mm = this.getEvaluator().getMembers();
            for (int mIndex = 0; mIndex < mm.length; ++mIndex) {
                if (!(mm[mIndex] instanceof RolapHierarchy.LimitedRollupMember) && !(mm[mIndex] instanceof RestrictedMemberReader.MultiCardinalityDefaultMember)) continue;
                List<Level> hierarchyLevels = schemaReader.getHierarchyLevels(mm[mIndex].getHierarchy());
                for (Level affectedLevel : hierarchyLevels) {
                    List<Member> availableMembers = schemaReader.getLevelMembers(affectedLevel, false);
                    for (Member member : availableMembers) {
                        if (member.isAll()) continue;
                        key.add(member);
                    }
                }
            }
            return key;
        }
    }
}

