/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.HashMap;
import java.util.Map;
import mondrian.olap.Exp;
import mondrian.olap.FunDef;
import mondrian.olap.NativeEvaluator;
import mondrian.rolap.RolapEvaluator;
import mondrian.rolap.RolapNative;
import mondrian.rolap.RolapNativeCrossJoin;
import mondrian.rolap.RolapNativeFilter;
import mondrian.rolap.RolapNativeTopCount;

public class RolapNativeRegistry
extends RolapNative {
    private Map<String, RolapNative> nativeEvaluatorMap = new HashMap<String, RolapNative>();

    public RolapNativeRegistry() {
        super.setEnabled(true);
        this.register("NonEmptyCrossJoin".toUpperCase(), new RolapNativeCrossJoin());
        this.register("CrossJoin".toUpperCase(), new RolapNativeCrossJoin());
        this.register("*", new RolapNativeCrossJoin());
        this.register("TopCount".toUpperCase(), new RolapNativeTopCount());
        this.register("Filter".toUpperCase(), new RolapNativeFilter());
    }

    public NativeEvaluator createEvaluator(RolapEvaluator evaluator, FunDef fun, Exp[] args) {
        if (!this.isEnabled()) {
            return null;
        }
        RolapNative rn = this.nativeEvaluatorMap.get(fun.getName().toUpperCase());
        if (rn == null) {
            return null;
        }
        NativeEvaluator ne = rn.createEvaluator(evaluator, fun, args);
        if (ne != null && this.listener != null) {
            RolapNative.NativeEvent e = new RolapNative.NativeEvent(this, ne);
            this.listener.foundEvaluator(e);
        }
        return ne;
    }

    public void register(String funName, RolapNative rn) {
        this.nativeEvaluatorMap.put(funName, rn);
    }

    void setListener(RolapNative.Listener listener) {
        super.setListener(listener);
        for (RolapNative rn : this.nativeEvaluatorMap.values()) {
            rn.setListener(listener);
        }
    }

    void useHardCache(boolean hard) {
        for (RolapNative rn : this.nativeEvaluatorMap.values()) {
            rn.useHardCache(hard);
        }
    }
}

