/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.sql.DataSource;
import mondrian.olap.CacheControl;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.FunTable;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Larder;
import mondrian.olap.Larders;
import mondrian.olap.LocalizedProperty;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianProperties;
import mondrian.olap.MondrianServer;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.OlapElementBase;
import mondrian.olap.Parameter;
import mondrian.olap.Role;
import mondrian.olap.RoleImpl;
import mondrian.olap.Schema;
import mondrian.olap.SchemaReader;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.fun.FunTableImpl;
import mondrian.olap.fun.GlobalFunTable;
import mondrian.olap.fun.Resolver;
import mondrian.olap.fun.UdfResolver;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.rolap.ArrayMemberSource;
import mondrian.rolap.CacheMemberReader;
import mondrian.rolap.MemberReader;
import mondrian.rolap.MemberSource;
import mondrian.rolap.NoCacheMemberReader;
import mondrian.rolap.RolapAttribute;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapNativeRegistry;
import mondrian.rolap.RolapSchemaLoader;
import mondrian.rolap.RolapSchemaParameter;
import mondrian.rolap.RolapSchemaPool;
import mondrian.rolap.RolapSchemaReader;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.SchemaKey;
import mondrian.rolap.SmartMemberReader;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.aggmatcher.AggTableManager;
import mondrian.rolap.aggmatcher.JdbcSchema;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.SqlQueryBuilder;
import mondrian.server.Execution;
import mondrian.server.Statement;
import mondrian.spi.DataServicesLocator;
import mondrian.spi.DataServicesProvider;
import mondrian.spi.Dialect;
import mondrian.spi.RoleGenerator;
import mondrian.spi.StatisticsProvider;
import mondrian.spi.UserDefinedFunction;
import mondrian.spi.impl.Scripts;
import mondrian.util.ByteString;
import mondrian.util.ClassResolver;
import mondrian.util.DirectedGraph;
import mondrian.util.Pair;
import org.apache.log4j.Logger;
import org.eigenbase.xom.ElementDef;
import org.eigenbase.xom.Location;
import org.eigenbase.xom.NodeDef;
import org.olap4j.impl.NamedListImpl;
import org.olap4j.impl.UnmodifiableArrayList;
import org.olap4j.mdx.IdentifierSegment;
import org.olap4j.metadata.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapSchema
extends OlapElementBase
implements Schema {
    static final Logger LOGGER = Logger.getLogger(RolapSchema.class);
    final String name;
    private RolapConnection internalConnection;
    private final Dialect dialect;
    private final Map<String, RolapCube> mapNameToCube = new HashMap<String, RolapCube>();
    final Map<String, RolapCubeDimension> sharedDimensions = new HashMap<String, RolapCubeDimension>();
    private RoleFactory defaultRole;
    final Role rootRole;
    ByteString md5Bytes;
    AggTableManager aggTableManager;
    final SchemaKey key;
    final Map<String, RoleFactory> mapNameToRole = new HashMap<String, RoleFactory>();
    private final Map<String, NamedSet> mapNameToSet = new HashMap<String, NamedSet>();
    private FunTable funTable;
    final List<RolapSchemaParameter> parameterList = new ArrayList<RolapSchemaParameter>();
    private Date schemaLoadDate;
    PhysSchema physicalSchema;
    final List<MondrianSchemaException> warningList;
    private final Larder larder;
    private final String id;
    public final Set<Locale> locales;
    private String dataServicesProvider;
    private RolapStarRegistry rolapStarRegistry = new RolapStarRegistry();
    final RolapNativeRegistry nativeRegistry = new RolapNativeRegistry();

    RolapSchema(SchemaKey key, Util.PropertyList connectInfo, DataSource dataSource, ByteString md5Bytes, boolean useContentChecksum, String name, boolean quoteSql, Set<Locale> locales, Larder larder) {
        this.id = Util.generateUuidString();
        this.key = key;
        this.locales = locales;
        this.md5Bytes = md5Bytes;
        if (useContentChecksum && md5Bytes == null) {
            throw new AssertionError();
        }
        this.rootRole = Util.createRootRole(this);
        this.defaultRole = new ConstantRoleFactory(this.rootRole);
        MondrianServer internalServer = MondrianServer.forId(null);
        this.internalConnection = new RolapConnection(internalServer, connectInfo, this, dataSource);
        assert (this.internalConnection.dialect != null);
        internalServer.removeConnection(this.internalConnection);
        internalServer.removeStatement(this.internalConnection.getInternalStatement());
        this.dialect = this.internalConnection.dialect.withQuoting(quoteSql);
        this.aggTableManager = new AggTableManager(this);
        this.name = name;
        if (name == null || name.equals("")) {
            throw Util.newError("<Schema> name must be set");
        }
        this.larder = larder;
        this.warningList = this.getInternalConnection() != null && "true".equals(this.getInternalConnection().getProperty(RolapConnectionProperties.Ignore.name())) ? new ArrayList<MondrianSchemaException>() : null;
        this.dataServicesProvider = connectInfo.get(RolapConnectionProperties.DataServicesProvider.name());
    }

    @Override
    public String getUniqueName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.larder.get(LocalizedProperty.DESCRIPTION, Larders.DEFAULT_LOCALE);
    }

    @Override
    public OlapElement lookupChild(SchemaReader schemaReader, Id.Segment s, MatchType matchType) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getQualifiedName() {
        return this.name;
    }

    @Override
    public Hierarchy getHierarchy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Dimension getDimension() {
        throw new UnsupportedOperationException();
    }

    protected void flushSegments() {
        RolapConnection internalConnection = this.getInternalConnection();
        if (internalConnection != null) {
            CacheControl cc = internalConnection.getCacheControl(null);
            for (RolapCube cube : this.getCubeList()) {
                cc.flush(cc.createMeasuresRegion(cube));
            }
        }
    }

    protected void flushJdbcSchema() {
        if (this.aggTableManager != null) {
            this.aggTableManager.finalCleanUp();
            this.aggTableManager = null;
        }
    }

    protected void finalCleanUp() {
        this.flushSegments();
        this.flushJdbcSchema();
    }

    protected void finalize() throws Throwable {
        try {
            super.finalize();
            this.flushJdbcSchema();
        }
        catch (Throwable t) {
            LOGGER.info((Object)MondrianResource.instance().FinalizerErrorRolapSchema.baseMessage, t);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (!(o instanceof RolapSchema)) {
            return false;
        }
        RolapSchema other = (RolapSchema)o;
        return other.key.equals(this.key);
    }

    @Override
    public int hashCode() {
        return this.key.hashCode();
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    void setSchemaLoadDate() {
        this.schemaLoadDate = new Date();
    }

    @Override
    public Date getSchemaLoadDate() {
        return this.schemaLoadDate;
    }

    @Override
    public List<Exception> getWarnings() {
        return Collections.unmodifiableList(Util.cast(this.warningList));
    }

    public RoleFactory getDefaultRole() {
        return this.defaultRole;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public Larder getLarder() {
        return this.larder;
    }

    public Dialect getDialect() {
        Util.deprecated("clean up", false);
        return this.dialect;
    }

    @Override
    public Dimension createDimension(Cube cube, String xml) {
        throw new UnsupportedOperationException("Support for Schema.createDimension has been removed in Mondrian 4.0");
    }

    @Override
    public Cube createCube(String xml) {
        return new RolapSchemaLoader(this).createCube(xml);
    }

    Pair<RoleFactory, String> createRole(String xml, NamePolicy namePolicy) {
        return new RolapSchemaLoader(this).createRole(xml);
    }

    public PhysSchema getPhysicalSchema() {
        return this.physicalSchema;
    }

    public static List<RolapSchema> getRolapSchemas() {
        return RolapSchemaPool.instance().getRolapSchemas();
    }

    public static boolean cacheContains(RolapSchema rolapSchema) {
        return RolapSchemaPool.instance().contains(rolapSchema);
    }

    @Override
    public Cube lookupCube(String cube, boolean failIfNotFound) {
        RolapCube mdxCube = this.lookupCube(cube);
        if (mdxCube == null && failIfNotFound) {
            throw MondrianResource.instance().MdxCubeNotFound.ex(cube);
        }
        return mdxCube;
    }

    protected RolapCube lookupCube(String cubeName) {
        return this.mapNameToCube.get(Util.normalizeName(cubeName));
    }

    public List<RolapCube> getCubesWithStar(RolapStar star) {
        ArrayList<RolapCube> list = new ArrayList<RolapCube>();
        block0: for (RolapCube cube : this.mapNameToCube.values()) {
            for (Member member : cube.getMeasures()) {
                RolapStoredMeasure measure;
                if (!(member instanceof RolapStoredMeasure) || (measure = (RolapStoredMeasure)member).getStarMeasure().getStar() != star) continue;
                list.add(cube);
                continue block0;
            }
        }
        return list;
    }

    public NamedSet getNamedSet(IdentifierSegment segment) {
        for (Map.Entry<String, NamedSet> entry : this.mapNameToSet.entrySet()) {
            if (!Util.matches(segment, entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    protected void addCube(RolapCube cube) {
        this.mapNameToCube.put(Util.normalizeName(cube.getName()), cube);
    }

    protected void addNamedSet(String name, NamedSet namedSet) {
        this.mapNameToSet.put(name, namedSet);
    }

    @Override
    public boolean removeCube(String cubeName) {
        RolapCube cube = this.mapNameToCube.remove(Util.normalizeName(cubeName));
        return cube != null;
    }

    @Override
    public Cube[] getCubes() {
        Collection<RolapCube> cubes = this.mapNameToCube.values();
        return cubes.toArray(new RolapCube[cubes.size()]);
    }

    public NamedList<RolapCube> getCubeList() {
        return new NamedListImpl(this.mapNameToCube.values());
    }

    @Override
    public Dimension[] getSharedDimensions() {
        Collection<RolapCubeDimension> dimensions = this.sharedDimensions.values();
        return dimensions.toArray(new RolapDimension[dimensions.size()]);
    }

    public NamedList<RolapCubeDimension> getSharedDimensionList() {
        return new NamedListImpl(this.sharedDimensions.values());
    }

    public NamedSet getNamedSet(String name) {
        return this.mapNameToSet.get(name);
    }

    @Override
    public Role lookupRole(String role) {
        RoleFactory roleFactory = this.mapNameToRole.get(role);
        if (roleFactory instanceof ConstantRoleFactory) {
            return ((ConstantRoleFactory)roleFactory).role;
        }
        return null;
    }

    public Set<String> roleNames() {
        return this.mapNameToRole.keySet();
    }

    @Override
    public FunTable getFunTable() {
        return this.funTable;
    }

    @Override
    public Parameter[] getParameters() {
        return this.parameterList.toArray(new Parameter[this.parameterList.size()]);
    }

    void defineFunction(Map<String, UdfResolver.UdfFactory> mapNameToUdf, final String name, String className, final Scripts.ScriptDefinition script) {
        UdfResolver.UdfFactory udfFactory;
        if (className == null && script == null) {
            throw Util.newError("Must specify either className attribute or Script element");
        }
        if (className != null && script != null) {
            throw Util.newError("Must not specify both className attribute and Script element");
        }
        if (className != null) {
            try {
                Class klass = ClassResolver.INSTANCE.forName(className, true);
                udfFactory = new UdfResolver.ClassUdfFactory(klass, name);
            }
            catch (ClassNotFoundException e) {
                throw MondrianResource.instance().UdfClassNotFound.ex(name, className);
            }
        } else {
            udfFactory = new UdfResolver.UdfFactory(){

                public UserDefinedFunction create() {
                    return Scripts.userDefinedFunction(script, name);
                }
            };
        }
        this.validateFunction(udfFactory);
        UdfResolver.UdfFactory existingUdf = mapNameToUdf.get(name);
        if (existingUdf != null) {
            throw MondrianResource.instance().UdfDuplicateName.ex(name);
        }
        mapNameToUdf.put(name, udfFactory);
    }

    private void validateFunction(UdfResolver.UdfFactory udfFactory) {
        UserDefinedFunction udf = udfFactory.create();
        String udfName = udf.getName();
        if (udfName == null || udfName.equals("")) {
            throw Util.newInternal("User-defined function defined by class '" + udf.getClass() + "' has empty name");
        }
        String description = udf.getDescription();
        Util.discard((Object)description);
        Type[] parameterTypes = udf.getParameterTypes();
        for (int i = 0; i < parameterTypes.length; ++i) {
            Type parameterType = parameterTypes[i];
            if (parameterType != null) continue;
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': parameter type #" + i + " is null");
        }
        String[] reservedWords = udf.getReservedWords();
        Util.discard((Object)reservedWords);
        Type returnType = udf.getReturnType(parameterTypes);
        if (returnType == null) {
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': return type is null");
        }
        Syntax syntax = udf.getSyntax();
        if (syntax == null) {
            throw Util.newInternal("Invalid user-defined function '" + udfName + "': syntax is null");
        }
    }

    MemberReader createMemberReader(RolapCubeHierarchy hierarchy, String memberReaderClass) {
        if (memberReaderClass != null) {
            ReflectiveOperationException e2;
            try {
                Object properties = null;
                Class clazz = ClassResolver.INSTANCE.forName(memberReaderClass, true);
                Constructor constructor = clazz.getConstructor(RolapHierarchy.class, Properties.class);
                Object o = constructor.newInstance(hierarchy, properties);
                if (o instanceof MemberReader) {
                    return (MemberReader)o;
                }
                if (o instanceof MemberSource) {
                    return new CacheMemberReader((MemberSource)o);
                }
                throw Util.newInternal("member reader class " + clazz + " does not implement " + MemberSource.class);
            }
            catch (ClassNotFoundException e) {
                e2 = e;
            }
            catch (NoSuchMethodException e) {
                e2 = e;
            }
            catch (InstantiationException e) {
                e2 = e;
            }
            catch (IllegalAccessException e) {
                e2 = e;
            }
            catch (InvocationTargetException e) {
                e2 = e;
            }
            throw Util.newInternal(e2, "while instantiating member reader '" + memberReaderClass);
        }
        if (hierarchy.getDimension().hanger) {
            ArrayList<RolapMember> memberList = new ArrayList<RolapMember>();
            if (hierarchy.hasAll()) {
                memberList.add(hierarchy.getAllMember());
            }
            return new CacheMemberReader(new HangerMemberSource(hierarchy, memberList));
        }
        DataServicesProvider provider = DataServicesLocator.getDataServicesProvider(this.getDataServiceProviderName());
        MemberReader source = provider.getMemberReader(hierarchy);
        if (MondrianProperties.instance().DisableCaching.get()) {
            return new NoCacheMemberReader(source);
        }
        return new SmartMemberReader(source);
    }

    public String getDataServiceProviderName() {
        return this.dataServicesProvider;
    }

    @Override
    public SchemaReader getSchemaReader() {
        return new RolapSchemaReader(this.rootRole, this).withLocus();
    }

    public ByteString getChecksum() {
        return this.md5Bytes;
    }

    public RolapConnection getInternalConnection() {
        return this.internalConnection;
    }

    private RolapStar makeRolapStar(PhysRelation fact) {
        DataSource dataSource = this.getInternalConnection().getDataSource();
        return new RolapStar(this, dataSource, fact);
    }

    void registerRoles(Map<String, RoleFactory> roles, RoleFactory defaultRole) {
        for (Map.Entry<String, RoleFactory> entry : roles.entrySet()) {
            this.mapNameToRole.put(entry.getKey(), entry.getValue());
        }
        this.defaultRole = defaultRole;
    }

    void initFunctionTable(Collection<UdfResolver.UdfFactory> userDefinedFunctions) {
        this.funTable = new RolapSchemaFunctionTable(userDefinedFunctions);
        ((RolapSchemaFunctionTable)this.funTable).init();
    }

    public RolapStarRegistry getRolapStarRegistry() {
        return this.rolapStarRegistry;
    }

    public RolapStar getStar(String factTableName) {
        return this.getRolapStarRegistry().getStar(factTableName);
    }

    public Collection<RolapStar> getStars() {
        return this.getRolapStarRegistry().getStars();
    }

    RolapNativeRegistry getNativeRegistry() {
        return this.nativeRegistry;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class GeneratingRoleFactory
    implements RoleFactory {
        private final RoleGenerator generator;

        public GeneratingRoleFactory(RoleGenerator generator) {
            this.generator = generator;
        }

        @Override
        public Role create(Map<String, Object> context) {
            String s = this.generator.asXml(context);
            Pair<RoleFactory, String> pair = RolapSchema.this.createRole(s, NamePolicy.NAMELESS);
            return ((RoleFactory)pair.left).create(context);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnionRoleFactory
    implements RoleFactory {
        private final List<RoleFactory> factories;

        public UnionRoleFactory(List<RoleFactory> factories) {
            this.factories = factories;
        }

        @Override
        public Role create(final Map<String, Object> context) {
            return RoleImpl.union((List<Role>)new AbstractList<Role>(){

                @Override
                public Role get(int index) {
                    return ((RoleFactory)UnionRoleFactory.this.factories.get(index)).create(context);
                }

                @Override
                public int size() {
                    return UnionRoleFactory.this.factories.size();
                }
            });
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class ConstantRoleFactory
    implements RoleFactory {
        private final Role role;

        ConstantRoleFactory(Role role) {
            this.role = role;
        }

        @Override
        public Role create(Map<String, Object> context) {
            return this.role;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface RoleFactory {
        public Role create(Map<String, Object> var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum NamePolicy {
        NAMED,
        SYSTEM_GENERATED,
        NAMELESS;

    }

    public static class PhysStatistic {
        private final Map<List, Integer> columnMap = new HashMap<List, Integer>();
        private final Map<List, Integer> tableMap = new HashMap<List, Integer>();
        private final Map<String, Integer> queryMap = new HashMap<String, Integer>();
        private final Dialect dialect;
        private final Statement internalStatement;
        private final DataSource dataSource;

        PhysStatistic(Dialect dialect, RolapConnection internalConnection) {
            this.dialect = dialect;
            this.internalStatement = internalConnection.getInternalStatement();
            this.dataSource = internalConnection.getDataSource();
        }

        public int getRelationCardinality(PhysRelation relation, String alias, int approxRowCount) {
            if (approxRowCount >= 0) {
                return approxRowCount;
            }
            if (relation instanceof PhysTable) {
                PhysTable table = (PhysTable)relation;
                return this.getTableCardinality(null, table.getSchemaName(), table.name);
            }
            SqlQuery sqlQuery = new SqlQuery(this.dialect);
            sqlQuery.addSelect("1", null);
            sqlQuery.addFrom(relation, null, true);
            return this.getQueryCardinality(sqlQuery.toString());
        }

        private int getTableCardinality(String catalog, String schema, String table) {
            List<String> key = Arrays.asList(catalog, schema, table);
            int rowCount = -1;
            if (this.tableMap.containsKey(key)) {
                rowCount = this.tableMap.get(key);
            } else {
                StatisticsProvider statisticsProvider;
                Dialect dialect = this.dialect;
                List<StatisticsProvider> statisticsProviders = dialect.getStatisticsProviders();
                Execution execution = new Execution(this.internalStatement, 0L);
                Iterator<StatisticsProvider> i$ = statisticsProviders.iterator();
                while (i$.hasNext() && (rowCount = (statisticsProvider = i$.next()).getTableCardinality(dialect, this.dataSource, catalog, schema, table, execution)) < 0) {
                }
                this.tableMap.put(key, rowCount);
            }
            return rowCount;
        }

        private int getQueryCardinality(String sql) {
            int rowCount = -1;
            if (this.queryMap.containsKey(sql)) {
                rowCount = this.queryMap.get(sql);
            } else {
                StatisticsProvider statisticsProvider;
                Dialect dialect = this.dialect;
                List<StatisticsProvider> statisticsProviders = dialect.getStatisticsProviders();
                Execution execution = new Execution(this.internalStatement, 0L);
                Iterator<StatisticsProvider> i$ = statisticsProviders.iterator();
                while (i$.hasNext() && (rowCount = (statisticsProvider = i$.next()).getQueryCardinality(dialect, this.dataSource, sql, execution)) < 0) {
                }
                this.queryMap.put(sql, rowCount);
            }
            return rowCount;
        }

        public int getColumnCardinality(PhysRelation relation, PhysColumn column, int approxCardinality) {
            if (approxCardinality >= 0) {
                return approxCardinality;
            }
            if (relation instanceof PhysTable && column instanceof PhysRealColumn) {
                PhysTable table = (PhysTable)relation;
                return this.getColumnCardinality(null, table.getSchemaName(), table.name, column.name);
            }
            SqlQuery sqlQuery = new SqlQuery(this.dialect);
            sqlQuery.setDistinct(true);
            sqlQuery.addSelect(column.toSql(), null);
            sqlQuery.addFrom(relation, null, true);
            return this.getQueryCardinality(sqlQuery.toString());
        }

        private int getColumnCardinality(String catalog, String schema, String table, String column) {
            List<String> key = Arrays.asList(catalog, schema, table, column);
            int rowCount = -1;
            if (this.columnMap.containsKey(key)) {
                rowCount = this.columnMap.get(key);
            } else {
                StatisticsProvider statisticsProvider;
                List<StatisticsProvider> statisticsProviders = this.dialect.getStatisticsProviders();
                Execution execution = new Execution(this.internalStatement, 0L);
                Iterator<StatisticsProvider> i$ = statisticsProviders.iterator();
                while (i$.hasNext() && (rowCount = (statisticsProvider = i$.next()).getColumnCardinality(this.dialect, this.dataSource, catalog, schema, table, column, execution)) < 0) {
                }
                this.columnMap.put(key, rowCount);
            }
            return rowCount;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnresolvedCalcColumn
    extends UnresolvedColumn {
        private final PhysCalcColumn physCalcColumn;
        private final List<PhysExpr> list;
        private final int index;

        public UnresolvedCalcColumn(PhysTable physTable, String tableName, MondrianDef.Column columnRef, MondrianDef.SQL sql, PhysCalcColumn physCalcColumn, List<PhysExpr> list, int index) {
            super(physTable, tableName, columnRef.name, sql);
            this.physCalcColumn = physCalcColumn;
            this.list = list;
            this.index = index;
        }

        @Override
        public String getContext() {
            return ", in definition of calculated column '" + this.physCalcColumn.relation.getAlias() + "'.'" + this.physCalcColumn.name + "'";
        }

        @Override
        public void onResolve(PhysColumn column) {
            this.list.set(this.index, column);
            this.physCalcColumn.compute();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum Severity {
        WARNING,
        ERROR,
        FATAL;

    }

    public static class MondrianSchemaException
    extends RuntimeException {
        private final XmlLocation xmlLocation;

        public MondrianSchemaException(String message, String nodeDesc, XmlLocation xmlLocation, Severity severity, Throwable cause) {
            super(message + (nodeDesc == null ? "" : " (in " + nodeDesc + ")") + (xmlLocation == null ? "" : " (at " + xmlLocation + ")"), cause);
            this.xmlLocation = xmlLocation;
        }

        public XmlLocation getXmlLocation() {
            return this.xmlLocation;
        }
    }

    public static class PhysSchemaException
    extends Exception {
        public PhysSchemaException(String message) {
            super(message);
        }
    }

    public static class CubeRouter
    implements PhysRouter {
        private final RolapMeasureGroup measureGroup;
        private final RolapCubeDimension cubeDimension;

        public CubeRouter(RolapMeasureGroup measureGroup, RolapCubeDimension cubeDimension) {
            this.measureGroup = measureGroup;
            this.cubeDimension = cubeDimension;
        }

        public String toString() {
            return "CubeRouter(cube=" + this.measureGroup.getCube().getName() + ", measureGroup=" + this.measureGroup.getName() + ", dimension=" + this.cubeDimension.getName() + ")";
        }

        public PhysPath path(PhysColumn column) {
            return this.measureGroup.getPath(this.cubeDimension, column);
        }
    }

    public static class NoRouter
    implements PhysRouter {
        public static final NoRouter INSTANCE = new NoRouter();

        private NoRouter() {
        }

        public PhysPath path(PhysColumn column) {
            return null;
        }
    }

    public static class BadRouter
    implements PhysRouter {
        public static final BadRouter INSTANCE = new BadRouter();

        private BadRouter() {
        }

        public PhysPath path(PhysColumn column) {
            throw new UnsupportedOperationException();
        }
    }

    public static interface PhysRouter {
        public PhysPath path(PhysColumn var1);
    }

    public class PhysHintImpl
    implements PhysHint {
    }

    public static interface PhysHint {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PhysPathBuilder {
        private final List<PhysHop> hopList = new ArrayList<PhysHop>();

        private PhysPathBuilder() {
        }

        public PhysPathBuilder(PhysRelation relation) {
            this();
            this.hopList.add(new PhysHop(relation, null, true));
        }

        public PhysPathBuilder(PhysPath path) {
            this();
            this.hopList.addAll(path.hopList);
        }

        public PhysPathBuilder add(PhysKey sourceKey, List<PhysColumn> columnList) {
            PhysHop prevHop = this.hopList.get(this.hopList.size() - 1);
            this.add(new PhysLink(sourceKey, prevHop.relation, columnList), sourceKey.relation, true);
            return this;
        }

        public PhysPathBuilder add(PhysLink link, PhysRelation relation, boolean forward) {
            return this.add(new PhysHop(relation, link, forward));
        }

        public PhysPathBuilder add(PhysHop hop) {
            this.hopList.add(hop);
            return this;
        }

        public PhysPathBuilder prepend(PhysKey sourceKey, List<PhysColumn> columnList) {
            PhysHop prevHop = this.hopList.get(0);
            this.prepend(new PhysLink(sourceKey, prevHop.relation, columnList), sourceKey.relation, true);
            return this;
        }

        public PhysPathBuilder prepend(PhysLink link, PhysRelation relation, boolean forward) {
            if (this.hopList.size() == 0) {
                assert (link == null);
            } else {
                PhysHop hop0 = this.hopList.get(0);
                this.hopList.set(0, new PhysHop(hop0.relation, link, forward));
            }
            this.hopList.add(0, new PhysHop(relation, null, true));
            return this;
        }

        public PhysPath done() {
            return new PhysPath((List<PhysHop>)UnmodifiableArrayList.of(this.hopList));
        }

        public PhysPathBuilder clone() {
            PhysPathBuilder pathBuilder = new PhysPathBuilder();
            pathBuilder.hopList.addAll(this.hopList);
            return pathBuilder;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PhysPath {
        public final List<PhysHop> hopList;
        public static final PhysPath EMPTY = new PhysPath(Collections.<PhysHop>emptyList());

        public PhysPath(List<PhysHop> hopList) {
            this.hopList = hopList;
            for (int i = 0; i < hopList.size(); ++i) {
                PhysHop hop = hopList.get(i);
                if (i == 0) {
                    assert (hop.link == null);
                    continue;
                }
                assert (hop.relation == hop.fromRelation());
                assert (hopList.get((int)(i - 1)).relation == hop.toRelation());
            }
        }

        public List<PhysLink> getLinks() {
            return new AbstractList<PhysLink>(){

                @Override
                public PhysLink get(int index) {
                    return PhysPath.this.hopList.get((int)(index + 1)).link;
                }

                @Override
                public int size() {
                    return PhysPath.this.hopList.size() - 1;
                }
            };
        }
    }

    public static class PhysHop {
        public final PhysRelation relation;
        public final PhysLink link;
        public final boolean forward;

        public PhysHop(PhysRelation relation, PhysLink link, boolean forward) {
            assert (relation != null);
            this.relation = relation;
            this.link = link;
            this.forward = forward;
        }

        public boolean equals(Object obj) {
            return obj instanceof PhysHop && this.relation.equals(((PhysHop)obj).relation) && Util.equals(this.link, ((PhysHop)obj).link) && this.forward == ((PhysHop)obj).forward;
        }

        public int hashCode() {
            return Util.hashV(0, this.relation, this.link, this.forward);
        }

        public final PhysRelation fromRelation() {
            return this.forward ? this.link.sourceKey.relation : this.link.targetRelation;
        }

        public final PhysRelation toRelation() {
            return this.forward ? this.link.targetRelation : this.link.sourceKey.relation;
        }
    }

    public static abstract class UnresolvedColumn
    extends PhysColumn {
        State state = State.UNRESOLVED;
        final String tableName;
        final String name;
        final ElementDef xml;

        public UnresolvedColumn(PhysRelation relation, String tableName, String name, ElementDef xml) {
            super(relation, name, 0, Dialect.Datatype.Boolean, null);
            assert (tableName != null);
            assert (name != null);
            this.tableName = tableName;
            this.name = name;
            this.xml = xml;
        }

        public abstract void onResolve(PhysColumn var1);

        public abstract String getContext();

        public String toString() {
            return this.tableName + "." + this.name;
        }

        public String toSql() {
            throw new UnsupportedOperationException("unresolved column " + this);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        public static enum State {
            UNRESOLVED,
            ACTIVE,
            RESOLVED,
            ERROR;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PhysCalcExpr
    extends PhysExpr {
        final List<PhysExpr> list;
        private final String sql;

        PhysCalcExpr(List<PhysExpr> list) {
            assert (list != null);
            this.list = list;
            this.sql = this.deriveSql();
        }

        @Override
        public Dialect.Datatype getDatatype() {
            return null;
        }

        @Override
        public SqlStatement.Type getInternalType() {
            return null;
        }

        @Override
        public String toSql() {
            return this.sql;
        }

        protected String deriveSql() {
            StringBuilder buf = new StringBuilder();
            for (PhysExpr o : this.list) {
                buf.append(o.toSql());
            }
            return buf.toString();
        }

        @Override
        public void foreachColumn(Util.Function1<PhysColumn, Void> fn) {
            for (PhysExpr o : this.list) {
                if (!(o instanceof PhysExpr)) continue;
                o.foreachColumn(fn);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static final class PhysCalcColumn
    extends PhysColumn {
        private RolapSchemaLoader loader;
        private NodeDef xmlNode;
        final List<PhysExpr> list;
        private String sql;

        PhysCalcColumn(RolapSchemaLoader loader, NodeDef xmlNode, PhysRelation table, String name, Dialect.Datatype datatype, SqlStatement.Type internalType, List<PhysExpr> list) {
            super(table, name, 4, datatype, internalType);
            this.loader = loader;
            this.xmlNode = xmlNode;
            this.list = list;
            this.compute();
        }

        public void compute() {
            if (this.loader != null && !this.list.isEmpty() && this.getUnresolvedColumnCount() == 0) {
                this.sql = this.deriveSql();
                if (this.datatype == null) {
                    PhysSchema physSchema = this.relation.getSchema();
                    SqlQuery query = new SqlQuery(physSchema.dialect);
                    query.addSelect(this.sql, null);
                    query.addFrom(this.relation, this.relation.getAlias(), true);
                    List<ColumnInfo> columnInfoList = physSchema.describe(this.loader, this.xmlNode, query.toSql());
                    if (columnInfoList != null && columnInfoList.size() == 1) {
                        this.datatype = columnInfoList.get((int)0).datatype;
                    }
                }
                this.loader = null;
                this.xmlNode = null;
            }
        }

        private int getUnresolvedColumnCount() {
            int unresolvedCount = 0;
            for (PhysExpr expr : this.list) {
                if (!(expr instanceof UnresolvedColumn)) continue;
                ++unresolvedCount;
            }
            return unresolvedCount;
        }

        @Override
        public String toSql() {
            return this.sql;
        }

        protected String deriveSql() {
            StringBuilder buf = new StringBuilder();
            for (PhysExpr expr : this.list) {
                buf.append(expr.toSql());
            }
            return buf.toString();
        }

        @Override
        public void foreachColumn(Util.Function1<PhysColumn, Void> callback) {
            for (PhysExpr physExpr : this.list) {
                physExpr.foreachColumn(callback);
            }
        }

        public List<PhysExpr> getList() {
            return this.list;
        }
    }

    public static final class PhysRealColumn
    extends PhysColumn {
        private final String sql = this.deriveSql();

        PhysRealColumn(PhysRelation relation, String name, Dialect.Datatype datatype, SqlStatement.Type internalType, int columnSize) {
            super(relation, name, columnSize, datatype, internalType);
        }

        PhysColumn cloneWithAlias(PhysRelation newRelation) {
            return new PhysRealColumn(newRelation, this.name, this.datatype, this.internalType, this.columnSize);
        }

        protected String deriveSql() {
            return this.relation.getSchema().dialect.quoteIdentifier(this.relation.getAlias()) + '.' + this.relation.getSchema().dialect.quoteIdentifier(this.name);
        }

        public int hashCode() {
            return Util.hash(this.name.hashCode(), this.relation);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PhysRealColumn) {
                PhysRealColumn that = (PhysRealColumn)obj;
                return this.name.equals(that.name) && this.relation.equals(that.relation);
            }
            return false;
        }

        public String toSql() {
            return this.sql;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PhysColumn
    extends PhysExpr {
        public final PhysRelation relation;
        public final String name;
        Dialect.Datatype datatype;
        protected final int columnSize;
        private final int ordinal;
        SqlStatement.Type internalType;

        public PhysColumn(PhysRelation relation, String name, int columnSize, Dialect.Datatype datatype, SqlStatement.Type internalType) {
            assert (relation != null);
            assert (name != null);
            this.name = name;
            this.relation = relation;
            this.columnSize = columnSize;
            this.datatype = datatype;
            this.internalType = internalType;
            this.ordinal = relation.getSchema().columnCount++;
        }

        public String toString() {
            return this.toSql();
        }

        public void setDatatype(Dialect.Datatype datatype) {
            this.datatype = datatype;
        }

        @Override
        public Dialect.Datatype getDatatype() {
            return this.datatype;
        }

        @Override
        public SqlStatement.Type getInternalType() {
            return this.internalType;
        }

        @Override
        public void foreachColumn(Util.Function1<PhysColumn, Void> callback) {
            callback.apply(this);
        }

        public int getColumnSize() {
            return this.columnSize;
        }

        public final int ordinal() {
            return this.ordinal;
        }

        public void setInternalType(SqlStatement.Type internalType) {
            this.internalType = internalType;
        }

        PhysColumn cloneWithAlias(PhysRelation newRelation) {
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PhysTextExpr
    extends PhysExpr {
        private final String text;

        PhysTextExpr(String s) {
            this.text = s;
        }

        @Override
        public String toSql() {
            return this.text;
        }

        @Override
        public void foreachColumn(Util.Function1<PhysColumn, Void> callback) {
        }

        @Override
        public Dialect.Datatype getDatatype() {
            return null;
        }

        @Override
        public SqlStatement.Type getInternalType() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class PhysExpr {
        public abstract String toSql();

        public abstract void foreachColumn(Util.Function1<PhysColumn, Void> var1);

        public final void foreachColumn(final SqlQueryBuilder queryBuilder, final SqlQueryBuilder.Joiner joiner) {
            this.foreachColumn(new Util.Function1<PhysColumn, Void>(){

                @Override
                public Void apply(PhysColumn column) {
                    joiner.addColumn(queryBuilder, column);
                    return null;
                }
            });
        }

        public abstract Dialect.Datatype getDatatype();

        public abstract SqlStatement.Type getInternalType();

        public Iterable<? extends PhysColumn> columns() {
            final LinkedHashSet set = new LinkedHashSet();
            this.foreachColumn(null, new SqlQueryBuilder.Joiner(){

                public void addColumn(SqlQueryBuilder queryBuilder, PhysColumn column) {
                    set.add(column);
                }

                public void addRelation(SqlQueryBuilder queryBuilder, PhysRelation relation) {
                }
            });
            return set;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PhysLink
    implements DirectedGraph.Edge<PhysRelation> {
        final PhysKey sourceKey;
        public final PhysRelation targetRelation;
        final List<PhysColumn> columnList;
        public final String sql;

        public PhysLink(PhysKey sourceKey, PhysRelation targetRelation, List<PhysColumn> columnList) {
            this.sourceKey = sourceKey;
            this.targetRelation = targetRelation;
            this.columnList = columnList;
            assert (columnList.size() == sourceKey.columnList.size()) : columnList + " vs. " + sourceKey.columnList;
            for (PhysColumn column : columnList) {
                assert (column.relation == targetRelation) : column.relation + "/" + targetRelation;
            }
            this.sql = this.deriveSql();
        }

        public int hashCode() {
            return Util.hashV(0, this.sourceKey, this.targetRelation, this.columnList);
        }

        public boolean equals(Object obj) {
            if (obj instanceof PhysLink) {
                PhysLink that = (PhysLink)obj;
                return this.sourceKey.equals(that.sourceKey) && this.targetRelation.equals(that.targetRelation) && this.columnList.equals(that.columnList);
            }
            return false;
        }

        public String toString() {
            return "Link from " + this.targetRelation + " " + this.columnList + " to " + this.sourceKey;
        }

        @Override
        public PhysRelation getFrom() {
            return this.targetRelation;
        }

        @Override
        public PhysRelation getTo() {
            return this.sourceKey.relation;
        }

        public String toSql() {
            return this.sql;
        }

        private String deriveSql() {
            StringBuilder buf = new StringBuilder();
            for (int i = 0; i < this.columnList.size(); ++i) {
                if (buf.length() > 0) {
                    buf.append(" and ");
                }
                PhysColumn targetColumn = this.columnList.get(i);
                PhysExpr sourceColumn = this.sourceKey.columnList.get(i);
                buf.append(targetColumn.toSql()).append(" = ").append(sourceColumn.toSql());
            }
            return buf.toString();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PhysKey {
        final PhysRelation relation;
        final List<PhysColumn> columnList;
        final String name;

        public PhysKey(PhysRelation relation, String name, List<PhysColumn> columnList) {
            assert (relation != null);
            assert (name != null);
            assert (columnList != null);
            this.relation = relation;
            this.name = name;
            this.columnList = columnList;
        }

        public int hashCode() {
            return Util.hashV(0, this.relation, this.columnList);
        }

        public boolean equals(Object obj) {
            if (obj instanceof PhysKey) {
                PhysKey that = (PhysKey)obj;
                return this.relation.equals(that.relation) && this.columnList.equals(that.columnList);
            }
            return false;
        }

        public String toString() {
            return "[Key " + this.relation + " (" + this.columnList + ")]";
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PhysTable
    extends PhysRelationImpl {
        final String schemaName;
        final String name;
        private Map<String, String> hintMap;
        private int rowCount;
        private Hook hook;

        public PhysTable(PhysSchema physSchema, String schemaName, String name, String alias, Map<String, String> hintMap) {
            super(physSchema, alias);
            this.schemaName = schemaName;
            this.name = name;
            this.hintMap = hintMap;
            assert (name != null);
            assert (alias != null);
        }

        @Override
        public PhysRelation cloneWithAlias(String newAlias) {
            PhysTable physTable = new PhysTable(this.physSchema, this.schemaName, this.name, newAlias, this.hintMap);
            physTable.addAllColumns(this);
            physTable.addAllKeys(this);
            physTable.setPopulated(true);
            physTable.setRowCount(this.getRowCount());
            return physTable;
        }

        private void setRowCount(int rowCount) {
            this.rowCount = rowCount;
        }

        public String toString() {
            return (this.schemaName == null ? "" : this.schemaName + '.') + this.name + (this.name.equals(this.alias) ? "" : " as " + this.alias);
        }

        @Override
        public int hashCode() {
            return Util.hashV(0, this.physSchema, this.schemaName, this.name, this.alias);
        }

        @Override
        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PhysTable) {
                PhysTable that = (PhysTable)obj;
                return this.alias.equals(that.alias) && this.name.equals(that.name) && this.schemaName.equals(that.schemaName) && this.physSchema.equals(that.physSchema);
            }
            return false;
        }

        public String getSchemaName() {
            return this.schemaName;
        }

        public String getName() {
            return this.name;
        }

        @Override
        protected boolean populateColumns(RolapSchemaLoader loader, NodeDef xmlNode, int[] rowCountAndSize) {
            JdbcSchema.Table jdbcTable = this.physSchema.jdbcSchema.getTable(this.name);
            if (jdbcTable == null) {
                if (this.hook == null) {
                    loader.getHandler().warning("Table '" + this.name + "' does not exist in database.", xmlNode, null);
                    return false;
                }
                this.hook.apply(this, loader.schema.getInternalConnection());
                this.hook = null;
                try {
                    jdbcTable = this.physSchema.jdbcSchema.reloadTable(this.name);
                }
                catch (SQLException e) {
                    throw Util.newError("Error while re-loading table '" + this.name + "'");
                }
            }
            try {
                jdbcTable.load();
            }
            catch (SQLException e) {
                throw Util.newError("Error while loading columns of table '" + this.name + "'");
            }
            this.rowCount = this.physSchema.statistic.getRelationCardinality(this, this.alias, -1);
            for (JdbcSchema.Table.Column jdbcColumn : jdbcTable.getColumns()) {
                PhysColumn column = (PhysColumn)this.columnsByName.get(jdbcColumn.getName());
                if (column != null) continue;
                column = new PhysRealColumn((PhysRelation)this, jdbcColumn.getName(), jdbcColumn.getDatatype(), null, jdbcColumn.getColumnSize());
                this.addColumn(column);
            }
            return true;
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        public Map<String, String> getHintMap() {
            return this.hintMap;
        }

        public void setHook(Hook hook) {
            this.hook = hook;
        }

        static interface Hook {
            public boolean apply(PhysTable var1, RolapConnection var2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PhysInlineTable
    extends PhysRelationImpl
    implements PhysRelation {
        final List<String[]> rowList = new ArrayList<String[]>();

        PhysInlineTable(PhysSchema physSchema, String alias) {
            super(physSchema, alias);
            assert (alias != null);
        }

        @Override
        public PhysRelation cloneWithAlias(String newAlias) {
            PhysInlineTable physInlineTable = new PhysInlineTable(this.physSchema, newAlias);
            physInlineTable.addAllColumns(this);
            physInlineTable.addAllKeys(this);
            physInlineTable.setPopulated(true);
            physInlineTable.setRowList(this.rowList);
            return physInlineTable;
        }

        private void setRowList(List<String[]> rowList) {
            this.rowList.addAll(rowList);
        }

        public String toString() {
            return this.alias;
        }

        @Override
        public int hashCode() {
            return Util.hashV(0, this.physSchema, this.alias);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof PhysInlineTable) {
                PhysInlineTable that = (PhysInlineTable)obj;
                return this.alias.equals(that.alias) && this.physSchema.equals(that.physSchema);
            }
            return false;
        }

        @Override
        protected boolean populateColumns(RolapSchemaLoader loader, NodeDef xmlNode, int[] rowCountAndSize) {
            rowCountAndSize[0] = this.rowList.size();
            rowCountAndSize[1] = this.columnsByName.size() * 4;
            return true;
        }
    }

    static class ColumnInfo {
        String name;
        Dialect.Datatype datatype;
        int size;

        public ColumnInfo(String name, Dialect.Datatype datatype, int size) {
            this.name = name;
            this.datatype = datatype;
            this.size = size;
        }
    }

    public static class PhysView
    extends PhysRelationImpl
    implements PhysRelation {
        private final String sqlString;

        PhysView(PhysSchema physSchema, String alias, String sqlString) {
            super(physSchema, alias);
            this.sqlString = sqlString;
            assert (sqlString != null && sqlString.length() > 0) : sqlString;
        }

        public PhysRelation cloneWithAlias(String newAlias) {
            PhysView physView = new PhysView(this.physSchema, newAlias, this.sqlString);
            physView.addAllColumns(this);
            physView.addAllKeys(this);
            physView.setPopulated(true);
            return physView;
        }

        public String getSqlString() {
            return this.sqlString;
        }

        public int hashCode() {
            return Util.hashV(0, this.physSchema, this.alias, this.sqlString);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj instanceof PhysView) {
                PhysView that = (PhysView)obj;
                return this.alias.equals(that.alias) && this.sqlString.equals(that.sqlString) && this.physSchema.equals(that.physSchema);
            }
            return false;
        }

        protected boolean populateColumns(RolapSchemaLoader loader, NodeDef xmlNode, int[] rowCountAndSize) {
            List<ColumnInfo> columnInfoList = this.physSchema.describe(loader, xmlNode, this.sqlString);
            if (columnInfoList == null) {
                return false;
            }
            for (ColumnInfo columnInfo : columnInfoList) {
                this.addColumn(new PhysRealColumn((PhysRelation)this, columnInfo.name, columnInfo.datatype, null, columnInfo.size));
            }
            boolean rowCount = true;
            int rowByteCount = 0;
            for (PhysColumn physColumn : this.columnsByName.values()) {
                rowByteCount += physColumn.getColumnSize();
            }
            rowCountAndSize[0] = 1;
            rowCountAndSize[1] = rowByteCount;
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static abstract class PhysRelationImpl
    implements PhysRelation {
        final PhysSchema physSchema;
        final String alias;
        final LinkedHashMap<String, PhysColumn> columnsByName = new LinkedHashMap();
        final LinkedHashMap<String, PhysKey> keysByName = new LinkedHashMap();
        private boolean populated;
        private int totalColumnByteCount;
        private int rowCount;

        PhysRelationImpl(PhysSchema physSchema, String alias) {
            this.alias = alias;
            this.physSchema = physSchema;
        }

        LinkedHashMap<String, PhysColumn> getColumnsByName() {
            return this.columnsByName;
        }

        void setPopulated(boolean populated) {
            this.populated = populated;
        }

        public abstract int hashCode();

        public abstract boolean equals(Object var1);

        @Override
        public PhysSchema getSchema() {
            return this.physSchema;
        }

        void addAllColumns(PhysRelationImpl relation) {
            for (PhysColumn column : relation.getColumnsByName().values()) {
                this.addColumn(column.cloneWithAlias(this));
            }
        }

        void addAllKeys(PhysRelationImpl relation) {
            for (PhysKey physKey : relation.getKeyList()) {
                this.addKey(physKey.name, physKey.columnList);
            }
        }

        @Override
        public PhysColumn getColumn(String columnName, boolean fail) {
            PhysColumn column = this.columnsByName.get(columnName);
            if (column == null && fail) {
                throw Util.newError("Column '" + columnName + "' not found in relation '" + this + "'");
            }
            return column;
        }

        @Override
        public String getAlias() {
            return this.alias;
        }

        @Override
        public Collection<PhysKey> getKeyList() {
            return this.keysByName.values();
        }

        @Override
        public int getVolume() {
            return this.getTotalColumnSize() * this.getRowCount();
        }

        protected int getTotalColumnSize() {
            return this.totalColumnByteCount;
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        @Override
        public PhysKey lookupKey(List<PhysColumn> physColumnList, boolean add) {
            for (PhysKey key : this.keysByName.values()) {
                if (!key.columnList.equals(physColumnList)) continue;
                return key;
            }
            if (add) {
                String keyName;
                int i = this.keysByName.size();
                while (this.keysByName.containsKey(keyName = "key$" + i)) {
                    ++i;
                }
                return this.addKey(keyName, physColumnList);
            }
            return null;
        }

        @Override
        public PhysKey lookupKey(String keyName) {
            return this.keysByName.get(keyName);
        }

        @Override
        public PhysKey addKey(String keyName, List<PhysColumn> keyColumnList) {
            PhysKey key = new PhysKey(this, keyName, keyColumnList);
            PhysKey previous = this.keysByName.put(keyName, key);
            if (previous != null) {
                assert (previous.equals(key));
                this.keysByName.put(keyName, previous);
                return previous;
            }
            return key;
        }

        public boolean ensurePopulated(RolapSchemaLoader loader, NodeDef xmlNode) {
            if (!this.populated) {
                int[] rowCountAndSize = new int[2];
                this.populated = this.populateColumns(loader, xmlNode, rowCountAndSize);
                this.rowCount = rowCountAndSize[0];
                this.totalColumnByteCount = rowCountAndSize[1];
            }
            return this.populated;
        }

        protected abstract boolean populateColumns(RolapSchemaLoader var1, NodeDef var2, int[] var3);

        @Override
        public void addColumn(PhysColumn column) {
            this.columnsByName.put(column.name, column);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static interface PhysRelation {
        public PhysColumn getColumn(String var1, boolean var2);

        public String getAlias();

        public PhysSchema getSchema();

        public PhysKey addKey(String var1, List<PhysColumn> var2);

        public PhysKey lookupKey(List<PhysColumn> var1, boolean var2);

        public PhysKey lookupKey(String var1);

        public Collection<PhysKey> getKeyList();

        public int getVolume();

        public int getRowCount();

        public void addColumn(PhysColumn var1);

        public PhysRelation cloneWithAlias(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PhysSchemaGraph {
        private final PhysSchema physSchema;
        private final DirectedGraph<PhysRelation, PhysLink> graph = new DirectedGraph();

        public PhysSchemaGraph(PhysSchema physSchema, Collection<PhysLink> linkList) {
            this.physSchema = physSchema;
            for (PhysLink link : linkList) {
                this.addLink(link);
            }
        }

        public boolean addLink(PhysLink link) {
            assert (link.getFrom().getSchema() == this.physSchema);
            assert (link.getTo().getSchema() == this.physSchema);
            assert (this.physSchema.linkSet.contains(link));
            if (!this.graph.edgeList().contains(link)) {
                this.graph.addEdge(link);
                return true;
            }
            return false;
        }

        private void addHopsBetween(PhysPathBuilder pathBuilder, PhysRelation prevRelation, Set<PhysRelation> nextRelations, boolean directed) throws PhysSchemaException {
            if (nextRelations.contains(prevRelation)) {
                return;
            }
            if (nextRelations.size() == 0) {
                throw new IllegalArgumentException("nextRelations is empty");
            }
            if (directed) {
                List<PhysLink> path = this.findUniquePath(prevRelation, nextRelations);
                for (PhysLink link : path) {
                    if (!nextRelations.contains(link.targetRelation)) {
                        pathBuilder.add(link, link.sourceKey.relation, true);
                        continue;
                    }
                    break;
                }
            } else {
                List<Pair<PhysLink, Boolean>> path = this.findUniquePathUndirected(prevRelation, nextRelations);
                for (Pair<PhysLink, Boolean> pair : path) {
                    PhysRelation sourceRelation;
                    PhysLink link = (PhysLink)pair.left;
                    boolean forward = (Boolean)pair.right;
                    PhysRelation targetRelation = forward ? link.targetRelation : link.sourceKey.relation;
                    PhysRelation physRelation = sourceRelation = forward ? link.sourceKey.relation : link.targetRelation;
                    if (!nextRelations.contains(targetRelation)) {
                        pathBuilder.add(link, sourceRelation, forward);
                        continue;
                    }
                    break;
                }
            }
        }

        private List<PhysLink> findUniquePath(PhysRelation prevRelation, Set<PhysRelation> nextRelations) throws PhysSchemaException {
            block4: for (PhysRelation nextRelation : nextRelations) {
                List<List<PhysLink>> pathList = this.graph.findAllPaths(prevRelation, nextRelation);
                switch (pathList.size()) {
                    case 0: {
                        continue block4;
                    }
                    case 1: {
                        return pathList.get(0);
                    }
                }
                throw new PhysSchemaException("Needed to find exactly one path from " + prevRelation + " to " + nextRelation + ", but found " + pathList.size() + " (" + pathList + ")");
            }
            throw new PhysSchemaException("Could not find a path from " + prevRelation + " to any of " + nextRelations);
        }

        private List<Pair<PhysLink, Boolean>> findUniquePathUndirected(PhysRelation prevRelation, Set<PhysRelation> nextRelations) throws PhysSchemaException {
            block4: for (PhysRelation nextRelation : nextRelations) {
                List<List<Pair<PhysLink, Boolean>>> pathList = this.graph.findAllPathsUndirected(prevRelation, nextRelation);
                switch (pathList.size()) {
                    case 0: {
                        continue block4;
                    }
                    case 1: {
                        return pathList.get(0);
                    }
                }
                List<Pair<PhysLink, Boolean>> smallest = null;
                for (List<Pair<PhysLink, Boolean>> path : pathList) {
                    if (smallest != null && smallest.size() <= path.size()) continue;
                    smallest = path;
                }
                return smallest;
            }
            throw new PhysSchemaException("Could not find a path from " + prevRelation + " to any of " + nextRelations);
        }

        public PhysPath findPath(PhysRelation relation, PhysRelation relation1) throws PhysSchemaException {
            return this.findPath(relation, Collections.singleton(relation1), true);
        }

        public PhysPath findPath(PhysRelation relation, Set<PhysRelation> targetRelations, boolean directed) throws PhysSchemaException {
            PhysPathBuilder pathBuilder = new PhysPathBuilder(relation);
            this.addHopsBetween(pathBuilder, relation, targetRelations, directed);
            return pathBuilder.done();
        }

        public void findPath(PhysPathBuilder pathBuilder, PhysRelation relation) throws PhysSchemaException {
            this.addHopsBetween(pathBuilder, ((PhysHop)((PhysPathBuilder)pathBuilder).hopList.get((int)(((PhysPathBuilder)pathBuilder).hopList.size() - 1))).relation, Collections.singleton(relation), true);
        }
    }

    public static class AttributeGraph {
        private final DirectedGraph<RolapAttribute, AttributeLink> graph = new DirectedGraph();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class AttributeLink
    implements DirectedGraph.Edge<RolapAttribute> {
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class PhysSchema {
        final LinkedHashMap<String, PhysRelation> tablesByName = new LinkedHashMap();
        final Dialect dialect;
        final JdbcSchema jdbcSchema;
        final Set<PhysLink> linkSet = new HashSet<PhysLink>();
        private final Map<PhysRelation, List<PhysLink>> hardLinksFrom = new HashMap<PhysRelation, List<PhysLink>>();
        private int nextAliasId = 0;
        private final PhysSchemaGraph schemaGraph = new PhysSchemaGraph(this, Collections.<PhysLink>emptyList());
        private int columnCount;
        public final PhysStatistic statistic;

        public PhysSchema(Dialect dialect, RolapConnection internalConnection, DataServicesProvider dataServicesProvider) {
            this.dialect = dialect;
            this.jdbcSchema = JdbcSchema.makeDB(internalConnection.getDataSource(), dataServicesProvider.getJdbcSchemaFactory());
            this.jdbcSchema.load();
            this.statistic = new PhysStatistic(dialect, internalConnection);
        }

        public boolean addLink(PhysKey sourceKey, PhysRelation targetRelation, List<PhysColumn> columnList, boolean hard) {
            PhysLink physLink = new PhysLink(sourceKey, targetRelation, columnList);
            if (hard) {
                List<PhysLink> list = this.hardLinksFrom.get(targetRelation);
                if (list == null) {
                    list = new ArrayList<PhysLink>(1);
                    this.hardLinksFrom.put(targetRelation, list);
                }
                list.add(physLink);
            }
            if (this.linkSet.add(physLink)) {
                this.schemaGraph.addLink(physLink);
                return true;
            }
            return false;
        }

        public List<PhysLink> hardLinksFrom(PhysRelation from) {
            Util.deprecated("not used - remove", false);
            List<PhysLink> linkList = this.hardLinksFrom.get(from);
            if (linkList == null) {
                return Collections.emptyList();
            }
            return linkList;
        }

        public String newAlias() {
            String alias;
            while (this.tablesByName.containsKey(alias = "_" + this.nextAliasId++)) {
            }
            return alias;
        }

        public PhysSchemaGraph getGraph() {
            return this.schemaGraph;
        }

        public int getColumnCount() {
            return this.columnCount;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        List<ColumnInfo> describe(RolapSchemaLoader loader, NodeDef xmlNode, String sql) {
            ArrayList<ColumnInfo> arrayList;
            Connection connection = null;
            PreparedStatement pstmt = null;
            try {
                connection = this.jdbcSchema.getDataSource().getConnection();
                pstmt = connection.prepareStatement(sql);
                ResultSetMetaData metaData = pstmt.getMetaData();
                int columnCount = metaData.getColumnCount();
                ArrayList<ColumnInfo> columnInfoList = new ArrayList<ColumnInfo>();
                for (int i = 0; i < columnCount; ++i) {
                    String columnName = metaData.getColumnLabel(i + 1);
                    String typeName = metaData.getColumnTypeName(i + 1);
                    int type = metaData.getColumnType(i + 1);
                    int columnSize = metaData.getColumnDisplaySize(i + 1);
                    assert (columnSize > 0);
                    Dialect.Datatype datatype = this.dialect.sqlTypeToDatatype(typeName, type);
                    if (datatype == null) {
                        loader.getHandler().warning("Unknown data type " + typeName + " (" + type + ") for column " + columnName + " of view; mondrian is probably" + " not familiar with this database's type" + " system", xmlNode, null);
                        continue;
                    }
                    columnInfoList.add(new ColumnInfo(columnName, datatype, columnSize));
                }
                pstmt.close();
                pstmt = null;
                connection.close();
                connection = null;
                arrayList = columnInfoList;
            }
            catch (SQLException e) {
                List<ColumnInfo> list;
                try {
                    loader.getHandler().warning("View is invalid: " + e.getMessage() + "\nSQL: " + sql, xmlNode, null, e);
                    list = null;
                }
                catch (Throwable throwable) {
                    Util.close(null, pstmt, connection);
                    throw throwable;
                }
                Util.close(null, pstmt, connection);
                return list;
            }
            Util.close(null, pstmt, connection);
            return arrayList;
        }
    }

    static class XmlLocationImpl
    implements XmlLocation {
        private final NodeDef node;
        private final Location location;
        private final String attributeName;

        XmlLocationImpl(NodeDef node, Location location, String attributeName) {
            this.node = node;
            this.location = location;
            this.attributeName = attributeName;
        }

        public String toString() {
            return this.location == null ? "null" : this.location.toString();
        }

        public String getRange() {
            int start = this.location.getStartPos();
            int end = start + this.location.getText(true).length();
            return start + "-" + end;
        }

        public XmlLocation at(String attributeName) {
            if (Util.equals(attributeName, this.attributeName)) {
                return this;
            }
            return new XmlLocationImpl(this.node, this.location, attributeName);
        }
    }

    public static interface XmlLocation {
        public String getRange();

        public XmlLocation at(String var1);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RolapSchemaFunctionTable
    extends FunTableImpl {
        private final List<UdfResolver.UdfFactory> udfFactoryList;

        RolapSchemaFunctionTable(Collection<UdfResolver.UdfFactory> udfs) {
            this.udfFactoryList = new ArrayList<UdfResolver.UdfFactory>(udfs);
        }

        @Override
        public void defineFunctions(FunTable.Builder builder) {
            GlobalFunTable globalFunTable = GlobalFunTable.instance();
            for (String reservedWord : globalFunTable.getReservedWords()) {
                builder.defineReserved(reservedWord);
            }
            for (Resolver resolver : globalFunTable.getResolvers()) {
                builder.define(resolver);
            }
            for (UdfResolver.UdfFactory udfFactory : this.udfFactoryList) {
                builder.define(new UdfResolver(udfFactory));
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class RolapStarRegistry {
        private final Map<PhysRelation, RolapStar> stars = new HashMap<PhysRelation, RolapStar>();

        RolapStarRegistry() {
        }

        synchronized RolapStar getOrCreateStar(PhysRelation fact) {
            RolapStar star = this.stars.get(fact);
            if (star == null) {
                star = RolapSchema.this.makeRolapStar(fact);
                this.stars.put(fact, star);
            }
            return star;
        }

        synchronized RolapStar getStar(String factTableName) {
            for (RolapStar star : this.getStars()) {
                String starFactTable = star.getFactTable().getTableName();
                if (starFactTable == null || !starFactTable.equals(factTableName)) continue;
                return star;
            }
            return null;
        }

        synchronized Collection<RolapStar> getStars() {
            return this.stars.values();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class HangerMemberSource
    extends ArrayMemberSource {
        public HangerMemberSource(RolapCubeHierarchy hierarchy, List<RolapMember> memberList) {
            super(hierarchy, memberList);
        }
    }
}

