/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.sql.DataSource;
import mondrian.calc.Calc;
import mondrian.calc.DummyExp;
import mondrian.calc.ExpCompiler;
import mondrian.calc.TupleList;
import mondrian.calc.impl.AbstractListCalc;
import mondrian.calc.impl.ConstantCalc;
import mondrian.calc.impl.UnaryTupleList;
import mondrian.mdx.ResolvedFunCall;
import mondrian.olap.Access;
import mondrian.olap.Cube;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Exp;
import mondrian.olap.Formula;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.Larder;
import mondrian.olap.Larders;
import mondrian.olap.Level;
import mondrian.olap.Literal;
import mondrian.olap.LocalizedProperty;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.Mondrian3Def;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianException;
import mondrian.olap.MondrianProperties;
import mondrian.olap.MondrianServer;
import mondrian.olap.NameResolver;
import mondrian.olap.NamedSet;
import mondrian.olap.OlapElement;
import mondrian.olap.Property;
import mondrian.olap.Query;
import mondrian.olap.Role;
import mondrian.olap.RoleImpl;
import mondrian.olap.SchemaReader;
import mondrian.olap.SetBase;
import mondrian.olap.Util;
import mondrian.olap.fun.FunDefBase;
import mondrian.olap.fun.UdfResolver;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.NumericType;
import mondrian.olap.type.SetType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.Type;
import mondrian.resource.MondrianResource;
import mondrian.rolap.DateTableBuilder;
import mondrian.rolap.MemberReader;
import mondrian.rolap.RestrictedMemberReader;
import mondrian.rolap.RolapAggregator;
import mondrian.rolap.RolapAttribute;
import mondrian.rolap.RolapAttributeImpl;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapClosure;
import mondrian.rolap.RolapConnection;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapDimension;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapProperty;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaLoaderHandlerImpl;
import mondrian.rolap.RolapSchemaParameter;
import mondrian.rolap.RolapSchemaUpgrader;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapStoredMeasure;
import mondrian.rolap.SchemaKey;
import mondrian.rolap.SqlStatement;
import mondrian.rolap.TimeColumnRole;
import mondrian.rolap.aggmatcher.ExplicitRules;
import mondrian.server.Locus;
import mondrian.spi.CellFormatter;
import mondrian.spi.DataServicesLocator;
import mondrian.spi.DataServicesProvider;
import mondrian.spi.Dialect;
import mondrian.spi.MemberFormatter;
import mondrian.spi.PropertyFormatter;
import mondrian.spi.RoleGenerator;
import mondrian.spi.impl.Scripts;
import mondrian.util.ByteString;
import mondrian.util.ClassResolver;
import mondrian.util.Composite;
import mondrian.util.Lazy;
import mondrian.util.Pair;
import mondrian.util.UnionIterator;
import org.apache.commons.collections.map.MultiValueMap;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.ElementDef;
import org.eigenbase.xom.NodeDef;
import org.eigenbase.xom.Parser;
import org.eigenbase.xom.TextDef;
import org.eigenbase.xom.XOMException;
import org.eigenbase.xom.XOMUtil;
import org.olap4j.impl.Olap4jUtil;
import org.olap4j.impl.UnmodifiableArrayMap;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Level;
import org.olap4j.metadata.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapSchemaLoader {
    private static final Logger LOGGER = Logger.getLogger(RolapSchema.class);
    private static final Set<Access> schemaAllowed = Olap4jUtil.enumSetOf((Enum)Access.NONE, (Enum[])new Access[]{Access.ALL, Access.ALL_DIMENSIONS, Access.CUSTOM});
    private static final Set<Access> cubeAllowed = Olap4jUtil.enumSetOf((Enum)Access.NONE, (Enum[])new Access[]{Access.ALL, Access.CUSTOM});
    private static final Set<Access> dimensionAllowed = Olap4jUtil.enumSetOf((Enum)Access.NONE, (Enum[])new Access[]{Access.ALL, Access.CUSTOM});
    private static final Set<Access> hierarchyAllowed = Olap4jUtil.enumSetOf((Enum)Access.NONE, (Enum[])new Access[]{Access.ALL, Access.CUSTOM});
    private static final Set<Access> memberAllowed = Olap4jUtil.enumSetOf((Enum)Access.NONE, (Enum[])new Access[]{Access.ALL});
    private static final Map<String, Dialect.Datatype> DATATYPE_MAP = new HashMap<String, Dialect.Datatype>();
    static final String MEASURES_LEVEL_NAME = "MeasuresLevel";
    private static final RolapSchema.RoleFactory DUMMY_ROLE = new RolapSchema.ConstantRoleFactory(new RoleImpl());
    private static final String EMPTY_TABLE_NAME = "_empty";
    private static final String EMPTY_TABLE_SOLE_COLUMN_NAME = "c";
    private static final Pattern PROTOCOL_PATTERN;
    private static final Object DUMMY;
    private static final String FACT_COUNT_MEASURE_NAME = "Fact Count";
    RolapSchema schema;
    private PhysSchemaBuilder physSchemaBuilder;
    private final RolapSchemaValidatorImpl validator = new RolapSchemaValidatorImpl();
    private final Map<Pair<RolapMeasureGroup, RolapCubeDimension>, RolapSchema.PhysPath> dimensionPaths = new HashMap<Pair<RolapMeasureGroup, RolapCubeDimension>, RolapSchema.PhysPath>();
    private final Handler handler = new RolapSchemaLoaderHandlerImpl(){

        @Override
        protected List<RolapSchema.MondrianSchemaException> getWarningList() {
            return RolapSchemaLoader.this.schema == null ? null : RolapSchemaLoader.this.schema.warningList;
        }
    };
    private MissingLinkAction missingLinkAction;
    private final List<Util.Function0> postCubeActions = new ArrayList<Util.Function0>();
    private final SimpleDateFormat SIMPLE_DATE_FORMAT = new SimpleDateFormat("yyyy-MM-dd");
    private final MultiValueMap cubeToDimMap = new MultiValueMap();
    private final List<RolapMember> measureList = new ArrayList<RolapMember>();
    private final List<RolapMember> aggFactCountMeasureList = new ArrayList<RolapMember>();
    private final List<AssignDefaultMember> assignDefaultMembers = new ArrayList<AssignDefaultMember>();
    private final Map<RolapHierarchy, List<RolapCubeHierarchy>> cubeHierMap = new HashMap<RolapHierarchy, List<RolapCubeHierarchy>>();
    final Map<String, List<Larders.Resource>> resourceMap = new HashMap<String, List<Larders.Resource>>();
    final Map<String, BitSet> resourceHierarchyTags = new HashMap<String, BitSet>();
    private static final Map<String, SqlStatement.Type> VALUES;

    RolapSchemaLoader(RolapSchema schema) {
        this.schema = schema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private RolapSchema loadStage0(SchemaKey key, ByteString md5Bytes, String catalogUrl, String catalogStr, Util.PropertyList connectInfo, DataSource dataSource) {
        assert (this.schema == null);
        try {
            MondrianDef.Schema xmlSchema;
            boolean useContentChecksum;
            DOMWrapper def;
            Parser xmlParser = XOMUtil.createDefaultParser();
            xmlParser.setKeepPositions(true);
            if (catalogStr == null) {
                InputStream in = null;
                try {
                    in = Util.readVirtualFile(catalogUrl);
                    def = xmlParser.parse(in);
                }
                finally {
                    if (in != null) {
                        in.close();
                    }
                }
                if (LOGGER.isDebugEnabled() || md5Bytes == null) {
                    try {
                        catalogStr = Util.readVirtualFileAsString(catalogUrl);
                    }
                    catch (IOException ex) {
                        LOGGER.debug((Object)("RolapSchema.load: ex=" + ex));
                        catalogStr = "?";
                    }
                }
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("RolapSchema.load: content: \n" + catalogStr));
                }
            } else {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("RolapSchema.load: catalogStr: \n" + catalogStr));
                }
                def = xmlParser.parse(catalogStr);
            }
            if (md5Bytes == null) {
                assert (catalogStr != null);
                md5Bytes = new ByteString(Util.digestMd5(catalogStr));
                useContentChecksum = false;
            } else {
                useContentChecksum = true;
            }
            MondrianDef.Handler.THREAD_LOCAL.set(this.handler);
            boolean legacy = this.isLegacy(def);
            if (legacy) {
                LOGGER.warn((Object)"Model is in legacy format");
                xmlSchema = RolapSchemaUpgrader.upgrade(this, def, key, md5Bytes, connectInfo, dataSource, useContentChecksum);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug((Object)("schema after conversion:\n" + xmlSchema.toXML()));
                }
            } else {
                this.checkSchemaVersion(def);
                xmlSchema = new MondrianDef.Schema(def);
            }
            RolapSchema rolapSchema = this.loadStage1(key, md5Bytes, RolapSchemaLoader.dirName(catalogUrl), useContentChecksum, connectInfo, dataSource, xmlSchema);
            return rolapSchema;
        }
        catch (XOMException e) {
            throw Util.newError(e, "while parsing catalog " + catalogUrl);
        }
        catch (IOException e) {
            throw Util.newError(e, "while parsing catalog " + catalogUrl);
        }
        finally {
            MondrianDef.Handler.THREAD_LOCAL.set(null);
        }
    }

    private RolapSchema loadStage1(SchemaKey key, ByteString md5Bytes, String catalogDirUrl, boolean useContentChecksum, Util.PropertyList connectInfo, DataSource dataSource, MondrianDef.Schema xmlSchema) throws XOMException {
        if (LOGGER.isDebugEnabled()) {
            StringWriter sw = new StringWriter(4096);
            PrintWriter pw = new PrintWriter(sw);
            pw.println("RolapSchema.load: dump xmlschema");
            xmlSchema.display(pw, 2);
            pw.flush();
            LOGGER.debug((Object)sw.toString());
        }
        HashSet<Locale> locales = new HashSet<Locale>();
        this.loadResources(catalogDirUrl, xmlSchema, locales);
        this.schema = new RolapSchema(key, connectInfo, dataSource, md5Bytes, useContentChecksum, xmlSchema.name, RolapSchemaLoader.toBoolean(xmlSchema.quoteSql, true), Collections.unmodifiableSet(locales), this.createLarder(".schema", xmlSchema.getAnnotations(), xmlSchema.name, xmlSchema.caption, xmlSchema.description).build());
        this.validator.putXml(this.schema, xmlSchema);
        this.missingLinkAction = Util.lookup(Util.toUpperCase(xmlSchema.missingLink), MissingLinkAction.WARNING);
        this.loadStage2(xmlSchema, xmlSchema.getPhysicalSchema(), (List<MondrianDef.UserDefinedFunction>)xmlSchema.getUserDefinedFunctions(), (List<MondrianDef.Dimension>)xmlSchema.getDimensions(), (List<MondrianDef.Parameter>)xmlSchema.getParameters(), (List<MondrianDef.Cube>)xmlSchema.getCubes());
        return this.schema;
    }

    private boolean isLegacy(DOMWrapper def) {
        String majorVersion;
        String metamodelVersion = def.getAttribute("metamodelVersion");
        if (metamodelVersion == null) {
            return !this.hasMondrian4Elements(def);
        }
        String[] versionParts = metamodelVersion.split("\\.");
        String string = majorVersion = versionParts.length > 0 ? versionParts[0] : "";
        return majorVersion.compareTo("4") < 0;
    }

    void loadStage2(MondrianDef.Schema xmlSchema, MondrianDef.PhysicalSchema xmlPhysicalSchema, List<MondrianDef.UserDefinedFunction> xmlUserDefinedFunctions, List<MondrianDef.Dimension> xmlDimensions, List<MondrianDef.Parameter> xmlParameters, List<MondrianDef.Cube> xmlCubes) {
        LinkedHashMap<String, RolapSchema.RoleFactory> rolesByName;
        block13: {
            MondrianDef.Role missed;
            int prevMapSize;
            Dialect dialect = this.schema.getDialect();
            this.schema.physicalSchema = this.validatePhysicalSchema(xmlPhysicalSchema, this.getHandler(), dialect, this.schema);
            HashMap<String, UdfResolver.UdfFactory> mapNameToUdf = new HashMap<String, UdfResolver.UdfFactory>();
            for (MondrianDef.UserDefinedFunction udf : xmlUserDefinedFunctions) {
                Scripts.ScriptDefinition scriptDef = RolapSchemaLoader.toScriptDef(udf.script);
                this.schema.defineFunction(mapNameToUdf, udf.name, udf.className, scriptDef);
            }
            this.schema.initFunctionTable(mapNameToUdf.values());
            HashSet<String> parameterNames = new HashSet<String>();
            for (MondrianDef.Parameter xmlParameter : xmlParameters) {
                String parameterName = xmlParameter.name;
                if (!parameterNames.add(parameterName)) {
                    throw MondrianResource.instance().DuplicateSchemaParameter.ex(parameterName);
                }
                Type type = xmlParameter.type.equals("String") ? new StringType() : (xmlParameter.type.equals("Numeric") ? new NumericType() : new MemberType(null, null, null, null));
                String description = xmlParameter.description;
                boolean modifiable = RolapSchemaLoader.toBoolean(xmlParameter.modifiable, true);
                String defaultValue = xmlParameter.defaultValue;
                RolapSchemaParameter param = new RolapSchemaParameter(this.schema, parameterName, defaultValue, description, type, modifiable);
                this.validator.putXml(param, xmlParameter);
            }
            for (MondrianDef.Cube xmlCube : xmlCubes) {
                RolapCube cube = this.createCube(this.schema, xmlCube, xmlSchema);
                if (cube == null) continue;
                Util.discard((Object)cube);
                for (Util.Function0 action : this.postCubeActions) {
                    action.apply();
                }
                this.postCubeActions.clear();
            }
            for (MondrianDef.NamedSet xmlNamedSet : xmlSchema.getNamedSets()) {
                this.schema.addNamedSet(xmlNamedSet.name, this.createNamedSet(null, xmlNamedSet));
            }
            rolesByName = new LinkedHashMap<String, RolapSchema.RoleFactory>();
            for (MondrianDef.Role xmlRole : xmlSchema.getRoles()) {
                if (rolesByName.containsKey(xmlRole.name)) {
                    this.handler.error("Duplicate role '" + xmlRole.name + "'", (NodeDef)xmlRole, "name");
                    continue;
                }
                rolesByName.put(xmlRole.name, DUMMY_ROLE);
            }
            do {
                prevMapSize = rolesByName.size();
                missed = null;
                for (MondrianDef.Role xmlRole : xmlSchema.getRoles()) {
                    if (rolesByName.get(xmlRole.name) != DUMMY_ROLE) continue;
                    RolapSchema.RoleFactory role = this.createRole(xmlRole, rolesByName);
                    if (role == DUMMY_ROLE) {
                        missed = xmlRole;
                        continue;
                    }
                    rolesByName.put(xmlRole.name, role);
                }
                if (missed == null) break block13;
            } while (rolesByName.size() != prevMapSize);
            this.handler.error("Role '" + missed.name + "' has cyclic dependencies on " + "other roles", (NodeDef)missed, null);
        }
        RolapSchema.RoleFactory defaultRole = null;
        if (xmlSchema.defaultRole != null && (defaultRole = this.schema.mapNameToRole.get(xmlSchema.defaultRole)) == null) {
            this.handler.warning("Role '" + xmlSchema.defaultRole + "' not found", xmlSchema, "defaultRole");
        }
        if (defaultRole == null) {
            defaultRole = this.schema.getDefaultRole();
        }
        this.schema.registerRoles(rolesByName, defaultRole);
        this.schema.aggTableManager.initialize();
        this.schema.setSchemaLoadDate();
    }

    private void loadResources(String catalogDirUrl, MondrianDef.Schema xmlSchema, Set<Locale> locales) {
        MondrianDef.Localization localization = xmlSchema.getLocalization();
        if (localization != null) {
            for (MondrianDef.Locale locale : localization.getLocales()) {
                locales.add(Util.parseLocale(locale.locale));
            }
            for (MondrianDef.Translation t : localization.getTranslations()) {
                for (Locale locale : locales) {
                    String path = t.path.replace("${locale}", locale.toString());
                    if (RolapSchemaLoader.isRelative(path)) {
                        path = catalogDirUrl + path;
                    }
                    try {
                        InputStream inputStream = Util.readVirtualFile(path);
                        Properties properties = new Properties();
                        properties.load(inputStream);
                        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
                            LocalizedProperty prop;
                            String key = (String)entry.getKey();
                            if (key.endsWith(".caption")) {
                                key = key.substring(0, key.length() - ".caption".length());
                                prop = LocalizedProperty.CAPTION;
                            } else {
                                if (!key.endsWith(".description")) continue;
                                key = key.substring(0, key.length() - ".description".length());
                                prop = LocalizedProperty.DESCRIPTION;
                            }
                            Util.putMulti(this.resourceMap, key, new Larders.Resource(prop, locale, (String)entry.getValue()));
                            if (!key.endsWith(".member")) continue;
                            int count = 0;
                            String hierarchyTag = null;
                            for (int i = 0; i < key.length(); ++i) {
                                if (key.charAt(i) != '.' || ++count != 3) continue;
                                hierarchyTag = key.substring(0, i);
                            }
                            Util.putMulti(this.resourceHierarchyTags, hierarchyTag, count - 3);
                        }
                        inputStream.close();
                    }
                    catch (Throwable e) {
                        this.handler.warning("Error reading resource file '" + path + "'; ignoring", t, "path", e);
                    }
                }
            }
        }
    }

    private static String dirName(String catalogUrl) {
        int lastBackSlash;
        int lastForwardSlash;
        int lastSlash;
        if (catalogUrl == null) {
            return null;
        }
        int q = catalogUrl.indexOf(63);
        if (q >= 0) {
            catalogUrl = catalogUrl.substring(0, q);
        }
        if ((lastSlash = Math.max(lastForwardSlash = catalogUrl.lastIndexOf(47), lastBackSlash = catalogUrl.lastIndexOf(92))) >= 0) {
            catalogUrl = catalogUrl.substring(0, lastSlash + 1);
        }
        return catalogUrl;
    }

    private static boolean isRelative(String path) {
        Matcher matcher = PROTOCOL_PATTERN.matcher(path);
        if (matcher.matches()) {
            path = matcher.replaceAll("");
        }
        return !path.startsWith("/");
    }

    private void checkSchemaVersion(DOMWrapper schemaDom) {
        String[] versionParts;
        String schemaVersion = schemaDom.getAttribute("metamodelVersion");
        if (schemaVersion == null) {
            if (this.hasMondrian4Elements(schemaDom)) {
                throw Util.newError("Model in 4.x or later format must have'metamodelVersion' attribute.");
            }
            schemaVersion = "3.x";
        }
        String schemaMajor = (versionParts = schemaVersion.split("\\.")).length > 0 ? versionParts[0] : "";
        MondrianServer.MondrianVersion mondrianVersion = MondrianServer.forId(null).getVersion();
        String serverMajor = mondrianVersion.getMajorVersion() + "";
        if (serverMajor.compareTo(schemaMajor) < 0) {
            String errorMsg = "Schema version '" + schemaVersion + "' is later than schema version '" + serverMajor + ".x' supported by this version of Mondrian";
            throw Util.newError(errorMsg);
        }
    }

    private boolean hasMondrian4Elements(DOMWrapper schemaDom) {
        for (DOMWrapper child : schemaDom.getChildren()) {
            if ("PhysicalSchema".equals(child.getTagName())) {
                return true;
            }
            if (!"Cube".equals(child.getTagName())) continue;
            for (DOMWrapper grandchild : child.getChildren()) {
                if (!"MeasureGroups".equals(grandchild.getTagName())) continue;
                return true;
            }
        }
        return false;
    }

    private static Scripts.ScriptDefinition toScriptDef(MondrianDef.Script script) {
        if (script == null) {
            return null;
        }
        Scripts.ScriptLanguage language = Scripts.ScriptLanguage.lookup(script.language);
        if (language == null) {
            throw Util.newError("Invalid script language '" + script.language + "'");
        }
        return new Scripts.ScriptDefinition(script.cdata, language);
    }

    private RolapSchema.PhysSchema validatePhysicalSchema(MondrianDef.PhysicalSchema xmlPhysicalSchema, Handler handler, Dialect dialect, RolapSchema schema) {
        if (xmlPhysicalSchema == null) {
            handler.error("Physical schema required", null, null);
            return null;
        }
        RolapSchema.PhysSchema physSchema = this.createSyntheticPhysicalSchema();
        RolapSchema.PhysInlineTable empty = new RolapSchema.PhysInlineTable(physSchema, EMPTY_TABLE_NAME);
        RolapSchema.PhysRealColumn c = new RolapSchema.PhysRealColumn((RolapSchema.PhysRelation)empty, EMPTY_TABLE_SOLE_COLUMN_NAME, Dialect.Datatype.Integer, null, -1);
        empty.columnsByName.put(c.name, c);
        physSchema.tablesByName.put(empty.alias, empty);
        this.physSchemaBuilder = new PhysSchemaBuilder(null, physSchema);
        HashSet<ElementDef> skip = new HashSet<ElementDef>();
        ArrayList<RolapSchema.UnresolvedColumn> unresolvedColumnList = new ArrayList<RolapSchema.UnresolvedColumn>();
        for (MondrianDef.Relation relation : Util.filter(xmlPhysicalSchema.children, MondrianDef.Relation.class)) {
            ElementDef inlineTable;
            RolapSchema.PhysRelationImpl physTable;
            String alias = relation.getAlias();
            if (relation instanceof MondrianDef.Table) {
                physTable = this.registerTable(handler, dialect, physSchema, skip, unresolvedColumnList, alias, (MondrianDef.Table)relation);
            } else if (relation instanceof MondrianDef.InlineTable) {
                inlineTable = (MondrianDef.InlineTable)relation;
                physTable = this.registerInlineTable(handler, dialect, schema, physSchema, (Set<ElementDef>)skip, (List<RolapSchema.UnresolvedColumn>)unresolvedColumnList, alias, (MondrianDef.InlineTable)inlineTable);
            } else if (relation instanceof MondrianDef.Query) {
                inlineTable = (MondrianDef.Query)relation;
                physTable = this.registerView(handler, dialect, schema, physSchema, skip, unresolvedColumnList, alias, (MondrianDef.Query)inlineTable);
            } else {
                handler.warning("Invalid element '" + relation.getName() + "' in physical schema", relation, null);
                continue;
            }
            if (physSchema.tablesByName.containsKey(alias)) {
                handler.warning("Duplicate table alias '" + alias + "'.", relation, null);
                continue;
            }
            physSchema.tablesByName.put(alias, physTable);
        }
        ArrayList<UnresolvedLink> unresolvedLinkList = new ArrayList<UnresolvedLink>();
        for (MondrianDef.Link xmlLink : Util.filter(xmlPhysicalSchema.children, MondrianDef.Link.class)) {
            List<RolapSchema.PhysColumn> columnList;
            int errorCount = 0;
            RolapSchema.PhysRelation sourceTable = physSchema.tablesByName.get(xmlLink.source);
            String string = Util.first(xmlLink.key, "primary");
            RolapSchema.PhysKey sourceKey = null;
            if (sourceTable == null) {
                handler.warning("Link references unknown source table '" + xmlLink.source + "'.", xmlLink, "source");
                ++errorCount;
            } else {
                sourceKey = sourceTable.lookupKey(string);
                if (sourceKey == null) {
                    handler.warning("Source table '" + xmlLink.source + "' of link has no key named '" + string + "'.", xmlLink, "source");
                    ++errorCount;
                }
            }
            RolapSchema.PhysRelation targetRelation = physSchema.tablesByName.get(xmlLink.target);
            if (targetRelation == null) {
                handler.warning("Link references unknown target table '" + xmlLink.target + "'.", xmlLink, "target");
                ++errorCount;
                columnList = null;
            } else {
                columnList = this.createColumnList(xmlLink, "foreignKeyColumn", targetRelation, xmlLink.foreignKeyColumn, xmlLink.foreignKey);
            }
            if (errorCount != 0) continue;
            unresolvedLinkList.add(new UnresolvedLink(sourceKey, targetRelation, columnList));
        }
        for (RolapSchema.UnresolvedColumn unresolvedColumn : unresolvedColumnList) {
            if (unresolvedColumn.state == RolapSchema.UnresolvedColumn.State.RESOLVED) continue;
            this.resolve(physSchema, unresolvedColumn);
        }
        for (UnresolvedLink unresolvedLink : unresolvedLinkList) {
            physSchema.addLink(unresolvedLink.sourceKey, unresolvedLink.targetRelation, unresolvedLink.columnList, false);
        }
        for (RolapSchema.PhysRelation table : physSchema.tablesByName.values()) {
            for (RolapSchema.PhysKey key : table.getKeyList()) {
                for (RolapSchema.PhysExpr physExpr : key.columnList) {
                    if (physExpr instanceof RolapSchema.PhysCalcColumn) {
                        RolapSchema.PhysCalcColumn physCalcColumn = (RolapSchema.PhysCalcColumn)physExpr;
                        handler.warning("Key must not contain calculated column; calculated column '" + physCalcColumn.name + "' in table '" + physCalcColumn.relation.getAlias() + "'.", (NodeDef)this.validator.getXml(table), null);
                        continue;
                    }
                    if (physExpr instanceof RolapSchema.UnresolvedColumn) continue;
                    RolapSchema.PhysRealColumn column = (RolapSchema.PhysRealColumn)physExpr;
                    if (column.relation == table) continue;
                    handler.warning("Columns in primary key must belong to key table; in table '" + table.getAlias() + "'.", (NodeDef)this.validator.getXml(table), null);
                }
            }
        }
        return physSchema;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void resolve(RolapSchema.PhysSchema physSchema, RolapSchema.UnresolvedColumn unresolvedColumn) {
        try {
            if (unresolvedColumn.state == RolapSchema.UnresolvedColumn.State.ACTIVE) {
                this.getHandler().warning("Calculated column '" + unresolvedColumn.name + "' in table '" + unresolvedColumn.tableName + "' has cyclic expression", (NodeDef)unresolvedColumn.xml, null);
                return;
            }
            unresolvedColumn.state = RolapSchema.UnresolvedColumn.State.ACTIVE;
            RolapSchema.PhysRelation table = physSchema.tablesByName.get(unresolvedColumn.tableName);
            if (table == null) {
                this.getHandler().warning("Unknown table '" + unresolvedColumn.tableName + "'" + unresolvedColumn.getContext() + ".", (NodeDef)unresolvedColumn.xml, null);
                return;
            }
            RolapSchema.PhysColumn column = table.getColumn(unresolvedColumn.name, false);
            if (column == null) {
                this.getHandler().warning("Reference to unknown column '" + unresolvedColumn.name + "' in table '" + unresolvedColumn.tableName + "'" + unresolvedColumn.getContext() + ".", (NodeDef)unresolvedColumn.xml, null);
            } else {
                if (column instanceof RolapSchema.PhysCalcColumn) {
                    RolapSchema.PhysCalcColumn physCalcColumn = (RolapSchema.PhysCalcColumn)column;
                    for (RolapSchema.PhysExpr o : physCalcColumn.list) {
                        if (!(o instanceof RolapSchema.UnresolvedColumn)) continue;
                        this.resolve(physSchema, (RolapSchema.UnresolvedColumn)o);
                    }
                }
                unresolvedColumn.state = RolapSchema.UnresolvedColumn.State.RESOLVED;
                unresolvedColumn.onResolve(column);
            }
        }
        finally {
            if (unresolvedColumn.state == RolapSchema.UnresolvedColumn.State.ACTIVE) {
                unresolvedColumn.state = RolapSchema.UnresolvedColumn.State.ERROR;
            }
        }
    }

    private RolapSchema.PhysInlineTable registerInlineTable(Handler handler, Dialect dialect, RolapSchema schema, RolapSchema.PhysSchema physSchema, Set<ElementDef> skip, List<RolapSchema.UnresolvedColumn> unresolvedColumnList, String alias, MondrianDef.InlineTable xmlInlineTable) {
        RolapSchema.PhysInlineTable physInlineTable = new RolapSchema.PhysInlineTable(physSchema, alias);
        this.validator.putXml(physInlineTable, xmlInlineTable);
        for (MondrianDef.RealOrCalcColumnDef column : xmlInlineTable.getColumnDefs()) {
            this.registerColumn(handler, dialect, skip, unresolvedColumnList, alias, physInlineTable, xmlInlineTable, column);
        }
        this.registerKey(handler, xmlInlineTable, null, xmlInlineTable.getKey(), unresolvedColumnList, physInlineTable);
        for (MondrianDef.Row row : xmlInlineTable.getRows()) {
            assert (row.values.length == xmlInlineTable.getColumnDefs().size());
            ArrayList<String> newRow = new ArrayList<String>();
            for (int i = 0; i < row.values.length; ++i) {
                MondrianDef.RealOrCalcColumnDef colDef = xmlInlineTable.getColumnDefs().get(i);
                assert (colDef.name.equals(row.values[i].column));
                newRow.add(row.values[i].cdata);
            }
            physInlineTable.rowList.add(newRow.toArray(new String[newRow.size()]));
        }
        return physInlineTable;
    }

    private RolapSchema.PhysView registerView(Handler handler, Dialect dialect, RolapSchema schema, RolapSchema.PhysSchema physSchema, Set<ElementDef> skip, List<RolapSchema.UnresolvedColumn> unresolvedColumnList, String alias, MondrianDef.Query xmlQuery) {
        MondrianDef.SQL xmlSql;
        try {
            xmlSql = MondrianDef.SQL.choose(xmlQuery.getExpressionView().expressions, dialect);
        }
        catch (MondrianDef.Missing missing) {
            return null;
        }
        RolapSchema.PhysView physView = new RolapSchema.PhysView(physSchema, alias, RolapSchemaLoader.getText(xmlSql));
        this.validator.putXml(physView, xmlQuery);
        physView.ensurePopulated(this, xmlQuery);
        this.registerKey(handler, xmlQuery, xmlQuery.keyColumn, null, unresolvedColumnList, physView);
        for (MondrianDef.Key key : xmlQuery.getKeys()) {
            this.registerKey(handler, xmlQuery, null, key, unresolvedColumnList, physView);
        }
        return physView;
    }

    private RolapSchema.PhysTable registerTable(Handler handler, Dialect dialect, RolapSchema.PhysSchema physSchema, Set<ElementDef> skip, List<RolapSchema.UnresolvedColumn> unresolvedColumnList, String alias, MondrianDef.Table xmlTable) {
        RolapSchema.PhysTable physTable = new RolapSchema.PhysTable(physSchema, xmlTable.schema, xmlTable.name, alias, RolapSchemaLoader.buildHintMap(xmlTable.getHints()));
        this.validator.putXml(physTable, xmlTable);
        if (xmlTable instanceof MondrianDef.AutoGeneratedDateTable) {
            this.registerAutoDateTable(handler, xmlTable, physTable);
            physTable.ensurePopulated(this, xmlTable);
        } else {
            physTable.ensurePopulated(this, xmlTable);
            for (MondrianDef.RealOrCalcColumnDef xmlColumn : xmlTable.getColumnDefs()) {
                this.registerColumn(handler, dialect, skip, unresolvedColumnList, alias, physTable, xmlTable, xmlColumn);
            }
        }
        this.registerKey(handler, xmlTable, xmlTable.keyColumn, null, unresolvedColumnList, physTable);
        for (MondrianDef.Key key : xmlTable.getKeys()) {
            this.registerKey(handler, xmlTable, null, key, unresolvedColumnList, physTable);
        }
        return physTable;
    }

    private void registerAutoDateTable(Handler handler, MondrianDef.Table xmlTable, RolapSchema.PhysTable physTable) {
        List<MondrianDef.RealOrCalcColumnDef> xmlColumnDefs;
        MondrianDef.AutoGeneratedDateTable xmlDateTable = (MondrianDef.AutoGeneratedDateTable)xmlTable;
        HashMap<String, TimeColumnRole.Struct> columnRoleMap = new HashMap<String, TimeColumnRole.Struct>();
        if (this.hasColumnDefs(xmlTable.childArray)) {
            xmlColumnDefs = xmlTable.getColumnDefs();
        } else {
            xmlColumnDefs = new ArrayList<MondrianDef.RealOrCalcColumnDef>();
            for (TimeColumnRole role : TimeColumnRole.values()) {
                MondrianDef.ColumnDef xmlColumnDef = new MondrianDef.ColumnDef();
                xmlColumnDef.name = role.columnName;
                xmlColumnDef.type = role.defaultDatatype.name();
                xmlColumnDef.timeDomain = new MondrianDef.TimeDomain();
                xmlColumnDef.timeDomain.role = role.name();
                xmlColumnDefs.add(xmlColumnDef);
            }
        }
        for (MondrianDef.RealOrCalcColumnDef xmlColumnDef : xmlColumnDefs) {
            TimeColumnRole.Struct struct;
            TimeColumnRole role;
            MondrianDef.TimeDomain domain = ((MondrianDef.ColumnDef)xmlColumnDef).timeDomain;
            if (domain != null) {
                role = Util.lookup(TimeColumnRole.class, domain.role.toUpperCase());
                if (role == null) {
                    handler.error("Bad role '" + (Object)((Object)domain) + "', in column '" + xmlColumnDef.name + "'. Allowable roles are " + Arrays.toString((Object[])TimeColumnRole.values()), (NodeDef)xmlColumnDef, "role");
                    continue;
                }
                struct = new TimeColumnRole.Struct(role, this.parseDate(domain.epoch, (NodeDef)domain, "epoch"));
            } else {
                role = TimeColumnRole.mapNameToRole.get(xmlColumnDef.name.toUpperCase());
                if (role == null) {
                    handler.error("Each column in an auto-generated date table must either have a nested <TimeDomain> element, or have a standard name such as 'the_month'; column '" + xmlColumnDef.name + "' is neither", (NodeDef)xmlColumnDef, null);
                    continue;
                }
                struct = new TimeColumnRole.Struct(role, null);
            }
            if (xmlColumnDef.type == null) {
                xmlColumnDef.type = struct.role.defaultDatatype.name();
            }
            columnRoleMap.put(xmlColumnDef.name, struct);
        }
        java.sql.Date startDate = this.parseDate(xmlDateTable.startDate, xmlDateTable, "startDate");
        java.sql.Date endDate = this.parseDate(xmlDateTable.endDate, xmlDateTable, "endDate");
        if (startDate == null || endDate == null) {
            return;
        }
        physTable.setHook(new DateTableBuilder(columnRoleMap, xmlColumnDefs, startDate, endDate));
    }

    private boolean hasColumnDefs(MondrianDef.TableElement[] children) {
        for (MondrianDef.TableElement child : children) {
            if (!(child instanceof MondrianDef.ColumnDefs)) continue;
            return true;
        }
        return false;
    }

    private java.sql.Date parseDate(String dateString, NodeDef node, String attributeName) {
        if (dateString == null) {
            return null;
        }
        try {
            Date date = this.SIMPLE_DATE_FORMAT.parse(dateString);
            return new java.sql.Date(date.getTime());
        }
        catch (ParseException e) {
            this.handler.error("Invalid date '" + dateString + "'", node, attributeName);
            return null;
        }
    }

    private void registerKey(Handler handler, ElementDef xmlTable, String columnName, final MondrianDef.Key xmlKey, List<RolapSchema.UnresolvedColumn> unresolvedColumnList, final RolapSchema.PhysRelationImpl physTable) {
        String keyName;
        List<Tcl> columns;
        if (xmlKey == null) {
            if (columnName == null) {
                return;
            }
            columns = Collections.singletonList(new Tcl(null, columnName, xmlTable));
            keyName = "primary";
        } else {
            columns = new AbstractList<Tcl>(){

                @Override
                public Tcl get(int index) {
                    MondrianDef.Column column = xmlKey.array[index];
                    return new Tcl(column.table, column.name, column);
                }

                @Override
                public int size() {
                    return xmlKey.array.length;
                }
            };
            keyName = xmlKey.name;
            if (keyName == null) {
                keyName = "primary";
            }
        }
        if (physTable.lookupKey(keyName) != null) {
            handler.error("Table has more than one key with name '" + keyName + "'", (NodeDef)xmlKey, null);
            return;
        }
        final RolapSchema.PhysKey key = physTable.addKey(keyName, new ArrayList<RolapSchema.PhysColumn>());
        int i = 0;
        for (Tcl columnRef : columns) {
            final int index = i++;
            RolapSchema.UnresolvedColumn unresolvedColumn = new RolapSchema.UnresolvedColumn(physTable, columnRef.table != null ? columnRef.table : physTable.alias, columnRef.column, columnRef.xml){

                public void onResolve(RolapSchema.PhysColumn column) {
                    assert (column != null);
                    key.columnList.set(index, column);
                }

                public String getContext() {
                    return ", in key of table '" + physTable.alias + "'";
                }
            };
            key.columnList.add(unresolvedColumn);
            unresolvedColumnList.add(unresolvedColumn);
        }
        if (key.columnList.size() != 1) {
            handler.warning("Key must have precisely one column; key " + key.columnList + " in table '" + physTable.alias + "'.", xmlKey, null);
        }
    }

    private void registerColumn(Handler handler, Dialect dialect, Set<ElementDef> skip, List<RolapSchema.UnresolvedColumn> unresolvedColumnList, String alias, RolapSchema.PhysRelationImpl physRelation, MondrianDef.Relation table, MondrianDef.RealOrCalcColumnDef xmlColumn) {
        boolean inlineTable = physRelation instanceof RolapSchema.PhysInlineTable;
        boolean calcColDef = xmlColumn instanceof MondrianDef.CalculatedColumnDef;
        if ((inlineTable || calcColDef) && physRelation.columnsByName.containsKey(xmlColumn.name)) {
            handler.warning("Duplicate column '" + xmlColumn.name + "' in table '" + alias + "'.", (NodeDef)xmlColumn, null);
            skip.add(xmlColumn);
            return;
        }
        if (inlineTable) {
            RolapSchema.PhysInlineTable physInlineTable = (RolapSchema.PhysInlineTable)physRelation;
            if (calcColDef) {
                handler.warning("Cannot define calculated column in inline table", (NodeDef)xmlColumn, null);
            } else {
                RolapSchema.PhysRealColumn physColumn = new RolapSchema.PhysRealColumn((RolapSchema.PhysRelation)physInlineTable, xmlColumn.name, RolapSchemaLoader.toType(xmlColumn.type), RolapSchemaLoader.toInternalType(xmlColumn.internalType), -1);
                this.validator.putXml(physColumn, (NodeDef)xmlColumn);
                physInlineTable.addColumn(physColumn);
            }
            return;
        }
        RolapSchema.PhysTable physTable = (RolapSchema.PhysTable)physRelation;
        if (calcColDef) {
            MondrianDef.SQL sql;
            MondrianDef.CalculatedColumnDef xmlCalcColumnDef = (MondrianDef.CalculatedColumnDef)xmlColumn;
            ArrayList<RolapSchema.PhysExpr> list = new ArrayList<RolapSchema.PhysExpr>();
            RolapSchema.PhysCalcColumn physCalcColumn = new RolapSchema.PhysCalcColumn(this, (NodeDef)xmlCalcColumnDef, physTable, xmlColumn.name, RolapSchemaLoader.toType(xmlColumn.type), RolapSchemaLoader.toInternalType(xmlColumn.internalType), list);
            this.validator.putXml(physCalcColumn, (NodeDef)xmlColumn);
            assert (xmlCalcColumnDef.expression != null);
            if (xmlCalcColumnDef.expression instanceof MondrianDef.ExpressionView) {
                MondrianDef.ExpressionView expressionView = (MondrianDef.ExpressionView)xmlCalcColumnDef.expression;
                sql = MondrianDef.SQL.choose(expressionView.expressions, dialect);
            } else {
                sql = new MondrianDef.SQL();
                sql.children = new NodeDef[]{(MondrianDef.Column)xmlCalcColumnDef.expression};
            }
            for (int i = 0; i < sql.children.length; ++i) {
                NodeDef child = sql.children[i];
                if (child instanceof TextDef) {
                    TextDef text = (TextDef)child;
                    String s = text.getText();
                    s = RolapSchemaLoader.trim(s, i == 0, i == sql.children.length - 1);
                    list.add(new RolapSchema.PhysTextExpr(s));
                    continue;
                }
                if (child instanceof MondrianDef.Column) {
                    int index = list.size();
                    MondrianDef.Column columnRef = (MondrianDef.Column)child;
                    RolapSchema.UnresolvedCalcColumn unresolvedColumn = new RolapSchema.UnresolvedCalcColumn(physTable, Util.first(columnRef.table, alias), columnRef, sql, physCalcColumn, list, index);
                    list.add(unresolvedColumn);
                    unresolvedColumnList.add(unresolvedColumn);
                    continue;
                }
                throw new IllegalArgumentException("illegal expression: " + child);
            }
            physCalcColumn.compute();
            physTable.addColumn(physCalcColumn);
        } else {
            RolapSchema.PhysColumn physColumn = physRelation.getColumn(xmlColumn.name, true);
            if (xmlColumn.type != null) {
                physColumn.setDatatype(RolapSchemaLoader.toType(xmlColumn.type));
            }
            if (xmlColumn.internalType != null) {
                physColumn.setInternalType(RolapSchemaLoader.toInternalType(xmlColumn.internalType));
            }
        }
    }

    private static String trim(String s, boolean left, boolean right) {
        while (left && s.length() > 0 && Character.isWhitespace(s.charAt(0))) {
            s = s.substring(1);
        }
        while (right && s.length() > 0 && Character.isWhitespace(s.charAt(s.length() - 1))) {
            s = s.substring(0, s.length() - 1);
        }
        return s;
    }

    static Dialect.Datatype toType(String type) {
        return DATATYPE_MAP.get(type);
    }

    private RolapSchema.PhysSchema createSyntheticPhysicalSchema() {
        DataServicesProvider provider = DataServicesLocator.getDataServicesProvider(this.schema.getDataServiceProviderName());
        return new RolapSchema.PhysSchema(this.schema.getDialect(), this.schema.getInternalConnection(), provider);
    }

    private RolapCube createCube(RolapSchema schema, MondrianDef.Cube xmlCube, MondrianDef.Schema xmlSchema) {
        Object xmlCubeDimensionsPlus;
        if (!RolapSchemaLoader.toBoolean(xmlCube.enabled, true)) {
            return null;
        }
        if (schema.getCubeList().get(xmlCube.name) != null) {
            this.getHandler().error("Duplicate cube '" + xmlCube.name + "'", (NodeDef)xmlCube, null);
            return null;
        }
        this.measureList.clear();
        this.aggFactCountMeasureList.clear();
        this.assignDefaultMembers.clear();
        this.cubeHierMap.clear();
        RolapCube cube = new RolapCube(this, xmlCube.name, RolapSchemaLoader.toBoolean(xmlCube.visible, true), this.createLarder(Util.quoteMdxIdentifier(xmlCube.name) + ".cube", xmlCube.getAnnotations(), xmlCube.name, xmlCube.caption, xmlCube.description).build(), xmlSchema.measuresCaption);
        this.validator.putXml(cube, xmlCube);
        this.deferAssignDefaultMember(cube, cube.getMeasuresHierarchy(), xmlCube, xmlCube.defaultMeasure);
        this.dimensionPaths.clear();
        NamedList<MondrianDef.Dimension> xmlCubeDimensions = xmlCube.getDimensions();
        if (xmlCube.enableScenarios.booleanValue()) {
            MondrianDef.Dimension xmlDimension = new MondrianDef.Dimension();
            xmlDimension.name = "Scenario";
            xmlDimension.hanger = true;
            xmlDimension.key = "Scenario";
            xmlDimension.type = Dimension.Type.SCENARIO.name();
            MondrianDef.Attributes xmlAttributes = new MondrianDef.Attributes();
            xmlDimension.children.add(xmlAttributes);
            MondrianDef.Attribute xmlAttribute = new MondrianDef.Attribute();
            xmlAttributes.array = new MondrianDef.Attribute[]{xmlAttribute};
            xmlAttribute.name = "Scenario";
            xmlAttribute.levelType = Level.Type.SCENARIO.name();
            xmlCubeDimensionsPlus = Composite.of(new List[]{xmlCubeDimensions, Collections.singletonList(xmlDimension)});
        } else {
            xmlCubeDimensionsPlus = xmlCubeDimensions;
        }
        int ordinal = cube.getDimensionList().size();
        for (MondrianDef.Dimension xmlCubeDimension : xmlCubeDimensionsPlus) {
            RolapCubeDimension dimension = this.getOrCreateDimension(cube, xmlCubeDimension, schema, xmlSchema, ordinal++, cube.hierarchyList, xmlCubeDimension.getAnnotations());
            if (dimension == null) continue;
            cube.addDimension(dimension);
        }
        NamedList<MondrianDef.MeasureGroup> xmlMeasureGroups = xmlCube.getMeasureGroups();
        if (xmlMeasureGroups.size() == 0 && !cube.getName().startsWith("$")) {
            this.handler.warning("Cube definition must contain a MeasureGroups element, and at least one MeasureGroup", xmlCube, null);
        }
        HashSet<String> measureNames = new HashSet<String>();
        HashSet<String> measureGroupNames = new HashSet<String>();
        ArrayList<4> unresolvedMeasures = new ArrayList<4>();
        for (MondrianDef.MeasureGroup xmlMeasureGroup : xmlMeasureGroups) {
            RolapSchema.PhysRelation fact;
            String name = xmlMeasureGroup.getNameAttribute();
            if (!measureGroupNames.add(name)) {
                this.handler.warning("Duplicate measure group '" + name + "' in cube '" + cube.getName() + "'", xmlMeasureGroup, "name");
            }
            if ((fact = this.physSchemaBuilder.getPhysRelation(xmlMeasureGroup.table, false)) == null) {
                this.handler.warning("Unknown fact table '" + xmlMeasureGroup.table + "'", xmlMeasureGroup, "table");
                continue;
            }
            RolapStar star = schema.getRolapStarRegistry().getOrCreateStar(fact);
            final RolapMeasureGroup measureGroup = new RolapMeasureGroup(cube, name, RolapSchemaLoader.toBoolean(xmlMeasureGroup.ignoreUnrelatedDimensions, false), star, xmlMeasureGroup.isAggregate());
            this.validator.putXml(measureGroup, xmlMeasureGroup);
            cube.addMeasureGroup(measureGroup);
            for (MondrianDef.MeasureOrRef xmlMeasureOrRef : xmlMeasureGroup.getMeasures()) {
                RolapSchema.PhysRelation relation;
                if (xmlMeasureOrRef instanceof MondrianDef.MeasureRef) {
                    if (xmlMeasureGroup.isAggregate()) {
                        final MondrianDef.MeasureRef xmlMeasureRef = (MondrianDef.MeasureRef)xmlMeasureOrRef;
                        unresolvedMeasures.add(new Util.Function0<RolapMeasureGroup.RolapMeasureRef>(){

                            @Override
                            public RolapMeasureGroup.RolapMeasureRef apply() {
                                return RolapSchemaLoader.this.createMeasureRef(RolapSchemaLoader.this.measureList, xmlMeasureRef, measureGroup);
                            }
                        });
                        continue;
                    }
                    this.handler.warning("MeasureRef must not occur in a fact MeasureGroup", xmlMeasureOrRef, null);
                    continue;
                }
                MondrianDef.Measure xmlMeasure = (MondrianDef.Measure)xmlMeasureOrRef;
                RolapSchema.PhysRelation physRelation = relation = xmlMeasureGroup.table == null ? null : this.getPhysRelation(xmlMeasureGroup.table, xmlMeasureGroup, "table");
                if (!measureNames.add(xmlMeasure.name)) {
                    this.getHandler().error("Duplicate measure '" + xmlMeasure.name + "' in cube '" + measureGroup.getCube().getName() + "'", (NodeDef)xmlMeasure, null);
                    continue;
                }
                RolapBaseCubeMeasure measure = this.createMeasure(measureGroup, xmlMeasure, relation);
                if (measure == null) continue;
                if (measure.getOrdinal() == -1) {
                    measure.setOrdinal(this.nonSystemMeasures().size());
                    measure.setOrderKey(Integer.valueOf(this.nonSystemMeasures().size()));
                }
                if (measure.getAggregator() == RolapAggregator.Count) {
                    measureGroup.factCountMeasure = measure;
                }
                if (measure.getExpr() != null && !RolapSchemaLoader.toBoolean(xmlCube.cache, true)) {
                    star.setCacheAggregations(false);
                }
                this.measureList.add(measure);
            }
            if (measureGroup.factCountMeasure == null) {
                MondrianDef.Measure xmlMeasure = new MondrianDef.Measure();
                xmlMeasure.aggregator = RolapAggregator.Count.name;
                xmlMeasure.name = FACT_COUNT_MEASURE_NAME;
                xmlMeasure.visible = Boolean.FALSE;
                RolapSchema.PhysRelation relation = xmlMeasureGroup.table == null ? null : this.getPhysRelation(xmlMeasureGroup.table, xmlMeasureGroup, "table");
                measureGroup.factCountMeasure = this.createMeasure(measureGroup, xmlMeasure, relation);
                if (measureGroup.factCountMeasure == null) {
                    throw new AssertionError();
                }
                this.measureList.add(measureGroup.factCountMeasure);
                this.aggFactCountMeasureList.add(measureGroup.factCountMeasure);
            }
            HashSet<? extends RolapCubeDimension> unlinkedDimensions = new HashSet<RolapCubeDimension>(cube.getDimensionList());
            unlinkedDimensions.remove(cube.getDimensionList().get(0));
            for (MondrianDef.DimensionLink xmlDimensionLink : xmlMeasureGroup.getDimensionLinks()) {
                RolapCubeDimension dimension = (RolapCubeDimension)cube.dimensionList.get(xmlDimensionLink.dimension);
                if (dimension == null) {
                    MondrianDef.Dimension xmlSchemaDimension = (MondrianDef.Dimension)xmlSchema.getDimensions().get(xmlDimensionLink.dimension);
                    if (xmlSchemaDimension != null) {
                        this.handler.warning("Dimension '" + xmlDimensionLink.dimension + "' not found in this cube, but there is a schema " + "dimension of that name. Did you intend to " + "create cube dimension referring to that schema " + "dimension?", (NodeDef)xmlDimensionLink, "dimension");
                        continue;
                    }
                    this.handler.warning("Dimension '" + xmlDimensionLink.dimension + "' not found", (NodeDef)xmlDimensionLink, "dimension");
                    continue;
                }
                if (!unlinkedDimensions.remove(dimension)) {
                    this.handler.warning("More than one link for dimension '" + xmlDimensionLink.dimension + "' in measure group '" + name + "'", (NodeDef)xmlDimensionLink, "dimension");
                }
                if (xmlDimensionLink instanceof MondrianDef.ForeignKeyLink) {
                    this.addForeignKeyLink(fact, measureGroup, dimension, (MondrianDef.ForeignKeyLink)xmlDimensionLink);
                    RolapCubeDimension closedDimension = this.findClosedPeerDimension(dimension);
                    if (closedDimension == null) continue;
                    this.addForeignKeyLink(fact, measureGroup, closedDimension, (MondrianDef.ForeignKeyLink)xmlDimensionLink);
                    continue;
                }
                if (xmlDimensionLink instanceof MondrianDef.FactLink) {
                    this.addFactLink(measureGroup, dimension);
                    continue;
                }
                if (xmlDimensionLink instanceof MondrianDef.ReferenceLink) continue;
                if (xmlDimensionLink instanceof MondrianDef.CopyLink) {
                    this.addCopyLink(measureGroup, dimension, (MondrianDef.CopyLink)xmlDimensionLink);
                    continue;
                }
                if (xmlDimensionLink instanceof MondrianDef.NoLink) continue;
                throw Util.newInternal("Unknown link type " + (Object)((Object)xmlDimensionLink));
            }
            for (RolapCubeDimension dimension : unlinkedDimensions) {
                if (dimension.hanger) continue;
                this.missingLinkAction.handle(this.handler, "No link for dimension '" + dimension.getName() + "' in measure group '" + measureGroup.getName() + "'", xmlMeasureGroup, null);
            }
        }
        for (Util.Function0 unresolvedMeasure : unresolvedMeasures) {
            unresolvedMeasure.apply();
        }
        cube.init(this.nonSystemMeasures());
        ArrayList<AssignDefaultMember> assignDefaultMembers2 = new ArrayList<AssignDefaultMember>(this.assignDefaultMembers);
        this.assignDefaultMembers.clear();
        for (AssignDefaultMember assign : assignDefaultMembers2) {
            AssignDefaultMember remaining = assign.apply();
            if (remaining == null) continue;
            this.assignDefaultMembers.add(remaining);
        }
        schema.addCube(cube);
        for (RolapMeasureGroup measureGroup : cube.getMeasureGroups()) {
            for (RolapStoredMeasure measure : measureGroup.measureList) {
                RolapSchema.PhysColumn expr = measure.getExpr();
                if (expr != null) assert (measureGroup.getFactRelation() == expr.relation);
                RolapStar star = measureGroup.getStar();
                RolapStar.Table table = star.getFactTable();
                table.makeMeasure((RolapBaseCubeMeasure)measure);
            }
            for (RolapMeasureGroup.RolapMeasureRef measureRef : measureGroup.measureRefList) {
                assert (measureGroup.getFactRelation() == measureRef.aggColumn.relation);
                RolapStar star = measureGroup.getStar();
                RolapStar.Table table = star.getFactTable();
                table.makeMeasure(measureRef.measure, measureRef.aggColumn, true);
            }
            for (RolapCubeDimension dimension : cube.dimensionList) {
                if (!measureGroup.existsLink(dimension)) continue;
                this.registerDimension(measureGroup, dimension, this.dimensionPaths.get(Pair.of(measureGroup, dimension)));
            }
        }
        this.createCalcMembersAndNamedSets((List<MondrianDef.CalculatedMember>)xmlCube.getCalculatedMembers(), (List<MondrianDef.NamedSet>)xmlCube.getNamedSets(), this.measureList, cube.calculatedMemberList, cube.namedSetList, cube, true);
        this.checkOrdinals(xmlCube);
        if (Util.deprecated(false, false).booleanValue()) {
            cube.setAggGroup(ExplicitRules.Group.make(cube, (Mondrian3Def.Cube)((Object)xmlCube)));
        }
        cube.init2();
        for (AssignDefaultMember assignDefaultMember : this.assignDefaultMembers) {
            assignDefaultMember.apply2();
        }
        for (RolapCubeHierarchy hierarchy : cube.hierarchyList) {
            assert (hierarchy.defaultMember != null) : hierarchy;
        }
        return cube;
    }

    private RolapCubeDimension findClosedPeerDimension(RolapCubeDimension dimension) {
        for (RolapCubeHierarchy hierarchy : dimension.getHierarchyList()) {
            for (RolapCubeLevel level : hierarchy.getLevelList()) {
                if (!level.hasClosedPeer()) continue;
                return level.getClosedPeer().getDimension();
            }
        }
        return null;
    }

    Larders.LarderBuilder createLarder(String tag, NamedList<MondrianDef.Annotation> annotations, String name, String caption, String description) {
        return new Larders.LarderBuilder().populate(Larders.create(annotations, name, caption, description, tag != null ? this.resourceMap.get(tag) : null, this.schema == null ? Locale.getDefault() : this.schema.getInternalConnection().getLocale()));
    }

    private List<RolapMember> nonSystemMeasures() {
        return this.minus(this.measureList, this.aggFactCountMeasureList);
    }

    private <T> List<T> minus(List<T> list0, Collection<T> remove) {
        ArrayList<T> list = new ArrayList<T>();
        for (T t : list0) {
            if (this.containsByIdentity(remove, t)) continue;
            list.add(t);
        }
        return list;
    }

    private <T> boolean containsByIdentity(Collection<T> remove, T next) {
        boolean b = false;
        for (T o : remove) {
            if (next != o) continue;
            b = true;
            break;
        }
        return b;
    }

    private RolapMeasureGroup.RolapMeasureRef createMeasureRef(List<RolapMember> measureList, MondrianDef.MeasureRef xmlMeasureRef, RolapMeasureGroup measureGroup) {
        RolapMember measure = RolapSchemaLoader.findMeasure(measureList, xmlMeasureRef.name);
        if (measure == null) {
            this.handler.error("Measure '" + xmlMeasureRef.name + "' not found", (NodeDef)xmlMeasureRef, "name");
            return null;
        }
        if (!(measure instanceof RolapBaseCubeMeasure)) {
            this.handler.error("Measure '" + xmlMeasureRef.name + "' is not a stored measure", (NodeDef)xmlMeasureRef, "name");
            return null;
        }
        RolapBaseCubeMeasure baseMeasure = (RolapBaseCubeMeasure)measure;
        RolapSchema.PhysColumn physColumn = this.getPhysColumn(measureGroup.getFactRelation(), xmlMeasureRef.aggColumn, xmlMeasureRef, "aggColumn");
        if (physColumn == null) {
            return null;
        }
        RolapMeasureGroup.RolapMeasureRef measureRef = new RolapMeasureGroup.RolapMeasureRef(baseMeasure, physColumn);
        measureGroup.measureRefList.add(measureRef);
        return measureRef;
    }

    private void addCopyLink(RolapMeasureGroup measureGroup, RolapCubeDimension dimension, MondrianDef.CopyLink xmlCopyLink) {
        RolapSchema.PhysPath path = new RolapSchema.PhysPathBuilder(measureGroup.getFactRelation()).done();
        this.dimensionPaths.put(Pair.of(measureGroup, dimension), path);
        RolapSchema.PhysRelation fact = measureGroup.getFactRelation();
        for (MondrianDef.Column xmlColumn : xmlCopyLink.columnRefs) {
            RolapSchema.PhysColumn column;
            RolapSchema.PhysColumn aggColumn = this.getPhysColumn(fact, xmlColumn.aggColumn, xmlColumn, "aggColumn");
            if (aggColumn == null || (column = this.getPhysColumn(this.last(fact, xmlColumn.table, xmlColumn, "table"), xmlColumn.name, xmlColumn, "name")) == null) continue;
            RolapStar.Column starAggColumn = RolapSchemaLoader.registerExpr(measureGroup, dimension, path, aggColumn, null, null);
            measureGroup.copyColumnList.add(Pair.of(starAggColumn, column));
        }
    }

    private static RolapMember findMeasure(List<RolapMember> memberList, String name) {
        for (RolapMember member : memberList) {
            if (Util.equalName(member.getName(), name)) {
                return member;
            }
            if (!member.getUniqueName().equals(name)) continue;
            return member;
        }
        return null;
    }

    private void registerDimension(RolapMeasureGroup measureGroup, RolapCubeDimension dimension, RolapSchema.PhysPath path) {
        for (RolapCubeHierarchy hierarchy : dimension.getHierarchyList()) {
            this.registerHierarchy(measureGroup, hierarchy);
        }
        for (RolapAttribute attribute : dimension.attributeMap.values()) {
            this.registerAttribute(measureGroup, dimension, attribute, path);
        }
    }

    private void registerHierarchy(RolapMeasureGroup measureGroup, RolapCubeHierarchy hierarchy) {
        for (RolapCubeLevel rolapCubeLevel : hierarchy.getLevelList()) {
            this.registerLevel(measureGroup, rolapCubeLevel);
        }
    }

    private void registerLevel(RolapMeasureGroup measureGroup, RolapCubeLevel level) {
        RolapCubeLevel peer = level.getClosedPeer();
        if (peer != null) {
            RolapAttribute attribute = peer.getAttribute();
            this.registerAttribute(measureGroup, peer.getDimension(), attribute, this.dimensionPaths.get(Pair.of(measureGroup, peer.getDimension())));
        }
    }

    private void registerAttribute(RolapMeasureGroup measureGroup, RolapCubeDimension dimension, RolapAttribute attribute, RolapSchema.PhysPath path) {
        for (RolapSchema.PhysColumn column : attribute.getKeyList()) {
            RolapSchemaLoader.registerExpr(measureGroup, dimension, path, column, attribute.getName(), "Key");
        }
        RolapSchemaLoader.registerExpr(measureGroup, dimension, path, attribute.getNameExp(), attribute.getName(), "Name");
        RolapSchemaLoader.registerExpr(measureGroup, dimension, path, attribute.getCaptionExp(), attribute.getName(), "Caption");
        for (RolapSchema.PhysColumn column : attribute.getOrderByList()) {
            RolapSchemaLoader.registerExpr(measureGroup, dimension, path, column, attribute.getName(), "OrderBy");
        }
    }

    private static RolapStar.Column registerExpr(RolapMeasureGroup measureGroup, RolapCubeDimension dimension, RolapSchema.PhysPath path, RolapSchema.PhysColumn expr, String name, String property) {
        assert (path != null);
        if (expr == null) {
            return null;
        }
        for (Pair<RolapStar.Column, RolapSchema.PhysColumn> pair : measureGroup.copyColumnList) {
            if (!((RolapSchema.PhysColumn)pair.right).equals(expr)) continue;
            return (RolapStar.Column)pair.left;
        }
        RolapSchema.PhysSchemaGraph graph = measureGroup.getFactRelation().getSchema().getGraph();
        RolapSchema.PhysPathBuilder pathBuilder = new RolapSchema.PhysPathBuilder(path);
        try {
            graph.findPath(pathBuilder, expr.relation);
        }
        catch (RolapSchema.PhysSchemaException e) {
            throw Util.newInternal(e, "Could not find path to " + expr.relation);
        }
        RolapStar star = measureGroup.getStar();
        RolapStar.Table starTable = star.getTable(pathBuilder.done());
        RolapStar.Column starColumn = starTable.lookupColumnByExpression(expr, true, name, property);
        assert (starColumn != null);
        measureGroup.starColumnMap.put(Pair.of(dimension, expr), starColumn);
        return starColumn;
    }

    private RolapBaseCubeMeasure createMeasure(RolapMeasureGroup measureGroup, MondrianDef.Measure xmlMeasure, RolapSchema.PhysRelation measureGroupTable) {
        Object propExpr;
        String propName;
        int j;
        String formatString;
        Dialect.Datatype specifiedDatatype;
        RolapSchema.PhysRelation table = this.last(measureGroupTable, xmlMeasure.table, xmlMeasure, "table");
        RolapCube cube = measureGroup.getCube();
        if (table == null) {
            throw MondrianResource.instance().MeasureWithColumnMustHaveTable.ex(cube.getName(), xmlMeasure.name);
        }
        RolapSchema.PhysColumn measureExp = this.createColumn(xmlMeasure, "column", measureGroupTable, xmlMeasure.column, xmlMeasure.getArguments());
        RolapAggregator aggregator = RolapSchemaLoader.lookupAggregator(xmlMeasure.aggregator);
        if (measureExp == null && aggregator != RolapAggregator.Count) {
            throw MondrianResource.instance().BadMeasureSource.ex(cube.getName(), xmlMeasure.name);
        }
        HashSet<RolapSchema.PhysRelation> relationSet = new HashSet<RolapSchema.PhysRelation>();
        PhysSchemaBuilder.collectRelations(aggregator, measureExp, measureGroup.getFactRelation(), relationSet);
        if (relationSet.size() != 1) {
            this.handler.error("Measure '" + xmlMeasure.name + "' must belong to one and only one relation", (NodeDef)xmlMeasure, xmlMeasure.column != null ? "column" : null);
        }
        Dialect.Datatype datatype = aggregator.deriveDatatype(measureExp == null ? Collections.emptyList() : Collections.singletonList(measureExp.getDatatype()));
        if (xmlMeasure.datatype == null) {
            specifiedDatatype = null;
        } else {
            specifiedDatatype = Util.lookup(Dialect.Datatype.class, xmlMeasure.datatype);
            if (specifiedDatatype == null) {
                this.handler.error("Invalid datatype '" + xmlMeasure.datatype + "'", (NodeDef)xmlMeasure, "datatype");
            }
        }
        if (specifiedDatatype != null && datatype != null && specifiedDatatype != datatype) {
            this.handler.error("Datatype '" + (Object)((Object)datatype) + "' of measure '" + xmlMeasure.name + "' is inconsistent with stated datatype '" + (Object)((Object)specifiedDatatype) + "'", (NodeDef)xmlMeasure, null);
        }
        if (datatype == null) {
            if (specifiedDatatype == null) {
                this.handler.error("Datatype of measure '" + xmlMeasure.name + "' cannot be derived, so must be specified", (NodeDef)xmlMeasure, null);
            } else {
                datatype = specifiedDatatype;
            }
        }
        if (datatype == null) {
            datatype = Dialect.Datatype.Numeric;
        }
        if ((formatString = xmlMeasure.formatString) == null) {
            formatString = "";
        }
        boolean visible = RolapSchemaLoader.toBoolean(xmlMeasure.visible, true);
        RolapCubeHierarchy measuresHierarchy = cube.getHierarchyList().get(0);
        RolapCubeLevel level = measuresHierarchy.getLevelList().get(0);
        Larder larder = this.createLarder(cube.getUniqueName() + "." + Util.quoteMdxIdentifier(xmlMeasure.name) + ".measure", xmlMeasure.getAnnotations(), xmlMeasure.name, xmlMeasure.caption, xmlMeasure.description).add(Property.FORMAT_EXP_PARSED, (Object)Literal.createString(formatString)).add(Property.FORMAT_EXP, (Object)formatString).add(Property.AGGREGATION_TYPE, (Object)aggregator).add(Property.DATATYPE, (Object)datatype.name()).add(Property.VISIBLE, (Object)visible).build();
        RolapBaseCubeMeasure measure = new RolapBaseCubeMeasure(measureGroup, level, xmlMeasure.name, Util.makeFqName(level.getHierarchy(), xmlMeasure.name), measureExp, aggregator, datatype, larder);
        measureGroup.measureList.add((Object)measure);
        this.validator.putXml(measure, xmlMeasure);
        CellFormatter cellFormatter = RolapSchemaLoader.makeCellFormatter(xmlMeasure, measure.getUniqueName());
        if (cellFormatter != null) {
            measure.setFormatter(cellFormatter);
        }
        ArrayList<String> propNames = new ArrayList<String>();
        ArrayList<String> propExprs = new ArrayList<String>();
        this.validateMemberProps(cube, (List<MondrianDef.CalculatedMemberProperty>)xmlMeasure.getCalculatedMemberProperties(), (List<String>)propNames, (List<String>)propExprs, xmlMeasure.name);
        for (j = 0; j < propNames.size(); ++j) {
            propName = (String)propNames.get(j);
            propExpr = propExprs.get(j);
            measure.setProperty(propName, propExpr);
        }
        measure.setOrdinal(-1);
        for (j = 0; j < propNames.size(); ++j) {
            String expr;
            propName = (String)propNames.get(j);
            propExpr = propExprs.get(j);
            measure.setProperty(propName, propExpr);
            if (!propName.equals(Property.MEMBER_ORDINAL.name) || !(propExpr instanceof String) || !(expr = (String)propExpr).startsWith("\"") || !expr.endsWith("\"")) continue;
            try {
                Integer ordinal = Integer.valueOf(expr.substring(1, expr.length() - 1));
                measure.setOrdinal(ordinal);
                measure.setOrderKey(ordinal);
                continue;
            }
            catch (NumberFormatException e) {
                Util.discard((Object)e);
            }
        }
        return measure;
    }

    private boolean hasMeasure(RolapCube cube, String measureName) {
        for (RolapMeasureGroup measureGroup : cube.getMeasureGroups()) {
            if (measureGroup.measureList.get(measureName) == null) continue;
            return true;
        }
        return false;
    }

    private static RolapAggregator lookupAggregator(String aggregatorName) {
        RolapAggregator aggregator = aggregatorName.equals("distinct count") ? RolapAggregator.DistinctCount : RolapAggregator.enumeration.getValue(aggregatorName, false);
        if (aggregator == null) {
            StringBuilder buf = new StringBuilder();
            for (String aggName : RolapAggregator.enumeration.getNames()) {
                if (buf.length() > 0) {
                    buf.append(", ");
                }
                buf.append('\'');
                buf.append(aggName);
                buf.append('\'');
            }
            throw MondrianResource.instance().UnknownAggregator.ex(aggregatorName, buf.toString());
        }
        return aggregator;
    }

    private void addForeignKeyLink(RolapSchema.PhysRelation fact, RolapMeasureGroup measureGroup, RolapCubeDimension dimension, MondrianDef.ForeignKeyLink xmlForeignKeyLink) {
        RolapSchema.PhysKey sourceKey;
        RolapAttribute keyAttribute;
        List<RolapSchema.PhysColumn> foreignKeyList = this.createColumnList(xmlForeignKeyLink, "foreignKeyColumn", fact, xmlForeignKeyLink.foreignKeyColumn, xmlForeignKeyLink.foreignKey);
        if (foreignKeyList == null) {
            return;
        }
        if (xmlForeignKeyLink.attribute == null) {
            keyAttribute = dimension.rolapDimension.keyAttribute;
            if (keyAttribute == null) {
                this.getHandler().error("Dimension '" + dimension.getName() + "' is used in a dimension link but has no key attribute. " + "Please specify key.", (NodeDef)xmlForeignKeyLink, null);
                return;
            }
            sourceKey = dimension.rolapDimension.key.get();
        } else {
            keyAttribute = dimension.rolapDimension.attributeMap.get(xmlForeignKeyLink.attribute);
            if (keyAttribute == null) {
                this.getHandler().error("Invalid attribute '" + xmlForeignKeyLink.attribute + "' in ForeignKeyLink. Dimension '" + dimension.getName() + "' has no such attribute.", (NodeDef)xmlForeignKeyLink, "attribute");
                return;
            }
            sourceKey = this.lookupKey(null, true, keyAttribute);
        }
        List<RolapSchema.PhysColumn> keyList = keyAttribute.getKeyList();
        if (foreignKeyList.size() != keyList.size()) {
            this.handler.error("Number of foreign key columns " + foreignKeyList.size() + " does not match number of key columns " + keyList.size(), (NodeDef)xmlForeignKeyLink, "foreignKey");
        }
        RolapSchema.PhysPathBuilder pathBuilderOrig = new RolapSchema.PhysPathBuilder(fact).add(sourceKey, foreignKeyList);
        RolapSchema.PhysPath path = pathBuilderOrig.clone().done();
        measureGroup.addLink(dimension, path);
        this.dimensionPaths.put(Pair.of(measureGroup, dimension), path);
        if (Util.deprecated(false, false).booleanValue()) {
            for (RolapAttribute attribute : dimension.attributeMap.values()) {
                RolapSchema.PhysSchemaGraph graph = measureGroup.getFactRelation().getSchema().getGraph();
                RolapSchema.PhysRelation relation = this.uniqueTable(attribute.getKeyList());
                if (relation == null && Util.deprecated(false, false).booleanValue()) {
                    if (attribute.getKeyList().isEmpty()) {
                        throw Util.newInternal("attribute " + attribute + " has empty key");
                    }
                    throw Util.newInternal("attribute " + attribute + " has key whose columns " + "belong to inconsistent relations " + attribute.getKeyList());
                }
                for (RolapSchema.PhysColumn column : attribute.getKeyList()) {
                    Pair<RolapCubeDimension, RolapSchema.PhysColumn> key = Pair.of(dimension, column);
                    if (measureGroup.starColumnMap.containsKey(key)) continue;
                    RolapSchema.PhysPathBuilder pathBuilder = pathBuilderOrig.clone();
                    try {
                        graph.findPath(pathBuilder, column.relation);
                    }
                    catch (RolapSchema.PhysSchemaException e) {
                        throw Util.newInternal("Could not find path to " + column.relation);
                    }
                    RolapStar star = measureGroup.getStar();
                    RolapStar.Table starTable = star.getTable(pathBuilder.done());
                    RolapStar.Column starColumn = starTable.lookupColumnByExpression(column, true, null, null);
                    assert (starColumn != null);
                    measureGroup.starColumnMap.put(key, starColumn);
                }
            }
        }
    }

    RolapSchema.PhysRelation uniqueTable(List<RolapSchema.PhysColumn> columnList) throws RuntimeException {
        RolapSchema.PhysRelation relation = null;
        for (RolapSchema.PhysColumn column : columnList) {
            if (relation == null) {
                relation = column.relation;
                continue;
            }
            if (relation == column.relation) continue;
            return null;
        }
        return relation;
    }

    private void addFactLink(RolapMeasureGroup measureGroup, RolapCubeDimension dimension) {
        RolapSchema.PhysPath path = new RolapSchema.PhysPathBuilder(measureGroup.getFactRelation()).done();
        measureGroup.addLink(dimension, path);
        this.dimensionPaths.put(Pair.of(measureGroup, dimension), path);
    }

    private void checkOrdinals(MondrianDef.Cube xmlCube) {
        HashMap<Integer, String> ordinals = new HashMap<Integer, String>();
        for (RolapMember measure : this.nonSystemMeasures()) {
            int ordinal = measure.getOrdinal();
            String prev = ordinals.put(ordinal, measure.getUniqueName());
            if (prev == null) continue;
            throw MondrianResource.instance().MeasureOrdinalsNotUnique.ex(xmlCube.name, String.valueOf(ordinal), prev, measure.getUniqueName());
        }
    }

    private RolapCubeDimension getOrCreateDimension(RolapCube cube, final MondrianDef.Dimension xmlCubeDimension, RolapSchema schema, final MondrianDef.Schema xmlSchema, int dimensionOrdinal, List<RolapCubeHierarchy> cubeHierarchyList, NamedList<MondrianDef.Annotation> annotations) {
        MondrianDef.Attribute xmlAttribute;
        MondrianDef.Dimension xmlDimension;
        String dimensionName = Util.first(xmlCubeDimension.name, xmlCubeDimension.source);
        if (cube.dimensionList.get(dimensionName) != null) {
            this.getHandler().error("Duplicate dimension '" + dimensionName + "'", (NodeDef)xmlCubeDimension, null);
            return null;
        }
        if (xmlCubeDimension.source != null) {
            xmlDimension = this.useSharedDimension(cube, xmlCubeDimension, schema, xmlSchema);
            if (xmlDimension == null) {
                return null;
            }
        } else {
            xmlDimension = xmlCubeDimension;
        }
        Dimension.Type dimensionType = xmlDimension.type == null ? Dimension.Type.OTHER : Dimension.Type.valueOf((String)xmlDimension.type);
        final RolapDimension dimension = new RolapDimension(schema, xmlDimension.name, RolapSchemaLoader.toBoolean(xmlDimension.visible, true), dimensionType, xmlDimension.hanger, this.createLarder(Util.quoteMdxIdentifier(xmlDimension.name) + ".dimension", annotations, xmlDimension.name, xmlDimension.caption, xmlDimension.description).build());
        this.validator.putXml(dimension, xmlDimension);
        if (xmlCubeDimension.source != null && !schema.sharedDimensions.containsKey(dimension.getName())) {
            schema.sharedDimensions.put(dimension.getName(), (RolapCubeDimension)DUMMY);
            this.postCubeActions.add(new Util.Function0(){

                public Object apply() {
                    RolapSchemaLoader.this.sharedDimension(dimension, xmlCubeDimension.source, xmlSchema);
                    return null;
                }
            });
        }
        RolapSchema.PhysRelation dimensionRelation = xmlDimension.hanger != false ? this.getPhysRelation(EMPTY_TABLE_NAME, null, null) : (xmlDimension.table == null ? null : this.getPhysRelation(xmlDimension.table, xmlDimension, "table"));
        ArrayList<RolapAttribute> attributeList = new ArrayList<RolapAttribute>();
        for (MondrianDef.Attribute xmlAttribute2 : xmlDimension.getAttributes()) {
            RolapAttribute attribute = this.createAttribute(xmlAttribute2, null, dimensionRelation, dimension);
            if (attribute == null) continue;
            RolapAttribute put = dimension.attributeMap.put(attribute.getName(), attribute);
            assert (put == null) : "validation rule should have caught dup attr";
            attributeList.add(attribute);
        }
        int attributeHierarchyCount = 0;
        for (RolapAttribute attribute : attributeList) {
            xmlAttribute = (MondrianDef.Attribute)this.validator.getXml(attribute, true);
            this.createProperties(this.physSchemaBuilder, dimension, attribute, dimensionRelation, xmlAttribute, attribute.getExplicitProperties());
        }
        if (xmlDimension.key != null) {
            dimension.keyAttribute = dimension.attributeMap.get(xmlDimension.key);
            if (dimension.keyAttribute == null) {
                this.getHandler().error("Key attribute '" + xmlDimension.key + "' is not a valid attribute of this dimension", (NodeDef)xmlDimension, "key");
                return null;
            }
            if (RolapSchemaLoader.uniqueRelation(dimension) == null) {
                this.getHandler().error("Columns in key of dimension's key attribute '" + xmlDimension.key + "' do not belong to same relation", (NodeDef)xmlDimension, "key");
                return null;
            }
        } else {
            if (attributeList.size() > 1) {
                this.getHandler().error(MondrianResource.instance().DimensionKeyOmitted.ex(xmlDimension.name), (NodeDef)this.validator.getXmls(dimension), null);
            }
            dimension.keyAttribute = (RolapAttribute)attributeList.get(0);
        }
        dimension.key = new Lazy<RolapSchema.PhysKey>(new Util.Function0<RolapSchema.PhysKey>(){

            @Override
            public RolapSchema.PhysKey apply() {
                return RolapSchemaLoader.this.lookupKey(xmlDimension, true, dimension.keyAttribute);
            }
        });
        for (MondrianDef.Hierarchy xmlHierarchy : xmlDimension.getHierarchies()) {
            String hierarchyName = Util.first(xmlHierarchy.name, xmlDimension.name);
            RolapHierarchy hierarchy = new RolapHierarchy(dimension, hierarchyName, Util.makeFqName(dimension, hierarchyName), RolapSchemaLoader.toBoolean(xmlHierarchy.visible, true), RolapSchemaLoader.toBoolean(xmlHierarchy.hasAll, true), null, null, this.createLarder(Util.makeFqName(dimension, hierarchyName) + ".hierarchy", xmlHierarchy.getAnnotations(), hierarchyName, xmlHierarchy.caption, xmlHierarchy.description).build());
            this.validator.putXml(hierarchy, xmlHierarchy);
            dimension.addHierarchy(hierarchy);
            hierarchy.initHierarchy(this, xmlHierarchy.allLevelName);
            if (xmlHierarchy.getLevels().size() == 0) {
                throw MondrianResource.instance().HierarchyHasNoLevels.ex(hierarchy.getUniqueName());
            }
            for (MondrianDef.Level xmlLevel : xmlHierarchy.getLevels()) {
                RolapLevel level = this.createLevel(cube, hierarchy, dimensionRelation, hierarchy.levelList.size(), xmlLevel);
                if (level == null) continue;
                hierarchy.levelList.add((Object)level);
            }
            this.deferAssignDefaultMember(cube, hierarchy, xmlHierarchy, xmlHierarchy.defaultMember);
        }
        for (RolapAttribute attribute : attributeList) {
            xmlAttribute = (MondrianDef.Attribute)this.validator.getXml(attribute, true);
            if (!RolapSchemaLoader.toBoolean(xmlAttribute.hasHierarchy, this.countHierarchies((List<? extends RolapHierarchy>)dimension.getHierarchyList(), attribute) == 0)) continue;
            if (dimension.getHierarchyList().get(xmlAttribute.name) != null) {
                this.handler.error("Cannot create hierarchy for attribute '" + xmlAttribute.name + "'; dimension already has a hierarchy of that name", (NodeDef)xmlAttribute, "name");
                continue;
            }
            ++attributeHierarchyCount;
            String uniqueName = Util.makeFqName(dimension, xmlAttribute.name);
            RolapHierarchy hierarchy = new RolapHierarchy(dimension, xmlAttribute.name, uniqueName, RolapSchemaLoader.toBoolean(xmlAttribute.visible, true), RolapSchemaLoader.toBoolean(xmlAttribute.hierarchyHasAll, true), null, attribute, this.createLarder(cube + "." + uniqueName + ".hierarchy", null, xmlAttribute.name, Util.first(xmlAttribute.hierarchyCaption, xmlAttribute.caption), xmlAttribute.description).populate(attribute.getLarder()).build());
            dimension.addHierarchy(hierarchy);
            dimension.attributeMap.put(attribute.getName(), attribute);
            hierarchy.initHierarchy(this, hierarchy.hasAll() ? xmlAttribute.hierarchyAllLevelName : null);
            hierarchy.levelList.add((Object)new RolapLevel(hierarchy, xmlAttribute.name, RolapSchemaLoader.toBoolean(xmlAttribute.visible, true), hierarchy.hasAll() ? 1 : 0, attribute, null, attribute.getOrderByList(), null, null, RolapLevel.HideMemberCondition.Never, this.createLarder(cube + "." + Util.makeFqName(hierarchy, xmlAttribute.name) + ".level", null, null, null, null).populate(this.createLarder(cube + "." + Util.makeFqName(hierarchy, xmlAttribute.name) + ".level", xmlAttribute.getAnnotations(), xmlAttribute.name, xmlAttribute.caption, xmlAttribute.description).build()).build(), this.resourceMap));
            this.deferAssignDefaultMember(cube, hierarchy, xmlAttribute, xmlAttribute.hierarchyDefaultMember);
        }
        if (dimension.getHierarchyList().isEmpty() && attributeHierarchyCount == 0) {
            this.getHandler().error("Dimension '" + dimension.getName() + "' must have at least one hierarchy (or attribute " + "hierarchy).", (NodeDef)xmlDimension, null);
            return null;
        }
        this.validateDimensionType(dimension);
        RolapCubeDimension cubeDimension = new RolapCubeDimension(cube, dimension, dimensionName, dimensionOrdinal, this.createLarder(cube.getUniqueName() + "." + Util.quoteMdxIdentifier(dimensionName) + ".dimension", xmlCubeDimension.getAnnotations(), dimensionName, Util.first(xmlCubeDimension.caption, xmlDimension.caption), Util.first(xmlCubeDimension.description, xmlDimension.description)).populate(dimension.getLarder()).build());
        this.initCubeDimension(cubeDimension, xmlCubeDimension.source, cubeHierarchyList);
        this.validator.putXml(cubeDimension, xmlCubeDimension);
        cubeDimension.attributeMap.putAll(dimension.attributeMap);
        return cubeDimension;
    }

    private void sharedDimension(RolapDimension dimension, String source, MondrianDef.Schema xmlSchema) {
        String name = dimension.getName();
        assert (this.schema.sharedDimensions.get(name) == DUMMY);
        MondrianDef.Cube xmlCube = new MondrianDef.Cube();
        xmlCube.name = "$" + source;
        xmlCube.enableScenarios = false;
        xmlCube.visible = Boolean.FALSE;
        xmlCube.defaultMeasure = FACT_COUNT_MEASURE_NAME;
        MondrianDef.Dimension xmlDimension = new MondrianDef.Dimension();
        xmlCube.children.holder(new MondrianDef.Dimensions()).list().add((Object)xmlDimension);
        xmlDimension.source = source;
        MondrianDef.MeasureGroup xmlMeasureGroup = new MondrianDef.MeasureGroup();
        xmlCube.children.holder(new MondrianDef.MeasureGroups()).list().add((Object)xmlMeasureGroup);
        xmlMeasureGroup.table = dimension.keyAttribute.getKeyList().get((int)0).relation.getAlias();
        MondrianDef.Measure xmlMeasure = new MondrianDef.Measure();
        xmlMeasureGroup.children.holder(new MondrianDef.Measures()).list().add((Object)xmlMeasure);
        xmlMeasure.name = FACT_COUNT_MEASURE_NAME;
        xmlMeasure.aggregator = RolapAggregator.Count.name;
        MondrianDef.FactLink xmlFactLink = new MondrianDef.FactLink();
        xmlMeasureGroup.children.holder(new MondrianDef.DimensionLinks()).list().add(xmlFactLink);
        xmlFactLink.dimension = name;
        RolapCube cube = this.createCube(this.schema, xmlCube, xmlSchema);
        RolapCubeDimension cubeDimension = cube.getDimensionList().get(1);
        this.schema.sharedDimensions.put(name, cubeDimension);
    }

    private MondrianDef.Dimension useSharedDimension(RolapCube cube, MondrianDef.Dimension xmlCubeDimension, RolapSchema schema, MondrianDef.Schema xmlSchema) {
        MondrianDef.Dimension sharedDimension;
        if (xmlCubeDimension.key != null) {
            this.getHandler().warning("Attribute 'key' must not be specified in dimension that references other dimension", xmlCubeDimension, "source");
        }
        if ((sharedDimension = (MondrianDef.Dimension)xmlSchema.getDimensions().get(xmlCubeDimension.source)) == null) {
            this.getHandler().error("Unknown shared dimension '" + xmlCubeDimension.source + "' in definition of dimension '" + xmlCubeDimension.name + "'", (NodeDef)xmlCubeDimension, "source");
            return null;
        }
        MondrianDef.Dimension clonedDim = null;
        if (this.cubeToDimMap.containsKey((Object)cube) && this.cubeToDimMap.getCollection((Object)cube).contains(sharedDimension)) {
            try {
                LinkedHashMap<String, RolapSchema.PhysRelation> tbls = schema.getPhysicalSchema().tablesByName;
                RolapSchema.PhysRelation physRelation = tbls.get(sharedDimension.table);
                if (physRelation != null) {
                    String newAlias = this.newTableAlias(physRelation, tbls);
                    RolapSchema.PhysRelation clonedRelation = physRelation.cloneWithAlias(newAlias);
                    tbls.put(newAlias, clonedRelation);
                    clonedDim = new MondrianDef.Dimension(sharedDimension._def);
                    clonedDim.table = newAlias;
                }
            }
            catch (XOMException e) {
                throw new MondrianException(e);
            }
        }
        this.cubeToDimMap.put((Object)cube, (Object)sharedDimension);
        MondrianDef.Dimension xmlDimension = clonedDim != null ? clonedDim : sharedDimension;
        return xmlDimension;
    }

    private String newTableAlias(RolapSchema.PhysRelation physRelation, LinkedHashMap<String, RolapSchema.PhysRelation> tbls) {
        String alias = physRelation.getAlias();
        int i = 1;
        String candidateAlias;
        while (tbls.containsKey(candidateAlias = alias + "_" + i)) {
            ++i;
        }
        return candidateAlias;
    }

    public static boolean toBoolean(Boolean aBoolean, boolean dflt) {
        return aBoolean == null ? dflt : aBoolean;
    }

    private int countHierarchies(List<? extends RolapHierarchy> hierarchyList, RolapAttribute attribute) {
        int n = 0;
        for (RolapHierarchy rolapHierarchy : hierarchyList) {
            for (RolapLevel rolapLevel : rolapHierarchy.getLevelList()) {
                if (rolapLevel.attribute != attribute) continue;
                ++n;
            }
        }
        return n;
    }

    private RolapSchema.PhysKey lookupKey(MondrianDef.Dimension xmlDimension, boolean create, RolapAttribute keyAttribute) {
        RolapSchema.PhysRelation relation = RolapSchemaLoader.uniqueRelation(keyAttribute.getDimension());
        if (relation == null) {
            return null;
        }
        for (RolapSchema.PhysKey key : relation.getKeyList()) {
            if (!key.columnList.equals(keyAttribute.getKeyList())) continue;
            return key;
        }
        if (create) {
            return relation.addKey("k$" + relation.getKeyList().size(), keyAttribute.getKeyList());
        }
        this.getHandler().error("The columns of dimension's key attribute do not match a known key of table '" + relation + "'", (NodeDef)xmlDimension, "key");
        return null;
    }

    static RolapSchema.PhysRelation uniqueRelation(RolapDimension dimension) {
        HashSet<RolapSchema.PhysRelation> relations = new HashSet<RolapSchema.PhysRelation>();
        for (RolapSchema.PhysColumn key : dimension.keyAttribute.getKeyList()) {
            relations.add(key.relation);
        }
        return relations.size() != 1 ? null : (RolapSchema.PhysRelation)relations.iterator().next();
    }

    private void validateDimensionType(RolapDimension dimension) {
        for (RolapHierarchy hierarchy : dimension.getHierarchyList()) {
            for (RolapLevel level : hierarchy.getLevelList()) {
                if (level.getLevelType().isTime() && dimension.getDimensionType() != Dimension.Type.TIME) {
                    this.getHandler().error(MondrianResource.instance().TimeLevelInNonTimeHierarchy.ex(dimension.getUniqueName()), (NodeDef)this.validator.getXmls(level, hierarchy, dimension), null);
                }
                if (!level.getLevelType().isTime() && !level.isAll() && dimension.getDimensionType() != Dimension.Type.TIME) continue;
            }
        }
    }

    void initCubeDimension(RolapCubeDimension cubeDimension, String dimSource, List<RolapCubeHierarchy> hierarchyList) {
        int originalSize = hierarchyList.size();
        for (RolapHierarchy hierarchy : cubeDimension.rolapDimension.getHierarchyList()) {
            String uniqueName = hierarchy.getDimension().isMeasures() ? hierarchy.getUniqueName() : Util.makeFqName(cubeDimension, hierarchy.getName());
            RolapCubeHierarchy cubeHierarchy = new RolapCubeHierarchy(this, cubeDimension, hierarchy, hierarchy.getName(), uniqueName, hierarchyList.size(), this.createLarder(cubeDimension.cube + "." + uniqueName + ".hierarchy", null, null, null, null).populate(Larders.prefix(hierarchy.getLarder(), dimSource, cubeDimension.getName())).build());
            MondrianDef.Hierarchy xmlHierarchy = (MondrianDef.Hierarchy)this.validator.getXml(hierarchy, false);
            MondrianDef.Attribute xmlAttribute = (MondrianDef.Attribute)this.validator.getXml(hierarchy.attribute, false);
            hierarchyList.add(cubeHierarchy);
            this.initCubeHierarchy(cubeHierarchy, Util.first(xmlAttribute != null ? Util.first(xmlAttribute.hierarchyAllMemberName, "All " + xmlAttribute.name) : (xmlHierarchy != null ? xmlHierarchy.allMemberName : null), "All " + cubeHierarchy.getName() + "s"), xmlAttribute != null ? xmlAttribute.hierarchyAllMemberCaption : (xmlHierarchy != null ? xmlHierarchy.allMemberCaption : null));
            if (!cubeHierarchy.isScenario) continue;
            assert (cubeDimension.cube.scenarioHierarchy == null);
            cubeDimension.cube.scenarioHierarchy = cubeHierarchy;
        }
        cubeDimension.getHierarchyList().addAll(hierarchyList.subList(originalSize, hierarchyList.size()));
    }

    void initCubeHierarchy(RolapCubeHierarchy hierarchy, String allMemberName, String allMemberCaption) {
        assert (allMemberName != null);
        hierarchy.initCubeHierarchy(this, allMemberName, allMemberCaption);
        for (RolapCubeLevel rolapCubeLevel : hierarchy.getLevelList()) {
            rolapCubeLevel.initLevel(this);
        }
        hierarchy.memberReader = this.schema.createMemberReader(hierarchy, null);
        Util.putMulti(this.cubeHierMap, hierarchy.getRolapHierarchy(), hierarchy);
    }

    void deferAssignDefaultMember(RolapCube cube, RolapHierarchy hierarchy, ElementDef xml, String hierarchyDefaultMember) {
        if (hierarchy instanceof RolapCubeHierarchy) {
            RolapCubeHierarchy cubeHierarchy = (RolapCubeHierarchy)hierarchy;
            this.deferAssignDefaultMember(cube, cubeHierarchy.getRolapHierarchy(), xml, hierarchyDefaultMember);
        } else {
            AssignDefaultMember x = hierarchy.getDimension().isMeasures() ? (hierarchyDefaultMember == null ? new MeasureAssignDefaultMember(cube, hierarchy, (MondrianDef.Cube)xml) : new NamedMeasureAssignDefaultMember(cube, hierarchy, (MondrianDef.Cube)xml)) : (hierarchyDefaultMember == null ? new NamelessAssignDefaultMember(cube, hierarchy, xml) : new NamedAssignDefaultMember(cube, hierarchy, xml, hierarchyDefaultMember));
            this.assignDefaultMembers.add(x);
        }
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    RolapAttribute createAttribute(MondrianDef.Attribute xmlAttribute, RolapSchema.PhysRelation closureRelation, RolapSchema.PhysRelation sourceRelation, final RolapDimension dimension) {
        void var10_15;
        String caption;
        void var10_12;
        List<RolapSchema.PhysColumn> list;
        boolean nameSpecified;
        MondrianDef.Attribute a;
        if (dimension.attributeMap.get(xmlAttribute.name) != null) {
            this.getHandler().error("Duplicate attribute '" + xmlAttribute.name + "' in dimension '" + dimension.getName() + "'", (NodeDef)xmlAttribute, null);
            return null;
        }
        if (dimension.hanger && (this.invalidHangerAttribute(a = xmlAttribute, a.keyColumn, "keyColumn") || this.invalidHangerAttribute(a, a.nameColumn, "nameColumn") || this.invalidHangerAttribute(a, a.orderByColumn, "orderByColumn") || this.invalidHangerAttribute(a, a.captionColumn, "captionColumn") || this.invalidHangerAttribute(a, a.getKey()) || this.invalidHangerAttribute(a, a.getName_()) || this.invalidHangerAttribute(a, a.getOrderBy()) || this.invalidHangerAttribute(a, a.getCaption()))) {
            return null;
        }
        RolapSchema.PhysRelation relation = this.last(sourceRelation, xmlAttribute.table, xmlAttribute, "table");
        List<RolapSchema.PhysColumn> keyList = this.createColumnList(xmlAttribute, "keyColumn", closureRelation != null ? closureRelation : relation, dimension.hanger ? EMPTY_TABLE_SOLE_COLUMN_NAME : xmlAttribute.keyColumn, xmlAttribute.getKey());
        if (keyList == null) {
            return null;
        }
        if (keyList.size() == 0) {
            this.getHandler().error("Attribute must have a key", (NodeDef)xmlAttribute, null);
            return null;
        }
        RolapSchema.PhysColumn nameExpr = this.createColumn(xmlAttribute, "nameColumn", closureRelation != null ? sourceRelation : relation, xmlAttribute.nameColumn, xmlAttribute.getName_());
        if (nameExpr == null) {
            nameSpecified = false;
            if (keyList.size() != 1) {
                this.getHandler().error("Attribute name must be specified. (Name can only be omitted when key contains a single column.)", (NodeDef)xmlAttribute, null);
                return null;
            }
            nameExpr = keyList.get(0);
        } else {
            nameSpecified = true;
        }
        RolapSchema.PhysColumn captionExpr = this.createColumn(xmlAttribute, "captionColumn", closureRelation != null ? sourceRelation : relation, xmlAttribute.captionColumn, xmlAttribute.getCaption());
        if (captionExpr == null) {
            captionExpr = nameExpr;
        }
        if ((list = this.createColumnList(xmlAttribute, "orderByColumn", closureRelation != null ? sourceRelation : relation, xmlAttribute.orderByColumn, xmlAttribute.getOrderBy())) == null) {
            List list2 = Collections.emptyList();
        }
        if (var10_12.isEmpty()) {
            if (nameSpecified) {
                List<RolapSchema.PhysColumn> list3 = Collections.singletonList(nameExpr);
            } else {
                List<RolapSchema.PhysColumn> list4 = keyList;
            }
        }
        int approxRowCount = RolapSchemaLoader.loadApproxRowCount(xmlAttribute.approxRowCount);
        Level.Type levelType = this.stringToLevelType(xmlAttribute.levelType);
        if (xmlAttribute.caption == null) {
            StringBuilder sb = new StringBuilder(dimension.getName());
            sb.append(" - ");
            if (xmlAttribute.name.startsWith("$")) {
                sb.append(xmlAttribute.name.replaceFirst("\\$", "").replaceAll("\\$", " - "));
            } else {
                sb.append(xmlAttribute.name.replaceAll("\\$", " - "));
            }
            caption = sb.toString();
        } else {
            caption = xmlAttribute.caption;
        }
        RolapAttributeImpl attribute = new RolapAttributeImpl(xmlAttribute.name, RolapSchemaLoader.toBoolean(xmlAttribute.visible, true), keyList, nameExpr, captionExpr, (List)var10_15, RolapSchemaLoader.makeMemberFormatter(xmlAttribute), levelType, approxRowCount, this.createLarder(Util.makeFqName(dimension, xmlAttribute.name) + ".attribute", xmlAttribute.getAnnotations(), xmlAttribute.name, caption, xmlAttribute.description).build()){

            public RolapDimension getDimension() {
                return dimension;
            }
        };
        this.validator.putXml(attribute, xmlAttribute);
        return attribute;
    }

    private boolean invalidHangerAttribute(MondrianDef.Attribute xmlAttribute, String keyColumn, String attributeName) {
        if (keyColumn != null) {
            this.getHandler().error("Attribute '" + xmlAttribute.name + "' in hanger dimension " + "must not map to column", (NodeDef)xmlAttribute, attributeName);
            return true;
        }
        return false;
    }

    private boolean invalidHangerAttribute(MondrianDef.Attribute xmlAttribute, MondrianDef.AttributeElement xml) {
        if (xml != null) {
            this.getHandler().error("Attribute '" + xmlAttribute.name + "' in hanger dimension " + "must not map to column", (NodeDef)xmlAttribute, null);
            return true;
        }
        return false;
    }

    private Level.Type stringToLevelType(String levelTypeString) {
        if ((levelTypeString = Util.camelToUpper(levelTypeString)).equals("TIME_HALF_YEARS")) {
            levelTypeString = "TIME_HALF_YEAR";
        }
        return Util.lookup(Level.Type.class, levelTypeString.toUpperCase());
    }

    public Handler getHandler() {
        return this.handler;
    }

    RolapLevel createLevel(RolapCube cube, RolapHierarchy hierarchy, RolapSchema.PhysRelation relation, int depth, MondrianDef.Level xmlLevel) {
        RolapAttribute parentAttribute;
        String levelName = Util.first(xmlLevel.name, xmlLevel.attribute);
        if (hierarchy.levelList.get(levelName) != null) {
            this.getHandler().error(MondrianResource.instance().HierarchyLevelNamesNotUnique.ex(hierarchy.getUniqueName(), levelName), (NodeDef)xmlLevel, null);
        }
        if (xmlLevel.attribute == null) {
            this.getHandler().error("Attribute 'attribute' is required", (NodeDef)xmlLevel, "attribute");
            return null;
        }
        RolapDimension dimension = hierarchy.getDimension();
        RolapAttribute attribute = dimension.attributeMap.get(xmlLevel.attribute);
        if (attribute == null) {
            this.getHandler().error("Attribute '" + xmlLevel.attribute + "' not found in Dimension '" + dimension.getName() + "'", (NodeDef)xmlLevel, "attribute");
            return null;
        }
        if (xmlLevel.parentAttribute != null) {
            parentAttribute = dimension.attributeMap.get(xmlLevel.parentAttribute);
            if (parentAttribute == null) {
                this.getHandler().error("Unknown parent attribute ''", (NodeDef)xmlLevel, "parentAttribute");
            }
        } else {
            parentAttribute = null;
        }
        List<RolapSchema.PhysColumn> orderByList = new ArrayList<RolapSchema.PhysColumn>(attribute.getOrderByList());
        if (!hierarchy.levelList.isEmpty()) {
            orderByList.removeAll(Util.last(hierarchy.levelList).getOrderByList());
        }
        if (orderByList.equals(attribute.getOrderByList())) {
            orderByList = attribute.getOrderByList();
        }
        RolapClosure closure = this.createClosure(cube, relation, xmlLevel, hierarchy);
        RolapLevel level = new RolapLevel(hierarchy, levelName, RolapSchemaLoader.toBoolean(xmlLevel.visible, true), depth, attribute, parentAttribute, orderByList, xmlLevel.nullParentValue, closure, RolapLevel.HideMemberCondition.valueOf(xmlLevel.hideMemberIf), this.createLarder(Util.makeFqName(hierarchy, levelName) + ".level", xmlLevel.getAnnotations(), xmlLevel.name, xmlLevel.caption, xmlLevel.description).build(), this.resourceMap);
        this.validator.putXml(level, xmlLevel);
        return level;
    }

    private RolapClosure createClosure(RolapCube cube, RolapSchema.PhysRelation relation, MondrianDef.Level xmlLevel, RolapHierarchy hierarchy) {
        RolapSchema.PhysRealColumn distanceExpr;
        MondrianDef.Closure xmlClosure = xmlLevel.getClosure();
        if (xmlClosure == null) {
            return null;
        }
        RolapDimension dimension = hierarchy.getDimension();
        Map<String, RolapAttribute> attributeMap = dimension.attributeMap;
        MondrianDef.Attribute xmlParentAttribute = (MondrianDef.Attribute)this.validator.map.get(attributeMap.get(xmlLevel.parentAttribute));
        MondrianDef.Attribute xmlAttribute = (MondrianDef.Attribute)this.validator.map.get(attributeMap.get(xmlLevel.attribute));
        final RolapDimension closureDim = new RolapDimension(this.schema, dimension.getName() + "$" + xmlParentAttribute.name + "$Parent", false, dimension.getDimensionType(), false, dimension.getLarder());
        closureDim.key = new Lazy<RolapSchema.PhysKey>(new Util.Function0<RolapSchema.PhysKey>(){

            @Override
            public RolapSchema.PhysKey apply() {
                return RolapSchemaLoader.this.lookupKey(null, true, closureDim.keyAttribute);
            }
        });
        MondrianDef.Dimension xmlClosureDimension = new MondrianDef.Dimension();
        xmlClosureDimension.caption = dimension.getCaption();
        xmlClosureDimension.key = "Item";
        xmlClosureDimension.name = dimension.getName() + "$" + xmlParentAttribute.name + "$Parent";
        xmlClosureDimension.type = null;
        xmlClosureDimension.visible = false;
        xmlClosureDimension.hanger = false;
        this.validator.putXml(dimension, xmlClosureDimension);
        RolapSchema.PhysRelation closureRelation = this.last(relation, xmlClosure.table, xmlClosure, "table");
        MondrianDef.Attribute xmlClosureAttribute1 = new MondrianDef.Attribute();
        xmlClosureAttribute1.name = "Closure";
        xmlClosureAttribute1.approxRowCount = xmlParentAttribute.approxRowCount;
        xmlClosureAttribute1.caption = xmlParentAttribute.caption;
        xmlClosureAttribute1.nameColumn = xmlParentAttribute.nameColumn;
        xmlClosureAttribute1.captionColumn = xmlParentAttribute.captionColumn;
        xmlClosureAttribute1.orderByColumn = xmlParentAttribute.orderByColumn;
        xmlClosureAttribute1.hasHierarchy = false;
        xmlClosureAttribute1.visible = false;
        xmlClosureAttribute1.levelType = xmlParentAttribute.levelType;
        xmlClosureAttribute1.table = xmlClosure.table;
        xmlClosureAttribute1.keyColumn = xmlClosure.parentColumn;
        xmlClosureAttribute1.children.add(xmlParentAttribute.getName_());
        xmlClosureAttribute1.children.add(xmlParentAttribute.getCaption());
        xmlClosureAttribute1.children.add(xmlParentAttribute.getOrderBy());
        xmlClosureAttribute1.children.add(xmlParentAttribute.getMemberFormatter());
        MondrianDef.Attribute xmlClosureAttribute2 = new MondrianDef.Attribute();
        xmlClosureAttribute2.name = "Item";
        xmlClosureAttribute2.approxRowCount = xmlAttribute.approxRowCount;
        xmlClosureAttribute2.caption = xmlAttribute.caption;
        xmlClosureAttribute2.nameColumn = null;
        xmlClosureAttribute2.captionColumn = null;
        xmlClosureAttribute2.orderByColumn = null;
        xmlClosureAttribute2.hasHierarchy = false;
        xmlClosureAttribute2.visible = false;
        xmlClosureAttribute2.levelType = xmlAttribute.levelType;
        xmlClosureAttribute2.table = xmlClosure.table;
        xmlClosureAttribute2.keyColumn = xmlClosure.childColumn;
        xmlClosureAttribute2.children.add(MondrianDef.Name.of(xmlAttribute.nameColumn, xmlAttribute.table, xmlAttribute.getName_()));
        xmlClosureAttribute2.children.add(MondrianDef.Caption.of(xmlAttribute.captionColumn, xmlAttribute.table, xmlAttribute.getCaption()));
        xmlClosureAttribute2.children.add(MondrianDef.OrderBy.of(xmlAttribute.orderByColumn, xmlAttribute.table, xmlAttribute.getOrderBy()));
        xmlClosureAttribute2.children.add(xmlAttribute.getMemberFormatter());
        this.copyAnnotations(xmlParentAttribute.getAnnotations(), xmlClosureAttribute1.children);
        this.copyAnnotations(xmlAttribute.getAnnotations(), xmlClosureAttribute2.children);
        xmlClosureAttribute1.children.addAll((Iterable<MondrianDef.AttributeElement>)xmlParentAttribute.getProperties());
        xmlClosureAttribute2.children.addAll((Iterable<MondrianDef.AttributeElement>)xmlAttribute.getProperties());
        RolapAttribute closureAttribute1 = this.createAttribute(xmlClosureAttribute1, closureRelation, relation, closureDim);
        RolapAttribute closureAttribute2 = this.createAttribute(xmlClosureAttribute2, closureRelation, relation, closureDim);
        closureDim.attributeMap.put(closureAttribute1.getName(), closureAttribute1);
        closureDim.attributeMap.put(closureAttribute2.getName(), closureAttribute2);
        closureDim.keyAttribute = closureAttribute2;
        RolapHierarchy closureHierarchy = new RolapHierarchy(closureDim, closureDim.getName(), Util.makeFqName(closureDim, closureDim.getName()), closureDim.isVisible(), true, hierarchy, null, Larders.create(closureDim.getName(), closureDim.getCaption(), closureDim.getDescription()));
        closureDim.addHierarchy(closureHierarchy);
        this.deferAssignDefaultMember(cube, closureHierarchy, null, null);
        closureHierarchy.initHierarchy(this, null);
        MondrianDef.Level xmlClosureLevel1 = new MondrianDef.Level();
        xmlClosureLevel1.attribute = closureAttribute1.getName();
        xmlClosureLevel1.name = closureAttribute1.getName();
        xmlClosureLevel1.visible = false;
        xmlClosureLevel1.hideMemberIf = RolapLevel.HideMemberCondition.Never.name();
        RolapLevel closureLevel1 = this.createLevel(cube, closureHierarchy, relation, 1, xmlClosureLevel1);
        MondrianDef.Level xmlClosureLevel2 = new MondrianDef.Level();
        xmlClosureLevel2.attribute = closureAttribute2.getName();
        xmlClosureLevel2.parentAttribute = closureAttribute1.getName();
        xmlClosureLevel2.name = closureAttribute2.getName();
        xmlClosureLevel2.visible = false;
        xmlClosureLevel2.hideMemberIf = RolapLevel.HideMemberCondition.Never.name();
        RolapLevel closureLevel2 = this.createLevel(cube, closureHierarchy, relation, 2, xmlClosureLevel2);
        closureHierarchy.levelList.add((Object)closureLevel1);
        closureHierarchy.levelList.add((Object)closureLevel2);
        if (xmlClosure.distanceColumn == null) {
            distanceExpr = null;
            this.getHandler().warning("Distance column omitted in closure element. Mondrian will assume that the closure table contains only tuples of parent-childs who are direct descendants (same as distance = 1).", xmlClosure, "distanceColumn");
        } else {
            distanceExpr = new RolapSchema.PhysRealColumn(closureRelation, xmlClosure.distanceColumn, null, null, Integer.MIN_VALUE);
        }
        return new RolapClosure(closureLevel1, distanceExpr);
    }

    private void copyAnnotations(NamedList<MondrianDef.Annotation> annotations, MondrianDef.Children<MondrianDef.AttributeElement> children) {
        if (annotations.size() > 0) {
            try {
                MondrianDef.Annotations anns = new MondrianDef.Annotations();
                for (MondrianDef.Annotation ann : annotations) {
                    anns.addChild(ann);
                }
                children.add(anns);
            }
            catch (XOMException e) {
                throw new MondrianException(e);
            }
        }
    }

    private RolapSchema.PhysColumn createColumn(ElementDef xml, String attributeName, RolapSchema.PhysRelation relation, String columnName, MondrianDef.Columns xmlKey) {
        List<RolapSchema.PhysColumn> list = this.createColumnList(xml, attributeName, relation, columnName, xmlKey);
        if (list == null) {
            return null;
        }
        switch (list.size()) {
            case 0: {
                return null;
            }
            case 1: {
                return list.get(0);
            }
        }
        this.getHandler().error("Only one column allowed", (NodeDef)xmlKey, null);
        return list.get(0);
    }

    private List<RolapSchema.PhysColumn> createColumnList(ElementDef xml, String attributeName, RolapSchema.PhysRelation table, String columnName, MondrianDef.Columns xmlColumns) {
        if (columnName != null) {
            if (xmlColumns != null) {
                this.getHandler().error("must not specify both " + attributeName + " and " + xmlColumns.getName(), (NodeDef)xmlColumns, null);
            }
            if (table == null) {
                this.getHandler().error("table must be specified", (NodeDef)xml, attributeName);
                return Collections.emptyList();
            }
            RolapSchema.PhysColumn column = table.getColumn(columnName, false);
            if (column == null) {
                this.getHandler().error("Column '" + columnName + "' not found in relation '" + table.getAlias() + "'", (NodeDef)xml, attributeName);
                return null;
            }
            return Collections.singletonList(column);
        }
        ArrayList<RolapSchema.PhysColumn> list = new ArrayList<RolapSchema.PhysColumn>();
        if (xmlColumns != null) {
            for (MondrianDef.Column xmlColumn : xmlColumns.array) {
                RolapSchema.PhysColumn column = this.getPhysColumn(this.last(table, xmlColumn.table, xmlColumn, "table"), xmlColumn.name, xmlColumn, "name");
                if (column == null) {
                    return null;
                }
                list.add(column);
            }
        }
        return list;
    }

    RolapSchema.PhysColumn getPhysColumn(RolapSchema.PhysRelation relation, String columnName, ElementDef xmlColumn, String attributeName) {
        if (relation == null) {
            this.getHandler().error("Table required. No table is specified or inherited when resolving column '" + columnName + "'", (NodeDef)xmlColumn, attributeName);
            return null;
        }
        RolapSchema.PhysColumn column = relation.getColumn(columnName, false);
        if (column == null) {
            this.getHandler().error("Column '" + columnName + "' not found in relation '" + relation + "'", (NodeDef)xmlColumn, attributeName);
        }
        return column;
    }

    private RolapSchema.PhysRelation getPhysRelation(String tableName, NodeDef xml, String xmlAttr) {
        RolapSchema.PhysRelation relation;
        if (tableName == null) {
            this.getHandler().error("table must be specified", xml, xmlAttr);
        }
        if ((relation = this.physSchemaBuilder.getPhysRelation(tableName, false)) == null) {
            this.getHandler().error("table '" + tableName + "' not found", xml, xmlAttr);
        }
        return relation;
    }

    RolapSchema.PhysRelation last(RolapSchema.PhysRelation s0, String tableName, NodeDef xmlTable, String xmlAttribute) {
        if (tableName != null) {
            return this.getPhysRelation(tableName, xmlTable, xmlAttribute);
        }
        return s0;
    }

    private void createProperties(PhysSchemaBuilder physSchemaBuilder, RolapDimension dimension, RolapAttribute attribute, RolapSchema.PhysRelation relation, MondrianDef.Attribute xmlAttribute, List<RolapProperty> propertyList) {
        for (MondrianDef.Property xmlProperty : xmlAttribute.getProperties()) {
            RolapProperty property = this.createProperty(dimension, attribute, xmlProperty);
            if (property == null) {
                return;
            }
            this.validator.putXml(property, xmlProperty);
            propertyList.add(property);
        }
    }

    private RolapProperty createProperty(RolapDimension dimension, RolapAttribute attribute, MondrianDef.Property xmlProperty) {
        RolapAttribute sourceAttribute = dimension.attributeMap.get(xmlProperty.attribute);
        if (sourceAttribute == null) {
            this.handler.error("Unknown attribute '" + xmlProperty.attribute + "'", (NodeDef)xmlProperty, "attribute");
            return null;
        }
        String name = Util.first(xmlProperty.name, xmlProperty.attribute);
        return new RolapProperty(name, attribute, sourceAttribute, RolapSchemaLoader.dialectToPropertyDatatype(sourceAttribute.getDatatype()), RolapSchemaLoader.makePropertyFormatter(xmlProperty), false, this.createLarder(Util.makeFqName(dimension, attribute.getName()) + ".property", xmlProperty.getAnnotations(), xmlProperty.name, xmlProperty.caption, xmlProperty.description).build());
    }

    private static Property.Datatype dialectToPropertyDatatype(Dialect.Datatype type) {
        Util.deprecated("obsolete Property.Datatype and this method", false);
        switch (type) {
            case Boolean: {
                return Property.Datatype.TYPE_BOOLEAN;
            }
            case Date: 
            case Time: 
            case Timestamp: {
                return Property.Datatype.TYPE_TIMESTAMP;
            }
            case Integer: 
            case Numeric: {
                return Property.Datatype.TYPE_NUMERIC;
            }
            case String: {
                return Property.Datatype.TYPE_STRING;
            }
        }
        throw Util.unexpected(type);
    }

    private static PropertyFormatter makePropertyFormatter(MondrianDef.Property xmlProperty) {
        Scripts.ScriptDefinition scriptDefinition;
        String propertyFormatterClassName;
        if (xmlProperty.getFormatter() != null) {
            propertyFormatterClassName = xmlProperty.getFormatter().className;
            scriptDefinition = RolapSchemaLoader.toScriptDef(xmlProperty.getFormatter().script);
        } else {
            propertyFormatterClassName = xmlProperty.formatter;
            scriptDefinition = null;
        }
        if (propertyFormatterClassName == null && scriptDefinition == null) {
            return null;
        }
        try {
            return RolapSchemaLoader.getFormatter(propertyFormatterClassName, PropertyFormatter.class, scriptDefinition);
        }
        catch (Exception e) {
            throw MondrianResource.instance().PropertyFormatterLoadFailed.ex(propertyFormatterClassName, xmlProperty.name, e);
        }
    }

    private static MemberFormatter makeMemberFormatter(MondrianDef.Attribute xmlAttribute) {
        MondrianDef.MemberFormatter xmlMemberFormatter = xmlAttribute.getMemberFormatter();
        if (xmlMemberFormatter == null) {
            return null;
        }
        String memberFormatterClassName = xmlMemberFormatter.className;
        Scripts.ScriptDefinition scriptDefinition = RolapSchemaLoader.toScriptDef(xmlMemberFormatter.script);
        if (memberFormatterClassName == null && scriptDefinition == null) {
            return null;
        }
        try {
            return RolapSchemaLoader.getFormatter(memberFormatterClassName, MemberFormatter.class, scriptDefinition);
        }
        catch (Exception e) {
            throw MondrianResource.instance().MemberFormatterLoadFailed.ex(memberFormatterClassName, xmlAttribute.name, e);
        }
    }

    private static CellFormatter makeCellFormatter(MondrianDef.Measure xmlMeasure, String measureUniqueName) {
        Scripts.ScriptDefinition scriptDefinition;
        String cellFormatterClassName;
        MondrianDef.CellFormatter xmlCellFormatter = xmlMeasure.getCellFormatter();
        if (xmlCellFormatter != null) {
            cellFormatterClassName = xmlCellFormatter.className;
            scriptDefinition = RolapSchemaLoader.toScriptDef(xmlCellFormatter.script);
        } else {
            cellFormatterClassName = xmlMeasure.formatter;
            scriptDefinition = null;
        }
        if (cellFormatterClassName == null && scriptDefinition == null) {
            return null;
        }
        try {
            return RolapSchemaLoader.getFormatter(cellFormatterClassName, CellFormatter.class, scriptDefinition);
        }
        catch (Exception e) {
            throw MondrianResource.instance().CellFormatterLoadFailed.ex(cellFormatterClassName, measureUniqueName, e);
        }
    }

    static RolapSchema createSchema(SchemaKey key, ByteString md5Bytes, String catalogUrl, String catalogStr, Util.PropertyList connectInfo, DataSource dataSource) {
        RolapSchemaLoader schemaLoader = new RolapSchemaLoader(null);
        RolapSchema x = schemaLoader.loadStage0(key, md5Bytes, catalogUrl, catalogStr, connectInfo, dataSource);
        schemaLoader.handler.check();
        return x;
    }

    private NamedSet createNamedSet(RolapCube cube, MondrianDef.NamedSet xmlNamedSet) {
        Exp exp;
        String formulaString = RolapSchemaLoader.formula(xmlNamedSet);
        try {
            exp = this.schema.getInternalConnection().parseExpression(formulaString);
        }
        catch (Exception e) {
            throw MondrianResource.instance().NamedSetHasBadFormula.ex(xmlNamedSet.name, e);
        }
        Formula formula = new Formula(new Id(new Id.NameSegment(xmlNamedSet.name, Id.Quoting.UNQUOTED)), exp);
        return formula.getNamedSet();
    }

    Pair<RolapSchema.RoleFactory, String> createRole(String role) {
        try {
            Parser xmlParser = XOMUtil.createDefaultParser();
            xmlParser.setKeepPositions(true);
            DOMWrapper def = xmlParser.parse(role);
            MondrianDef.Role xmlRole = new MondrianDef.Role(def);
            RolapSchema.RoleFactory roleFactory = this.createRole(xmlRole, this.schema.mapNameToRole);
            return Pair.of(roleFactory, xmlRole.name);
        }
        catch (XOMException e) {
            throw new RuntimeException("while creating role from [" + role + "]", e);
        }
    }

    RolapSchema.RoleFactory createRole(MondrianDef.Role xmlRole, Map<String, RolapSchema.RoleFactory> mapNameToRole) {
        int count = (xmlRole.getUnion() == null ? 0 : 1) + (xmlRole.getSchemaGrants().isEmpty() ? 0 : 1) + (xmlRole.className == null ? 0 : 1) + (xmlRole.getScript() == null ? 0 : 1);
        if (count != 1) {
            throw MondrianResource.instance().RoleUnionGrants.ex();
        }
        if (xmlRole.getUnion() != null) {
            return this.createUnionRole(mapNameToRole, xmlRole.getUnion());
        }
        if (xmlRole.getScript() != null) {
            return this.createScriptRole(xmlRole.getScript());
        }
        if (xmlRole.className != null) {
            return this.createClassRole(xmlRole.className);
        }
        return this.createGrantRole(xmlRole.getSchemaGrants());
    }

    private RolapSchema.RoleFactory createClassRole(String className) {
        try {
            Class clazz = ClassResolver.INSTANCE.forName(className, true);
            Object o = clazz.newInstance();
            if (o instanceof Role) {
                return new RolapSchema.ConstantRoleFactory((Role)o);
            }
            if (o instanceof RoleGenerator) {
                RolapSchema rolapSchema = this.schema;
                rolapSchema.getClass();
                return rolapSchema.new RolapSchema.GeneratingRoleFactory((RoleGenerator)o);
            }
            Util.discard((boolean)false);
            throw new RuntimeException("neither role nor role generator");
        }
        catch (ClassNotFoundException e) {
            Util.discard((boolean)false);
            throw new RuntimeException("while creating role", e);
        }
        catch (InstantiationException e) {
            Util.discard((boolean)false);
            throw new RuntimeException("while creating role", e);
        }
        catch (IllegalAccessException e) {
            Util.discard((boolean)false);
            throw new RuntimeException("while creating role", e);
        }
    }

    private RolapSchema.RoleFactory createScriptRole(MondrianDef.Script xmlScript) {
        Scripts.ScriptDefinition script = RolapSchemaLoader.toScriptDef(xmlScript);
        RoleGenerator roleGenerator = Scripts.roleGenerator(script);
        RolapSchema rolapSchema = this.schema;
        rolapSchema.getClass();
        return rolapSchema.new RolapSchema.GeneratingRoleFactory(roleGenerator);
    }

    private RolapSchema.RoleFactory createGrantRole(List<MondrianDef.SchemaGrant> xmlSchemaGrants) {
        RoleImpl role = new RoleImpl();
        for (MondrianDef.SchemaGrant schemaGrant : xmlSchemaGrants) {
            role.grant(this.schema, RolapSchemaLoader.getAccess(schemaGrant.access, schemaAllowed));
            for (MondrianDef.CubeGrant cubeGrant : schemaGrant.cubeGrants) {
                RolapCube cube = this.schema.lookupCube(cubeGrant.cube);
                if (cube == null) {
                    throw Util.newError("Unknown cube '" + cubeGrant.cube + "'");
                }
                role.grant(cube, RolapSchemaLoader.getAccess(cubeGrant.access, cubeAllowed));
                SchemaReader schemaReader = cube.getSchemaReader(null);
                for (MondrianDef.DimensionGrant dimensionGrant : cubeGrant.dimensionGrants) {
                    Dimension dimension = (Dimension)schemaReader.lookupCompound(cube, Util.parseIdentifier(dimensionGrant.dimension), true, 2);
                    role.grant(dimension, RolapSchemaLoader.getAccess(dimensionGrant.access, dimensionAllowed));
                }
                for (ElementDef elementDef : cubeGrant.hierarchyGrants) {
                    Role.RollupPolicy rollupPolicy;
                    Hierarchy hierarchy = (Hierarchy)schemaReader.lookupCompound(cube, Util.parseIdentifier(elementDef.hierarchy), true, 3);
                    Access hierarchyAccess = RolapSchemaLoader.getAccess(elementDef.access, hierarchyAllowed);
                    Level topLevel = null;
                    if (elementDef.topLevel != null) {
                        if (hierarchyAccess != Access.CUSTOM) {
                            throw Util.newError("You may only specify 'topLevel' if access='custom'");
                        }
                        topLevel = (Level)schemaReader.lookupCompound(cube, Util.parseIdentifier(elementDef.topLevel), true, 4);
                    }
                    Level bottomLevel = null;
                    if (elementDef.bottomLevel != null) {
                        if (hierarchyAccess != Access.CUSTOM) {
                            throw Util.newError("You may only specify 'bottomLevel' if access='custom'");
                        }
                        bottomLevel = (Level)schemaReader.lookupCompound(cube, Util.parseIdentifier(elementDef.bottomLevel), true, 4);
                    }
                    if (elementDef.rollupPolicy != null) {
                        try {
                            rollupPolicy = Role.RollupPolicy.valueOf(elementDef.rollupPolicy.toUpperCase());
                        }
                        catch (IllegalArgumentException e) {
                            throw Util.newError("Illegal rollupPolicy value '" + elementDef.rollupPolicy + "'");
                        }
                    } else {
                        rollupPolicy = Role.RollupPolicy.FULL;
                    }
                    role.grant(hierarchy, hierarchyAccess, topLevel, bottomLevel, rollupPolicy);
                    for (MondrianDef.MemberGrant memberGrant : elementDef.memberGrants) {
                        if (hierarchyAccess != Access.CUSTOM) {
                            throw Util.newError("You may only specify <MemberGrant> if <Hierarchy> has access='custom'");
                        }
                        boolean ignoreInvalidMembers = MondrianProperties.instance().IgnoreInvalidMembers.get();
                        Member member = schemaReader.withLocus().getMemberByUniqueName(Util.parseIdentifier(memberGrant.member), !ignoreInvalidMembers);
                        if (member == null) {
                            assert (ignoreInvalidMembers);
                            continue;
                        }
                        if (member.getHierarchy() != hierarchy) {
                            throw Util.newError("Member '" + member + "' is not in hierarchy '" + hierarchy + "'");
                        }
                        role.grant(member, RolapSchemaLoader.getAccess(memberGrant.access, memberAllowed));
                    }
                }
            }
        }
        role.makeImmutable();
        return new RolapSchema.ConstantRoleFactory(role);
    }

    private RolapSchema.RoleFactory createUnionRole(Map<String, RolapSchema.RoleFactory> mapNameToRole, MondrianDef.Union xmlUnion) {
        ArrayList<RolapSchema.RoleFactory> roleList = new ArrayList<RolapSchema.RoleFactory>();
        for (MondrianDef.RoleUsage roleUsage : xmlUnion.list()) {
            RolapSchema.RoleFactory role = mapNameToRole.get(roleUsage.roleName);
            if (role == DUMMY_ROLE) {
                return DUMMY_ROLE;
            }
            if (role == null) {
                throw MondrianResource.instance().UnknownRole.ex(roleUsage.roleName);
            }
            roleList.add(role);
        }
        return new RolapSchema.UnionRoleFactory(roleList);
    }

    private static Access getAccess(String accessString, Set<Access> allowed) {
        Access access = Access.valueOf(accessString.toUpperCase());
        if (allowed.contains((Object)access)) {
            return access;
        }
        throw Util.newError("Bad value access='" + accessString + "'");
    }

    static int loadApproxRowCount(String approxRowCount) {
        boolean notNullAndNumeric;
        boolean bl = notNullAndNumeric = approxRowCount != null && approxRowCount.matches("^\\d+$");
        if (notNullAndNumeric) {
            return Integer.parseInt(approxRowCount);
        }
        return Integer.MIN_VALUE;
    }

    public static Map<String, String> buildHintMap(List<MondrianDef.Hint> hints) {
        if (hints == null || hints.isEmpty()) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hintMap = new HashMap<String, String>();
        for (MondrianDef.Hint hint : hints) {
            hintMap.put(hint.type, hint.cdata);
        }
        return hintMap;
    }

    public Cube createCube(String xml) {
        RolapCube cube;
        try {
            Parser xmlParser = XOMUtil.createDefaultParser();
            xmlParser.setKeepPositions(true);
            DOMWrapper def = xmlParser.parse(xml);
            String tagName = def.getTagName();
            if (!tagName.equals("Cube")) {
                throw new XOMException("Got <" + tagName + "> when expecting <Cube>");
            }
            MondrianDef.Schema xmlSchema = new MondrianDef.Schema();
            MondrianDef.Cube xmlCube = new MondrianDef.Cube(def);
            cube = new RolapCube(this, xmlCube.name, RolapSchemaLoader.toBoolean(xmlCube.visible, true), this.createLarder(Util.quoteMdxIdentifier(xmlCube.name) + ".cube", xmlCube.getAnnotations(), xmlCube.name, xmlCube.caption, xmlCube.description).build(), xmlSchema.measuresCaption);
            this.validator.putXml(cube, xmlCube);
        }
        catch (XOMException e) {
            throw Util.newError(e, "Error while creating cube from XML [" + xml + "]");
        }
        return cube;
    }

    void createCalcMembersAndNamedSets(List<MondrianDef.CalculatedMember> xmlCalcMembers, List<MondrianDef.NamedSet> xmlNamedSets, List<RolapMember> memberList, List<Formula> calculatedMemberList, List<Formula> namedSetList, RolapCube cube, boolean errOnDups) {
        int i;
        Query queryExp = this.resolveCalcMembers(xmlCalcMembers, xmlNamedSets, cube, errOnDups);
        if (queryExp == null) {
            return;
        }
        Util.assertTrue(queryExp.getFormulas().length == xmlCalcMembers.size() + xmlNamedSets.size());
        for (i = 0; i < xmlCalcMembers.size(); ++i) {
            this.postCalcMember(cube, xmlCalcMembers, calculatedMemberList, i, queryExp, memberList);
        }
        for (i = 0; i < xmlNamedSets.size(); ++i) {
            this.postNamedSet(cube, xmlNamedSets, xmlCalcMembers.size(), i, queryExp, namedSetList);
        }
    }

    private Query resolveCalcMembers(List<MondrianDef.CalculatedMember> xmlCalcMembers, List<MondrianDef.NamedSet> xmlNamedSets, RolapCube cube, boolean errOnDups) {
        if (xmlCalcMembers.size() == 0 && xmlNamedSets.size() == 0) {
            return null;
        }
        List<Formula> calculatedMemberList = cube.calculatedMemberList;
        StringBuilder buf = new StringBuilder(256);
        buf.append("WITH").append(Util.nl);
        LinkedHashSet<String> fqNames = new LinkedHashSet<String>();
        for (int i = 0; i < xmlCalcMembers.size(); ++i) {
            this.preCalcMember(xmlCalcMembers, calculatedMemberList, i, buf, cube, errOnDups, fqNames);
        }
        HashSet<String> nameSet = new HashSet<String>();
        for (Formula namedSet : cube.namedSetList) {
            nameSet.add(namedSet.getName());
        }
        for (MondrianDef.NamedSet xmlNamedSet : xmlNamedSets) {
            this.preNamedSet(xmlNamedSet, cube, nameSet, buf);
        }
        buf.append("SELECT FROM ").append(cube.getUniqueName());
        final String queryString = buf.toString();
        try {
            final RolapConnection conn = this.schema.getInternalConnection();
            return Locus.execute(conn, "Validate calculated members in cube", new Locus.Action<Query>(){

                @Override
                public Query execute() {
                    Query queryExp = conn.parseQuery(queryString);
                    queryExp.resolve();
                    return queryExp;
                }
            });
        }
        catch (Exception e) {
            throw MondrianResource.instance().UnknownNamedSetHasBadFormula.ex(cube.getName(), e);
        }
    }

    private void postNamedSet(RolapCube cube, List<MondrianDef.NamedSet> xmlNamedSets, int offset, int i, Query queryExp, List<Formula> formulaList) {
        MondrianDef.NamedSet xmlNamedSet = xmlNamedSets.get(i);
        Util.discard((Object)xmlNamedSet);
        Formula formula = queryExp.getFormulas()[offset + i];
        SetBase namedSet = (SetBase)formula.getNamedSet();
        namedSet.setLarder(this.createLarder(cube + "." + namedSet.getUniqueName() + ".set", xmlNamedSet.getAnnotations(), xmlNamedSet.name, this.emptyNull(xmlNamedSet.caption), this.emptyNull(xmlNamedSet.description)).build());
        formulaList.add(formula);
    }

    private String emptyNull(String s) {
        if ("".equals(s)) {
            return null;
        }
        return s;
    }

    private void preNamedSet(MondrianDef.NamedSet xmlNamedSet, RolapCube cube, Set<String> nameSet, StringBuilder buf) {
        if (!nameSet.add(xmlNamedSet.name)) {
            throw MondrianResource.instance().NamedSetNotUnique.ex(xmlNamedSet.name, cube.getName());
        }
        buf.append("SET ").append(Util.makeFqName(xmlNamedSet.name)).append(Util.nl).append(" AS ");
        String result = RolapSchemaLoader.formula(xmlNamedSet);
        Util.singleQuoteString(result, buf);
        buf.append(Util.nl);
    }

    private static String formula(MondrianDef.NamedSet xmlNamedSet) {
        MondrianDef.Formula formula = xmlNamedSet.getFormula();
        if (formula != null) {
            return formula.cdata;
        }
        return xmlNamedSet.formula;
    }

    private void postCalcMember(RolapCube cube, List<MondrianDef.CalculatedMember> xmlCalcMembers, List<Formula> calculatedMemberList, int i, Query queryExp, List<RolapMember> memberList) {
        MondrianDef.CalculatedMember xmlCalcMember = xmlCalcMembers.get(i);
        Formula formula = queryExp.getFormulas()[i];
        calculatedMemberList.add(formula);
        RolapMember member = (RolapMember)formula.getMdxMember();
        ((RolapCalculatedMember)member).setLarder(Larders.LarderBuilder.of(member.getLarder()).addAll(xmlCalcMember.getAnnotations()).caption(this.second(xmlCalcMember.name, xmlCalcMember.caption)).description(this.emptyNull(xmlCalcMember.description)).addAll(this.resourceMap.get(cube + "." + member + ".member")).add(Property.VISIBLE, (Object)RolapSchemaLoader.toBoolean(xmlCalcMember.visible, true)).build());
        memberList.add(member);
    }

    private String second(String s1, String s2) {
        if (s2 == null || s2.equals("") || s2.equals(s1)) {
            return null;
        }
        return s2;
    }

    private void preCalcMember(List<MondrianDef.CalculatedMember> xmlCalcMembers, List<Formula> calculatedMemberList, int j, StringBuilder buf, RolapCube cube, boolean errOnDup, Set<String> fqNames) {
        MondrianDef.CalculatedMember xmlCalcMember = xmlCalcMembers.get(j);
        Hierarchy hierarchy = null;
        String dimName = null;
        if (xmlCalcMember.hierarchy != null && xmlCalcMember.dimension != null) {
            throw MondrianResource.instance().CalcMemberHasBothDimensionAndHierarchy.ex(xmlCalcMember.name, cube.getName());
        }
        if (xmlCalcMember.dimension != null) {
            dimName = xmlCalcMember.dimension;
            Dimension dimension = (Dimension)cube.getSchemaReader().withLocus().lookupCompound(cube, Util.parseIdentifier(dimName), false, 2);
            if (dimension == null) {
                dimension = cube.lookupDimension(new Id.NameSegment(xmlCalcMember.dimension, Id.Quoting.UNQUOTED));
            }
            if (dimension != null) {
                hierarchy = dimension.getHierarchy();
            }
        } else if (xmlCalcMember.hierarchy != null) {
            dimName = xmlCalcMember.hierarchy;
            hierarchy = (Hierarchy)cube.getSchemaReader().withLocus().lookupCompound(cube, Util.parseIdentifier(dimName), false, 3);
        }
        if (hierarchy == null) {
            throw MondrianResource.instance().CalcMemberHasBadDimension.ex(dimName, xmlCalcMember.name, cube.getName());
        }
        String parentFqName = xmlCalcMember.parent != null ? xmlCalcMember.parent : hierarchy.getUniqueNameSsas();
        if (!hierarchy.getDimension().isMeasures()) {
            OlapElement parent = new NameResolver().resolve(cube, Util.toOlap4j(Util.parseIdentifier(parentFqName)), false, 0, MatchType.EXACT, cube.getSchemaReader().getNamespaces());
            if (parent == null) {
                throw MondrianResource.instance().CalcMemberHasUnknownParent.ex(parentFqName, xmlCalcMember.name, cube.getName());
            }
            if (parent.getHierarchy() != hierarchy) {
                throw MondrianResource.instance().CalcMemberHasDifferentParentAndHierarchy.ex(xmlCalcMember.name, cube.getName(), hierarchy.getUniqueName());
            }
        }
        String fqName = Util.makeFqName(parentFqName, xmlCalcMember.name);
        for (int i = 0; i < calculatedMemberList.size(); ++i) {
            Formula formula = calculatedMemberList.get(i);
            if (!formula.getName().equals(xmlCalcMember.name) || !formula.getMdxMember().getHierarchy().equals(hierarchy)) continue;
            if (errOnDup) {
                throw MondrianResource.instance().CalcMemberNotUnique.ex(fqName, cube.getName());
            }
            calculatedMemberList.remove(i);
            --i;
        }
        if (!fqNames.add(fqName)) {
            throw MondrianResource.instance().CalcMemberNotUnique.ex(fqName, cube.getName());
        }
        NamedList<MondrianDef.CalculatedMemberProperty> xmlProperties = xmlCalcMember.getCalculatedMemberProperties();
        ArrayList<String> propNames = new ArrayList<String>();
        ArrayList<String> propExprs = new ArrayList<String>();
        this.validateMemberProps(cube, (List<MondrianDef.CalculatedMemberProperty>)xmlProperties, (List<String>)propNames, (List<String>)propExprs, xmlCalcMember.name);
        int measureCount = cube.getMeasures().size();
        String result = this.getFormula(xmlCalcMember, fqName);
        if (result == null) {
            result = "1";
        }
        assert (fqName.startsWith("["));
        buf.append("MEMBER ").append(fqName).append(Util.nl).append("  AS ");
        Util.singleQuoteString(result, buf);
        MondrianDef.CellFormatter xmlCellFormatter = xmlCalcMember.getCellFormatter();
        if (xmlCellFormatter != null) {
            if (xmlCellFormatter.className != null) {
                propNames.add(Property.CELL_FORMATTER.name);
                propExprs.add(Util.quoteForMdx(xmlCellFormatter.className));
            }
            if (xmlCellFormatter.script != null) {
                if (xmlCellFormatter.script.language != null) {
                    propNames.add(Property.CELL_FORMATTER_SCRIPT_LANGUAGE.name);
                    propExprs.add(Util.quoteForMdx(xmlCellFormatter.script.language));
                }
                propNames.add(Property.CELL_FORMATTER_SCRIPT.name);
                propExprs.add(Util.quoteForMdx(xmlCellFormatter.script.cdata));
            }
        }
        assert (propNames.size() == propExprs.size());
        this.processFormatStringAttribute(xmlCalcMember, buf);
        for (int i = 0; i < propNames.size(); ++i) {
            String name = (String)propNames.get(i);
            String expr = (String)propExprs.get(i);
            buf.append(",").append(Util.nl);
            expr = this.removeSurroundingQuotesIfNumericProperty(name, expr);
            buf.append(name).append(" = ").append(expr);
        }
        buf.append(",").append(Util.nl);
        Util.quoteMdxIdentifier(Property.MEMBER_SCOPE.name, buf);
        buf.append(" = 'CUBE'");
        if (!propNames.contains(Property.MEMBER_ORDINAL.getName())) {
            buf.append(",").append(Util.nl).append(Property.MEMBER_ORDINAL).append(" = ").append(measureCount + j);
        }
        buf.append(Util.nl);
    }

    private String getFormula(MondrianDef.CalculatedMember xmlCalcMember, String fqName) {
        String result1 = xmlCalcMember.getFormula() != null ? xmlCalcMember.getFormula().cdata : null;
        String result2 = xmlCalcMember.formula;
        if (result1 != null && result2 != null) {
            this.handler.error("Must not specify both 'formula' attribute and 'Formula' child element; ignoring member '" + fqName + "'", (NodeDef)xmlCalcMember, "formula");
            return null;
        }
        if (result1 == null && result2 == null) {
            this.handler.error("Must specify either 'formula' attribute or 'Formula' child element; ignoring member '" + fqName + "'", (NodeDef)xmlCalcMember, "formula");
            return null;
        }
        return Util.first(result1, result2);
    }

    private String removeSurroundingQuotesIfNumericProperty(String name, String expr) {
        Property prop = Property.lookup(name, false);
        if (prop != null && prop.getType() == Property.Datatype.TYPE_NUMERIC && this.isSurroundedWithQuotes(expr) && expr.length() > 2) {
            return expr.substring(1, expr.length() - 1);
        }
        return expr;
    }

    private boolean isSurroundedWithQuotes(String expr) {
        return expr.startsWith("\"") && expr.endsWith("\"");
    }

    void processFormatStringAttribute(MondrianDef.CalculatedMember xmlCalcMember, StringBuilder buf) {
        if (xmlCalcMember.formatString != null) {
            buf.append(",").append(Util.nl).append(Property.FORMAT_STRING.name).append(" = ").append(Util.quoteForMdx(xmlCalcMember.formatString));
        }
    }

    private void validateMemberProps(RolapCube cube, List<MondrianDef.CalculatedMemberProperty> xmlProperties, List<String> propNames, List<String> propExprs, String memberName) {
        if (xmlProperties == null) {
            return;
        }
        for (MondrianDef.CalculatedMemberProperty xmlProperty : xmlProperties) {
            if (xmlProperty.expression == null && xmlProperty.value == null) {
                throw MondrianResource.instance().NeitherExprNorValueForCalcMemberProperty.ex(xmlProperty.name, memberName, cube.getName());
            }
            if (xmlProperty.expression != null && xmlProperty.value != null) {
                throw MondrianResource.instance().ExprAndValueForMemberProperty.ex(xmlProperty.name, memberName, cube.getName());
            }
            propNames.add(xmlProperty.name);
            if (xmlProperty.expression != null) {
                propExprs.add(xmlProperty.expression);
                continue;
            }
            propExprs.add(Util.quoteForMdx(xmlProperty.value));
        }
    }

    static <T> T getFormatter(String className, Class<T> iface, Scripts.ScriptDefinition script) throws Exception {
        if (className == null && script == null) {
            throw Util.newError("Must specify either className attribute or Script element");
        }
        if (className != null && script != null) {
            throw Util.newError("Must not specify both className attribute and Script element");
        }
        if (className != null) {
            return ClassResolver.INSTANCE.instantiateSafe(className, new Object[0]);
        }
        if (iface == CellFormatter.class) {
            return iface.cast(Scripts.cellFormatter(script));
        }
        if (iface == MemberFormatter.class) {
            return iface.cast(Scripts.memberFormatter(script));
        }
        if (iface == PropertyFormatter.class) {
            return iface.cast(Scripts.propertyFormatter(script));
        }
        throw new RuntimeException("Unknown class " + iface);
    }

    public Member createCalculatedMember(RolapCube cube, String xml) {
        MondrianDef.CalculatedMember xmlCalcMember;
        try {
            Parser xmlParser = XOMUtil.createDefaultParser();
            DOMWrapper def = xmlParser.parse(xml);
            String tagName = def.getTagName();
            if (!tagName.equals("CalculatedMember")) {
                throw new XOMException("Got <" + tagName + "> when expecting <CalculatedMember>");
            }
            xmlCalcMember = new MondrianDef.CalculatedMember(def);
        }
        catch (XOMException e) {
            throw Util.newError(e, "Error while creating calculated member from XML [" + xml + "]");
        }
        ArrayList<RolapMember> memberList = new ArrayList<RolapMember>();
        this.createCalcMembersAndNamedSets(Collections.singletonList(xmlCalcMember), Collections.<MondrianDef.NamedSet>emptyList(), memberList, cube.calculatedMemberList, cube.namedSetList, cube, true);
        assert (memberList.size() == 1);
        return (Member)memberList.get(0);
    }

    static String getTableName(RolapLevel level) {
        HashSet<String> tableNames = new HashSet<String>();
        for (RolapSchema.PhysColumn expr : level.getAttribute().getKeyList()) {
            if (!(expr instanceof RolapSchema.PhysRealColumn)) continue;
            RolapSchema.PhysRealColumn mc = (RolapSchema.PhysRealColumn)expr;
            tableNames.add(mc.relation.getAlias());
        }
        return tableNames.size() == 1 ? (String)tableNames.iterator().next() : null;
    }

    private static SqlStatement.Type toInternalType(String internalTypeName) {
        SqlStatement.Type type = VALUES.get(internalTypeName);
        if (type == null && internalTypeName != null) {
            throw Util.newError("Invalid value '" + internalTypeName + "' for attribute 'internalType' of element 'Level'. " + "Valid values are: " + VALUES.keySet());
        }
        return type;
    }

    static String getText(MondrianDef.SQL sql) {
        StringBuilder buf = new StringBuilder();
        for (NodeDef child : sql.children) {
            if (!(child instanceof TextDef)) continue;
            TextDef textDef = (TextDef)child;
            buf.append(textDef.s);
        }
        return buf.toString();
    }

    static MemberReader createMemberReader(final RolapCubeHierarchy hierarchy, Role role) {
        Access access = role.getAccess(hierarchy);
        switch (access) {
            case NONE: {
                role.getAccess(hierarchy);
                throw Util.newInternal("Illegal access to members of hierarchy " + hierarchy);
            }
            case ALL: {
                return hierarchy.isRagged() ? new RestrictedMemberReader(hierarchy.getMemberReader(), role) : hierarchy.getMemberReader();
            }
            case CUSTOM: {
                final Role.HierarchyAccess hierarchyAccess = role.getAccessDetails(hierarchy);
                Role.RollupPolicy rollupPolicy = hierarchyAccess.getRollupPolicy();
                final NumericType returnType = new NumericType();
                switch (rollupPolicy) {
                    case FULL: {
                        return new RestrictedMemberReader(hierarchy.getMemberReader(), role);
                    }
                    case PARTIAL: {
                        MemberType memberType1 = new MemberType(hierarchy.getDimension(), hierarchy, null, null);
                        SetType setType = new SetType(memberType1);
                        AbstractListCalc listCalc = new AbstractListCalc(new DummyExp(setType), new Calc[0]){

                            public TupleList evaluateList(Evaluator evaluator) {
                                return new UnaryTupleList(hierarchy.getLowestMembersForAccess(evaluator, hierarchyAccess, null));
                            }

                            public boolean dependsOn(Hierarchy hierarchy2) {
                                return true;
                            }
                        };
                        final RolapHierarchy.LimitedRollupAggregateCalc partialCalc = new RolapHierarchy.LimitedRollupAggregateCalc(returnType, listCalc);
                        ResolvedFunCall partialExp = new ResolvedFunCall(new FunDefBase("$x", "x", "In"){

                            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                                return partialCalc;
                            }

                            public void unparse(Exp[] args, PrintWriter pw) {
                                pw.print("$RollupAccessibleChildren()");
                            }
                        }, new Exp[0], returnType);
                        return new RolapHierarchy.LimitedRollupSubstitutingMemberReader(hierarchy.getMemberReader(), role, hierarchyAccess, partialExp);
                    }
                    case HIDDEN: {
                        ResolvedFunCall hiddenExp = new ResolvedFunCall(new FunDefBase("$x", "x", "In"){

                            public Calc compileCall(ResolvedFunCall call, ExpCompiler compiler) {
                                return new ConstantCalc(returnType, null);
                            }

                            public void unparse(Exp[] args, PrintWriter pw) {
                                pw.print("$RollupAccessibleChildren()");
                            }
                        }, new Exp[0], returnType);
                        return new RolapHierarchy.LimitedRollupSubstitutingMemberReader(hierarchy.getMemberReader(), role, hierarchyAccess, hiddenExp);
                    }
                }
                throw Util.unexpected(rollupPolicy);
            }
        }
        throw Util.badValue(access);
    }

    static {
        for (Dialect.Datatype datatype : Dialect.Datatype.values()) {
            DATATYPE_MAP.put(datatype.name(), datatype);
        }
        PROTOCOL_PATTERN = Pattern.compile("[a-z]+:");
        DUMMY = new Object();
        VALUES = UnmodifiableArrayMap.of((Object)"int", (Object)((Object)SqlStatement.Type.INT), (Object[])new Object[]{"double", SqlStatement.Type.DOUBLE, "Object", SqlStatement.Type.OBJECT, "String", SqlStatement.Type.STRING, "long", SqlStatement.Type.LONG});
    }

    private class NamedAssignDefaultMember
    extends AssignDefaultMember {
        private final List<Id.Segment> uniqueNameParts;
        protected final String defaultMemberName;

        public NamedAssignDefaultMember(RolapCube cube, RolapHierarchy hierarchy, ElementDef xml, String defaultMemberName) {
            super(cube, hierarchy, xml);
            this.defaultMemberName = defaultMemberName;
            this.uniqueNameParts = defaultMemberName.contains("[") ? Util.parseIdentifier(defaultMemberName) : Collections.singletonList(new Id.NameSegment(defaultMemberName, Id.Quoting.UNQUOTED));
        }

        public AssignDefaultMember apply() {
            for (RolapCubeHierarchy cubeHierarchy : this.cubeHierarchies()) {
                this.setDefaultMember(cubeHierarchy, cubeHierarchy.getAllMember());
            }
            int failureCount = 0;
            for (RolapCubeHierarchy cubeHierarchy : this.cubeHierarchies()) {
                RolapMember member = this.lookup(this.cube.getSchemaReader(), cubeHierarchy);
                if (member != null) {
                    this.setDefaultMember(cubeHierarchy, member);
                    continue;
                }
                ++failureCount;
            }
            return failureCount > 0 ? this : null;
        }

        public void apply2() {
            int failureCount = 0;
            for (RolapCubeHierarchy cubeHierarchy : this.cubeHierarchies()) {
                RolapMember member = this.lookup(this.cube.getSchemaReader(), cubeHierarchy);
                if (member != null) {
                    this.setDefaultMember(cubeHierarchy, member);
                    continue;
                }
                ++failureCount;
            }
            if (failureCount > 0) {
                this.fail();
            }
        }

        protected void fail() {
            RolapSchemaLoader.this.handler.error("Can not find Default Member with name \"" + this.defaultMemberName + "\"", (NodeDef)this.xml, null);
        }

        protected RolapMember lookup(SchemaReader schemaReader, RolapCubeHierarchy cubeHierarchy) {
            RolapMember member = (RolapMember)new NameResolver().resolve(cubeHierarchy, Util.toOlap4j(this.uniqueNameParts), false, 6, MatchType.EXACT, this.cube.getSchemaReader().getNamespaces());
            if (member != null) {
                return member;
            }
            return (RolapMember)new NameResolver().resolve(new RolapHierarchy.DummyElement(cubeHierarchy), Util.toOlap4j(this.uniqueNameParts), false, 6, MatchType.EXACT, this.cube.getSchemaReader().getNamespaces());
        }
    }

    private class NamelessAssignDefaultMember
    extends AssignDefaultMember {
        public NamelessAssignDefaultMember(RolapCube cube, RolapHierarchy hierarchy, ElementDef xml) {
            super(cube, hierarchy, xml);
        }

        public AssignDefaultMember apply() {
            for (RolapCubeHierarchy cubeHierarchy : this.cubeHierarchies()) {
                this.setDefaultMember(cubeHierarchy, cubeHierarchy.getAllMember());
            }
            if (this.hierarchy.hasAll()) {
                return null;
            }
            int failedCount = 0;
            for (RolapCubeHierarchy cubeHierarchy : this.cubeHierarchies()) {
                RolapMember member = this.firstMember(cubeHierarchy);
                if (member != null) {
                    this.setDefaultMember(cubeHierarchy, member);
                    continue;
                }
                ++failedCount;
            }
            return failedCount > 0 ? this : null;
        }

        protected RolapMember firstMember(RolapCubeHierarchy cubeHierarchy) {
            SchemaReader schemaReader = this.cube.getSchemaReader();
            return this.deriveDefaultMember(cubeHierarchy, schemaReader);
        }

        RolapMember deriveDefaultMember(RolapCubeHierarchy hierarchy, SchemaReader schemaReader) {
            List<RolapMember> rootMembers = hierarchy.getMemberReader().getRootMembers();
            List calcMemberList = Util.cast(schemaReader.getCalculatedMembers(hierarchy.getLevelList().get(0)));
            for (RolapMember rootMember : UnionIterator.over(new Collection[]{rootMembers, calcMemberList})) {
                if (rootMember.isHidden()) continue;
                return rootMember;
            }
            return null;
        }

        void apply2() {
            assert (!this.hierarchy.hasAll());
            int failedCount = 0;
            for (RolapCubeHierarchy cubeHierarchy : this.cubeHierarchies()) {
                RolapMember member = this.firstMember(cubeHierarchy);
                if (member != null) {
                    this.setDefaultMember(cubeHierarchy, member);
                    continue;
                }
                ++failedCount;
            }
            if (failedCount > 0) {
                this.fail();
            }
        }

        protected void fail() {
            RolapSchemaLoader.this.getHandler().error(MondrianResource.instance().InvalidHierarchyCondition.ex(this.hierarchy.getUniqueName()), (NodeDef)this.xml, null);
        }
    }

    private class NamedMeasureAssignDefaultMember
    extends NamedAssignDefaultMember {
        public NamedMeasureAssignDefaultMember(RolapCube cube, RolapHierarchy hierarchy, MondrianDef.Cube xml) {
            super(cube, hierarchy, xml, xml.defaultMeasure);
        }

        protected RolapMember lookup(SchemaReader schemaReader, RolapCubeHierarchy cubeHierarchy) {
            return RolapSchemaLoader.findMeasure(RolapSchemaLoader.this.measureList, this.defaultMemberName);
        }

        protected void fail() {
            MondrianDef.Cube xmlCube = (MondrianDef.Cube)this.xml;
            RolapSchemaLoader.this.handler.error("Default measure '" + xmlCube.defaultMeasure + "' not found", (NodeDef)xmlCube, "defaultMeasure");
        }
    }

    private class MeasureAssignDefaultMember
    extends NamelessAssignDefaultMember {
        public MeasureAssignDefaultMember(RolapCube cube, RolapHierarchy hierarchy, MondrianDef.Cube xml) {
            super(cube, hierarchy, xml);
        }

        protected RolapMember firstMember(RolapCubeHierarchy cubeHierarchy) {
            for (RolapMember measure : RolapSchemaLoader.this.measureList) {
                if (RolapSchemaLoader.this.containsByIdentity(RolapSchemaLoader.this.aggFactCountMeasureList, measure)) continue;
                return measure;
            }
            return null;
        }

        protected void fail() {
            MondrianDef.Cube xmlCube = (MondrianDef.Cube)this.xml;
            RolapSchemaLoader.this.getHandler().error("Cube '" + xmlCube.name + "' must have at least one measure", (NodeDef)xmlCube, null);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private abstract class AssignDefaultMember {
        final RolapCube cube;
        final RolapHierarchy hierarchy;
        final ElementDef xml;

        AssignDefaultMember(RolapCube cube, RolapHierarchy hierarchy, ElementDef xml) {
            this.cube = cube;
            this.hierarchy = hierarchy;
            this.xml = xml;
        }

        abstract AssignDefaultMember apply();

        abstract void apply2();

        protected void setDefaultMember(RolapCubeHierarchy hierarchy, RolapMember member) {
            hierarchy.setDefaultMember(member);
        }

        protected List<RolapCubeHierarchy> cubeHierarchies() {
            List<RolapCubeHierarchy> list = (List<RolapCubeHierarchy>)RolapSchemaLoader.this.cubeHierMap.get(this.hierarchy);
            return list != null ? list : Collections.emptyList();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class MondrianMultipleSchemaException
    extends RuntimeException {
        public final List<RolapSchema.MondrianSchemaException> exceptionList;

        public MondrianMultipleSchemaException(String message, List<RolapSchema.MondrianSchemaException> exceptionList) {
            super(message);
            this.exceptionList = exceptionList;
            assert (exceptionList.size() > 0);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MissingLinkAction {
        IGNORE{

            public void handle(Handler handler, String message, NodeDef xml, String attr) {
            }
        }
        ,
        WARNING{

            public void handle(Handler handler, String message, NodeDef xml, String attr) {
                handler.warning(message, xml, attr);
            }
        }
        ,
        ERROR{

            public void handle(Handler handler, String message, NodeDef xml, String attr) {
                handler.error(message, xml, attr);
            }
        };


        public abstract void handle(Handler var1, String var2, NodeDef var3, String var4);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class RolapSchemaValidatorImpl
    implements RolapSchemaValidator {
        private final Map<Object, NodeDef> map = new IdentityHashMap<Object, NodeDef>();

        RolapSchemaValidatorImpl() {
        }

        @Override
        public <T extends NodeDef> T getXml(Object o) {
            return this.getXml(o, true);
        }

        @Override
        public <T extends NodeDef> T getXml(Object o, boolean fail) {
            NodeDef xml = this.map.get(o);
            assert (xml != null || !fail) : "no xml element fouund for " + o;
            return (T)xml;
        }

        public <T extends NodeDef> T getXmls(Object ... os) {
            for (Object o1 : os) {
                T t = this.getXml(o1, false);
                if (t == null) continue;
                return t;
            }
            return null;
        }

        public void putXml(Object metaElement, NodeDef xml) {
            this.map.put(metaElement, xml);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static interface RolapSchemaValidator {
        public <T extends NodeDef> T getXml(Object var1);

        public <T extends NodeDef> T getXml(Object var1, boolean var2);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class PhysSchemaBuilder {
        final RolapSchemaLoader loader;
        RolapCube cube;
        final RolapSchema.PhysSchema physSchema;
        private int nextId = 0;
        Map<String, DimensionLink> dimensionLinks = new HashMap<String, DimensionLink>();

        PhysSchemaBuilder(RolapSchemaLoader loader, RolapSchema.PhysSchema physSchema) {
            assert (physSchema != null);
            this.loader = loader;
            this.physSchema = physSchema;
        }

        RolapSchema.PhysExpr toPhysExpr(RolapSchema.PhysRelation physRelation, MondrianDef.Expression exp) {
            if (exp == null) {
                return null;
            }
            if (exp instanceof MondrianDef.ExpressionView) {
                MondrianDef.ExpressionView expressionView = (MondrianDef.ExpressionView)exp;
                return this.toPhysExpr(physRelation, expressionView);
            }
            if (exp instanceof MondrianDef.Column) {
                MondrianDef.Column column = (MondrianDef.Column)exp;
                if (column.table != null) {
                    physRelation = this.getPhysRelation(column.table, false);
                }
                if (physRelation == null) {
                    this.getHandler().error("Column must specify table", (NodeDef)exp, null);
                    return new RolapSchema.PhysTextExpr("0");
                }
                RolapSchema.PhysColumn physColumn = physRelation.getColumn(column.name, false);
                if (physColumn == null) {
                    this.getHandler().error("Unknown column '" + column.name + "'", (NodeDef)column, "name");
                    return new RolapSchema.PhysTextExpr("0");
                }
                return physColumn;
            }
            throw Util.newInternal("Unknown expression type " + exp.getClass());
        }

        RolapSchema.PhysExpr toPhysExpr(RolapSchema.PhysRelation physRelation, MondrianDef.ExpressionView xmlExpressionView) {
            MondrianDef.SQL sql = MondrianDef.SQL.choose(xmlExpressionView.expressions, this.physSchema.dialect);
            return this.toPhysExpr(physRelation, sql);
        }

        RolapSchema.PhysExpr toPhysExpr(RolapSchema.PhysRelation physRelation, MondrianDef.SQL sql) {
            if (sql.children.length == 1 && sql.children[0] instanceof MondrianDef.Column) {
                return this.toPhysExpr(physRelation, (MondrianDef.Column)sql.children[0]);
            }
            ArrayList<RolapSchema.PhysExpr> list = new ArrayList<RolapSchema.PhysExpr>();
            for (NodeDef child : sql.children) {
                if (child instanceof TextDef) {
                    TextDef text = (TextDef)child;
                    list.add(new RolapSchema.PhysTextExpr(text.getText()));
                    continue;
                }
                list.add(this.toPhysExpr(physRelation, (MondrianDef.Expression)child));
            }
            HashSet<RolapSchema.PhysRelation> relationSet = new HashSet<RolapSchema.PhysRelation>();
            PhysSchemaBuilder.collectRelations(list, null, relationSet);
            if (relationSet.size() != 1) {
                return new RolapSchema.PhysCalcExpr(list);
            }
            RolapSchema.PhysRelation relation = (RolapSchema.PhysRelation)relationSet.iterator().next();
            RolapSchema.PhysCalcColumn physCalcColumn = new RolapSchema.PhysCalcColumn(this.loader, null, relation, "$" + this.nextId++, null, null, list);
            relation.addColumn(physCalcColumn);
            return physCalcColumn;
        }

        private static void collectRelations(List<RolapSchema.PhysExpr> list, RolapSchema.PhysRelation defaultRelation, Set<RolapSchema.PhysRelation> relationSet) {
            for (RolapSchema.PhysExpr expr : list) {
                PhysSchemaBuilder.collectRelations(expr, defaultRelation, relationSet);
            }
        }

        static void collectRelations(RolapSchema.PhysExpr expr, RolapSchema.PhysRelation defaultRelation, Set<RolapSchema.PhysRelation> relationSet) {
            if (expr instanceof RolapSchema.PhysColumn) {
                RolapSchema.PhysColumn column = (RolapSchema.PhysColumn)expr;
                assert (column.relation != null);
                relationSet.add(column.relation);
            } else if (expr instanceof RolapSchema.PhysCalcColumn) {
                PhysSchemaBuilder.collectRelations(((RolapSchema.PhysCalcColumn)expr).getList(), defaultRelation, relationSet);
            } else if (expr instanceof RolapSchema.PhysCalcExpr) {
                PhysSchemaBuilder.collectRelations(((RolapSchema.PhysCalcExpr)expr).list, defaultRelation, relationSet);
            } else if (defaultRelation != null) {
                relationSet.add(defaultRelation);
            }
        }

        RolapSchema.PhysExpr toPhysExpr(RolapSchema.PhysRelation relation, MondrianDef.Expression exp, String column) {
            if (exp != null) {
                return this.toPhysExpr(relation, exp);
            }
            if (column != null) {
                if (relation == null) {
                    this.loader.getHandler().error("Table must be specified", (NodeDef)exp, null);
                    return this.dummyColumn(relation);
                }
                return this.toPhysColumn(relation, column);
            }
            return null;
        }

        public RolapSchema.PhysRelation getPhysRelation(String alias, boolean fail) {
            RolapSchema.PhysRelation physTable = this.physSchema.tablesByName.get(alias);
            if (physTable == null && fail) {
                throw Util.newInternal("Table '" + alias + "' not found");
            }
            return physTable;
        }

        public RolapSchema.PhysColumn toPhysColumn(RolapSchema.PhysRelation physRelation, String column) {
            return physRelation.getColumn(column, true);
        }

        public RolapSchema.PhysColumn dummyColumn(RolapSchema.PhysRelation relation) {
            if (relation == null) {
                String tableName = "dummyTable$" + this.nextId++;
                relation = new RolapSchema.PhysTable(this.physSchema, null, tableName, tableName, Collections.<String, String>emptyMap());
            }
            return new RolapSchema.PhysCalcColumn(this.loader, null, relation, "dummy$" + this.nextId++, null, null, Collections.singletonList(new RolapSchema.PhysTextExpr("0")));
        }

        public static void collectRelations(RolapAggregator aggregator, RolapSchema.PhysExpr expr, RolapSchema.PhysRelation defaultRelation, Set<RolapSchema.PhysRelation> relationSet) {
            assert (aggregator != null);
            if (aggregator == RolapAggregator.Count && expr == null && defaultRelation != null) {
                relationSet.add(defaultRelation);
            }
            if (expr != null) {
                PhysSchemaBuilder.collectRelations(expr, defaultRelation, relationSet);
            }
        }

        public Handler getHandler() {
            return this.loader.getHandler();
        }

        public static class DimensionLink
        extends MondrianDef.DimensionLink {
            public DimensionLink(RolapSchemaUpgrader schemaUpgrader, String name, RolapSchema.PhysRelation fact, String foreignKey, String primaryKeyTable, String primaryKey, boolean degenerate) {
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static class UnresolvedLink {
        final RolapSchema.PhysKey sourceKey;
        final RolapSchema.PhysRelation targetRelation;
        final List<RolapSchema.PhysColumn> columnList;

        public UnresolvedLink(RolapSchema.PhysKey sourceKey, RolapSchema.PhysRelation targetRelation, List<RolapSchema.PhysColumn> columnList) {
            this.sourceKey = sourceKey;
            this.targetRelation = targetRelation;
            this.columnList = columnList;
        }
    }

    static interface Handler
    extends MondrianDef.Handler {
        public RolapSchema.XmlLocation locate(NodeDef var1, String var2);

        public void warning(String var1, NodeDef var2, String var3);

        public void warning(String var1, NodeDef var2, String var3, Throwable var4);

        public void error(String var1, NodeDef var2, String var3);

        public void error(MondrianException var1, NodeDef var2, String var3);

        public RuntimeException fatal(String var1, NodeDef var2, String var3);

        public void check() throws MondrianMultipleSchemaException;
    }

    static class Tcl {
        private final String table;
        private final String column;
        private final ElementDef xml;

        Tcl(String table, String column, ElementDef xml) {
            this.table = table;
            this.column = column;
            this.xml = xml;
        }
    }
}

