/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.sql.DataSource;
import mondrian.mdx.MdxVisitorImpl;
import mondrian.mdx.MemberExpr;
import mondrian.olap.Dimension;
import mondrian.olap.Formula;
import mondrian.olap.Id;
import mondrian.olap.Larders;
import mondrian.olap.Member;
import mondrian.olap.Mondrian3Def;
import mondrian.olap.MondrianDef;
import mondrian.olap.MondrianServer;
import mondrian.olap.OlapElement;
import mondrian.olap.Util;
import mondrian.rolap.CacheMemberReader;
import mondrian.rolap.MeasureMemberSource;
import mondrian.rolap.PhysSchemaConverter;
import mondrian.rolap.RolapBaseCubeMeasure;
import mondrian.rolap.RolapCalculatedMember;
import mondrian.rolap.RolapCube;
import mondrian.rolap.RolapCubeDimension;
import mondrian.rolap.RolapCubeHierarchy;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapHierarchy;
import mondrian.rolap.RolapLevel;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapSchemaLoader;
import mondrian.rolap.RolapStar;
import mondrian.rolap.RolapUtil;
import mondrian.rolap.RolapVirtualCubeMeasure;
import mondrian.rolap.SchemaKey;
import mondrian.spi.DataServicesLocator;
import mondrian.spi.DataServicesProvider;
import mondrian.spi.Dialect;
import mondrian.util.ByteString;
import mondrian.util.Pair;
import org.apache.log4j.Logger;
import org.eigenbase.xom.DOMWrapper;
import org.eigenbase.xom.ElementDef;
import org.eigenbase.xom.NodeDef;
import org.eigenbase.xom.TextDef;
import org.eigenbase.xom.XOMException;
import org.olap4j.metadata.NamedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RolapSchemaUpgrader {
    private final PhysSchemaConverter physSchemaConverter;
    private final RolapSchemaLoader loader;
    private final RolapSchema schema;
    private final Map<String, CubeInfo> cubeInfoMap = new HashMap<String, CubeInfo>();
    public static final Logger LOGGER = Logger.getLogger(RolapSchemaUpgrader.class);

    private RolapSchemaUpgrader(RolapSchemaLoader loader, RolapSchema schema, RolapSchema.PhysSchema physSchema) {
        this.loader = loader;
        this.schema = schema;
        this.physSchemaConverter = new PhysSchemaConverter(loader, physSchema);
    }

    static MondrianDef.Schema upgrade(RolapSchemaLoader loader, DOMWrapper def, SchemaKey key, ByteString md5Bytes, Util.PropertyList connectInfo, DataSource dataSource, boolean useContentChecksum) throws XOMException {
        Mondrian3Def.Schema xmlLegacySchema = new Mondrian3Def.Schema(def);
        RolapSchema tempSchema = new RolapSchema(key, connectInfo, dataSource, md5Bytes, useContentChecksum, xmlLegacySchema.name, true, Collections.<Locale>emptySet(), Larders.create(null, null, xmlLegacySchema.description));
        DataServicesProvider provider = DataServicesLocator.getDataServicesProvider(tempSchema.getDataServiceProviderName());
        tempSchema.physicalSchema = new RolapSchema.PhysSchema(tempSchema.getDialect(), tempSchema.getInternalConnection(), provider);
        RolapSchemaUpgrader upgrader = new RolapSchemaUpgrader(loader, tempSchema, tempSchema.physicalSchema);
        return upgrader.convertSchema(xmlLegacySchema);
    }

    protected static Mondrian3Def.CalculatedMember lookupXmlCalculatedMember(Mondrian3Def.Schema xmlSchema, String calcMemberName, String cubeName) {
        for (Mondrian3Def.Cube cube : xmlSchema.cubes) {
            if (!Util.equalName(cube.name, cubeName)) continue;
            for (Mondrian3Def.CalculatedMember xmlCalcMember : cube.calculatedMembers) {
                if (!Util.equalName(RolapSchemaUpgrader.calcMemberFqName(xmlCalcMember), calcMemberName)) continue;
                return xmlCalcMember;
            }
        }
        return null;
    }

    private static String calcMemberFqName(Mondrian3Def.CalculatedMember xmlCalcMember) {
        if (xmlCalcMember.dimension != null) {
            return Util.makeFqName(Util.quoteMdxIdentifier(xmlCalcMember.dimension), xmlCalcMember.name);
        }
        return Util.makeFqName(xmlCalcMember.hierarchy, xmlCalcMember.name);
    }

    /*
     * WARNING - void declaration
     */
    MondrianDef.Cube convertCube(Mondrian3Def.Schema xmlLegacySchema, Mondrian3Def.Cube xmlLegacyCube) {
        Mondrian3Def.Relation xmlFact = xmlLegacyCube.fact;
        RolapSchema.PhysRelation fact = xmlFact == null ? null : this.toPhysRelation(xmlFact);
        MondrianDef.Cube xmlCube = new MondrianDef.Cube();
        xmlCube.name = xmlLegacyCube.name;
        xmlCube.cache = xmlLegacyCube.cache;
        xmlCube.caption = xmlLegacyCube.caption;
        xmlCube.defaultMeasure = xmlLegacyCube.defaultMeasure;
        xmlCube.description = xmlLegacyCube.description;
        xmlCube.enabled = xmlLegacyCube.enabled;
        xmlCube.visible = xmlLegacyCube.visible;
        xmlCube.enableScenarios = false;
        NamedList<MondrianDef.Dimension> xmlDimensions = xmlCube.children.holder(new MondrianDef.Dimensions()).list();
        HashMap<String, MondrianDef.Dimension> xmlDimensionMap = new HashMap<String, MondrianDef.Dimension>();
        ArrayList<LevelInfo> levelList = new ArrayList<LevelInfo>();
        for (Mondrian3Def.CubeDimension xmlLegacyDimension : xmlLegacyCube.dimensions) {
            xmlDimensions.add((Object)this.convertCubeDimension(null, xmlLegacyCube.name, xmlDimensionMap, fact, xmlFact, xmlLegacyDimension, xmlLegacyDimension.visible, xmlLegacySchema, levelList));
        }
        MondrianDef.MeasureGroup xmlMeasureGroup = this.convertCubeMeasures(xmlLegacyCube, fact, xmlCube.children.holder(new MondrianDef.MeasureGroups()).list());
        if (xmlMeasureGroup == null) {
            return xmlCube;
        }
        LinkedHashMap<String, String> dimensionNameFks = new LinkedHashMap<String, String>();
        for (Mondrian3Def.CubeDimension cubeDimension : xmlLegacyCube.dimensions) {
            String foreignKey = cubeDimension.foreignKey;
            if (foreignKey != null && this.isDegenerate(cubeDimension, xmlLegacySchema, xmlFact)) {
                foreignKey = null;
            }
            dimensionNameFks.put(cubeDimension.name, foreignKey);
        }
        this.convertMeasureLinks(xmlLegacyCube, xmlMeasureGroup, dimensionNameFks);
        for (ElementDef elementDef : xmlLegacyCube.calculatedMembers) {
            xmlCube.children.holder(new MondrianDef.CalculatedMembers()).list().add((Object)this.convertCalculatedMember((Mondrian3Def.CalculatedMember)elementDef));
        }
        for (ElementDef elementDef : xmlLegacyCube.namedSets) {
            xmlCube.children.holder(new MondrianDef.NamedSets()).list().add((Object)this.convertNamedSet((Mondrian3Def.NamedSet)elementDef));
        }
        this.convertAnnotations(xmlCube.children, xmlLegacyCube.annotations);
        this.cubeInfoMap.put(xmlCube.name, new CubeInfo(xmlCube.name, fact, xmlFact, xmlLegacyCube));
        if (xmlLegacyCube.fact instanceof Mondrian3Def.Table) {
            void var14_24;
            Mondrian3Def.Table xmlLegacyFactTable = (Mondrian3Def.Table)xmlLegacyCube.fact;
            Mondrian3Def.AggTable[] arr$ = xmlLegacyFactTable.aggTables;
            int len$ = arr$.length;
            boolean bl = false;
            while (var14_24 < len$) {
                Mondrian3Def.AggTable xmlLegacyAggTable = arr$[var14_24];
                if (xmlLegacyAggTable instanceof Mondrian3Def.AggName) {
                    this.convertAggName(xmlMeasureGroup, (Mondrian3Def.AggName)xmlLegacyAggTable, levelList, xmlCube.children.holder(new MondrianDef.MeasureGroups()).list());
                } else {
                    LOGGER.warn((Object)("Cannot convert " + xmlLegacyAggTable.getName()));
                }
                ++var14_24;
            }
        }
        return xmlCube;
    }

    private MondrianDef.MeasureGroup convertCubeMeasures(Mondrian3Def.Cube xmlCube, RolapSchema.PhysRelation fact, NamedList<MondrianDef.MeasureGroup> xmlMeasureGroups) {
        Mondrian3Def.Relation xmlFact = xmlCube.fact;
        if (xmlFact == null) {
            this.loader.getHandler().warning("Cube '" + xmlCube.name + "' requires fact table", (NodeDef)xmlCube, null);
            return null;
        }
        if (xmlFact.getAlias() == null) {
            throw Util.newError("Must specify alias for fact table of cube '" + xmlCube.name + "'");
        }
        MondrianDef.MeasureGroup xmlMeasureGroup = new MondrianDef.MeasureGroup();
        xmlMeasureGroup.type = "fact";
        xmlMeasureGroup.name = xmlCube.name;
        xmlMeasureGroup.table = xmlFact.getAlias();
        xmlMeasureGroups.add((Object)xmlMeasureGroup);
        NamedList<MondrianDef.MeasureOrRef> xmlMeasures = xmlMeasureGroup.children.holder(new MondrianDef.Measures()).list();
        for (Mondrian3Def.Measure xmlLegacyMeasure : xmlCube.measures) {
            xmlMeasures.add((Object)this.convertMeasure(fact, xmlLegacyMeasure));
        }
        return xmlMeasureGroup;
    }

    private void convertMeasureLinks(Mondrian3Def.Cube xmlCube, MondrianDef.MeasureGroup xmlMeasureGroup, Map<String, String> dimensionNameFks) {
        Mondrian3Def.Relation xmlFact = xmlCube.fact;
        List<MondrianDef.DimensionLink> xmlDimensionLinks = xmlMeasureGroup.children.holder(new MondrianDef.DimensionLinks()).list();
        for (Map.Entry<String, String> entry : dimensionNameFks.entrySet()) {
            MondrianDef.DimensionLink xmlDimensionLink;
            String dimensionName = entry.getKey();
            String foreignKey = entry.getValue();
            if (foreignKey == null) {
                MondrianDef.FactLink xmlFactLink = new MondrianDef.FactLink();
                xmlFactLink.dimension = dimensionName;
                xmlDimensionLink = xmlFactLink;
            } else {
                MondrianDef.ForeignKeyLink xmlRegularLink = new MondrianDef.ForeignKeyLink();
                xmlRegularLink.dimension = dimensionName;
                xmlRegularLink.foreignKey = new MondrianDef.ForeignKey();
                xmlRegularLink.foreignKey.array = new MondrianDef.Column[]{new MondrianDef.Column(xmlFact.getAlias(), foreignKey)};
                xmlDimensionLink = xmlRegularLink;
            }
            xmlDimensionLinks.add(xmlDimensionLink);
        }
    }

    private MondrianDef.MeasureGroup convertAggName(MondrianDef.MeasureGroup xmlFactMeasureGroup, Mondrian3Def.AggName xmlLegacyAggName, List<LevelInfo> levelList, NamedList<MondrianDef.MeasureGroup> xmlMeasureGroupList) {
        MondrianDef.MeasureGroup xmlMeasureGroup = new MondrianDef.MeasureGroup();
        String nameTest = xmlLegacyAggName.name;
        while (xmlMeasureGroupList.get(nameTest) != null) {
            nameTest = nameTest + "_";
        }
        xmlMeasureGroup.name = nameTest;
        xmlMeasureGroup.table = xmlLegacyAggName.name;
        xmlMeasureGroup.type = "aggregate";
        xmlMeasureGroup.approxRowCount = xmlLegacyAggName.approxRowCount;
        Util.discard((Object)xmlLegacyAggName.ignoreColumns);
        final RolapSchema.PhysTable relation = (RolapSchema.PhysTable)this.lookupOrCreateTable(xmlLegacyAggName.name);
        relation.populateColumns(this.loader, null, null);
        Util.Function1<String, String> sanitizer = xmlLegacyAggName.ignorecase != false ? new Util.Function1<String, String>(){

            @Override
            public String apply(String param) {
                for (String s : relation.columnsByName.keySet()) {
                    if (!s.equalsIgnoreCase(param)) continue;
                    return s;
                }
                return param;
            }
        } : Util.identityFunctor();
        MondrianDef.Measures xmlMeasures = xmlMeasureGroup.children.holder(new MondrianDef.Measures());
        MondrianDef.DimensionLinks xmlDimensionLinks = xmlMeasureGroup.children.holder(new MondrianDef.DimensionLinks());
        for (Mondrian3Def.AggForeignKey xmlLegacyForeignKey : xmlLegacyAggName.foreignKeys) {
            this.convertAggForeignKey(xmlFactMeasureGroup, xmlDimensionLinks, xmlLegacyForeignKey.factColumn, (String)sanitizer.apply(xmlLegacyForeignKey.aggColumn));
        }
        HashMap<String, MondrianDef.CopyLink> copyLinks = new HashMap<String, MondrianDef.CopyLink>();
        for (Mondrian3Def.AggLevel aggLevel : xmlLegacyAggName.levels) {
            LevelInfo level = RolapSchemaUpgrader.lookupLevelInfo(levelList, aggLevel.name);
            if (level == null) {
                LOGGER.warn((Object)("Level '" + aggLevel.name + "' not found; skipping this AggLevel"));
                continue;
            }
            MondrianDef.CopyLink copyLink = (MondrianDef.CopyLink)((Object)copyLinks.get(level.dimension));
            if (copyLink == null) {
                copyLink = new MondrianDef.CopyLink();
                copyLink.dimension = level.dimension;
                copyLinks.put(level.dimension, copyLink);
                copyLink.columnRefs = new MondrianDef.Column[0];
                xmlDimensionLinks.list().add(copyLink);
            }
            MondrianDef.Column column = new MondrianDef.Column();
            column.aggColumn = (String)sanitizer.apply(aggLevel.column);
            column.name = (String)sanitizer.apply(level.column);
            column.table = level.table;
            copyLink.columnRefs = Util.append(copyLink.columnRefs, column);
            if (RolapSchemaLoader.toBoolean(aggLevel.collapsed, true)) continue;
        }
        if (xmlLegacyAggName.factcount != null) {
            MondrianDef.MeasureRef xmlCountMeasureRef = new MondrianDef.MeasureRef();
            xmlCountMeasureRef.aggColumn = (String)sanitizer.apply(xmlLegacyAggName.factcount.column);
            xmlCountMeasureRef.name = "Fact Count";
            xmlMeasures.list().add((Object)xmlCountMeasureRef);
        }
        for (ElementDef elementDef : xmlLegacyAggName.measures) {
            MondrianDef.MeasureRef xmlMeasureRef = new MondrianDef.MeasureRef();
            xmlMeasureRef.aggColumn = (String)sanitizer.apply(elementDef.column);
            xmlMeasureRef.name = elementDef.name;
            xmlMeasures.list().add((Object)xmlMeasureRef);
        }
        xmlMeasureGroupList.add((Object)xmlMeasureGroup);
        return xmlMeasureGroup;
    }

    private void convertAggForeignKey(MondrianDef.MeasureGroup xmlFactMeasureGroup, MondrianDef.DimensionLinks xmlDimensionLinks, String factColumn, String aggColumn) {
        for (MondrianDef.DimensionLink xmlLink : xmlFactMeasureGroup.getDimensionLinks()) {
            MondrianDef.ForeignKeyLink xmlFKLink;
            if (!(xmlLink instanceof MondrianDef.ForeignKeyLink) || !this.matchesForeignKey(xmlFKLink = (MondrianDef.ForeignKeyLink)xmlLink, factColumn)) continue;
            MondrianDef.ForeignKeyLink xmlAggFKLink = new MondrianDef.ForeignKeyLink();
            xmlAggFKLink.foreignKeyColumn = aggColumn;
            xmlAggFKLink.dimension = xmlFKLink.dimension;
            xmlDimensionLinks.list().add(xmlAggFKLink);
        }
    }

    private boolean matchesForeignKey(MondrianDef.ForeignKeyLink xmlForeignKeyLink, String factColumn) {
        if (xmlForeignKeyLink.foreignKeyColumn != null && xmlForeignKeyLink.foreignKeyColumn.equals(factColumn)) {
            return true;
        }
        return xmlForeignKeyLink.foreignKey != null && xmlForeignKeyLink.foreignKey.array.length == 1 && xmlForeignKeyLink.foreignKey.array[0].name.equals(factColumn);
    }

    private RolapSchema.PhysRelation lookupOrCreateTable(String table) {
        RolapSchema.PhysSchema physSchema = this.physSchemaConverter.physSchema;
        RolapSchema.PhysRelation physRelation = physSchema.tablesByName.get(table);
        if (physRelation == null) {
            physRelation = new RolapSchema.PhysTable(physSchema, null, table, table, Collections.<String, String>emptyMap());
            physSchema.tablesByName.put(table, physRelation);
        }
        return physRelation;
    }

    private boolean findOriginalMembers(Formula formula, List<MondrianDef.CalculatedMember> xmlCalcMemberList, List<Formula> calcMemberList) {
        for (MondrianDef.CalculatedMember xmlCalcMember : xmlCalcMemberList) {
            Dimension dimension = this.lookupDimension(new Id.NameSegment(xmlCalcMember.dimension, Id.Quoting.UNQUOTED));
            if (!formula.getName().equals(xmlCalcMember.name) || !formula.getMdxMember().getDimension().getName().equals(dimension.getName())) continue;
            calcMemberList.add(formula);
            return true;
        }
        return false;
    }

    private Dimension lookupDimension(Id.Segment segment) {
        return null;
    }

    private MondrianDef.Dimension convertCubeDimension(Map<String, Info> infoMap, String cubeName, Map<String, MondrianDef.Dimension> xmlDimensionMap, RolapSchema.PhysRelation fact, Mondrian3Def.RelationOrJoin xmlFact, Mondrian3Def.CubeDimension xmlLegacyCubeDimension, boolean visible, Mondrian3Def.Schema xmlLegacySchema, List<LevelInfo> levelList) {
        List<Link> links;
        Mondrian3Def.Dimension xmlLegacyDimension;
        if (xmlLegacyCubeDimension instanceof Mondrian3Def.Dimension) {
            xmlLegacyDimension = (Mondrian3Def.Dimension)xmlLegacyCubeDimension;
        } else {
            Mondrian3Def.DimensionUsage xmlLegacyDimensionUsage = (Mondrian3Def.DimensionUsage)xmlLegacyCubeDimension;
            xmlLegacyDimension = xmlLegacyDimensionUsage.getDimension(xmlLegacySchema);
        }
        assert (this.physSchemaConverter != null);
        String dimensionName = xmlLegacyDimension.name;
        if (xmlLegacyCubeDimension instanceof Mondrian3Def.VirtualCubeDimension) {
            Mondrian3Def.VirtualCubeDimension xmlVirtualCubeDimension = (Mondrian3Def.VirtualCubeDimension)xmlLegacyCubeDimension;
            assert (xmlFact == null) : "VirtualCubeDimension only occurs within virtual cube, which has no fact table";
            if (xmlVirtualCubeDimension.cubeName == null) {
                links = new ArrayList<Link>();
                block4: for (Info info : infoMap.values()) {
                    Mondrian3Def.Cube xmlCubeUsed = info.xmlLegacyCube;
                    List<Mondrian3Def.DimensionUsage> usageList = RolapSchemaUpgrader.lookupSharedDimension(xmlCubeUsed, xmlVirtualCubeDimension.name);
                    switch (usageList.size()) {
                        case 0: {
                            continue block4;
                        }
                        case 1: {
                            links.add(new Link(this.toPhysRelation(xmlCubeUsed.fact), usageList.get((int)0).foreignKey));
                            continue block4;
                        }
                    }
                    Util.deprecated("test this", false);
                    this.loader.getHandler().error("Shared cube dimension is ambiguous: more than one dimension in base cube " + xmlCubeUsed.name + " uses shared dimension " + xmlVirtualCubeDimension.name, (NodeDef)xmlLegacyCubeDimension, null);
                }
                if (links.isEmpty()) {
                    this.loader.getHandler().error("Virtual cube dimension must join to at least one cube: dimension '" + xmlVirtualCubeDimension.name + "' in cube '" + cubeName + "'", (NodeDef)xmlLegacyCubeDimension, null);
                }
            } else {
                Mondrian3Def.Cube cube = this.getCube(xmlLegacySchema, xmlVirtualCubeDimension.cubeName);
                if (cube == null) {
                    Util.deprecated("use schema.error, and test", false);
                    throw Util.newError("Unknown cube '" + xmlVirtualCubeDimension.cubeName + "'");
                }
                xmlFact = cube.fact;
                links = Collections.singletonList(new Link(this.toPhysRelation(cube.fact), xmlVirtualCubeDimension.foreignKey));
            }
        } else {
            String foreignKey;
            if (xmlLegacyCubeDimension instanceof Mondrian3Def.DimensionUsage) {
                Mondrian3Def.DimensionUsage xmlLegacyDimensionUsage = (Mondrian3Def.DimensionUsage)xmlLegacyCubeDimension;
                foreignKey = xmlLegacyDimensionUsage.foreignKey;
                if (xmlLegacyDimensionUsage.name != null) {
                    dimensionName = xmlLegacyDimensionUsage.name;
                }
            } else if (xmlLegacyCubeDimension instanceof Mondrian3Def.Dimension) {
                foreignKey = xmlLegacyDimension.foreignKey;
            } else {
                throw new AssertionError((Object)"unknown dimension type");
            }
            boolean degenerate = this.isDegenerate(xmlLegacyCubeDimension, xmlLegacySchema, xmlFact);
            if (foreignKey == null && !degenerate) {
                throw this.loader.getHandler().fatal("Dimension or DimensionUsage must have foreignKey", (NodeDef)xmlLegacyCubeDimension, null);
            }
            links = Collections.singletonList(new Link(fact, foreignKey));
            Pair<String, String> pair = this.getUniquePrimaryKey(xmlLegacyDimension);
            this.physSchemaConverter.dimensionLinks.put(dimensionName, new RolapSchemaLoader.PhysSchemaBuilder.DimensionLink(this, dimensionName, fact, foreignKey, (String)pair.left, (String)pair.right, degenerate));
        }
        MondrianDef.Dimension xmlDimension = this.convertDimension(links, xmlDimensionMap, xmlFact, xmlLegacyDimension, dimensionName, visible, Util.first(xmlLegacyCubeDimension.description, xmlLegacyDimension.description), levelList);
        this.convertAnnotations(xmlDimension.children, xmlLegacyCubeDimension.annotations);
        this.convertCaption(xmlLegacyCubeDimension, xmlLegacyDimension, xmlDimension);
        if (xmlLegacyCubeDimension instanceof Mondrian3Def.DimensionUsage) {
            xmlDimension.source = ((Mondrian3Def.DimensionUsage)xmlLegacyCubeDimension).source;
            xmlDimension.key = null;
        }
        return xmlDimension;
    }

    private void convertCaption(Mondrian3Def.CubeDimension xmlLegacyCubeDimension, Mondrian3Def.Dimension xmlLegacyDimension, MondrianDef.Dimension xmlDimension) {
        xmlDimension.caption = Util.first(xmlLegacyCubeDimension.caption, xmlLegacyDimension.caption);
    }

    private boolean isDegenerate(Mondrian3Def.CubeDimension xmlCubeDimension, Mondrian3Def.Schema xmlSchema, Mondrian3Def.RelationOrJoin xmlFact) {
        if (xmlCubeDimension instanceof Mondrian3Def.Dimension) {
            Mondrian3Def.Dimension dimension = (Mondrian3Def.Dimension)xmlCubeDimension;
            for (Mondrian3Def.Hierarchy hierarchy : dimension.hierarchies) {
                if (hierarchy.relation == null || Util.equals((Object)hierarchy.relation, (Object)xmlFact)) continue;
                return false;
            }
            return true;
        }
        if (xmlCubeDimension instanceof Mondrian3Def.DimensionUsage) {
            Mondrian3Def.Dimension dimension = xmlCubeDimension.getDimension(xmlSchema);
            if (dimension == null) {
                return false;
            }
            return this.isDegenerate(dimension, xmlSchema, xmlFact);
        }
        return false;
    }

    Pair<String, String> getUniquePrimaryKey(Mondrian3Def.Dimension dimension) {
        if (dimension.hierarchies.length == 0) {
            throw this.loader.getHandler().fatal("Dimension has no hierarchies", (NodeDef)dimension, null);
        }
        HashSet<Pair<String, String>> primaryKeySet = new HashSet<Pair<String, String>>();
        for (Mondrian3Def.Hierarchy xmlHierarchy : dimension.hierarchies) {
            String primaryKeyTable = xmlHierarchy.primaryKeyTable;
            if (primaryKeyTable == null && xmlHierarchy.relation instanceof Mondrian3Def.Relation) {
                primaryKeyTable = ((Mondrian3Def.Relation)xmlHierarchy.relation).getAlias();
            }
            primaryKeySet.add(Pair.of(primaryKeyTable, xmlHierarchy.primaryKey));
        }
        if (primaryKeySet.size() != 1) {
            throw this.loader.getHandler().fatal("Cannot convert schema: hierarchies in dimension '" + dimension.name + "' do not have consistent primary keys", (NodeDef)dimension, null);
        }
        return (Pair)primaryKeySet.iterator().next();
    }

    /*
     * WARNING - void declaration
     */
    private Pair<Set<String>, Map<String, Info>> buildInfoMap(Mondrian3Def.Schema xmlLegacySchema, Mondrian3Def.VirtualCube xmlVirtualCube) {
        LinkedHashSet<String> dimensionNames = new LinkedHashSet<String>();
        LinkedHashSet<String> names = new LinkedHashSet<String>();
        if (xmlVirtualCube.cubeUsage != null) {
            for (ElementDef elementDef : xmlVirtualCube.cubeUsage.cubeUsages) {
                names.add(elementDef.cubeName);
            }
        }
        for (ElementDef elementDef : xmlVirtualCube.dimensions) {
            if (elementDef.cubeName != null) {
                names.add(elementDef.cubeName);
            }
            dimensionNames.add(elementDef.name);
        }
        for (ElementDef elementDef : xmlVirtualCube.measures) {
            if (elementDef.cubeName == null) continue;
            names.add(elementDef.cubeName);
        }
        LinkedHashMap<String, Info> infoMap = new LinkedHashMap<String, Info>();
        for (String name : names) {
            Mondrian3Def.Cube cube = this.getCube(xmlLegacySchema, name);
            if (cube == null) {
                throw Util.newError("Cube '" + name + "' not found");
            }
            infoMap.put(name, new Info(name, cube));
        }
        if (xmlVirtualCube.cubeUsage != null) {
            void var8_18;
            Mondrian3Def.CubeUsage[] arr$ = xmlVirtualCube.cubeUsage.cubeUsages;
            int len$ = arr$.length;
            boolean bl = false;
            while (var8_18 < len$) {
                Mondrian3Def.CubeUsage xmlCubeUsage = arr$[var8_18];
                ((Info)infoMap.get((Object)xmlCubeUsage.cubeName)).ignoreUnrelatedDimensions = RolapSchemaLoader.toBoolean(xmlCubeUsage.ignoreUnrelatedDimensions, false);
                ++var8_18;
            }
        }
        return Pair.of(dimensionNames, infoMap);
    }

    private Mondrian3Def.VirtualCube getVirtualCube(Mondrian3Def.Schema xmlSchema, String name) {
        for (Mondrian3Def.VirtualCube cube : xmlSchema.virtualCubes) {
            if (!cube.name.equals(name)) continue;
            return cube;
        }
        return null;
    }

    private Mondrian3Def.Cube getCube(Mondrian3Def.Schema xmlSchema, String name) {
        for (Mondrian3Def.Cube cube : xmlSchema.cubes) {
            if (!cube.name.equals(name)) continue;
            return cube;
        }
        return null;
    }

    void registerDimension_old(RolapCubeDimension dimension) {
    }

    private Logger getLogger() {
        return RolapSchema.LOGGER;
    }

    private HierarchyUsage[] getUsages(RolapCubeHierarchy hierarchy) {
        return new HierarchyUsage[0];
    }

    private static String format(Mondrian3Def.RelationOrJoin relation) {
        StringBuilder buf = new StringBuilder();
        RolapSchemaUpgrader.format(relation, buf, "");
        return buf.toString();
    }

    private static void format(Mondrian3Def.RelationOrJoin relation, StringBuilder buf, String indent) {
        if (relation instanceof Mondrian3Def.Table) {
            Mondrian3Def.Table table = (Mondrian3Def.Table)relation;
            buf.append(indent);
            buf.append(table.name);
            if (table.alias != null) {
                buf.append('(');
                buf.append(table.alias);
                buf.append(')');
            }
            buf.append(Util.nl);
        } else {
            Mondrian3Def.Join join = (Mondrian3Def.Join)relation;
            String subindent = indent + "  ";
            buf.append(indent);
            buf.append(join.getLeftAlias());
            buf.append('.');
            buf.append(join.leftKey);
            buf.append('=');
            buf.append(join.getRightAlias());
            buf.append('.');
            buf.append(join.rightKey);
            buf.append(Util.nl);
            RolapSchemaUpgrader.format(join.left, buf, subindent);
            RolapSchemaUpgrader.format(join.right, buf, indent);
        }
    }

    public static <T extends OlapElement> T lookupLevel(List<? extends T> elements, String name) {
        for (OlapElement element : elements) {
            if (!element.getName().equals(name)) continue;
            return (T)element;
        }
        return null;
    }

    public static LevelInfo lookupLevelInfo(List<LevelInfo> elements, String name) {
        for (LevelInfo element : elements) {
            if (element.level.equals(name)) {
                return element;
            }
            String elementName = Util.quoteMdxIdentifier(Id.NameSegment.toList(element.dimension, element.hierarchy, element.level));
            if (!elementName.equals(name)) continue;
            return element;
        }
        for (LevelInfo element : elements) {
            if (element.level.equals(name)) {
                return element;
            }
            String shortElementName = Util.quoteMdxIdentifier(Id.NameSegment.toList(element.dimension, element.level));
            if (!shortElementName.equals(name)) continue;
            return element;
        }
        return null;
    }

    private static Mondrian3Def.RelationOrJoin reorder(Mondrian3Def.RelationOrJoin relation, List<? extends RolapCubeLevel> levels) {
        if (levels.size() < 2) {
            return relation;
        }
        HashMap<String, RelNode> nodeMap = new HashMap<String, RelNode>();
        for (int i = 0; i < levels.size(); ++i) {
            RolapLevel level = levels.get(i);
            if (level.isAll()) continue;
            String tableName = RolapSchemaLoader.getTableName(level);
            if (tableName == null) {
                return relation;
            }
            RelNode rnode = new RelNode(tableName, i);
            nodeMap.put(tableName, rnode);
        }
        if (!RolapSchemaUpgrader.validateNodes(relation, nodeMap)) {
            return relation;
        }
        relation = RolapSchemaUpgrader.copy(relation);
        RolapSchemaUpgrader.leftToRight(relation, nodeMap);
        RolapSchemaUpgrader.topToBottom(relation);
        return relation;
    }

    private static boolean validateNodes(Mondrian3Def.RelationOrJoin relation, Map<String, RelNode> map) {
        if (relation instanceof Mondrian3Def.Relation) {
            Mondrian3Def.Relation table = (Mondrian3Def.Relation)relation;
            RelNode relNode = RelNode.lookup(table, map);
            return relNode != null;
        }
        if (relation instanceof Mondrian3Def.Join) {
            Mondrian3Def.Join join = (Mondrian3Def.Join)relation;
            return RolapSchemaUpgrader.validateNodes(join.left, map) && RolapSchemaUpgrader.validateNodes(join.right, map);
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    private static int leftToRight(Mondrian3Def.RelationOrJoin relation, Map<String, RelNode> map) {
        if (relation instanceof Mondrian3Def.Relation) {
            Mondrian3Def.Relation table = (Mondrian3Def.Relation)relation;
            RelNode relNode = RelNode.lookup(table, map);
            relNode.table = table;
            return relNode.depth;
        }
        if (relation instanceof Mondrian3Def.Join) {
            Mondrian3Def.Join join = (Mondrian3Def.Join)relation;
            int leftDepth = RolapSchemaUpgrader.leftToRight(join.left, map);
            int rightDepth = RolapSchemaUpgrader.leftToRight(join.right, map);
            if (rightDepth > leftDepth) {
                String leftAlias = join.leftAlias;
                String leftKey = join.leftKey;
                Mondrian3Def.RelationOrJoin left = join.left;
                join.leftAlias = join.rightAlias;
                join.leftKey = join.rightKey;
                join.left = join.right;
                join.rightAlias = leftAlias;
                join.rightKey = leftKey;
                join.right = left;
            }
            return leftDepth;
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    private static void topToBottom(Mondrian3Def.RelationOrJoin relation) {
        if (!(relation instanceof Mondrian3Def.Table) && relation instanceof Mondrian3Def.Join) {
            Mondrian3Def.Join join = (Mondrian3Def.Join)relation;
            while (join.left instanceof Mondrian3Def.Join) {
                Mondrian3Def.Join jleft = (Mondrian3Def.Join)join.left;
                join.right = new Mondrian3Def.Join(join.leftAlias, join.leftKey, jleft.right, join.rightAlias, join.rightKey, join.right);
                join.left = jleft.left;
                join.rightAlias = jleft.rightAlias;
                join.rightKey = jleft.rightKey;
                join.leftAlias = jleft.leftAlias;
                join.leftKey = jleft.leftKey;
            }
        }
    }

    private static Mondrian3Def.RelationOrJoin copy(Mondrian3Def.RelationOrJoin relation) {
        if (relation instanceof Mondrian3Def.Table) {
            Mondrian3Def.Table table = (Mondrian3Def.Table)relation;
            return new Mondrian3Def.Table(table);
        }
        if (relation instanceof Mondrian3Def.InlineTable) {
            Mondrian3Def.InlineTable table = (Mondrian3Def.InlineTable)relation;
            return new Mondrian3Def.InlineTable(table);
        }
        if (relation instanceof Mondrian3Def.Join) {
            Mondrian3Def.Join join = (Mondrian3Def.Join)relation;
            Mondrian3Def.RelationOrJoin left = RolapSchemaUpgrader.copy(join.left);
            Mondrian3Def.RelationOrJoin right = RolapSchemaUpgrader.copy(join.right);
            return new Mondrian3Def.Join(join.leftAlias, join.leftKey, left, join.rightAlias, join.rightKey, right);
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    private static Mondrian3Def.RelationOrJoin snip(Mondrian3Def.RelationOrJoin relation, String tableName) {
        Util.deprecated("unused?", false);
        if (relation instanceof Mondrian3Def.Table) {
            Mondrian3Def.Table table = (Mondrian3Def.Table)relation;
            return table.alias != null && table.alias.equals(tableName) ? null : (table.name.equals(tableName) ? null : table);
        }
        if (relation instanceof Mondrian3Def.Join) {
            Mondrian3Def.Join join = (Mondrian3Def.Join)relation;
            Mondrian3Def.RelationOrJoin left = RolapSchemaUpgrader.snip(join.left, tableName);
            if (left == null) {
                return join.right;
            }
            join.left = left;
            Mondrian3Def.RelationOrJoin right = RolapSchemaUpgrader.snip(join.right, tableName);
            if (right == null) {
                return join.left;
            }
            join.right = right;
            return join;
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relation));
    }

    RolapStar.Table addJoin(RolapStar.Table table, RolapSchemaLoader.PhysSchemaBuilder physSchemaBuilder, Mondrian3Def.RelationOrJoin relationOrJoin, RolapSchema.PhysHop joinCondition) {
        Util.deprecated("move this to PhysSchmaBuilder?", false);
        if (relationOrJoin instanceof Mondrian3Def.Relation) {
            Mondrian3Def.Relation relation = (Mondrian3Def.Relation)relationOrJoin;
            RolapSchema.PhysRelation physRelation = this.toPhysRelation(relation);
            RolapStar.Table starTable = table.findChild(joinCondition, true);
            assert (starTable != null);
            return starTable;
        }
        if (relationOrJoin instanceof Mondrian3Def.Join) {
            Mondrian3Def.Join join = (Mondrian3Def.Join)relationOrJoin;
            RolapStar.Table leftTable = this.addJoin(table, physSchemaBuilder, join.left, joinCondition);
            String leftAlias = join.leftAlias;
            if (leftAlias == null && (leftAlias = ((Mondrian3Def.Relation)join.left).getAlias()) == null) {
                throw Util.newError("missing leftKeyAlias in " + (Object)((Object)relationOrJoin));
            }
            assert (leftTable.findAncestor(leftAlias) == leftTable);
            leftAlias = leftTable.getAlias();
            String rightAlias = join.rightAlias;
            if (rightAlias == null) {
                if (join.right instanceof Mondrian3Def.Join) {
                    Mondrian3Def.Join joinright = (Mondrian3Def.Join)join.right;
                    rightAlias = ((Mondrian3Def.Relation)joinright.left).getAlias();
                } else {
                    rightAlias = ((Mondrian3Def.Relation)join.right).getAlias();
                }
                if (rightAlias == null) {
                    throw Util.newError("missing rightKeyAlias in " + (Object)((Object)relationOrJoin));
                }
            }
            RolapStar.Condition joinCondition2 = new RolapStar.Condition(physSchemaBuilder.getPhysRelation(leftAlias, true).getColumn(join.leftKey, true), physSchemaBuilder.getPhysRelation(rightAlias, true).getColumn(join.rightKey, true));
            return this.addJoin(leftTable, physSchemaBuilder, join.right, joinCondition);
        }
        throw Util.newInternal("bad relation type " + (Object)((Object)relationOrJoin));
    }

    RolapSchema.PhysRelation toPhysRelation2(Mondrian3Def.Relation xmlRelation) {
        RolapSchema.PhysSchema physSchema = this.physSchemaConverter.physSchema;
        String alias = xmlRelation.getAlias();
        RolapSchema.PhysRelation physRelation = physSchema.tablesByName.get(alias);
        if (physRelation == null) {
            if (xmlRelation instanceof Mondrian3Def.Table) {
                Mondrian3Def.Table xmlTable = (Mondrian3Def.Table)xmlRelation;
                RolapSchema.PhysTable physTable = new RolapSchema.PhysTable(physSchema, xmlTable.schema, xmlTable.name, alias, xmlTable.getHintMap());
                physTable.ensurePopulated(this.loader, (NodeDef)xmlTable);
                physRelation = physTable;
            } else if (xmlRelation instanceof Mondrian3Def.InlineTable) {
                Mondrian3Def.InlineTable xmlInlineTable = (Mondrian3Def.InlineTable)xmlRelation;
                RolapSchema.PhysInlineTable physInlineTable = new RolapSchema.PhysInlineTable(physSchema, alias);
                for (Mondrian3Def.RealOrCalcColumnDef columnDef : xmlInlineTable.columnDefs.array) {
                    physInlineTable.addColumn(new RolapSchema.PhysRealColumn((RolapSchema.PhysRelation)physInlineTable, columnDef.name, Dialect.Datatype.valueOf(columnDef.type), null, 4));
                }
                assert (physInlineTable.getTotalColumnSize() > 0) : "Inline tables must have at least one column to work properly in Mondrian 4+.";
                physInlineTable.lookupKey(Collections.singletonList(physInlineTable.columnsByName.values().iterator().next()), true);
                int columnCount = physInlineTable.columnsByName.size();
                for (Mondrian3Def.Row row : xmlInlineTable.rows.array) {
                    String[] values = new String[columnCount];
                    for (Mondrian3Def.Value value : row.values) {
                        String columnName;
                        int columnOrdinal = 0;
                        Iterator i$ = physInlineTable.columnsByName.keySet().iterator();
                        while (i$.hasNext() && !(columnName = (String)i$.next()).equals(value.column)) {
                            ++columnOrdinal;
                        }
                        if (columnOrdinal >= columnCount) {
                            throw Util.newError("Unknown column '" + value.column + "'");
                        }
                        values[columnOrdinal] = value.cdata;
                    }
                    physInlineTable.rowList.add(values);
                }
                RolapSchema.PhysView physView = RolapUtil.convertInlineTableToRelation(physInlineTable, physSchema.dialect);
                physView.ensurePopulated(this.loader, (NodeDef)xmlInlineTable);
                physRelation = physView;
            } else if (xmlRelation instanceof Mondrian3Def.View) {
                Mondrian3Def.View xmlView = (Mondrian3Def.View)xmlRelation;
                Mondrian3Def.SQL sql = Mondrian3Def.SQL.choose(xmlView.selects, this.schema.getDialect());
                RolapSchema.PhysView physView = new RolapSchema.PhysView(physSchema, alias, RolapSchemaUpgrader.getText(sql));
                physView.ensurePopulated(this.loader, (NodeDef)xmlView);
                physRelation = physView;
            } else {
                throw Util.needToImplement("translate xml table to phys table for table type" + ((Object)((Object)xmlRelation)).getClass());
            }
            physSchema.tablesByName.put(alias, physRelation);
        }
        assert (physRelation.getSchema() == physSchema);
        return physRelation;
    }

    static String getText(Mondrian3Def.SQL sql) {
        StringBuilder buf = new StringBuilder();
        for (NodeDef child : sql.children) {
            if (!(child instanceof TextDef)) continue;
            TextDef textDef = (TextDef)child;
            buf.append(textDef.s);
        }
        return buf.toString();
    }

    RolapSchema.PhysRelation toPhysRelation(Mondrian3Def.Relation xmlLegacyRelation) {
        String alias = xmlLegacyRelation.getAlias();
        RolapSchema.PhysRelation physRelation = this.physSchemaConverter.physSchema.tablesByName.get(alias);
        if (physRelation == null) {
            ElementDef xmlRelation;
            if (xmlLegacyRelation instanceof Mondrian3Def.Table) {
                MondrianDef.Table xmlTable;
                Mondrian3Def.Table xmlLegacyTable = (Mondrian3Def.Table)xmlLegacyRelation;
                RolapSchema.PhysTable physTable = new RolapSchema.PhysTable(this.physSchemaConverter.physSchema, xmlLegacyTable.schema, xmlLegacyTable.name, alias, RolapSchemaUpgrader.buildHintMap(xmlLegacyTable.tableHints));
                physTable.ensurePopulated(this.loader, (NodeDef)xmlLegacyTable);
                physRelation = physTable;
                xmlRelation = xmlTable = this.convert(xmlLegacyTable);
            } else if (xmlLegacyRelation instanceof Mondrian3Def.InlineTable) {
                Mondrian3Def.InlineTable xmlLegacyInlineTable = (Mondrian3Def.InlineTable)xmlLegacyRelation;
                RolapSchema.PhysInlineTable physInlineTable = new RolapSchema.PhysInlineTable(this.physSchemaConverter.physSchema, alias);
                for (Mondrian3Def.RealOrCalcColumnDef columnDef : xmlLegacyInlineTable.columnDefs.array) {
                    physInlineTable.addColumn(new RolapSchema.PhysRealColumn((RolapSchema.PhysRelation)physInlineTable, columnDef.name, Dialect.Datatype.valueOf(columnDef.type), null, -1));
                }
                int columnCount = physInlineTable.columnsByName.size();
                assert (columnCount > 0) : "Inline tables must have at least one column to work properly in Mondrian 4+.";
                physInlineTable.lookupKey(Collections.singletonList(physInlineTable.columnsByName.values().iterator().next()), true);
                for (Mondrian3Def.Row row : xmlLegacyInlineTable.rows.array) {
                    String[] values = new String[columnCount];
                    for (Mondrian3Def.Value value : row.values) {
                        String columnName;
                        int columnOrdinal = 0;
                        Iterator i$ = physInlineTable.columnsByName.keySet().iterator();
                        while (i$.hasNext() && !(columnName = (String)i$.next()).equals(value.column)) {
                            ++columnOrdinal;
                        }
                        if (columnOrdinal >= columnCount) {
                            throw Util.newError("Unknown column '" + value.column + "'");
                        }
                        values[columnOrdinal] = value.cdata;
                    }
                    physInlineTable.rowList.add(values);
                }
                if (Util.deprecated(false, false).booleanValue()) {
                    RolapSchema.PhysView physView = RolapUtil.convertInlineTableToRelation(physInlineTable, this.physSchemaConverter.physSchema.dialect);
                    physView.ensurePopulated(this.loader, (NodeDef)xmlLegacyInlineTable);
                    physRelation = physView;
                } else {
                    physRelation = physInlineTable;
                }
                MondrianDef.InlineTable xmlInlineTable = this.convert(xmlLegacyInlineTable);
                xmlRelation = xmlInlineTable;
            } else if (xmlLegacyRelation instanceof Mondrian3Def.View) {
                Mondrian3Def.View xmlView = (Mondrian3Def.View)xmlLegacyRelation;
                Mondrian3Def.SQL sql = Mondrian3Def.SQL.choose(xmlView.selects, this.schema.getDialect());
                RolapSchema.PhysView physView = new RolapSchema.PhysView(this.physSchemaConverter.physSchema, alias, RolapSchemaUpgrader.getText(sql));
                physView.ensurePopulated(this.loader, (NodeDef)xmlView);
                physRelation = physView;
                MondrianDef.Query xmlQuery = new MondrianDef.Query();
                xmlQuery.alias = alias;
                MondrianDef.ExpressionView xmlExpressionView = new MondrianDef.ExpressionView();
                xmlExpressionView.expressions = this.convert(xmlView.selects);
                xmlQuery.children.add(xmlExpressionView);
                xmlRelation = xmlQuery;
            } else {
                throw Util.needToImplement("translate xml table to phys table for table type" + ((Object)((Object)xmlLegacyRelation)).getClass());
            }
            this.physSchemaConverter.physSchema.tablesByName.put(alias, physRelation);
            this.physSchemaConverter.xmlTables.put(alias, (MondrianDef.Relation)xmlRelation);
        }
        assert (physRelation.getSchema() == this.physSchemaConverter.physSchema);
        return physRelation;
    }

    private MondrianDef.Table convert(Mondrian3Def.Table xmlLegacyTable) {
        MondrianDef.Table xmlTable = new MondrianDef.Table();
        xmlTable.name = xmlLegacyTable.name;
        xmlTable.alias = xmlLegacyTable.alias;
        if (xmlLegacyTable.filter != null) {
            throw Util.needToImplement("translate xml table SQL filter for table '" + (Object)((Object)xmlLegacyTable) + "'");
        }
        return xmlTable;
    }

    private MondrianDef.InlineTable convert(Mondrian3Def.InlineTable xmlLegacyInlineTable) {
        MondrianDef.InlineTable xmlInlineTable = new MondrianDef.InlineTable();
        List<MondrianDef.RealOrCalcColumnDef> xmlColumnDefs = xmlInlineTable.children.holder(new MondrianDef.ColumnDefs()).list();
        for (Mondrian3Def.RealOrCalcColumnDef xmlLegacyColumnDef : xmlLegacyInlineTable.columnDefs.array) {
            xmlColumnDefs.add(this.convert((Mondrian3Def.ColumnDef)xmlLegacyColumnDef));
        }
        assert (xmlColumnDefs.size() > 0) : "Inline tables must have at least one column to work properly in Mondrian 4+.";
        List<MondrianDef.Column> xmlKeys = xmlInlineTable.children.holder(new MondrianDef.Key()).list();
        MondrianDef.Key key = new MondrianDef.Key();
        MondrianDef.Column column = new MondrianDef.Column();
        column.name = xmlColumnDefs.get((int)0).name;
        column.table = xmlLegacyInlineTable.alias;
        key.array = new MondrianDef.Column[1];
        key.array[0] = column;
        key.name = "key$0";
        xmlKeys.add(column);
        List<MondrianDef.Row> xmlRows = xmlInlineTable.children.holder(new MondrianDef.Rows()).list();
        for (Mondrian3Def.Row xmlLegacyRow : xmlLegacyInlineTable.rows.array) {
            xmlRows.add(this.convert(xmlLegacyRow));
        }
        return xmlInlineTable;
    }

    private MondrianDef.Row convert(Mondrian3Def.Row xmlLegacyRow) {
        MondrianDef.Row xmlRow = new MondrianDef.Row();
        xmlRow.values = this.convert(xmlLegacyRow.values);
        return xmlRow;
    }

    private MondrianDef.Value[] convert(Mondrian3Def.Value[] xmlLegacyValues) {
        MondrianDef.Value[] xmlValues = new MondrianDef.Value[xmlLegacyValues.length];
        for (int i = 0; i < xmlValues.length; ++i) {
            xmlValues[i] = this.convert(xmlLegacyValues[i]);
        }
        return xmlValues;
    }

    private MondrianDef.Value convert(Mondrian3Def.Value xmlLegacyValue) {
        MondrianDef.Value xmlValue = new MondrianDef.Value();
        xmlValue.column = xmlLegacyValue.column;
        xmlValue.cdata = xmlLegacyValue.cdata;
        return xmlValue;
    }

    private MondrianDef.ColumnDef convert(Mondrian3Def.ColumnDef xmlLegacyColumnDef) {
        MondrianDef.ColumnDef xmlColumnDef = new MondrianDef.ColumnDef();
        xmlColumnDef.name = xmlLegacyColumnDef.name;
        xmlColumnDef.type = xmlLegacyColumnDef.type;
        return xmlColumnDef;
    }

    private MondrianDef.SQL[] convert(Mondrian3Def.SQL[] xmlLegacySqls) {
        MondrianDef.SQL[] xmlSqls = new MondrianDef.SQL[xmlLegacySqls.length];
        for (int i = 0; i < xmlLegacySqls.length; ++i) {
            xmlSqls[i] = this.convert(xmlLegacySqls[i]);
        }
        return xmlSqls;
    }

    private MondrianDef.SQL convert(Mondrian3Def.SQL xmlLegacySql) {
        MondrianDef.SQL xmlSql = new MondrianDef.SQL();
        xmlSql.dialect = xmlLegacySql.dialect;
        xmlSql.children = new NodeDef[]{new TextDef(xmlLegacySql.getCData())};
        return xmlSql;
    }

    private MondrianDef.ExpressionView convert(RolapSchema.PhysRelation relation, Map<String, RolapSchema.PhysRelation> relations, String levelUniqueName, Mondrian3Def.ExpressionView xmlLegacyExpressionView) {
        Mondrian3Def.SQL[] xmlLegacySqls = xmlLegacyExpressionView.expressions;
        MondrianDef.SQL[] xmlSqls = new MondrianDef.SQL[xmlLegacySqls.length];
        for (int i = 0; i < xmlLegacySqls.length; ++i) {
            xmlSqls[i] = this.convert(relation, relations, levelUniqueName, xmlLegacySqls[i]);
        }
        MondrianDef.ExpressionView xmlExpressionView = new MondrianDef.ExpressionView();
        xmlExpressionView.expressions = xmlSqls;
        return xmlExpressionView;
    }

    private MondrianDef.SQL convert(RolapSchema.PhysRelation relation, Map<String, RolapSchema.PhysRelation> relations, String levelUniqueName, Mondrian3Def.SQL xmlLegacySql) {
        List<NodeDef> list = this.asdasd(relation, relations, levelUniqueName, xmlLegacySql);
        MondrianDef.SQL xmlSql = new MondrianDef.SQL();
        xmlSql.children = list.toArray(new NodeDef[list.size()]);
        xmlSql.dialect = xmlLegacySql.dialect;
        return xmlSql;
    }

    private List<NodeDef> asdasd(RolapSchema.PhysRelation relation, Map<String, RolapSchema.PhysRelation> relations, String levelUniqueName, Mondrian3Def.SQL legacySql) {
        ArrayList<NodeDef> list = new ArrayList<NodeDef>();
        for (NodeDef legacyChild : legacySql.children) {
            if (legacyChild instanceof TextDef) {
                TextDef text = (TextDef)legacyChild;
                list.add((NodeDef)text);
                continue;
            }
            if (legacyChild instanceof Mondrian3Def.Column) {
                RolapSchema.PhysRelation relation2;
                Mondrian3Def.Column legacyColumn = (Mondrian3Def.Column)legacyChild;
                if (legacyColumn.table != null) {
                    Util.assertTrue(relations.containsKey(legacyColumn.table));
                    relation2 = relations.get(legacyColumn.table);
                } else {
                    relation2 = relation;
                }
                MondrianDef.Column column = this.registerLevelColumn(relation2, legacyColumn.name, relations, levelUniqueName);
                list.add(column);
                continue;
            }
            throw Util.newInternal("unexpected element in expression: " + legacyChild.getName());
        }
        return list;
    }

    public static Map<String, String> buildHintMap(Mondrian3Def.Hint[] hints) {
        if (hints == null || hints.length == 0) {
            return Collections.emptyMap();
        }
        HashMap<String, String> hintMap = new HashMap<String, String>();
        for (Mondrian3Def.Hint hint : hints) {
            hintMap.put(hint.type, hint.cdata);
        }
        return hintMap;
    }

    private static List<Mondrian3Def.DimensionUsage> lookupSharedDimension(Mondrian3Def.Cube xmlCube, String sharedDimName) {
        ArrayList<Mondrian3Def.DimensionUsage> usageList = new ArrayList<Mondrian3Def.DimensionUsage>();
        for (Mondrian3Def.CubeDimension xmlCubeDimension : xmlCube.dimensions) {
            if (!(xmlCubeDimension instanceof Mondrian3Def.DimensionUsage)) continue;
            Mondrian3Def.DimensionUsage dimensionUsage = (Mondrian3Def.DimensionUsage)xmlCubeDimension;
            if (!dimensionUsage.source.equals(sharedDimName)) continue;
            usageList.add(dimensionUsage);
        }
        return usageList;
    }

    public MondrianDef.Schema convertSchema(Mondrian3Def.Schema xmlLegacySchema) {
        MondrianDef.Schema xmlSchema = new MondrianDef.Schema();
        xmlSchema.name = xmlLegacySchema.name;
        xmlSchema.metamodelVersion = MondrianServer.forConnection(this.schema.getInternalConnection()).getVersion().getVersionString();
        xmlSchema.missingLink = "ignore";
        ArrayList<LevelInfo> levelList = new ArrayList<LevelInfo>();
        for (Mondrian3Def.Dimension dimension : xmlLegacySchema.dimensions) {
            xmlSchema.children.add(this.convertSharedDimension(dimension, levelList));
        }
        for (ElementDef elementDef : xmlLegacySchema.cubes) {
            xmlSchema.children.add(this.convertCube(xmlLegacySchema, (Mondrian3Def.Cube)elementDef));
        }
        for (ElementDef elementDef : xmlLegacySchema.virtualCubes) {
            xmlSchema.children.add(this.convertVirtualCube(xmlLegacySchema, (Mondrian3Def.VirtualCube)elementDef));
        }
        for (ElementDef elementDef : xmlLegacySchema.namedSets) {
            xmlSchema.children.add(this.convertNamedSet((Mondrian3Def.NamedSet)elementDef));
        }
        for (ElementDef elementDef : xmlLegacySchema.parameters) {
            xmlSchema.children.add(this.convertParameter((Mondrian3Def.Parameter)elementDef));
        }
        for (ElementDef elementDef : xmlLegacySchema.roles) {
            xmlSchema.children.add(this.convertRole((Mondrian3Def.Role)elementDef));
        }
        MondrianDef.PhysicalSchema xmlPhysicalSchema = this.physSchemaConverter.toDef(this.physSchemaConverter.physSchema);
        xmlSchema.children.add(0, xmlPhysicalSchema);
        this.convertAnnotations(xmlSchema.children, xmlLegacySchema.annotations);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)xmlSchema.toXML());
        }
        return xmlSchema;
    }

    private MondrianDef.Parameter convertParameter(Mondrian3Def.Parameter xmlLegacyParameter) {
        MondrianDef.Parameter xmlParameter = new MondrianDef.Parameter();
        xmlParameter.name = xmlLegacyParameter.name;
        xmlParameter.defaultValue = xmlLegacyParameter.defaultValue;
        xmlParameter.description = xmlLegacyParameter.description;
        xmlParameter.modifiable = xmlLegacyParameter.modifiable;
        xmlParameter.type = xmlLegacyParameter.type;
        return xmlParameter;
    }

    private MondrianDef.Cube convertVirtualCube(Mondrian3Def.Schema xmlLegacySchema, Mondrian3Def.VirtualCube xmlLegacyVirtualCube) {
        MondrianDef.Cube xmlCube = new MondrianDef.Cube();
        xmlCube.name = xmlLegacyVirtualCube.name;
        xmlCube.cache = true;
        xmlCube.caption = xmlLegacyVirtualCube.caption;
        xmlCube.defaultMeasure = xmlLegacyVirtualCube.defaultMeasure;
        xmlCube.description = xmlLegacyVirtualCube.description;
        xmlCube.enabled = xmlLegacyVirtualCube.enabled;
        xmlCube.enableScenarios = false;
        xmlCube.visible = xmlLegacyVirtualCube.visible;
        this.convertAnnotations(xmlCube.children, xmlLegacyVirtualCube.annotations);
        Pair<Set<String>, Map<String, Info>> pair = this.buildInfoMap(xmlLegacySchema, xmlLegacyVirtualCube);
        Set dimensionNames = (Set)pair.left;
        Map infoMap = (Map)pair.right;
        NamedList<MondrianDef.MeasureGroup> xmlMeasureGroups = xmlCube.children.holder(new MondrianDef.MeasureGroups()).list();
        for (Info info : infoMap.values()) {
            MondrianDef.MeasureGroup xmlMeasureGroup;
            info.xmlMeasureGroup = xmlMeasureGroup = new MondrianDef.MeasureGroup();
            xmlMeasureGroup.type = "fact";
            xmlMeasureGroup.ignoreUnrelatedDimensions = info.ignoreUnrelatedDimensions;
            xmlMeasureGroup.table = info.xmlLegacyCube.fact.getAlias();
            xmlMeasureGroup.name = info.cubeName;
            xmlMeasureGroups.add((Object)xmlMeasureGroup);
        }
        LinkedHashMap<String, MondrianDef.Dimension> xmlDimensionMap = new LinkedHashMap<String, MondrianDef.Dimension>();
        for (Mondrian3Def.VirtualCubeDimension xmlVirtualCubeDimension : xmlLegacyVirtualCube.dimensions) {
            List<Object> cubeInfoList;
            if (xmlVirtualCubeDimension.cubeName == null) {
                cubeInfoList = new ArrayList();
                for (Info info : infoMap.values()) {
                    cubeInfoList.add(this.lookupCube(info.cubeName));
                }
            } else {
                cubeInfoList = Collections.singletonList(this.lookupCube(xmlVirtualCubeDimension.cubeName));
            }
            int nonJoinCount = 0;
            for (CubeInfo cubeInfo : cubeInfoList) {
                Mondrian3Def.CubeDimension xmlLegacyCubeDimension = this.lookupDimension(cubeInfo.xmlLegacyCube, xmlVirtualCubeDimension.name);
                ArrayList<LevelInfo> levelList = new ArrayList<LevelInfo>();
                if (xmlLegacyCubeDimension == null) {
                    if (xmlVirtualCubeDimension.cubeName == null) {
                        ++nonJoinCount;
                        continue;
                    }
                    throw Util.newError("Dimension '" + xmlVirtualCubeDimension.name + "' not found in base cube '" + cubeInfo.xmlLegacyCube.name + "'");
                }
                MondrianDef.Dimension xmlDimension = this.convertCubeDimension(infoMap, xmlLegacyVirtualCube.name, xmlDimensionMap, cubeInfo.fact, cubeInfo.xmlFact, xmlLegacyCubeDimension, xmlVirtualCubeDimension.visible, xmlLegacySchema, levelList);
                cubeInfo.dimensionKeys.put(xmlDimension.name, xmlLegacyCubeDimension.foreignKey);
            }
            if (nonJoinCount != cubeInfoList.size()) continue;
            this.loader.getHandler().error("Virtual cube dimension must join to at least one cube: dimension '" + xmlVirtualCubeDimension.name + "' in cube '" + xmlLegacyVirtualCube.name + "'", (NodeDef)xmlVirtualCubeDimension, null);
        }
        xmlCube.children.holder(new MondrianDef.Dimensions()).list().addAll(xmlDimensionMap.values());
        HashSet<String> measureNames = new HashSet<String>();
        for (Mondrian3Def.VirtualCubeMeasure xmlLegacyMeasure : xmlLegacyVirtualCube.measures) {
            this.convertVirtualCubeMeasure(xmlCube, measureNames, infoMap, xmlLegacyMeasure);
        }
        for (Info info : infoMap.values()) {
            this.convertMeasureLinks(info.xmlLegacyCube, info.xmlMeasureGroup, this.cubeInfoMap.get((Object)info.cubeName).dimensionKeys);
        }
        NamedList<MondrianDef.CalculatedMember> xmlCalcMembers = xmlCube.children.holder(new MondrianDef.CalculatedMembers()).list();
        NamedList<MondrianDef.NamedSet> xmlNamedSets = xmlCube.children.holder(new MondrianDef.NamedSets()).list();
        for (Mondrian3Def.CalculatedMember calculatedMember : xmlLegacyVirtualCube.calculatedMembers) {
            xmlCalcMembers.add((Object)this.convertCalculatedMember(calculatedMember));
        }
        for (ElementDef elementDef : xmlLegacyVirtualCube.namedSets) {
            xmlNamedSets.add((Object)this.convertNamedSet((Mondrian3Def.NamedSet)elementDef));
        }
        return xmlCube;
    }

    private void convertVirtualCubeMeasure(MondrianDef.Cube xmlCube, Set<String> calcMeasureNames, Map<String, Info> infoMap, Mondrian3Def.VirtualCubeMeasure xmlLegacyMeasure) {
        Info info = infoMap.get(xmlLegacyMeasure.cubeName);
        assert (info != null);
        Mondrian3Def.Measure xmlLegacyBaseMeasure = this.lookupMeasure(info.xmlLegacyCube, xmlLegacyMeasure.name);
        if (xmlLegacyBaseMeasure != null) {
            MondrianDef.Measure xmlMeasure = this.convertMeasure(this.cubeInfoMap.get((Object)info.cubeName).fact, xmlLegacyBaseMeasure);
            xmlMeasure.visible = RolapSchemaLoader.toBoolean(xmlLegacyMeasure.visible, true);
            this.convertAnnotations(xmlMeasure.children, xmlLegacyMeasure.annotations);
            info.xmlMeasureGroup.children.holder(new MondrianDef.Measures()).list().add((Object)xmlMeasure);
            return;
        }
        Mondrian3Def.CalculatedMember xmlLegacyBaseCalcMeasure = this.lookupCalcMember(info.xmlLegacyCube, xmlLegacyMeasure.name);
        if (xmlLegacyBaseCalcMeasure != null) {
            MondrianDef.CalculatedMember xmlCalcMember = this.convertCalculatedMember(xmlLegacyBaseCalcMeasure);
            xmlCalcMember.visible = RolapSchemaLoader.toBoolean(xmlLegacyMeasure.visible, true);
            xmlCube.children.holder(new MondrianDef.CalculatedMembers()).list().add((Object)xmlCalcMember);
            calcMeasureNames.add(xmlLegacyBaseCalcMeasure.name);
            return;
        }
        throw Util.newInternal("could not find measure '" + xmlLegacyMeasure.name + "' in cube '" + xmlLegacyMeasure.cubeName + "'");
    }

    private Mondrian3Def.CalculatedMember lookupCalcMember(Mondrian3Def.Cube xmlCube, String name) {
        for (Mondrian3Def.CalculatedMember xmlCalcMember : xmlCube.calculatedMembers) {
            String uniqueName = "[" + xmlCalcMember.dimension + "].[" + xmlCalcMember.name + "]";
            if (!uniqueName.equals(name)) continue;
            return xmlCalcMember;
        }
        return null;
    }

    private Mondrian3Def.Measure lookupMeasure(Mondrian3Def.Cube xmlCube, String name) {
        for (Mondrian3Def.Measure xmlMeasure : xmlCube.measures) {
            if (!("[Measures].[" + xmlMeasure.name + "]").equals(name)) continue;
            return xmlMeasure;
        }
        return null;
    }

    private CubeInfo lookupCube(String cubeName) {
        return this.cubeInfoMap.get(cubeName);
    }

    private Mondrian3Def.CubeDimension lookupDimension(Mondrian3Def.Cube xmlCube, String name) {
        for (Mondrian3Def.CubeDimension xmlDimension : xmlCube.dimensions) {
            if (!xmlDimension.name.equals(name)) continue;
            return xmlDimension;
        }
        return null;
    }

    private void convertAnnotations(MondrianDef.Children<?> children, Mondrian3Def.Annotations annotations) {
        if (annotations == null) {
            return;
        }
        NamedList<MondrianDef.Annotation> xmlAnnotations = children.holder(new MondrianDef.Annotations()).list();
        for (Mondrian3Def.Annotation xmlLegacyAnnotation : annotations.array) {
            MondrianDef.Annotation xmlAnnotation = new MondrianDef.Annotation();
            xmlAnnotation.name = xmlLegacyAnnotation.name;
            xmlAnnotation.cdata = xmlLegacyAnnotation.cdata;
            xmlAnnotations.add(xmlAnnotation);
        }
    }

    private MondrianDef.Dimension convertSharedDimension(Mondrian3Def.Dimension xmlLegacyDimension, List<LevelInfo> levelList) {
        return this.convertDimension(null, new HashMap<String, MondrianDef.Dimension>(), null, xmlLegacyDimension, xmlLegacyDimension.name, xmlLegacyDimension.visible, xmlLegacyDimension.description, levelList);
    }

    public MondrianDef.Dimension convertDimension(List<Link> links, Map<String, MondrianDef.Dimension> xmlDimensionMap, Mondrian3Def.RelationOrJoin xmlLegacyFact, Mondrian3Def.Dimension xmlLegacyDimension, String dimensionName, boolean visible, String description, List<LevelInfo> levelList) {
        assert (dimensionName != null);
        MondrianDef.Dimension xmlDimension = new MondrianDef.Dimension();
        xmlDimension.name = dimensionName;
        xmlDimension.visible = visible;
        NamedList<MondrianDef.Hierarchy> hierarchyList = xmlDimension.children.holder(new MondrianDef.Hierarchies()).list();
        xmlDimension.caption = xmlLegacyDimension.caption;
        xmlDimension.description = description;
        if (xmlLegacyDimension.highCardinality.booleanValue()) {
            LOGGER.warn((Object)("Removing unsupported highCardinality attribute from " + dimensionName));
        }
        Util.discard((Object)xmlLegacyDimension.highCardinality);
        xmlDimension.type = xmlLegacyDimension.type == null || xmlLegacyDimension.type.equalsIgnoreCase("StandardDimension") ? null : (xmlLegacyDimension.type.equalsIgnoreCase("TimeDimension") ? "TIME" : xmlLegacyDimension.type);
        xmlDimension.hanger = false;
        Util.discard((Object)xmlLegacyDimension.usagePrefix);
        MondrianDef.Attribute[] xmlKeyAttributes = new MondrianDef.Attribute[]{null};
        for (int i = 0; i < xmlLegacyDimension.hierarchies.length; ++i) {
            hierarchyList.add(this.convertHierarchy(links, xmlLegacyFact, xmlLegacyDimension.hierarchies[i], xmlDimension, xmlKeyAttributes, levelList));
        }
        MondrianDef.Attribute xmlKeyAttribute = xmlKeyAttributes[0];
        if (xmlKeyAttribute != null) {
            xmlDimension.key = xmlKeyAttribute.name;
        }
        if (xmlDimensionMap.containsKey(dimensionName)) {
            return xmlDimensionMap.get(dimensionName);
        }
        xmlDimensionMap.put(dimensionName, xmlDimension);
        this.physSchemaConverter.legacyMap.put(xmlDimension, xmlLegacyDimension);
        return xmlDimension;
    }

    private MondrianDef.Hierarchy convertHierarchy(List<Link> links, Mondrian3Def.RelationOrJoin xmlLegacyFact, Mondrian3Def.Hierarchy xmlLegacyHierarchy, MondrianDef.Dimension xmlDimension, MondrianDef.Attribute[] xmlKeyAttributes, List<LevelInfo> levelList) {
        MondrianDef.Hierarchy xmlHierarchy;
        block11: {
            MondrianDef.Attribute xmlKeyAttribute;
            block14: {
                block12: {
                    RolapSchema.PhysRelation firstRelation;
                    block13: {
                        Mondrian3Def.RelationOrJoin xmlLegacyRelation;
                        xmlHierarchy = new MondrianDef.Hierarchy();
                        xmlHierarchy.allLevelName = xmlLegacyHierarchy.allLevelName;
                        xmlHierarchy.allMemberCaption = xmlLegacyHierarchy.allMemberCaption;
                        xmlHierarchy.allMemberName = xmlLegacyHierarchy.allMemberName;
                        xmlHierarchy.defaultMember = xmlLegacyHierarchy.defaultMember;
                        xmlHierarchy.hasAll = xmlLegacyHierarchy.hasAll;
                        xmlHierarchy.visible = xmlLegacyHierarchy.visible;
                        if (xmlLegacyHierarchy.name == null) {
                            xmlHierarchy.name = xmlDimension.name;
                            xmlHierarchy.caption = Util.first(xmlLegacyHierarchy.caption, xmlDimension.caption);
                            xmlHierarchy.description = Util.first(xmlLegacyHierarchy.description, xmlDimension.description);
                        } else {
                            xmlHierarchy.name = xmlLegacyHierarchy.name;
                            xmlHierarchy.caption = xmlLegacyHierarchy.caption;
                            xmlHierarchy.description = xmlLegacyHierarchy.description;
                        }
                        Util.discard((Object)xmlLegacyHierarchy.memberReaderClass);
                        Util.discard((Object)xmlLegacyHierarchy.memberReaderParameters);
                        this.convertAnnotations(xmlHierarchy.children, xmlLegacyHierarchy.annotations);
                        HashMap<String, RolapSchema.PhysRelation> relations = new HashMap<String, RolapSchema.PhysRelation>();
                        Mondrian3Def.RelationOrJoin relationOrJoin = xmlLegacyRelation = xmlLegacyHierarchy.relation != null ? xmlLegacyHierarchy.relation : xmlLegacyFact;
                        if (xmlLegacyRelation == null) {
                            throw this.physSchemaConverter.getHandler().fatal("Hierarchy in legacy-style schema must include a relation", (NodeDef)xmlLegacyHierarchy, null);
                        }
                        ArrayList<String> tableNames = new ArrayList<String>();
                        this.gatherTableNames(xmlLegacyRelation, tableNames);
                        if (xmlLegacyHierarchy.primaryKeyTable != null && !tableNames.contains(xmlLegacyHierarchy.primaryKeyTable)) {
                            this.physSchemaConverter.getHandler().error("Table '" + xmlLegacyHierarchy.primaryKeyTable + "' not found", (NodeDef)xmlLegacyHierarchy, "primaryKeyTable");
                            this.physSchemaConverter.legacyMap.put(xmlHierarchy, xmlLegacyHierarchy);
                            return xmlHierarchy;
                        }
                        RolapSchema.PhysRelation soleRelation = null;
                        if (links != null) {
                            for (Link link : links) {
                                this.registerRelation(link.fact, xmlLegacyRelation, link.foreignKey, link.fact.getAlias(), xmlLegacyHierarchy.primaryKey, xmlLegacyHierarchy.primaryKeyTable, false, relations);
                            }
                            if (relations.size() == 1) {
                                soleRelation = (RolapSchema.PhysRelation)relations.values().iterator().next();
                            }
                        } else {
                            soleRelation = this.registerRelation(null, xmlLegacyRelation, null, null, xmlLegacyHierarchy.primaryKey, xmlLegacyHierarchy.primaryKeyTable, false, relations);
                        }
                        for (int i = 0; i < xmlLegacyHierarchy.levels.length; ++i) {
                            xmlHierarchy.children.add(this.convertLevel(xmlDimension, xmlHierarchy, xmlLegacyHierarchy, i, xmlLegacyHierarchy.levels[i], relations, soleRelation, links, levelList));
                        }
                        if (xmlKeyAttributes[0] != null) break block11;
                        if (xmlLegacyHierarchy.primaryKey == null) break block12;
                        xmlKeyAttribute = new MondrianDef.Attribute();
                        xmlKeyAttribute.name = "$Id";
                        xmlKeyAttribute.keyColumn = xmlLegacyHierarchy.primaryKey;
                        firstRelation = soleRelation;
                        if (xmlLegacyHierarchy.primaryKeyTable != null) {
                            for (RolapSchema.PhysRelation relation : relations.values()) {
                                if (!relation.getAlias().equals(xmlLegacyHierarchy.primaryKeyTable)) continue;
                                firstRelation = relation;
                            }
                        }
                        if (firstRelation != null) break block13;
                        this.loader.getHandler().error("could not find table for hierarchy's key", (NodeDef)xmlLegacyHierarchy, "primaryKey");
                        break block11;
                    }
                    xmlKeyAttribute.table = firstRelation.getAlias();
                    xmlKeyAttribute.levelType = "Regular";
                    xmlKeyAttribute.hasHierarchy = false;
                    xmlDimension.children.holder(new MondrianDef.Attributes()).list().add((Object)xmlKeyAttribute);
                    MondrianDef.Relation xmlRelation = this.physSchemaConverter.xmlTables.get(firstRelation.getAlias());
                    this.addKey(xmlRelation, xmlKeyAttribute.keyColumn);
                    firstRelation.lookupKey(Collections.singletonList(firstRelation.getColumn(xmlKeyAttribute.keyColumn, true)), true);
                    break block14;
                }
                xmlKeyAttribute = (MondrianDef.Attribute)xmlDimension.getAttributes().get(((MondrianDef.Level)xmlHierarchy.getLevels().get((int)0)).attribute);
            }
            xmlKeyAttributes[0] = xmlKeyAttribute;
        }
        this.physSchemaConverter.legacyMap.put(xmlHierarchy, xmlLegacyHierarchy);
        return xmlHierarchy;
    }

    private void addKey(MondrianDef.Relation xmlRelation, String ... keyColumns) {
        if (xmlRelation instanceof MondrianDef.Table) {
            MondrianDef.Table xmlTable = (MondrianDef.Table)xmlRelation;
            for (String keyColumn : keyColumns) {
                MondrianDef.Column xmlColumn = new MondrianDef.Column();
                xmlColumn.name = keyColumn;
                xmlTable.children.holder(new MondrianDef.Key()).list().add(xmlColumn);
            }
        }
    }

    private void gatherTableNames(Mondrian3Def.RelationOrJoin xmlRelation, List<String> tableNames) {
        if (xmlRelation instanceof Mondrian3Def.Join) {
            Mondrian3Def.Join join = (Mondrian3Def.Join)xmlRelation;
            this.gatherTableNames(join.left, tableNames);
            this.gatherTableNames(join.right, tableNames);
        } else {
            Mondrian3Def.Relation relation = (Mondrian3Def.Relation)xmlRelation;
            tableNames.add(relation.getAlias());
        }
    }

    private RolapSchema.PhysRelation registerRelation(RolapSchema.PhysRelation leftRelation, Mondrian3Def.RelationOrJoin relationOrJoin, String leftKeyColumnName, String leftAlias, String rightKeyColumnName, String rightAlias, boolean hardLink, Map<String, RolapSchema.PhysRelation> relations) {
        RolapSchema.PhysRelation rightRelation;
        RolapSchema.PhysRelation midRelation;
        assert (leftKeyColumnName == null || leftRelation != null);
        assert (relationOrJoin != null);
        if (relationOrJoin instanceof Mondrian3Def.Join) {
            Mondrian3Def.Join join = (Mondrian3Def.Join)relationOrJoin;
            midRelation = this.registerRelation(leftRelation, join.left, leftKeyColumnName, leftAlias, rightKeyColumnName, rightAlias, false, relations);
            rightRelation = this.registerRelation(midRelation, join.right, join.leftKey, join.leftAlias, join.rightKey, join.rightAlias, true, relations);
        } else {
            RolapSchema.PhysKey rightKey;
            Mondrian3Def.Relation relation = (Mondrian3Def.Relation)relationOrJoin;
            midRelation = rightRelation = this.toPhysRelation(relation);
            if (rightRelation instanceof RolapSchema.PhysTable) {
                RolapSchema.PhysTable physTable = (RolapSchema.PhysTable)rightRelation;
                physTable.ensurePopulated(this.loader, (NodeDef)relation);
            }
            if (rightKeyColumnName != null) {
                RolapSchema.PhysColumn rightColumn = rightRelation.getColumn(rightKeyColumnName, false);
                if (rightColumn == null) {
                    throw new IllegalArgumentException();
                }
                List<RolapSchema.PhysColumn> keyColumnList = Collections.singletonList(rightColumn);
                rightKey = rightRelation.lookupKey(keyColumnList, true);
                if (rightAlias != null && relation.getAlias() != null && !rightAlias.equals(relation.getAlias())) {
                    throw new IllegalArgumentException("right alias " + rightAlias + " != table alias " + relation.getAlias());
                }
            } else {
                rightKey = null;
            }
            relations.put(rightRelation.getAlias(), rightRelation);
            if (leftKeyColumnName != null) {
                RolapSchema.PhysColumn leftColumn = leftRelation.getColumn(leftKeyColumnName, false);
                if (leftColumn == null) {
                    throw Util.newInternal("Relation " + leftRelation + " does not contain column " + leftKeyColumnName);
                }
                List<RolapSchema.PhysColumn> leftKeyColumnList = Collections.singletonList(leftColumn);
                assert (rightKey != null);
                this.physSchemaConverter.physSchema.addLink(rightKey, leftRelation, leftKeyColumnList, hardLink);
            }
        }
        if (rightKeyColumnName != null) {
            RolapSchema.PhysColumn column = midRelation.getColumn(rightKeyColumnName, false);
            if (column == null) {
                throw new IllegalArgumentException("right relation=" + rightRelation + ", right key=" + rightKeyColumnName);
            }
            List<RolapSchema.PhysColumn> keyColumnList = Collections.singletonList(column);
            RolapSchema.PhysKey midKey = midRelation.lookupKey(keyColumnList, true);
        }
        return rightRelation;
    }

    private MondrianDef.Level convertLevel(MondrianDef.Dimension xmlDimension, MondrianDef.Hierarchy xmlHierarchy, Mondrian3Def.Hierarchy xmlLegacyHierarchy, int ordinal, Mondrian3Def.Level xmlLegacyLevel, Map<String, RolapSchema.PhysRelation> relations, RolapSchema.PhysRelation relation, List<Link> links, List<LevelInfo> levelList) {
        NamedList<MondrianDef.Attribute> attributeList = xmlDimension.children.holder(new MondrianDef.Attributes()).list();
        MondrianDef.Attribute xmlAttribute = new MondrianDef.Attribute();
        attributeList.add((Object)xmlAttribute);
        xmlAttribute.approxRowCount = xmlLegacyLevel.approxRowCount;
        xmlAttribute.caption = xmlLegacyLevel.caption;
        xmlAttribute.captionColumn = xmlLegacyLevel.captionColumn;
        xmlAttribute.keyColumn = xmlLegacyLevel.column;
        xmlAttribute.name = Util.uniquify(xmlLegacyLevel.name, Integer.MAX_VALUE, new ArrayList<String>(this.names(attributeList)));
        this.convertMemberFormatter(xmlLegacyLevel.formatter, xmlLegacyLevel.memberFormatter, xmlAttribute.children);
        MondrianDef.Level xmlLevel = new MondrianDef.Level();
        xmlLevel.caption = null;
        if (xmlLegacyLevel.table != null) {
            relation = this.physSchemaConverter.getPhysRelation(xmlLegacyLevel.table, true);
        }
        xmlLevel.name = xmlLegacyLevel.name;
        xmlLevel.attribute = xmlAttribute.name;
        xmlLevel.visible = xmlLegacyLevel.visible;
        xmlAttribute.table = relation == null ? null : relation.getAlias();
        xmlLevel.hideMemberIf = xmlLegacyLevel.hideMemberIf;
        xmlLevel.description = xmlLegacyLevel.description;
        xmlLevel.caption = xmlLegacyLevel.caption;
        this.convertAnnotations(xmlLevel.children, xmlLegacyLevel.annotations);
        xmlAttribute.levelType = xmlLegacyLevel.levelType;
        xmlAttribute.hasHierarchy = false;
        String levelUniqueName = null;
        MondrianDef.Column keyColumn = this.convertColumnOrExpr(relation, xmlLegacyLevel.keyExp, xmlLegacyLevel.column, relations, levelUniqueName, MondrianDef.Key.class, xmlAttribute.children);
        xmlAttribute.keyColumn = null;
        levelList.add(new LevelInfo(xmlDimension.name, xmlHierarchy.name, xmlLevel.name, keyColumn.table, keyColumn.name));
        if (!xmlLegacyLevel.uniqueMembers.booleanValue() && ordinal > 0) {
            MondrianDef.Attribute prevAttribute = (MondrianDef.Attribute)attributeList.get(attributeList.size() - 2);
            xmlAttribute.children.holder(new MondrianDef.Key()).list().addAll(0, prevAttribute.getKey().list());
        }
        MondrianDef.Column n = this.convertColumnOrExpr(relation, xmlLegacyLevel.nameExp, xmlLegacyLevel.nameColumn, relations, levelUniqueName, MondrianDef.Name.class, xmlAttribute.children);
        xmlAttribute.nameColumn = null;
        if (xmlAttribute.getName_() == null && xmlAttribute.getKey().list().size() > 1) {
            xmlAttribute.children.holder(new MondrianDef.Name()).list().add(Util.last(xmlAttribute.getKey().list()));
        }
        this.convertColumnOrExpr(relation, xmlLegacyLevel.captionExp, xmlLegacyLevel.captionColumn, relations, levelUniqueName, MondrianDef.Caption.class, xmlAttribute.children);
        xmlAttribute.captionColumn = null;
        MondrianDef.Column x = this.convertColumnOrExpr(relation, xmlLegacyLevel.ordinalExp, xmlLegacyLevel.ordinalColumn, relations, levelUniqueName, MondrianDef.OrderBy.class, xmlAttribute.children);
        xmlAttribute.orderByColumn = null;
        if (x == null && n != null) {
            xmlAttribute.children.holder(new MondrianDef.OrderBy()).list().addAll(xmlAttribute.getKey().list());
        }
        if (xmlLegacyLevel.parentColumn != null || xmlLegacyLevel.parentExp != null) {
            MondrianDef.Attribute xmlParentAttribute = new MondrianDef.Attribute();
            attributeList.add(attributeList.size() - 1, (Object)xmlParentAttribute);
            xmlParentAttribute.name = xmlAttribute.name + "$Parent";
            xmlParentAttribute.levelType = "Regular";
            this.convertColumnOrExpr(relation, xmlLegacyLevel.parentExp, xmlLegacyLevel.parentColumn, relations, levelUniqueName, MondrianDef.Key.class, xmlParentAttribute.children);
            xmlLevel.parentAttribute = xmlParentAttribute.name;
            xmlLevel.nullParentValue = xmlLegacyLevel.nullParentValue;
            xmlParentAttribute.hasHierarchy = false;
            if (xmlLegacyLevel.closure != null) {
                RolapSchema.PhysRelation physClosureTable = this.toPhysRelation2(xmlLegacyLevel.closure.table);
                RolapSchema.PhysKey key = physClosureTable.addKey("primary", Collections.singletonList(physClosureTable.getColumn(xmlLegacyLevel.closure.childColumn, true)));
                this.physSchemaConverter.physSchema.addLink(relation.lookupKey(Collections.singletonList(relation.getColumn(keyColumn.name, false)), false), physClosureTable, Collections.singletonList(physClosureTable.getColumn(xmlLegacyLevel.closure.childColumn, true)), false);
                if (links != null) {
                    for (Link link : links) {
                        this.physSchemaConverter.physSchema.addLink(key, link.fact, Collections.singletonList(link.fact.getColumn(link.foreignKey, true)), false);
                    }
                }
                MondrianDef.Closure closure = new MondrianDef.Closure();
                closure.childColumn = xmlLegacyLevel.closure.childColumn;
                closure.parentColumn = xmlLegacyLevel.closure.parentColumn;
                closure.distanceColumn = "distance";
                closure.table = xmlLegacyLevel.closure.table.getAlias();
                this.physSchemaConverter.legacyMap.put(closure, xmlLegacyLevel.closure);
                xmlLevel.children.add(closure);
            }
        }
        for (int i = 0; i < xmlLegacyLevel.properties.length; ++i) {
            Mondrian3Def.Property xmlLegacyProperty = xmlLegacyLevel.properties[i];
            MondrianDef.Attribute xmlPropertyAttribute = new MondrianDef.Attribute();
            xmlPropertyAttribute.name = xmlAttribute.name + "$" + xmlLegacyProperty.name;
            xmlPropertyAttribute.datatype = xmlLegacyProperty.type;
            xmlPropertyAttribute.levelType = "Regular";
            xmlPropertyAttribute.hasHierarchy = false;
            this.convertColumnOrExpr(relation, null, xmlLegacyProperty.column, relations, levelUniqueName, MondrianDef.Key.class, xmlPropertyAttribute.children);
            attributeList.add((Object)xmlPropertyAttribute);
            MondrianDef.Property xmlProperty = this.convertProperty(xmlLegacyProperty, xmlPropertyAttribute.name);
            xmlAttribute.children.add(xmlProperty);
        }
        xmlAttribute.datatype = xmlLegacyLevel.type;
        boolean uniqueMembers = xmlLegacyLevel.uniqueMembers == null ? ordinal == 0 : xmlLegacyLevel.uniqueMembers;
        this.physSchemaConverter.legacyMap.put(xmlLevel, xmlLegacyLevel);
        return xmlLevel;
    }

    private <T extends MondrianDef.NamedElement> List<String> names(final NamedList<T> elementList) {
        return new AbstractList<String>(){

            @Override
            public String get(int index) {
                return ((MondrianDef.NamedElement)elementList.get(index)).getNameAttribute();
            }

            @Override
            public int size() {
                return elementList.size();
            }
        };
    }

    private void convertMemberFormatter(String formatter, Mondrian3Def.MemberFormatter xmlLegacyMemberFormatter, MondrianDef.Children<MondrianDef.AttributeElement> children) {
        if (formatter != null) {
            MondrianDef.MemberFormatter xmlMemberFormatter = new MondrianDef.MemberFormatter();
            xmlMemberFormatter.className = formatter;
            children.add(xmlMemberFormatter);
        } else if (xmlLegacyMemberFormatter != null) {
            MondrianDef.MemberFormatter xmlMemberFormatter = new MondrianDef.MemberFormatter();
            xmlMemberFormatter.className = xmlLegacyMemberFormatter.className;
            xmlMemberFormatter.script = this.convertScript(xmlLegacyMemberFormatter.script);
            children.add(xmlMemberFormatter);
        }
    }

    private MondrianDef.Property convertProperty(Mondrian3Def.Property xmlLegacyProperty, String sourceAttributeName) {
        MondrianDef.Property xmlProperty = new MondrianDef.Property();
        xmlProperty.caption = xmlLegacyProperty.caption;
        xmlProperty.formatter = xmlLegacyProperty.formatter;
        if (xmlLegacyProperty.propertyFormatter != null) {
            xmlProperty.children.add(this.convertPropertyFormatter(xmlLegacyProperty.propertyFormatter));
        }
        xmlProperty.name = xmlLegacyProperty.name;
        xmlProperty.description = xmlLegacyProperty.description;
        xmlProperty.caption = xmlLegacyProperty.caption;
        xmlProperty.attribute = sourceAttributeName;
        return xmlProperty;
    }

    private MondrianDef.PropertyFormatter convertPropertyFormatter(Mondrian3Def.PropertyFormatter xmlLegacyPropertyFormatter) {
        if (xmlLegacyPropertyFormatter == null) {
            return null;
        }
        MondrianDef.PropertyFormatter xmlPropertyFormatter = new MondrianDef.PropertyFormatter();
        xmlPropertyFormatter.className = xmlLegacyPropertyFormatter.className;
        xmlPropertyFormatter.script = this.convertScript(xmlLegacyPropertyFormatter.script);
        return xmlPropertyFormatter;
    }

    <T extends MondrianDef.Columns> MondrianDef.Column convertColumnOrExpr(RolapSchema.PhysRelation relation, Mondrian3Def.ExpressionView legacyExpression, String columnName, Map<String, RolapSchema.PhysRelation> relations, String levelUniqueName, Class<T> keyClass, MondrianDef.Children<MondrianDef.AttributeElement> attributeChildren) {
        MondrianDef.Column x = this.convertColumnOrExpr(relation, legacyExpression, columnName, relations, levelUniqueName);
        if (x != null) {
            try {
                MondrianDef.Columns xmlColumns = (MondrianDef.Columns)keyClass.newInstance();
                xmlColumns.array = new MondrianDef.Column[]{x};
                attributeChildren.add((MondrianDef.AttributeElement)((Object)xmlColumns));
            }
            catch (InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
        return x;
    }

    private MondrianDef.Column convertColumnOrExpr(RolapSchema.PhysRelation relation, Mondrian3Def.ExpressionView legacyExpression, String columnName, Map<String, RolapSchema.PhysRelation> relations, String levelUniqueName) {
        if (legacyExpression != null) {
            assert (columnName == null);
            return this.convertExpr(relation, legacyExpression, relations, levelUniqueName);
        }
        if (columnName != null) {
            return this.registerLevelColumn(relation, columnName, relations, levelUniqueName);
        }
        return null;
    }

    private MondrianDef.Column convertExpr(RolapSchema.PhysRelation relation, Mondrian3Def.ExpressionView legacyExpression, Map<String, RolapSchema.PhysRelation> relations, String levelUniqueName) {
        RolapSchema.PhysColumn physColumn;
        ArrayList<MondrianDef.SQL> xmlSqlList = new ArrayList<MondrianDef.SQL>();
        for (Mondrian3Def.SQL xmlLegacySql : legacyExpression.expressions) {
            NodeDef def;
            List<NodeDef> list = this.asdasd(relation, relations, levelUniqueName, xmlLegacySql);
            if (list.size() == 1 && (def = list.get(0)) instanceof MondrianDef.Column) {
                return (MondrianDef.Column)def;
            }
            MondrianDef.SQL xmlSql = new MondrianDef.SQL();
            xmlSql.children = list.toArray(new NodeDef[list.size()]);
            xmlSql.dialect = xmlLegacySql.dialect;
            xmlSqlList.add(xmlSql);
        }
        MondrianDef.ExpressionView xmlExpressionview = this.convert(relation, relations, levelUniqueName, legacyExpression);
        MondrianDef.Expression xmlExpression = this.optimize(xmlExpressionview);
        RolapSchema.PhysExpr measureExp = this.physSchemaConverter.toPhysExpr(relation, xmlExpression);
        if (measureExp instanceof RolapSchema.PhysColumn) {
            physColumn = (RolapSchema.PhysColumn)measureExp;
        } else {
            physColumn = this.physSchemaConverter.toPhysColumn(measureExp, legacyExpression, xmlExpressionview, relation);
            if (physColumn == null) {
                return null;
            }
        }
        if (physColumn instanceof RolapSchema.PhysCalcColumn) {
            MondrianDef.Table xmlTable = (MondrianDef.Table)this.physSchemaConverter.xmlTables.get(physColumn.relation.getAlias());
            MondrianDef.CalculatedColumnDef xmlCalcColumnDef = new MondrianDef.CalculatedColumnDef();
            xmlCalcColumnDef.name = physColumn.name;
            xmlCalcColumnDef.expression = xmlExpression;
            xmlTable.children.holder(new MondrianDef.ColumnDefs()).list().add(xmlCalcColumnDef);
        }
        MondrianDef.Column xmlColumn = new MondrianDef.Column();
        xmlColumn.table = physColumn.relation.getAlias();
        xmlColumn.name = physColumn.name;
        return xmlColumn;
    }

    private MondrianDef.Expression optimize(MondrianDef.ExpressionView xmlExpressionView) {
        if (xmlExpressionView.expressions.length == 1) {
            MondrianDef.SQL xmlExpression = xmlExpressionView.expressions[0];
            NodeDef xmlChild = xmlExpression.children[0];
            if (xmlExpression.children.length == 1 && xmlChild instanceof MondrianDef.Column) {
                return (MondrianDef.Column)xmlChild;
            }
        }
        return xmlExpressionView;
    }

    private MondrianDef.Column registerLevelColumn(RolapSchema.PhysRelation relation, String columnName, Map<String, RolapSchema.PhysRelation> relations, String levelUniqueName) {
        assert (relation != null);
        MondrianDef.Column column = new MondrianDef.Column();
        column.name = columnName;
        column.table = relation.getAlias();
        return column;
    }

    private MondrianDef.Measure convertMeasure(RolapSchema.PhysRelation fact, Mondrian3Def.Measure xmlLegacyMeasure) {
        MondrianDef.Column column;
        MondrianDef.Measure xmlMeasure = new MondrianDef.Measure();
        xmlMeasure.name = xmlLegacyMeasure.name;
        xmlMeasure.visible = xmlLegacyMeasure.visible;
        xmlMeasure.aggregator = xmlLegacyMeasure.aggregator;
        xmlMeasure.caption = xmlLegacyMeasure.caption;
        xmlMeasure.datatype = xmlLegacyMeasure.datatype;
        xmlMeasure.formatString = xmlLegacyMeasure.formatString;
        xmlMeasure.formatter = xmlLegacyMeasure.formatter;
        xmlMeasure.description = xmlLegacyMeasure.description;
        xmlMeasure.table = null;
        this.convertAnnotations(xmlMeasure.children, xmlLegacyMeasure.annotations);
        for (Mondrian3Def.CalculatedMemberProperty xmlLegacyMemberProperty : xmlLegacyMeasure.memberProperties) {
            if (xmlLegacyMemberProperty.name.equals("MEMBER_ORDINAL")) continue;
            xmlMeasure.children.add(this.convertMemberProperty(xmlLegacyMemberProperty));
        }
        if (xmlLegacyMeasure.cellFormatter != null) {
            xmlMeasure.children.add(this.convertCellFormatter(xmlLegacyMeasure.cellFormatter));
        }
        if ((column = this.convertColumnOrExpr(fact, xmlLegacyMeasure.measureExp, xmlLegacyMeasure.column, this.physSchemaConverter.physSchema.tablesByName, "MeasuresLevel")) != null) {
            MondrianDef.Arguments xmlArguments = new MondrianDef.Arguments();
            xmlMeasure.children.add(xmlArguments);
            xmlArguments.array = new MondrianDef.Column[]{column};
        }
        xmlMeasure.column = null;
        return xmlMeasure;
    }

    private MondrianDef.CalculatedMember convertCalculatedMember(Mondrian3Def.CalculatedMember xmlLegacyCalcMember) {
        MondrianDef.CalculatedMember xmlCalcMember = new MondrianDef.CalculatedMember();
        xmlCalcMember.caption = xmlLegacyCalcMember.caption;
        xmlCalcMember.description = xmlLegacyCalcMember.description;
        xmlCalcMember.formatString = xmlLegacyCalcMember.formatString;
        xmlCalcMember.formula = xmlLegacyCalcMember.formula;
        xmlCalcMember.dimension = xmlLegacyCalcMember.dimension;
        xmlCalcMember.hierarchy = xmlLegacyCalcMember.hierarchy;
        xmlCalcMember.parent = xmlLegacyCalcMember.parent;
        xmlCalcMember.name = xmlLegacyCalcMember.name;
        xmlCalcMember.visible = xmlLegacyCalcMember.visible;
        if (xmlLegacyCalcMember.formulaElement != null) {
            xmlCalcMember.children.add(this.convertFormula(xmlLegacyCalcMember.formulaElement));
        }
        if (xmlLegacyCalcMember.cellFormatter != null) {
            xmlCalcMember.children.add(this.convertCellFormatter(xmlLegacyCalcMember.cellFormatter));
        }
        this.convertAnnotations(xmlCalcMember.children, xmlLegacyCalcMember.annotations);
        this.convertCalcMemberProperties(xmlCalcMember.children, xmlLegacyCalcMember.memberProperties, true);
        return xmlCalcMember;
    }

    private void convertCalcMemberProperties(MondrianDef.Children<MondrianDef.CalculatedMemberElement> children, Mondrian3Def.CalculatedMemberProperty[] memberProperties, boolean skipOrdinal) {
        for (Mondrian3Def.CalculatedMemberProperty xmlLegacyMemberProperty : memberProperties) {
            if (skipOrdinal && xmlLegacyMemberProperty.name.equals("MEMBER_ORDINAL")) continue;
            children.add(this.convertMemberProperty(xmlLegacyMemberProperty));
        }
    }

    private MondrianDef.CellFormatter convertCellFormatter(Mondrian3Def.CellFormatter xmlLegacyCellFormatter) {
        MondrianDef.CellFormatter xmlCellFormatter = new MondrianDef.CellFormatter();
        xmlCellFormatter.className = xmlLegacyCellFormatter.className;
        xmlCellFormatter.script = this.convertScript(xmlLegacyCellFormatter.script);
        return xmlCellFormatter;
    }

    private MondrianDef.Script convertScript(Mondrian3Def.Script xmlLegacyScript) {
        if (xmlLegacyScript == null) {
            return null;
        }
        MondrianDef.Script xmlScript = new MondrianDef.Script();
        xmlScript.cdata = xmlLegacyScript.cdata;
        xmlScript.language = xmlLegacyScript.language;
        return xmlScript;
    }

    private MondrianDef.CalculatedMemberElement convertFormula(Mondrian3Def.Formula xmlLegacyFormula) {
        MondrianDef.Formula xmlFormula = new MondrianDef.Formula();
        xmlFormula.cdata = xmlLegacyFormula.cdata;
        return xmlFormula;
    }

    private MondrianDef.NamedSet convertNamedSet(Mondrian3Def.NamedSet xmlLegacyNamedSet) {
        MondrianDef.NamedSet xmlNamedSet = new MondrianDef.NamedSet();
        xmlNamedSet.name = xmlLegacyNamedSet.name;
        xmlNamedSet.caption = xmlLegacyNamedSet.caption;
        xmlNamedSet.description = xmlLegacyNamedSet.description;
        xmlNamedSet.formula = xmlLegacyNamedSet.formula;
        if (xmlLegacyNamedSet.formulaElement != null) {
            xmlNamedSet.children.add(this.convertFormula(xmlLegacyNamedSet.formulaElement));
        }
        this.convertAnnotations(xmlNamedSet.children, xmlLegacyNamedSet.annotations);
        return xmlNamedSet;
    }

    private MondrianDef.CalculatedMemberProperty convertMemberProperty(Mondrian3Def.CalculatedMemberProperty xmlLegacyMemberProperty) {
        MondrianDef.CalculatedMemberProperty xmlCalcMemProp = new MondrianDef.CalculatedMemberProperty();
        xmlCalcMemProp.caption = xmlLegacyMemberProperty.caption;
        xmlCalcMemProp.description = xmlLegacyMemberProperty.description;
        xmlCalcMemProp.expression = xmlLegacyMemberProperty.expression;
        xmlCalcMemProp.name = xmlLegacyMemberProperty.name;
        xmlCalcMemProp.value = xmlLegacyMemberProperty.value;
        return xmlCalcMemProp;
    }

    private MondrianDef.Role convertRole(Mondrian3Def.Role xmlLegacyRole) {
        MondrianDef.Role xmlRole = new MondrianDef.Role();
        xmlRole.name = xmlLegacyRole.name;
        if (xmlLegacyRole.union != null) {
            for (ElementDef elementDef : xmlLegacyRole.union.roleUsages) {
                xmlRole.children.holder(new MondrianDef.Union()).list().add(this.convertRoleUsage((Mondrian3Def.RoleUsage)elementDef));
            }
        }
        for (ElementDef elementDef : xmlLegacyRole.schemaGrants) {
            xmlRole.children.add(this.convertSchemaGrant((Mondrian3Def.SchemaGrant)elementDef));
        }
        this.convertAnnotations(xmlRole.children, xmlLegacyRole.annotations);
        return xmlRole;
    }

    private MondrianDef.RoleUsage convertRoleUsage(Mondrian3Def.RoleUsage xmlLegacyRoleUsage) {
        MondrianDef.RoleUsage xmlRoleUsage = new MondrianDef.RoleUsage();
        xmlRoleUsage.roleName = xmlLegacyRoleUsage.roleName;
        return xmlRoleUsage;
    }

    private MondrianDef.SchemaGrant convertSchemaGrant(Mondrian3Def.SchemaGrant xmlLegacySchemaGrant) {
        MondrianDef.SchemaGrant xmlSchemaGrant = new MondrianDef.SchemaGrant();
        xmlSchemaGrant.access = xmlLegacySchemaGrant.access;
        xmlSchemaGrant.cubeGrants = this.convertCubeGrants(xmlLegacySchemaGrant.cubeGrants);
        return xmlSchemaGrant;
    }

    private MondrianDef.CubeGrant[] convertCubeGrants(Mondrian3Def.CubeGrant[] xmlLegacyCubeGrants) {
        ArrayList<MondrianDef.CubeGrant> list = new ArrayList<MondrianDef.CubeGrant>();
        for (Mondrian3Def.CubeGrant xmlLegacyCubeGrant : xmlLegacyCubeGrants) {
            list.add(this.convertCubeGrant(xmlLegacyCubeGrant));
        }
        return list.toArray(new MondrianDef.CubeGrant[list.size()]);
    }

    private MondrianDef.CubeGrant convertCubeGrant(Mondrian3Def.CubeGrant xmlLegacyCubeGrant) {
        MondrianDef.CubeGrant xmlCubeGrant = new MondrianDef.CubeGrant();
        xmlCubeGrant.cube = xmlLegacyCubeGrant.cube;
        xmlCubeGrant.access = xmlLegacyCubeGrant.access;
        xmlCubeGrant.dimensionGrants = this.convertDimensionGrants(xmlLegacyCubeGrant.dimensionGrants);
        xmlCubeGrant.hierarchyGrants = this.convertHierarchyGrants(xmlLegacyCubeGrant.hierarchyGrants);
        return xmlCubeGrant;
    }

    private MondrianDef.DimensionGrant[] convertDimensionGrants(Mondrian3Def.DimensionGrant[] xmlLegacyDimensionGrants) {
        ArrayList<MondrianDef.DimensionGrant> list = new ArrayList<MondrianDef.DimensionGrant>();
        for (Mondrian3Def.DimensionGrant xmlLegacyDimensionGrant : xmlLegacyDimensionGrants) {
            list.add(this.convertDimensionGrant(xmlLegacyDimensionGrant));
        }
        return list.toArray(new MondrianDef.DimensionGrant[list.size()]);
    }

    private MondrianDef.DimensionGrant convertDimensionGrant(Mondrian3Def.DimensionGrant xmlLegacyDimensionGrant) {
        MondrianDef.DimensionGrant xmlDimensionGrant = new MondrianDef.DimensionGrant();
        xmlDimensionGrant.access = xmlLegacyDimensionGrant.access;
        xmlDimensionGrant.dimension = xmlLegacyDimensionGrant.dimension;
        return xmlDimensionGrant;
    }

    private MondrianDef.HierarchyGrant[] convertHierarchyGrants(Mondrian3Def.HierarchyGrant[] xmlLegacyHierarchyGrants) {
        ArrayList<MondrianDef.HierarchyGrant> list = new ArrayList<MondrianDef.HierarchyGrant>();
        for (Mondrian3Def.HierarchyGrant xmlLegacyHierarchyGrant : xmlLegacyHierarchyGrants) {
            list.add(this.convertHierarchyGrant(xmlLegacyHierarchyGrant));
        }
        return list.toArray(new MondrianDef.HierarchyGrant[list.size()]);
    }

    private MondrianDef.HierarchyGrant convertHierarchyGrant(Mondrian3Def.HierarchyGrant xmlLegacyHierarchyGrant) {
        MondrianDef.HierarchyGrant xmlHierarchyGrant = new MondrianDef.HierarchyGrant();
        xmlHierarchyGrant.access = xmlLegacyHierarchyGrant.access;
        xmlHierarchyGrant.topLevel = xmlLegacyHierarchyGrant.topLevel;
        xmlHierarchyGrant.bottomLevel = xmlLegacyHierarchyGrant.bottomLevel;
        xmlHierarchyGrant.hierarchy = xmlLegacyHierarchyGrant.hierarchy;
        xmlHierarchyGrant.rollupPolicy = xmlLegacyHierarchyGrant.rollupPolicy;
        xmlHierarchyGrant.memberGrants = this.convertMemberGrants(xmlLegacyHierarchyGrant.memberGrants);
        return xmlHierarchyGrant;
    }

    private MondrianDef.MemberGrant[] convertMemberGrants(Mondrian3Def.MemberGrant[] xmlLegacyMemberGrants) {
        ArrayList<MondrianDef.MemberGrant> list = new ArrayList<MondrianDef.MemberGrant>();
        for (Mondrian3Def.MemberGrant xmlLegacyMemberGrant : xmlLegacyMemberGrants) {
            list.add(this.convertMemberGrant(xmlLegacyMemberGrant));
        }
        return list.toArray(new MondrianDef.MemberGrant[list.size()]);
    }

    private MondrianDef.MemberGrant convertMemberGrant(Mondrian3Def.MemberGrant xmlLegacyMemberGrant) {
        MondrianDef.MemberGrant xmlMemberGrant = new MondrianDef.MemberGrant();
        xmlMemberGrant.access = xmlLegacyMemberGrant.access;
        xmlMemberGrant.member = xmlLegacyMemberGrant.member;
        return xmlMemberGrant;
    }

    static class LevelInfo {
        final String dimension;
        final String hierarchy;
        final String level;
        final String table;
        final String column;

        public LevelInfo(String dimension, String hierarchy, String level, String table, String column) {
            this.dimension = dimension;
            this.hierarchy = hierarchy;
            this.level = level;
            this.table = table;
            this.column = column;
        }
    }

    static class CubeInfo {
        final String name;
        final RolapSchema.PhysRelation fact;
        final Mondrian3Def.Relation xmlFact;
        final Mondrian3Def.Cube xmlLegacyCube;
        final Map<String, String> dimensionKeys = new LinkedHashMap<String, String>();

        public CubeInfo(String name, RolapSchema.PhysRelation fact, Mondrian3Def.Relation xmlFact, Mondrian3Def.Cube xmlLegacyCube) {
            this.name = name;
            this.fact = fact;
            this.xmlFact = xmlFact;
            this.xmlLegacyCube = xmlLegacyCube;
        }
    }

    static class Info {
        final String cubeName;
        final Mondrian3Def.Cube xmlLegacyCube;
        MondrianDef.MeasureGroup xmlMeasureGroup;
        boolean ignoreUnrelatedDimensions;

        public Info(String cubeName, Mondrian3Def.Cube xmlLegacyCube) {
            this.cubeName = cubeName;
            this.xmlLegacyCube = xmlLegacyCube;
        }
    }

    public static class HierarchyUsage {
        private static final Logger LOGGER = Logger.getLogger(HierarchyUsage.class);
        protected final RolapSchema.PhysRelation fact;
        private final String hierarchyName;
        private final String name;
        private final String fullName;
        private final String foreignKey;
        private final String source;
        private final String usagePrefix;
        private final String level;
        private RolapSchema.PhysRelation joinTable;
        private RolapSchema.PhysExpr joinExp;
        private final Kind kind;

        HierarchyUsage(RolapCube cube, RolapHierarchy hierarchy, Mondrian3Def.CubeDimension cubeDim) {
            Util.deprecated("remove HierarchyUsage", true);
            assert (cubeDim != null) : "precondition: cubeDim != null";
            this.fact = null;
            this.name = cubeDim.name;
            this.foreignKey = cubeDim.foreignKey;
            if (cubeDim instanceof Mondrian3Def.DimensionUsage) {
                this.kind = Kind.SHARED;
                Mondrian3Def.DimensionUsage du = (Mondrian3Def.DimensionUsage)cubeDim;
                this.hierarchyName = this.deriveHierarchyName(hierarchy);
                int index = this.hierarchyName.indexOf(46);
                if (index == -1) {
                    this.fullName = this.name;
                    this.source = du.source;
                } else {
                    String hname = this.hierarchyName.substring(index + 1, this.hierarchyName.length());
                    StringBuilder buf = new StringBuilder(32);
                    buf.append(this.name);
                    buf.append('.');
                    buf.append(hname);
                    this.fullName = buf.toString();
                    buf.setLength(0);
                    buf.append(du.source);
                    buf.append('.');
                    buf.append(hname);
                    this.source = buf.toString();
                }
                this.level = du.level;
                this.usagePrefix = du.usagePrefix;
                this.init(cube, hierarchy, du);
            } else if (cubeDim instanceof Mondrian3Def.Dimension) {
                this.kind = Kind.PRIVATE;
                Mondrian3Def.Dimension d = (Mondrian3Def.Dimension)cubeDim;
                this.hierarchyName = this.deriveHierarchyName(hierarchy);
                this.fullName = this.name;
                this.source = null;
                this.usagePrefix = d.usagePrefix;
                this.level = null;
                this.init(cube, hierarchy, null);
            } else if (cubeDim instanceof Mondrian3Def.VirtualCubeDimension) {
                this.kind = Kind.VIRTUAL;
                Mondrian3Def.VirtualCubeDimension vd = (Mondrian3Def.VirtualCubeDimension)cubeDim;
                this.hierarchyName = cubeDim.name;
                this.fullName = this.name;
                this.source = null;
                this.usagePrefix = null;
                this.level = null;
                this.init(cube, hierarchy, null);
            } else {
                this.getLogger().warn((Object)("HierarchyUsage<init>: Unknown cubeDim=" + ((Object)((Object)cubeDim)).getClass().getName()));
                this.kind = Kind.UNKNOWN;
                this.hierarchyName = cubeDim.name;
                this.fullName = this.name;
                this.source = null;
                this.usagePrefix = null;
                this.level = null;
                this.init(cube, hierarchy, null);
            }
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug((Object)(this.toString() + ", cubeDim=" + ((Object)((Object)cubeDim)).getClass().getName()));
            }
        }

        private String deriveHierarchyName(RolapHierarchy hierarchy) {
            String name = hierarchy.getName();
            String dimensionName = hierarchy.getDimension().getName();
            if (name == null || name.equals("") || name.equals(dimensionName)) {
                return name;
            }
            return dimensionName + '.' + name;
        }

        protected Logger getLogger() {
            return LOGGER;
        }

        public String getHierarchyName() {
            return this.hierarchyName;
        }

        public String getFullName() {
            return this.fullName;
        }

        public String getName() {
            return this.name;
        }

        public String getForeignKey() {
            return this.foreignKey;
        }

        public String getSource() {
            return this.source;
        }

        public String getLevelName() {
            return this.level;
        }

        public String getUsagePrefix() {
            return this.usagePrefix;
        }

        public RolapSchema.PhysRelation getJoinTable() {
            return this.joinTable;
        }

        public RolapSchema.PhysExpr getJoinExp() {
            return this.joinExp;
        }

        public Kind getKind() {
            return this.kind;
        }

        public boolean isShared() {
            return this.kind == Kind.SHARED;
        }

        public boolean isVirtual() {
            return this.kind == Kind.VIRTUAL;
        }

        public boolean isPrivate() {
            return this.kind == Kind.PRIVATE;
        }

        public boolean equals(Object o) {
            if (o instanceof HierarchyUsage) {
                HierarchyUsage other = (HierarchyUsage)o;
                return this.kind == other.kind && Util.equals(this.fact, other.fact) && this.hierarchyName.equals(other.hierarchyName) && Util.equalName(this.name, other.name) && Util.equalName(this.source, other.source) && Util.equalName(this.foreignKey, other.foreignKey);
            }
            return false;
        }

        public int hashCode() {
            int h = this.fact.hashCode();
            h = Util.hash(h, this.hierarchyName);
            h = Util.hash(h, this.name);
            h = Util.hash(h, this.source);
            h = Util.hash(h, this.foreignKey);
            return h;
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(100);
            buf.append("HierarchyUsage: ");
            buf.append("kind=");
            buf.append(this.kind.name());
            buf.append(", hierarchyName=");
            buf.append(this.hierarchyName);
            buf.append(", fullName=");
            buf.append(this.fullName);
            buf.append(", foreignKey=");
            buf.append(this.foreignKey);
            buf.append(", source=");
            buf.append(this.source);
            buf.append(", level=");
            buf.append(this.level);
            buf.append(", name=");
            buf.append(this.name);
            return buf.toString();
        }

        void init(RolapCube cube, RolapHierarchy hierarchy, Mondrian3Def.DimensionUsage cubeDim) {
            Util.deprecated("fix or remove", false);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Kind {
            UNKNOWN,
            SHARED,
            VIRTUAL,
            PRIVATE;

        }
    }

    public static class RolapCubeUsages {
        private Mondrian3Def.CubeUsages cubeUsages;

        public RolapCubeUsages(Mondrian3Def.CubeUsages cubeUsage) {
            Util.deprecated("obsolete", false);
            this.cubeUsages = cubeUsage;
        }

        public boolean shouldIgnoreUnrelatedDimensions(RolapMeasureGroup measureGroup) {
            if (this.cubeUsages == null || this.cubeUsages.cubeUsages == null) {
                return false;
            }
            for (Mondrian3Def.CubeUsage usage : this.cubeUsages.cubeUsages) {
                if (!usage.cubeName.equals(measureGroup.getName()) || !Boolean.TRUE.equals(usage.ignoreUnrelatedDimensions)) continue;
                return true;
            }
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class CubeComparator
    implements Comparator<RolapCube> {
        private CubeComparator() {
        }

        @Override
        public int compare(RolapCube c1, RolapCube c2) {
            return c1.getName().compareTo(c2.getName());
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class MeasureFinder
    extends MdxVisitorImpl {
        private final Mondrian3Def.Schema xmlSchema = null;
        private final RolapSchema schema;
        private RolapCube virtualCube;
        private RolapCube baseCube;
        private RolapCubeLevel measuresLevel;
        private List<RolapVirtualCubeMeasure> measuresFound;
        private List<RolapCalculatedMember> calcMembersSeen;

        public MeasureFinder(RolapCube virtualCube, RolapCube baseCube, RolapCubeLevel measuresLevel) {
            this.schema = virtualCube.getSchema();
            this.virtualCube = virtualCube;
            this.baseCube = baseCube;
            this.measuresLevel = measuresLevel;
            this.measuresFound = new ArrayList<RolapVirtualCubeMeasure>();
            this.calcMembersSeen = new ArrayList<RolapCalculatedMember>();
        }

        @Override
        public Object visit(MemberExpr memberExpr) {
            Member member = memberExpr.getMember();
            if (member instanceof RolapCalculatedMember) {
                if (this.calcMembersSeen.contains(member)) {
                    return null;
                }
                RolapCalculatedMember calcMember = (RolapCalculatedMember)member;
                Formula formula = calcMember.getFormula();
                formula.accept(this);
                this.calcMembersSeen.add(calcMember);
                this.virtualCube.setMeasuresHierarchyMemberReader(new CacheMemberReader(new MeasureMemberSource(this.virtualCube.getMeasuresHierarchy(), Util.cast(this.measuresFound))));
                Mondrian3Def.CalculatedMember xmlCalcMember = RolapSchemaUpgrader.lookupXmlCalculatedMember(this.xmlSchema, calcMember.getUniqueName(), this.baseCube.getName());
                return null;
            }
            if (member instanceof RolapBaseCubeMeasure) {
                RolapBaseCubeMeasure baseMeasure = (RolapBaseCubeMeasure)member;
                RolapMeasureGroup measureGroup = null;
                for (RolapMeasureGroup measureGroup2 : this.virtualCube.getMeasureGroups()) {
                    if (!measureGroup2.getName().equals(baseMeasure.getCube().getName())) continue;
                    measureGroup = measureGroup2;
                    break;
                }
                assert (measureGroup != null);
                RolapVirtualCubeMeasure virtualCubeMeasure = new RolapVirtualCubeMeasure(measureGroup, null, this.measuresLevel, baseMeasure, Larders.EMPTY);
                if (!this.measuresFound.contains(virtualCubeMeasure)) {
                    this.measuresFound.add(virtualCubeMeasure);
                }
            }
            return null;
        }

        public List<RolapVirtualCubeMeasure> getMeasuresFound() {
            return this.measuresFound;
        }
    }

    static class Link {
        final RolapSchema.PhysRelation fact;
        final String foreignKey;

        Link(RolapSchema.PhysRelation fact, String foreignKey) {
            this.fact = fact;
            this.foreignKey = foreignKey;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class RelNode {
        private int depth;
        private String alias;
        private Mondrian3Def.Relation table;

        private static RelNode lookup(Mondrian3Def.Relation table, Map<String, RelNode> map) {
            RelNode relNode;
            if (table instanceof Mondrian3Def.Table && (relNode = map.get(((Mondrian3Def.Table)table).name)) != null) {
                return relNode;
            }
            return map.get(table.getAlias());
        }

        RelNode(String alias, int depth) {
            this.alias = alias;
            this.depth = depth;
        }
    }
}

