/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.agg;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import mondrian.olap.Util;
import mondrian.rolap.BitKey;
import mondrian.rolap.StarColumnPredicate;
import mondrian.rolap.StarPredicate;
import mondrian.rolap.agg.AndPredicate;
import mondrian.rolap.agg.ListColumnPredicate;
import mondrian.rolap.agg.PredicateColumn;
import mondrian.rolap.agg.Predicates;
import mondrian.spi.Dialect;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractColumnPredicate
implements StarColumnPredicate {
    protected final PredicateColumn constrainedColumn;
    private BitKey constrainedColumnBitKey;

    protected AbstractColumnPredicate(PredicateColumn constrainedColumn) {
        this.constrainedColumn = constrainedColumn;
        assert (constrainedColumn != null);
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append(this.constrainedColumn.physColumn.toSql());
        this.describe(buf);
        return buf.toString();
    }

    @Override
    public final PredicateColumn getColumn() {
        return this.constrainedColumn;
    }

    @Override
    public List<PredicateColumn> getColumnList() {
        return Collections.singletonList(this.constrainedColumn);
    }

    @Override
    public BitKey getConstrainedColumnBitKey() {
        if (this.constrainedColumnBitKey == null) {
            this.constrainedColumnBitKey = BitKey.Factory.makeBitKey(this.constrainedColumn.physColumn.relation.getSchema().getColumnCount());
            this.constrainedColumnBitKey.set(this.constrainedColumn.physColumn.ordinal());
        }
        return this.constrainedColumnBitKey;
    }

    @Override
    public boolean evaluate(List<Object> valueList) {
        assert (valueList.size() == 1);
        return this.evaluate(valueList.get(0));
    }

    @Override
    public boolean equalConstraint(StarPredicate that) {
        return false;
    }

    @Override
    public StarPredicate or(StarPredicate predicate) {
        StarColumnPredicate starColumnPredicate;
        if (predicate instanceof StarColumnPredicate && (starColumnPredicate = (StarColumnPredicate)predicate).getColumn() == this.getColumn()) {
            return this.orColumn(starColumnPredicate);
        }
        return Predicates.or(Arrays.asList(this, predicate));
    }

    @Override
    public StarColumnPredicate orColumn(StarColumnPredicate predicate) {
        assert (predicate.getColumn() == this.getColumn());
        if (predicate instanceof ListColumnPredicate) {
            ListColumnPredicate that = (ListColumnPredicate)predicate;
            ArrayList<StarColumnPredicate> list = new ArrayList<StarColumnPredicate>();
            list.add(this);
            list.addAll(that.getPredicates());
            return new ListColumnPredicate(this.getColumn(), list);
        }
        ArrayList<StarColumnPredicate> list = new ArrayList<StarColumnPredicate>(2);
        list.add(this);
        list.add(predicate);
        return new ListColumnPredicate(this.getColumn(), list);
    }

    @Override
    public StarPredicate and(StarPredicate predicate) {
        return new AndPredicate(Arrays.asList(this, predicate));
    }

    @Override
    public void toSql(Dialect dialect, StringBuilder buf) {
        throw Util.needToImplement(this);
    }
}

