/*
 * Decompiled with CFR 0.152.
 */
package mondrian.rolap.sql;

import java.util.Collections;
import java.util.List;
import mondrian.olap.Evaluator;
import mondrian.rolap.RolapCubeLevel;
import mondrian.rolap.RolapMeasureGroup;
import mondrian.rolap.RolapMember;
import mondrian.rolap.RolapSchema;
import mondrian.rolap.RolapStarSet;
import mondrian.rolap.SqlConstraintUtils;
import mondrian.rolap.sql.MemberChildrenConstraint;
import mondrian.rolap.sql.SqlQuery;
import mondrian.rolap.sql.SqlQueryBuilder;
import mondrian.rolap.sql.TupleConstraint;
import mondrian.util.Pair;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MemberKeyConstraint
implements TupleConstraint {
    private final Pair<List<RolapSchema.PhysColumn>, List<Comparable>> cacheKey;
    private final List<RolapSchema.PhysColumn> columnList;
    private final List<Comparable> valueList;

    public MemberKeyConstraint(List<RolapSchema.PhysColumn> columnList, List<Comparable> valueList) {
        this.columnList = columnList;
        this.valueList = valueList;
        this.cacheKey = Pair.of(columnList, valueList);
    }

    @Override
    public boolean isJoinRequired() {
        return false;
    }

    @Override
    public List<RolapMeasureGroup> getMeasureGroupList() {
        return Collections.emptyList();
    }

    @Override
    public void addConstraint(SqlQueryBuilder queryBuilder, RolapStarSet baseCube) {
        for (int i = 0; i < this.columnList.size(); ++i) {
            RolapSchema.PhysColumn expression = this.columnList.get(i);
            Comparable value = this.valueList.get(i);
            SqlConstraintUtils.constrainLevel2(queryBuilder, expression, null, value);
        }
    }

    @Override
    public void addLevelConstraint(SqlQuery sqlQuery, RolapStarSet baseCube, RolapCubeLevel level) {
    }

    @Override
    public MemberChildrenConstraint getMemberChildrenConstraint(RolapMember parent) {
        return null;
    }

    public String toString() {
        return "MemberKeyConstraint";
    }

    @Override
    public Object getCacheKey() {
        return this.cacheKey;
    }

    @Override
    public Evaluator getEvaluator() {
        return null;
    }
}

