/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.List;
import java.util.Map;
import mondrian.rolap.SqlStatement;
import mondrian.spi.StatisticsProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public interface Dialect {
    public String toUpper(String var1);

    public String caseWhenElse(String var1, String var2, String var3);

    public String quoteIdentifier(String var1);

    public void quoteIdentifier(String var1, StringBuilder var2);

    public String quoteIdentifier(String var1, String var2);

    public void quoteIdentifier(StringBuilder var1, String ... var2);

    public String getQuoteIdentifierString();

    public void quoteStringLiteral(StringBuilder var1, String var2);

    public void quoteNumericLiteral(StringBuilder var1, Number var2);

    public void quoteBooleanLiteral(StringBuilder var1, boolean var2);

    public void quoteDateLiteral(StringBuilder var1, Date var2);

    public void quoteTimeLiteral(StringBuilder var1, Time var2);

    public void quoteTimestampLiteral(StringBuilder var1, Timestamp var2);

    public boolean requiresAliasForFromQuery();

    public boolean allowsAs();

    public boolean allowsFromQuery();

    public boolean allowsCompoundCountDistinct();

    public boolean allowsCountDistinct();

    public boolean allowsMultipleCountDistinct();

    public boolean allowsMultipleDistinctSqlMeasures();

    public String generateInline(List<String> var1, List<String> var2, List<String[]> var3);

    public boolean needsExponent(Object var1, String var2);

    public void quote(StringBuilder var1, Object var2, Datatype var3) throws NumberFormatException;

    public boolean allowsDdl();

    public String generateOrderItem(String var1, boolean var2, boolean var3, boolean var4);

    public boolean supportsGroupByExpressions();

    public boolean supportsGroupingSets();

    public boolean supportsUnlimitedValueList();

    public boolean requiresGroupByAlias();

    public boolean requiresOrderByAlias();

    public boolean requiresHavingAlias();

    public boolean allowsOrderByAlias();

    public boolean requiresUnionOrderByOrdinal();

    public boolean requiresUnionOrderByExprToBeInSelectClause();

    public boolean supportsMultiValueInExpr();

    public boolean supportsResultSetConcurrency(int var1, int var2);

    public int getMaxColumnNameLength();

    public DatabaseProduct getDatabaseProduct();

    public void appendHintsAfterFromClause(StringBuilder var1, Map<String, String> var2);

    public boolean allowsDialectSharing();

    public boolean allowsSelectNotInGroupBy();

    public boolean allowsJoinOn();

    public boolean allowsRegularExpressionInWhereClause();

    public String generateCountExpression(String var1);

    public String generateRegularExpression(String var1, String var2);

    public Datatype sqlTypeToDatatype(String var1, int var2);

    public String datatypeToString(Datatype var1, int var2, int var3);

    public List<StatisticsProvider> getStatisticsProviders();

    public SqlStatement.Type getType(ResultSetMetaData var1, int var2) throws SQLException;

    public boolean alwaysQuoteIdentifiers();

    public boolean needToQuote(String var1);

    public Dialect withQuoting(boolean var1);

    public boolean hasSpecialChars(String var1);

    public String rectifyCase(String var1);

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Datatype {
        String{

            public void quoteValue(StringBuilder buf, Dialect dialect, Object value) {
                dialect.quoteStringLiteral(buf, Datatype.toString_(value));
            }
        }
        ,
        Numeric{

            public void quoteValue(StringBuilder buf, Dialect dialect, Object value) {
                dialect.quoteNumericLiteral(buf, Datatype.toNumber(value));
            }

            public boolean isNumeric() {
                return true;
            }
        }
        ,
        Integer{

            public void quoteValue(StringBuilder buf, Dialect dialect, Object value) {
                dialect.quoteNumericLiteral(buf, Datatype.toInteger(value));
            }

            public boolean isNumeric() {
                return true;
            }
        }
        ,
        Boolean{

            public void quoteValue(StringBuilder buf, Dialect dialect, Object value) {
                dialect.quoteBooleanLiteral(buf, Datatype.toBoolean(value));
            }
        }
        ,
        Date{

            public void quoteValue(StringBuilder buf, Dialect dialect, Object value) {
                dialect.quoteDateLiteral(buf, Datatype.toDate(value));
            }
        }
        ,
        Time{

            public void quoteValue(StringBuilder buf, Dialect dialect, Object value) {
                dialect.quoteTimeLiteral(buf, Datatype.toTime(value));
            }
        }
        ,
        Timestamp{

            public void quoteValue(StringBuilder buf, Dialect dialect, Object value) {
                dialect.quoteTimestampLiteral(buf, Datatype.toTimestamp(value));
            }
        };


        private static String toString_(Object value) {
            return value.toString();
        }

        private static Number toNumber(Object value) {
            return Datatype.toInteger(value);
        }

        private static Number toInteger(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            Number number = value instanceof Number ? (Number)value : new BigDecimal(value.toString());
            return number;
        }

        private static boolean toBoolean(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            if (value instanceof Boolean) {
                return (Boolean)value;
            }
            String valueString = value.toString();
            if (valueString.equalsIgnoreCase("TRUE")) {
                return true;
            }
            if (valueString.equalsIgnoreCase("FALSE")) {
                return false;
            }
            throw new NumberFormatException("Illegal BOOLEAN literal:  " + value);
        }

        private static Date toDate(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            if (value instanceof Date) {
                return (Date)value;
            }
            String valueString = value.toString();
            try {
                return java.sql.Date.valueOf(valueString);
            }
            catch (IllegalArgumentException ex) {
                try {
                    Timestamp timestamp = java.sql.Timestamp.valueOf(valueString);
                    return new Date(timestamp.getTime());
                }
                catch (IllegalArgumentException ex2) {
                    throw new NumberFormatException("Illegal DATE literal:  " + value);
                }
            }
        }

        private static Time toTime(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            if (value instanceof Time) {
                return (Time)value;
            }
            try {
                String valueString = value.toString();
                return java.sql.Time.valueOf(valueString);
            }
            catch (IllegalArgumentException ex) {
                throw new NumberFormatException("Illegal TIME literal:  " + value);
            }
        }

        private static Timestamp toTimestamp(Object value) {
            if (value == null) {
                throw new NullPointerException();
            }
            if (value instanceof Timestamp) {
                return (Timestamp)value;
            }
            try {
                String valueString = value.toString();
                return java.sql.Timestamp.valueOf(valueString);
            }
            catch (IllegalArgumentException ex) {
                throw new NumberFormatException("Illegal TIME literal:  " + value);
            }
        }

        public abstract void quoteValue(StringBuilder var1, Dialect var2, Object var3) throws NumberFormatException, NullPointerException;

        public boolean isNumeric() {
            return false;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DatabaseProduct {
        ACCESS,
        UNKNOWN,
        DERBY,
        DB2_OLD_AS400,
        DB2_AS400,
        DB2,
        FIREBIRD,
        GREENPLUM,
        HIVE,
        HSQLDB,
        IMPALA,
        INFORMIX,
        INFOBRIGHT,
        INGRES,
        INTERBASE,
        LUCIDDB,
        MSSQL,
        MONETDB,
        NETEZZA,
        NEOVIEW,
        NUODB,
        ORACLE,
        KYLIN,
        PHOENIX,
        POSTGRESQL,
        REDSHIFT,
        MYSQL,
        SQLSTREAM,
        SYBASE,
        TERADATA,
        VERTICA,
        VECTORWISE,
        SPARKSQL;


        public DatabaseProduct getFamily() {
            switch (this) {
                case DB2_OLD_AS400: 
                case DB2_AS400: {
                    return DB2;
                }
            }
            return this;
        }

        public static DatabaseProduct getDatabaseProduct(String name) {
            for (DatabaseProduct databaseProduct : DatabaseProduct.values()) {
                if (!databaseProduct.name().equalsIgnoreCase(name)) continue;
                return databaseProduct;
            }
            return UNKNOWN;
        }
    }
}

