/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import mondrian.olap.Util;
import mondrian.rolap.SqlStatement;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

public class MonetDbDialect
extends JdbcDialectImpl {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(MonetDbDialect.class, Dialect.DatabaseProduct.MONETDB);

    public MonetDbDialect(Connection connection) throws SQLException {
        super(connection);
    }

    public MonetDbDialect() {
    }

    public boolean requiresAliasForFromQuery() {
        return true;
    }

    public boolean allowsSelectNotInGroupBy() {
        return false;
    }

    public boolean allowsJoinOn() {
        return true;
    }

    public boolean requiresGroupByAlias() {
        return true;
    }

    public boolean requiresOrderByAlias() {
        return true;
    }

    public boolean requiresHavingAlias() {
        return true;
    }

    public void quoteStringLiteral(StringBuilder buf, String s) {
        buf.append('\'');
        String s0 = Util.replace(s, "'", "''");
        String s1 = Util.replace(s0, "\\", "\\\\");
        buf.append(s1);
        buf.append('\'');
    }

    public SqlStatement.Type getType(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        int columnType = metaData.getColumnType(columnIndex + 1);
        int precision = metaData.getPrecision(columnIndex + 1);
        int scale = metaData.getScale(columnIndex + 1);
        if (columnType == 2 || columnType == 3) {
            if (scale == 0 && precision == 0) {
                this.logTypeInfo(metaData, columnIndex, SqlStatement.Type.DOUBLE);
                return SqlStatement.Type.DOUBLE;
            }
        } else if (columnType == 16) {
            return SqlStatement.Type.OBJECT;
        }
        return super.getType(metaData, columnIndex);
    }
}

