/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import mondrian.rolap.SqlStatement;
import mondrian.spi.Dialect;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;
import mondrian.spi.impl.PostgreSqlDialect;

public class NetezzaDialect
extends PostgreSqlDialect {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(NetezzaDialect.class, Dialect.DatabaseProduct.NETEZZA){

        protected boolean acceptsConnection(Connection connection) {
            return JdbcDialectImpl.isDatabase(Dialect.DatabaseProduct.NETEZZA, connection);
        }
    };

    public NetezzaDialect(Connection connection) throws SQLException {
        super(connection);
    }

    public Dialect.DatabaseProduct getDatabaseProduct() {
        return Dialect.DatabaseProduct.NETEZZA;
    }

    public boolean allowsRegularExpressionInWhereClause() {
        return false;
    }

    public String generateRegularExpression(String source, String javaRegex) {
        throw new UnsupportedOperationException();
    }

    public SqlStatement.Type getType(ResultSetMetaData metaData, int columnIndex) throws SQLException {
        int precision = metaData.getPrecision(columnIndex + 1);
        int scale = metaData.getScale(columnIndex + 1);
        int columnType = metaData.getColumnType(columnIndex + 1);
        if (columnType == 2 || columnType == 3 && scale == 0 && precision == 38) {
            this.logTypeInfo(metaData, columnIndex, SqlStatement.Type.DOUBLE);
            return SqlStatement.Type.DOUBLE;
        }
        return super.getType(metaData, columnIndex);
    }
}

