/*
 * Decompiled with CFR 0.152.
 */
package mondrian.spi.impl;

import java.sql.Connection;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import mondrian.olap.Util;
import mondrian.spi.Dialect;
import mondrian.spi.StatisticsProvider;
import mondrian.spi.impl.JdbcDialectFactory;
import mondrian.spi.impl.JdbcDialectImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhoenixDialect
extends JdbcDialectImpl {
    public static final JdbcDialectFactory FACTORY = new JdbcDialectFactory(PhoenixDialect.class, Dialect.DatabaseProduct.PHOENIX);

    public PhoenixDialect(Connection connection) throws SQLException {
        super(connection);
    }

    @Override
    public boolean allowsAs() {
        return true;
    }

    @Override
    public boolean allowsCompoundCountDistinct() {
        return false;
    }

    @Override
    public boolean allowsCountDistinct() {
        return false;
    }

    @Override
    public boolean allowsDdl() {
        return true;
    }

    @Override
    public boolean allowsDialectSharing() {
        return true;
    }

    @Override
    public boolean allowsFromQuery() {
        return false;
    }

    @Override
    public boolean allowsMultipleCountDistinct() {
        return false;
    }

    @Override
    public boolean allowsMultipleDistinctSqlMeasures() {
        return false;
    }

    @Override
    public boolean allowsOrderByAlias() {
        return false;
    }

    @Override
    public boolean allowsRegularExpressionInWhereClause() {
        return true;
    }

    @Override
    public boolean allowsSelectNotInGroupBy() {
        return true;
    }

    @Override
    public String getQuoteIdentifierString() {
        return "\"";
    }

    @Override
    public boolean requiresAliasForFromQuery() {
        return false;
    }

    @Override
    public boolean requiresHavingAlias() {
        return false;
    }

    @Override
    public boolean requiresOrderByAlias() {
        return false;
    }

    @Override
    public boolean requiresUnionOrderByExprToBeInSelectClause() {
        return false;
    }

    @Override
    public boolean requiresUnionOrderByOrdinal() {
        return false;
    }

    @Override
    public boolean supportsGroupByExpressions() {
        return true;
    }

    @Override
    public boolean supportsGroupingSets() {
        return false;
    }

    @Override
    public boolean supportsMultiValueInExpr() {
        return true;
    }

    @Override
    public boolean supportsUnlimitedValueList() {
        return true;
    }

    @Override
    public List<StatisticsProvider> getStatisticsProviders() {
        return new ArrayList<StatisticsProvider>();
    }

    @Override
    protected void quoteDateLiteral(StringBuilder buf, String value, Date date) {
        buf.append("TO_DATE(");
        Util.singleQuoteString(value, buf);
        buf.append(", 'yyyy-MM-dd')");
    }

    @Override
    public void quoteTimeLiteral(StringBuilder buf, Time value) {
        buf.append("TO_DATE(");
        Util.singleQuoteString(value.toString(), buf);
        buf.append(", 'HH:mm:ss')");
    }

    @Override
    public void quoteTimestampLiteral(StringBuilder buf, Timestamp value) {
        buf.append("TO_DATE(");
        Util.singleQuoteString(value.toString(), buf);
        buf.append(", 'yyyy-MM-dd HH:mm:ss.SSS')");
    }
}

