/*
 * Decompiled with CFR 0.152.
 */
package mondrian.udf;

import java.util.Date;
import java.util.List;
import java.util.Locale;
import mondrian.olap.Dimension;
import mondrian.olap.Evaluator;
import mondrian.olap.Hierarchy;
import mondrian.olap.Id;
import mondrian.olap.MatchType;
import mondrian.olap.Member;
import mondrian.olap.Syntax;
import mondrian.olap.Util;
import mondrian.olap.type.HierarchyType;
import mondrian.olap.type.MemberType;
import mondrian.olap.type.StringType;
import mondrian.olap.type.SymbolType;
import mondrian.olap.type.Type;
import mondrian.spi.UserDefinedFunction;
import mondrian.util.Format;
import org.apache.log4j.Logger;

public class CurrentDateMemberUdf
implements UserDefinedFunction {
    private Object resultDateMember = null;
    private static final Logger LOGGER = Logger.getLogger(CurrentDateMemberUdf.class);

    public Object execute(Evaluator evaluator, UserDefinedFunction.Argument[] arguments) {
        Object arg0;
        MatchType matchType;
        if (this.resultDateMember != null) {
            return this.resultDateMember;
        }
        Object formatArg = arguments[1].evaluateScalar(evaluator);
        Locale locale = Locale.getDefault();
        Format format = new Format((String)formatArg, locale);
        String currDateStr = format.format(this.getDate(evaluator, arguments));
        if (arguments.length == 3) {
            String matchStr = arguments[2].evaluateScalar(evaluator).toString();
            matchType = Enum.valueOf(MatchType.class, matchStr);
        } else {
            matchType = MatchType.EXACT;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)("Current Date Member Lookup, attempting to find:" + currDateStr));
        }
        List<Id.Segment> uniqueNames = Util.parseIdentifier(currDateStr);
        this.resultDateMember = evaluator.getSchemaReader().getMemberByUniqueName(uniqueNames, false, matchType);
        if (this.resultDateMember != null) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("Current Date Member Lookup, found:" + ((Member)this.resultDateMember).getUniqueName()));
            }
            return this.resultDateMember;
        }
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug((Object)"Failed to match Current Date Member");
        }
        this.resultDateMember = (arg0 = arguments[0].evaluate(evaluator)) instanceof Hierarchy ? ((Hierarchy)arg0).getNullMember() : ((Dimension)arg0).getHierarchy().getNullMember();
        return this.resultDateMember;
    }

    Date getDate(Evaluator evaluator, UserDefinedFunction.Argument[] arguments) {
        return evaluator.getQueryStartTime();
    }

    public String getDescription() {
        return "Returns the closest or exact member within the specified dimension corresponding to the current date, in the format specified by the format parameter. Format strings are the same as used by the MDX Format function, namely the Visual Basic format strings. See http://www.apostate.com/programming/vb-format.html.";
    }

    public String getName() {
        return "CurrentDateMember";
    }

    public Type[] getParameterTypes() {
        return new Type[]{new HierarchyType(null, null), new StringType(), new SymbolType()};
    }

    public String[] getReservedWords() {
        return new String[]{"EXACT", "BEFORE", "AFTER"};
    }

    public Type getReturnType(Type[] parameterTypes) {
        return MemberType.Unknown;
    }

    public Syntax getSyntax() {
        return Syntax.Function;
    }
}

