/*
 * Decompiled with CFR 0.152.
 */
package mondrian.util;

import java.lang.reflect.Array;
import java.util.AbstractSequentialList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.NoSuchElementException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ChunkList<E>
extends AbstractSequentialList<E> {
    private static final int HEADER_SIZE = 3;
    private static final int CHUNK_SIZE = 64;
    private static final int LOW_SIZE = 21;
    private static final int POST_MERGE_SIZE = 42;
    private static final Integer[] INTEGERS = new Integer[68];
    private int size;
    private Object[] first;
    private Object[] last;

    public ChunkList() {
    }

    public ChunkList(Collection<E> collection) {
        this.addAll(collection);
    }

    boolean isValid(boolean print, boolean fail) {
        if (this.first == null != (this.last == null)) {
            assert (!fail);
            return false;
        }
        if (this.first == null != (this.size == 0)) {
            assert (!fail);
            return false;
        }
        int n = 0;
        for (Object e : this) {
            if (n++ <= this.size) continue;
            assert (!fail);
            return false;
        }
        if (n != this.size) {
            assert (!fail);
            return false;
        }
        Object[] prev = null;
        Object[] chunk = this.first;
        while (chunk != null) {
            if (ChunkList.prev(chunk) != prev) {
                assert (!fail);
                return false;
            }
            prev = chunk;
            if (ChunkList.end(chunk) == 3) {
                assert (!fail) : "chunk is empty";
                return false;
            }
            chunk = ChunkList.next(chunk);
        }
        if (print) {
            System.out.println(this.chunkSizeDistribution());
        }
        return true;
    }

    String chunkSizeDistribution() {
        Integer integer;
        ArrayList<Integer> list = new ArrayList<Integer>();
        int n = 0;
        Object[] chunk = this.first;
        while (chunk != null) {
            ++n;
            int size1 = ChunkList.end(chunk) - 3;
            while (size1 > list.size() - 1) {
                list.add(null);
            }
            integer = (Integer)list.get(size1);
            if (integer == null) {
                list.set(size1, 1);
            } else {
                list.set(size1, integer + 1);
            }
            chunk = ChunkList.next(chunk);
        }
        ArrayList<String> strings = new ArrayList<String>();
        for (int i = 0; i < list.size(); ++i) {
            integer = (Integer)list.get(i);
            if (integer == null) continue;
            strings.add(i + ":" + integer);
        }
        return "size: " + this.size() + ", distribution: " + strings + ", chunks: " + n + ", elements per chunk: " + (float)this.size / (float)n;
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        if (index < 0 || index > this.size()) {
            throw new IndexOutOfBoundsException();
        }
        return this.locate(index);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public void clear() {
        Object[] x = this.first;
        while (x != null) {
            Object[] next = ChunkList.next(x);
            ChunkList.setNext(x, null);
            ChunkList.setPrev(x, null);
            x = next;
        }
        this.last = null;
        this.first = null;
        this.size = 0;
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        int end;
        Object[] chunk;
        if (index != this.size() || c.isEmpty()) {
            return super.addAll(index, c);
        }
        if (this.last == null) {
            chunk = new Object[67];
            end = 3;
        } else {
            chunk = this.last;
            end = ChunkList.end(chunk);
        }
        for (E e : c) {
            if (end == 67) {
                Object[] prev = chunk;
                chunk = new Object[67];
                end = 3;
                ChunkList.setNext(prev, chunk);
                ChunkList.setPrev(chunk, prev);
            }
            chunk[end++] = e;
        }
        this.last = chunk;
        ChunkList.setEnd(chunk, end);
        return true;
    }

    @Override
    public <T> T[] toArray(T[] a) {
        int size = this.size();
        T[] r = a.length >= size ? a : (Object[])Array.newInstance(a.getClass().getComponentType(), size);
        this.populateArray(r);
        if (r.length > size) {
            r[size] = null;
        }
        return r;
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.size];
        this.populateArray(a);
        return a;
    }

    private <T> void populateArray(T[] r) {
        if (this.first == null) {
            return;
        }
        int start = 0;
        Object[] chunk = this.first;
        while (true) {
            int end = ChunkList.end(chunk);
            int count = end - 3;
            System.arraycopy(chunk, 3, r, start, count);
            chunk = ChunkList.next(chunk);
            if (chunk == null) break;
            start += count;
        }
    }

    @Override
    public boolean contains(Object o) {
        return this.locate(o, true) != null;
    }

    @Override
    public int indexOf(Object o) {
        ChunkListIterator listIterator = this.locate(o, true);
        if (listIterator == null) {
            return -1;
        }
        return listIterator.nextIndex();
    }

    @Override
    public int lastIndexOf(Object o) {
        ChunkListIterator listIterator = this.locate(o, false);
        if (listIterator == null) {
            return -1;
        }
        return listIterator.nextIndex();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        if (c.isEmpty()) {
            return true;
        }
        HashSet set = new HashSet(c);
        for (Object e : this) {
            if (!set.remove(e) || !set.isEmpty()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean add(E element) {
        int end;
        Object[] chunk = this.last;
        if (chunk == null) {
            this.last = new Object[67];
            this.first = this.last;
            chunk = this.last;
            end = 3;
        } else {
            end = ChunkList.end(chunk);
            if (end == 67) {
                chunk = new Object[67];
                ChunkList.setNext(this.last, chunk);
                ChunkList.setPrev(chunk, this.last);
                end = 3;
                this.last = chunk;
            }
        }
        ChunkList.setEnd(chunk, end + 1);
        ChunkList.setElement(chunk, end, element);
        ++this.size;
        return true;
    }

    @Override
    public void add(int index, E element) {
        if (index == this.size) {
            this.add(element);
        } else {
            super.add(index, element);
        }
    }

    @Override
    public void addFirst(E e) {
        this.add(0, e);
    }

    @Override
    public void addLast(E e) {
        this.add(this.size(), e);
    }

    public boolean offerFirst(E e) {
        this.addFirst(e);
        return true;
    }

    public boolean offerLast(E e) {
        this.addLast(e);
        return true;
    }

    @Override
    public E removeFirst() {
        return this.xxxFirst(true);
    }

    public E pollFirst() {
        return this.xxxFirst(false);
    }

    private E xxxFirst(boolean throwOnEmpty) {
        if (this.isEmpty()) {
            if (throwOnEmpty) {
                throw new NoSuchElementException();
            }
            return null;
        }
        ListIterator<E> iterator = this.listIterator(0);
        E e = iterator.next();
        iterator.remove();
        return e;
    }

    @Override
    public E removeLast() {
        return this.xxxLast(true);
    }

    public E pollLast() {
        return this.xxxLast(false);
    }

    private E xxxLast(boolean throwOnEmpty) {
        if (this.isEmpty()) {
            if (throwOnEmpty) {
                throw new NoSuchElementException();
            }
            return null;
        }
        ListIterator<E> iterator = this.listIterator(this.size);
        E e = iterator.previous();
        iterator.remove();
        return e;
    }

    @Override
    public E getFirst() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(0);
    }

    @Override
    public E getLast() {
        if (this.isEmpty()) {
            throw new NoSuchElementException();
        }
        return this.get(this.size - 1);
    }

    public E peekFirst() {
        if (this.isEmpty()) {
            return null;
        }
        return this.get(0);
    }

    public E peekLast() {
        if (this.isEmpty()) {
            return null;
        }
        return this.get(this.size - 1);
    }

    public boolean removeFirstOccurrence(Object o) {
        ListIterator<E> i = this.listIterator(0);
        while (i.hasNext()) {
            E e = i.next();
            if (!e.equals(o)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public boolean removeLastOccurrence(Object o) {
        ListIterator<E> i = this.listIterator(this.size - 1);
        while (i.hasPrevious()) {
            E e = i.previous();
            if (!e.equals(o)) continue;
            i.remove();
            return true;
        }
        return false;
    }

    public boolean offer(E e) {
        return this.add(e);
    }

    public E remove() {
        return this.removeFirst();
    }

    public E poll() {
        return this.pollFirst();
    }

    public E element() {
        return this.getFirst();
    }

    public E peek() {
        return this.peekFirst();
    }

    public void push(E e) {
        this.addFirst(e);
    }

    public E pop() {
        return this.removeFirst();
    }

    public Iterator<E> descendingIterator() {
        return new DescendingIterator();
    }

    private static Object[] prev(Object[] chunk) {
        return (Object[])chunk[0];
    }

    private static void setPrev(Object[] chunk, Object[] prev) {
        chunk[0] = prev;
    }

    private static Object[] next(Object[] chunk) {
        return (Object[])chunk[1];
    }

    private static void setNext(Object[] chunk, Object[] next) {
        assert (chunk != next);
        chunk[1] = next;
    }

    private static int end(Object[] chunk) {
        return (Integer)chunk[2];
    }

    private static void setEnd(Object[] chunk, int size) {
        chunk[2] = INTEGERS[size];
    }

    private static Object element(Object[] chunk, int index) {
        return chunk[index];
    }

    private static void setElement(Object[] chunk, int index, Object element) {
        chunk[index] = element;
    }

    private ChunkListIterator locate(int index) {
        if (this.first == null) {
            return new ChunkListIterator();
        }
        if (index * 2 <= this.size) {
            int n = 0;
            Object[] chunk = this.first;
            while (true) {
                int end = ChunkList.end(chunk);
                int nextN = n + end - 3;
                Object[] next = ChunkList.next(chunk);
                if (nextN > index || next == null) {
                    return new ChunkListIterator(chunk, n, index - n + 3, end);
                }
                n = nextN;
                chunk = next;
            }
        }
        int n = this.size;
        Object[] chunk = this.last;
        while (true) {
            int end = ChunkList.end(chunk);
            int start = n - (end - 3);
            Object[] prev = ChunkList.prev(chunk);
            if (start <= index) {
                return new ChunkListIterator(chunk, n, index - start + 3, end);
            }
            n = start;
            chunk = prev;
        }
    }

    private ChunkListIterator locate(E element, boolean forward) {
        if (this.first == null) {
            return null;
        }
        if (forward) {
            int start = 0;
            Object[] chunk = this.first;
            while (true) {
                int i;
                int end = ChunkList.end(chunk);
                if (element == null) {
                    for (i = 3; i < end; ++i) {
                        if (chunk[i] != null) continue;
                        return new ChunkListIterator(chunk, start, i, end);
                    }
                } else {
                    for (i = 3; i < end; ++i) {
                        if (!element.equals(chunk[i])) continue;
                        return new ChunkListIterator(chunk, start, i, end);
                    }
                }
                if ((chunk = ChunkList.next(chunk)) == null) {
                    return null;
                }
                start += end - 3;
            }
        }
        int top = this.size;
        Object[] chunk = this.last;
        while (true) {
            int i;
            int end = ChunkList.end(chunk);
            int start = top - (end - 3);
            if (element == null) {
                for (i = end - 1; i >= 3; --i) {
                    if (chunk[i] != null) continue;
                    return new ChunkListIterator(chunk, start, i, end);
                }
            } else {
                for (i = end - 1; i >= 3; --i) {
                    if (!element.equals(chunk[i])) continue;
                    return new ChunkListIterator(chunk, start, i, end);
                }
            }
            if ((chunk = ChunkList.prev(chunk)) == null) {
                return null;
            }
            top = start;
        }
    }

    static /* synthetic */ Object[] access$502(ChunkList x0, Object[] x1) {
        x0.last = x1;
        return x1;
    }

    static /* synthetic */ Object[] access$702(ChunkList x0, Object[] x1) {
        x0.first = x1;
        return x1;
    }

    static {
        for (int i = 0; i < INTEGERS.length; ++i) {
            ChunkList.INTEGERS[i] = i;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class DescendingIterator
    implements Iterator<E> {
        private final ChunkListIterator iterator;

        private DescendingIterator() {
            this.iterator = ChunkList.this.locate(ChunkList.this.size());
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasPrevious();
        }

        @Override
        public E next() {
            return this.iterator.previous();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class ChunkListIterator
    implements ListIterator<E> {
        private Object[] chunk;
        private int startIndex;
        private int nextIndex;
        private int lastReturned;
        private Object[] lastReturnedChunk;
        private int end;

        ChunkListIterator() {
            this(null, 0, 0, 0);
        }

        ChunkListIterator(Object[] chunk, int startIndex, int nextIndex, int end) {
            this.chunk = chunk;
            this.startIndex = startIndex;
            this.nextIndex = nextIndex;
            this.end = end;
            this.lastReturnedChunk = null;
        }

        @Override
        public boolean hasNext() {
            return this.nextIndex < this.end;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.lastReturned = this.nextIndex;
            this.lastReturnedChunk = this.chunk;
            Object element = ChunkList.element(this.chunk, this.nextIndex);
            ++this.nextIndex;
            if (this.nextIndex == this.end) {
                this.chunk = ChunkList.next(this.chunk);
                this.startIndex += this.end - 3;
                this.end = this.chunk == null ? 3 : ChunkList.end(this.chunk);
                this.nextIndex = 3;
            }
            return element;
        }

        @Override
        public boolean hasPrevious() {
            return this.nextIndex >= 3 || ChunkList.prev(this.chunk) != null;
        }

        @Override
        public E previous() {
            Object element = ChunkList.element(this.chunk, this.nextIndex);
            this.lastReturned = this.nextIndex--;
            this.lastReturnedChunk = this.chunk;
            if (this.nextIndex == 2) {
                Object[] objectArray = this.chunk = this.chunk == null ? ChunkList.this.last : ChunkList.prev(this.chunk);
                if (this.chunk == null) {
                    throw new NoSuchElementException();
                }
                this.end = ChunkList.end(this.chunk);
                this.startIndex -= this.end - 3;
                this.nextIndex = this.end - 1;
            }
            return element;
        }

        @Override
        public int nextIndex() {
            return this.startIndex + (this.nextIndex - 3);
        }

        @Override
        public int previousIndex() {
            return this.startIndex + (this.nextIndex - 3) - 1;
        }

        @Override
        public void remove() {
            if (this.lastReturnedChunk == null) {
                throw new IllegalStateException();
            }
            --ChunkList.this.size;
            if (this.lastReturnedChunk == this.chunk) {
                this.remove_(this.end, this.chunk, this.lastReturned, true);
            } else {
                int lastReturnedEnd = ChunkList.end(this.lastReturnedChunk);
                this.remove_(lastReturnedEnd, this.lastReturnedChunk, this.lastReturned, false);
            }
            this.lastReturnedChunk = null;
        }

        private void remove_(int end, Object[] chunk, int pos, boolean b) {
            if (end == 4) {
                Object[] prev = ChunkList.prev(chunk);
                Object[] next = ChunkList.next(chunk);
                if (next == null) {
                    ChunkList.access$502(ChunkList.this, prev);
                    if (prev == null) {
                        ChunkList.access$702(ChunkList.this, null);
                    } else {
                        ChunkList.setNext(prev, null);
                    }
                    if (b) {
                        this.chunk = null;
                        this.nextIndex = 3;
                        this.end = 3;
                    }
                } else {
                    if (prev == null) {
                        ChunkList.access$702(ChunkList.this, next);
                        ChunkList.setPrev(next, null);
                    } else {
                        ChunkList.setNext(prev, next);
                        ChunkList.setPrev(next, prev);
                    }
                    if (b) {
                        this.chunk = next;
                        this.nextIndex = 3;
                        this.end = ChunkList.end(next);
                    }
                }
            } else {
                System.arraycopy(chunk, pos + 1, chunk, pos, end - pos - 1);
                ChunkList.setElement(chunk, --end, null);
                ChunkList.setEnd(chunk, end);
                if (b) {
                    if (this.nextIndex == end) {
                        Object[] next = ChunkList.next(chunk);
                        if (next != null) {
                            this.startIndex += end - 3;
                            this.chunk = next;
                            this.nextIndex = 3;
                            this.end = ChunkList.end(next);
                        }
                    } else {
                        this.end = end;
                    }
                }
            }
        }

        @Override
        public void set(E e) {
            if (this.lastReturnedChunk == null) {
                throw new IllegalStateException();
            }
            ChunkList.setElement(this.lastReturnedChunk, this.lastReturned, e);
            this.lastReturnedChunk = null;
        }

        @Override
        public void add(E e) {
            if (this.nextIndex == this.end) {
                if (this.chunk == null) {
                    Object[] newChunk = new Object[67];
                    assert (ChunkList.this.first == null && ChunkList.this.last == null);
                    this.chunk = newChunk;
                    ChunkList.access$502(ChunkList.this, ChunkList.access$702(ChunkList.this, newChunk));
                    this.nextIndex = 3;
                    this.end = 3;
                } else if (this.end >= 67) {
                    Object[] newChunk = new Object[67];
                    Object[] next = ChunkList.next(this.chunk);
                    ChunkList.setPrev(newChunk, this.chunk);
                    ChunkList.setNext(this.chunk, newChunk);
                    if (next == null) {
                        ChunkList.access$502(ChunkList.this, newChunk);
                    } else {
                        ChunkList.setPrev(next, newChunk);
                        ChunkList.setNext(newChunk, next);
                    }
                    this.startIndex += 64;
                    this.chunk = newChunk;
                    this.nextIndex = 3;
                    this.end = 3;
                }
            } else {
                if (this.end == 67) {
                    Object[] newChunk = new Object[67];
                    Object[] next = ChunkList.next(this.chunk);
                    ChunkList.setNext(newChunk, next);
                    if (next != null) {
                        ChunkList.setPrev(next, newChunk);
                    }
                    ChunkList.setPrev(newChunk, this.chunk);
                    ChunkList.setNext(this.chunk, newChunk);
                    int newSize = 32;
                    int remainingEnd = this.end - 32;
                    System.arraycopy(this.chunk, remainingEnd, newChunk, 3, 32);
                    Arrays.fill(this.chunk, remainingEnd, this.end, null);
                    if (this.nextIndex <= remainingEnd) {
                        this.end = remainingEnd;
                        ChunkList.setEnd(newChunk, 35);
                    } else {
                        ChunkList.setEnd(this.chunk, remainingEnd);
                        this.chunk = newChunk;
                        this.end = 35;
                        this.nextIndex -= remainingEnd - 3;
                    }
                }
                System.arraycopy(this.chunk, this.nextIndex, this.chunk, this.nextIndex + 1, this.end - this.nextIndex);
            }
            ChunkList.setElement(this.chunk, this.nextIndex, e);
            ++this.end;
            ChunkList.setEnd(this.chunk, this.end);
            ++ChunkList.this.size;
        }
    }
}

