/*
 * Decompiled with CFR 0.152.
 */
package mondrian.xmla.impl;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URL;
import javax.servlet.ServletConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import mondrian.olap.MondrianServer;
import mondrian.olap.Util;
import mondrian.server.RepositoryContentFinder;
import mondrian.server.UrlRepositoryContentFinder;
import mondrian.spi.CatalogLocator;
import mondrian.spi.impl.ServletContextCatalogLocator;
import mondrian.xmla.XmlaHandler;
import mondrian.xmla.impl.DefaultXmlaServlet;

public class MondrianXmlaServlet
extends DefaultXmlaServlet {
    public static final String DEFAULT_DATASOURCE_FILE = "datasources.xml";
    protected MondrianServer server;

    protected XmlaHandler.ConnectionFactory createConnectionFactory(ServletConfig servletConfig) throws ServletException {
        if (this.server == null) {
            CatalogLocator catalogLocator = this.makeCatalogLocator(servletConfig);
            String dataSources = this.makeDataSourcesUrl(servletConfig);
            RepositoryContentFinder contentFinder = this.makeContentFinder(dataSources);
            this.server = MondrianServer.createWithRepository(contentFinder, catalogLocator);
        }
        return (XmlaHandler.ConnectionFactory)this.server;
    }

    public void destroy() {
        super.destroy();
        if (this.server != null) {
            this.server.shutdown();
            this.server = null;
        }
    }

    protected RepositoryContentFinder makeContentFinder(String dataSources) {
        return new UrlRepositoryContentFinder(dataSources);
    }

    protected CatalogLocator makeCatalogLocator(ServletConfig servletConfig) {
        ServletContext servletContext = servletConfig.getServletContext();
        return new ServletContextCatalogLocator(servletContext);
    }

    protected String makeDataSourcesUrl(ServletConfig servletConfig) {
        String paramValue = servletConfig.getInitParameter("DataSourcesConfig");
        boolean optional = MondrianXmlaServlet.getBooleanInitParameter((ServletConfig)servletConfig, (String)"OptionalDataSourceConfig");
        URL dataSourcesConfigUrl = null;
        try {
            if (paramValue == null) {
                String defaultDS = "WEB-INF/datasources.xml";
                ServletContext servletContext = servletConfig.getServletContext();
                File realPath = new File(servletContext.getRealPath(defaultDS));
                if (realPath.exists()) {
                    dataSourcesConfigUrl = realPath.toURL();
                    return dataSourcesConfigUrl.toString();
                }
                return null;
            }
            if (paramValue.startsWith("inline:")) {
                return paramValue;
            }
            paramValue = Util.replaceProperties(paramValue, Util.toMap(System.getProperties()));
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug((Object)("XmlaServlet.makeDataSources: paramValue=" + paramValue));
            }
            MalformedURLException mue = null;
            try {
                dataSourcesConfigUrl = new URL(paramValue);
            }
            catch (MalformedURLException e) {
                mue = e;
            }
            if (dataSourcesConfigUrl == null) {
                File f = new File(paramValue);
                if (f.exists()) {
                    dataSourcesConfigUrl = f.toURL();
                } else if (mue != null && !optional) {
                    throw mue;
                }
                return null;
            }
            return dataSourcesConfigUrl.toString();
        }
        catch (MalformedURLException mue) {
            throw Util.newError(mue, "invalid URL path '" + paramValue + "'");
        }
    }
}

