package org.jasig.cas.client.statuscheck;

import org.jasig.cas.client.util.DomainUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.*;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

import static org.jasig.cas.client.util.AbstractCasFilter.CONST_CAS_ASSERTION;

/**
 * Created by huang on 2017/9/17.
 */
public class WechatSessionCheckFilter implements Filter {

    private static final Logger logger = LoggerFactory.getLogger(WechatSessionCheckFilter.class);

    public static final String ALREADY_FILTERED_SUFFIX = "WechatSessionCheckFilter.FILTERED";

    private String wechatSessionUrl;

    public void init(FilterConfig filterConfig) throws ServletException {
        wechatSessionUrl = filterConfig.getInitParameter("wechatSessionUrl");
        if(wechatSessionUrl == null || "".equals(wechatSessionUrl.trim())){
            throw new RuntimeException("wechat 会话获取地址不能为空不能为空 ｛wechatSessionUrl｝");
        }
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
//直接通过filter 不处理
        if(servletRequest.getAttribute("__pass_sso")!=null){
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        boolean hasAlreadyFilteredAttribute = request.getAttribute(ALREADY_FILTERED_SUFFIX) != null;

        if (hasAlreadyFilteredAttribute) {
            filterChain.doFilter(request, response);
        }else {
            request.setAttribute(ALREADY_FILTERED_SUFFIX, Boolean.TRUE);

            if(request.getAttribute(CONST_CAS_ASSERTION)!=null ||( request.getSession()!=null && request.getSession().getAttribute(CONST_CAS_ASSERTION)!=null)){
                filterChain.doFilter(servletRequest, servletResponse);
                return;
            }

//            final String userAgent = request.getHeader("User-Agent");
//            try {
//                if(userAgent.toLowerCase().indexOf("micromessenger")>0){
//                    logger.info("检查wechat cookie 登录");
//
//                    //取cookie 中的信息
//                    String wk = null;
//                    if(request.getCookies()!=null){
//                        for (Cookie cookie : request.getCookies()) {
//                            if("__wt".equals(cookie.getName())){
//                                wk= cookie.getValue();
//                                break;
//                            }
//                        }
//                    }
//                    logger.info("微信cookie中wt的值：{}",wk);
//                    if(wk!=null && !"".equals(wk.trim())){
//                        URL url=new URL(this.wechatSessionUrl+wk);
//                        URLConnection conn=null;
//                        BufferedReader reader = null;
//
//                        StringBuffer resultBuffer = null;
//                        try {
//                            conn = url.openConnection();
//
//                            //2.处理设置参数和一般请求属性
//                            //2.1设置参数
//                            //可以根据请求的需要设置参数
//                            conn.setUseCaches(false);
//                            conn.setConnectTimeout(5000); //请求超时时间
//
//                            //2.2请求属性
//                            //设置通用的请求属性 更多的头字段信息可以查阅HTTP协议
//                            conn.setRequestProperty("accept", "*/*");
//                            conn.setRequestProperty("connection", "Keep-Alive");
//
//                            //3.使用 connect 方法建立到远程对象的实际连接。
//                            conn.connect();
//
//                            //4.2获取响应正文
//                            resultBuffer = new StringBuffer();
//                            String tempLine = null;
//
//                            reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
//                            while ((tempLine = reader.readLine()) != null) {
//                                resultBuffer.append(tempLine);
//                            }
//                        } catch (IOException e) {
//                            logger.error(e.getLocalizedMessage(),e);
//                        } finally {
//                            if(conn!=null){
//                            }
//                            if(reader!=null){
//                                reader.close();
//                            }
//                        }
//                        Map<String,Object> map = new HashMap();
//                        if(resultBuffer!=null){
//                            String responseStr = resultBuffer.toString();
//                            responseStr = responseStr.replaceFirst("\\{","").replaceFirst("\\}","");
//                            String [] props = responseStr.split(",");
//                            for (String prop : props) {
//                                String []kv = prop.split(":");
//                                if(kv.length==2){
//                                    map.put(kv[0].replaceAll("\"",""),kv[1].replaceAll("\"",""));
//                                }
//                            }
//                        }
//                        logger.info("调用wechatapi查询用户信息map：{}",map.size());
//                        if(map.size()>0 && map.get("id")!=null){
//                            AttributePrincipal attributePrincipal = new AttributePrincipalImpl(map.get("id").toString(),map);
//                            Assertion assertion = new AssertionImpl(attributePrincipal,map);
//                            request.setAttribute(CONST_CAS_ASSERTION, assertion);
//                            if (request.getSession()!=null) {
//                                request.getSession().setAttribute(CONST_CAS_ASSERTION, assertion);
//                            }
//                            logger.info("调用wechatapi返回的用户信息set：CONST_CAS_ASSERTION");
//
//                        }else{
//                            logger.info("微信cookie无效，进行删除");
//
//                            //cookie 已经无效，删除
//                            deleteWkCookie(request, response);
//                        }
//                    }
//                }
//            } catch (IOException e) {
//                logger.error("cooke 无效，处理失败",e);
//                //删除wk cookie
//                deleteWkCookie(request, response);
//            }

            filterChain.doFilter(servletRequest, servletResponse);
        }
    }

    private void deleteWkCookie(HttpServletRequest request, HttpServletResponse response) {
        try {
            Cookie cookie = new Cookie("__wt","");
            String mainDomain = DomainUtils.getMainDomain(request.getServerName());
            cookie.setDomain(mainDomain);
//        cookie.setHttpOnly(true);
            cookie.setPath("/");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        } catch (Exception e) {
            logger.warn("异常信息：{}", e);
        }
    }

    public String regexMapStr(String regex,String body){
        Matcher matcher= Pattern.compile(regex).matcher(body);
        while(matcher.find())
        {
            String ret=matcher.group(1);
            return ret;
        }
        return "";
    }

    public void destroy() {

    }

}
