package org.jasig.cas.client.util;

import jdk.nashorn.internal.runtime.regexp.joni.Regex;

import java.util.regex.Pattern;

/**
 * Created by huang on 2017/10/26.
 */
public abstract class DomainUtils {

    private static Pattern r = Pattern.compile("((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})(\\.((2(5[0-5]|[0-4]\\d))|[0-1]?\\d{1,2})){3}");

    public static String getMainDomain(String domain){

        if (r.matcher(domain).matches()) {
            return domain;
        }

        String str = domain.replace("http://","").replace("https://","");
        String [] l = str.split("\\.");
        int length = l.length;
        int l2= length;
        if(length>1){
            l2 = length -2;
        }
        StringBuilder sb = new StringBuilder();
        for(;l2<length;l2++){
            sb.append(l[l2]+".");
        }
        String mainDomain = "";
        if(sb.toString().endsWith(".")){
            mainDomain = sb.toString().substring(0,sb.length()-1);
        }else{
            mainDomain = sb.toString();
        }
        return mainDomain;
    }

    public static String getCookieMainDomain(String domain){
        return getMainDomain(domain);
    }

    /*public static void main(String []args){

        System.out.println(getMainDomain("ipiccgd.com"));
        System.out.println(getMainDomain("www.ipiccgd.com"));
        System.out.println(getMainDomain("xx.ipiccgd.com"));
        System.out.println(getMainDomain("xxx.ooo.ipiccgd.com"));
    }*/
}
