/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.authentication;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.IOException;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.HashMap;
import java.util.Map;
import javax.imageio.ImageIO;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.authentication.AuthenticationRedirectStrategy;
import org.jasig.cas.client.authentication.ContainsPatternUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.DefaultAuthenticationRedirectStrategy;
import org.jasig.cas.client.authentication.DefaultGatewayResolverImpl;
import org.jasig.cas.client.authentication.ExactUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.GatewayResolver;
import org.jasig.cas.client.authentication.RegexUrlPatternMatcherStrategy;
import org.jasig.cas.client.authentication.UrlPatternMatcherStrategy;
import org.jasig.cas.client.configuration.ConfigurationKeys;
import org.jasig.cas.client.util.AbstractCasFilter;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.ReflectUtils;
import org.jasig.cas.client.validation.Assertion;

public class AuthenticationFilter
extends AbstractCasFilter {
    private String casServerLoginUrl;
    private boolean renew = false;
    private String clientSourceTarget;
    private String casServerUrlPrefix;
    private String ajaxLoginCallBackUrlPrefix;
    private boolean gateway = false;
    private GatewayResolver gatewayStorage = new DefaultGatewayResolverImpl();
    private AuthenticationRedirectStrategy authenticationRedirectStrategy = new DefaultAuthenticationRedirectStrategy();
    private UrlPatternMatcherStrategy ignoreUrlPatternMatcherStrategyClass = null;
    private static final Map<String, Class<? extends UrlPatternMatcherStrategy>> PATTERN_MATCHER_TYPES = new HashMap<String, Class<? extends UrlPatternMatcherStrategy>>();

    public AuthenticationFilter() {
        this(Protocol.CAS2);
    }

    protected AuthenticationFilter(Protocol protocol) {
        super(protocol);
    }

    public void setCasServerUrlPrefix(String casServerUrlPrefix) {
        this.casServerUrlPrefix = casServerUrlPrefix;
    }

    public void setAjaxLoginCallBackUrlPrefix(String ajaxLoginCallBackUrlPrefix) {
        this.ajaxLoginCallBackUrlPrefix = ajaxLoginCallBackUrlPrefix;
    }

    protected void initInternal(FilterConfig filterConfig) throws ServletException {
        if (!this.isIgnoreInitConfiguration()) {
            Class authenticationRedirectStrategyClass;
            Class gatewayStorageClass;
            super.initInternal(filterConfig);
            this.setCasServerLoginUrl(this.getString(ConfigurationKeys.CAS_SERVER_LOGIN_URL));
            this.setClientSourceTarget(filterConfig.getInitParameter("clientSourceTarget"));
            this.setAjaxLoginCallBackUrlPrefix(filterConfig.getInitParameter("ajaxLoginCallBackUrlPrefix"));
            this.setCasServerUrlPrefix(filterConfig.getInitParameter("casServerUrlPrefix"));
            if (this.casServerUrlPrefix == null) {
                this.casServerUrlPrefix = this.casServerLoginUrl.replace("/login", "");
            }
            this.setRenew(this.getBoolean(ConfigurationKeys.RENEW));
            this.setGateway(this.getBoolean(ConfigurationKeys.GATEWAY));
            String ignorePattern = this.getString(ConfigurationKeys.IGNORE_PATTERN);
            String ignoreUrlPatternType = this.getString(ConfigurationKeys.IGNORE_URL_PATTERN_TYPE);
            if (ignorePattern != null) {
                Class<? extends UrlPatternMatcherStrategy> ignoreUrlMatcherClass = PATTERN_MATCHER_TYPES.get(ignoreUrlPatternType);
                if (ignoreUrlMatcherClass != null) {
                    this.ignoreUrlPatternMatcherStrategyClass = (UrlPatternMatcherStrategy)ReflectUtils.newInstance(ignoreUrlMatcherClass.getName(), new Object[0]);
                } else {
                    try {
                        this.logger.trace("Assuming {} is a qualified class name...", (Object)ignoreUrlPatternType);
                        this.ignoreUrlPatternMatcherStrategyClass = (UrlPatternMatcherStrategy)ReflectUtils.newInstance(ignoreUrlPatternType, new Object[0]);
                    }
                    catch (IllegalArgumentException e) {
                        this.logger.error("Could not instantiate class [{}]", (Object)ignoreUrlPatternType, (Object)e);
                    }
                }
                if (this.ignoreUrlPatternMatcherStrategyClass != null) {
                    this.ignoreUrlPatternMatcherStrategyClass.setPattern(ignorePattern);
                }
            }
            if ((gatewayStorageClass = this.getClass(ConfigurationKeys.GATEWAY_STORAGE_CLASS)) != null) {
                this.setGatewayStorage((GatewayResolver)ReflectUtils.newInstance(gatewayStorageClass, new Object[0]));
            }
            if ((authenticationRedirectStrategyClass = this.getClass(ConfigurationKeys.AUTHENTICATION_REDIRECT_STRATEGY_CLASS)) != null) {
                this.authenticationRedirectStrategy = (AuthenticationRedirectStrategy)ReflectUtils.newInstance(authenticationRedirectStrategyClass, new Object[0]);
            }
        }
    }

    public void init() {
        super.init();
        CommonUtils.assertNotNull(this.casServerLoginUrl, "casServerLoginUrl cannot be null.");
    }

    private final String getLoginImgStr(String url) {
        String script = "(function(){\n\tvar body = document.getElementsByTagName('body')[0];\n\tvar img = document.createElement(\"img\");\n\timg.src = '" + url + "';\n\timg.style.display='none'\n\tbody.appendChild(img); \n})();\n";
        return script;
    }

    public final void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        String modifiedServiceUrl;
        boolean wasGatewayed;
        if (servletRequest.getAttribute("__pass_sso") != null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        HttpServletResponse response = (HttpServletResponse)servletResponse;
        if (this.isRequestUrlExcluded(request)) {
            this.logger.debug("Request is ignored.");
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        Boolean cookLoginFlag = false;
        if (request.getCookies() != null) {
            for (Cookie cookie : request.getCookies()) {
                if (!"__l".equals(cookie.getName()) || !"true".equals(cookie.getValue())) continue;
                cookLoginFlag = true;
                break;
            }
        }
        Boolean sessionLoginFlag = false;
        Boolean cookieUuidFlag = false;
        String cookieUid = null;
        String uuid = null;
        if (request.getAttribute("_const_cas_assertion_") != null || request.getSession() != null && request.getSession().getAttribute("_const_cas_assertion_") != null) {
            sessionLoginFlag = true;
            uuid = (String)request.getSession().getAttribute("principaluuid");
            if (request.getCookies() != null && uuid != null && !"".equals(uuid)) {
                for (Cookie cookie : request.getCookies()) {
                    if (!"__u".equals(cookie.getName())) continue;
                    cookieUid = cookie.getValue();
                    break;
                }
            }
        }
        if (cookieUid == null || "".equals(cookieUid) || cookieUid.equals(uuid)) {
            cookieUuidFlag = true;
        }
        if (sessionLoginFlag.booleanValue() && cookLoginFlag.booleanValue() && cookieUuidFlag.booleanValue()) {
            if (request.getRequestURI().endsWith("_getuserinfo.jsonp")) {
                response.setContentType("application/javascript");
                String functionName = request.getParameter("callback");
                if (functionName == null || "".endsWith(functionName)) {
                    functionName = "callback";
                }
                functionName = functionName.replace("<", "");
                StringBuilder sb = new StringBuilder();
                Assertion assertion = (Assertion)request.getSession().getAttribute("_const_cas_assertion_");
                Map<String, Object> map = assertion.getPrincipal().getAttributes();
                sb.append("{");
                String phone = (String)map.get("phone");
                String email = (String)map.get("email");
                String userName = (String)map.get("userName");
                if (phone != null && phone.length() > 3) {
                    sb.append("\"phone\":\"" + phone.substring(0, 3) + "****\",");
                }
                if (userName != null && !"".equals(userName.trim())) {
                    if (userName.length() > 3) {
                        sb.append("\"userName\":\"" + userName.substring(0, 3) + "****\",");
                    } else {
                        sb.append("\"userName\":\"" + userName + "****\",");
                    }
                }
                if (email != null && email.indexOf("@") > 0) {
                    String emailend = email.substring(email.indexOf("@"), email.length());
                    if ((email = email.substring(0, email.indexOf("@"))).length() > 3) {
                        sb.append("\"email\":\"" + email.substring(0, 3) + "****" + emailend + "\",");
                    } else {
                        sb.append("\"email\":\"" + email + "****" + emailend + "\",");
                    }
                }
                sb.append("\"version\":" + System.currentTimeMillis() + "");
                sb.append("}");
                response.setContentType("application/javascript; charset=UTF-8");
                response.getWriter().write(functionName + "(" + sb.toString() + ")");
                return;
            }
            if (request.getRequestURI().indexOf("_autologin_") >= 0) {
                response.setContentType("image/jpeg");
                BufferedImage bi = new BufferedImage(1, 1, 1);
                ImageIO.write((RenderedImage)bi, "jpg", (OutputStream)response.getOutputStream());
                return;
            }
            if (request.getRequestURI().indexOf("_checkStatus.js") > 0) {
                response.setContentType("application/javascript");
                response.getWriter().write("");
                return;
            }
            if (request.getRequestURI().indexOf("_ajaxLoginCallback.js") > 0) {
                String backuri;
                String logout = request.getParameter("logout");
                if (logout != null && "true".equals(logout.trim()) && request.getSession(false) != null) {
                    request.getSession(false).invalidate();
                }
                if ((backuri = request.getParameter("_backUrl")) == null) {
                    response.sendRedirect(request.getContextPath());
                } else {
                    response.sendRedirect(backuri);
                }
                return;
            }
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (request.getRequestURI().endsWith("_checkStatus.js")) {
            String render = request.getParameter("r");
            if ((render == null || render.trim() == "") && (render = request.getHeader("Referer")) == null) {
                render = "";
            }
            render = this.ajaxLoginCallBackUrlPrefix + "/_ajaxLoginCallback.js?_source_target=" + this.makeSourceTarget(request, response) + "&_backUrl=" + URLEncoder.encode(this.makeLoginCallBackUrl(render, this.makeSourceTarget(request, response), request, response), "UTF-8");
            String prefix = this.casServerLoginUrl.indexOf("?") > 0 ? "&" : "?";
            String urlToRedirectTo = this.casServerLoginUrl + prefix + "service=" + URLEncoder.encode(render, "UTF-8");
            String soureTarget = this.makeSourceTarget(request, response);
            if (soureTarget != null) {
                urlToRedirectTo = urlToRedirectTo + "&_source_target=" + soureTarget;
            }
            response.setContentType("application/javascript");
            response.getWriter().write("window.location.href='" + urlToRedirectTo + "';");
            return;
        }
        String serviceUrl = this.constructServiceUrl(request, response);
        String ticket = this.retrieveTicketFromRequest(request);
        boolean bl = wasGatewayed = this.gateway && this.gatewayStorage.hasGatewayedAlready(request, serviceUrl);
        if (CommonUtils.isNotBlank(ticket) || wasGatewayed) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        this.logger.debug("no ticket and no assertion found");
        if (this.gateway) {
            this.logger.debug("setting gateway attribute in session");
            modifiedServiceUrl = this.gatewayStorage.storeGatewayInformation(request, serviceUrl);
        } else {
            modifiedServiceUrl = serviceUrl;
        }
        modifiedServiceUrl = this.makeLoginCallBackUrl(modifiedServiceUrl, this.makeSourceTarget(request, response), request, response);
        this.logger.debug("Constructed service url: {}", (Object)modifiedServiceUrl);
        String urlToRedirectTo = CommonUtils.constructRedirectUrl(this.casServerLoginUrl, this.getProtocol().getServiceParameterName(), modifiedServiceUrl, this.renew, this.gateway);
        String soureTarget = this.makeSourceTarget(request, response);
        if (soureTarget != null) {
            String prefix = urlToRedirectTo.indexOf("?") > 0 ? "&" : "?";
            urlToRedirectTo = urlToRedirectTo + prefix + "_source_target=" + soureTarget;
        }
        this.logger.debug("redirecting to \"{}\"", (Object)urlToRedirectTo);
        this.authenticationRedirectStrategy.redirect(request, response, urlToRedirectTo, cookieUuidFlag);
    }

    public final void setRenew(boolean renew) {
        this.renew = renew;
    }

    public final void setGateway(boolean gateway) {
        this.gateway = gateway;
    }

    public final void setCasServerLoginUrl(String casServerLoginUrl) {
        this.casServerLoginUrl = casServerLoginUrl;
    }

    public final void setClientSourceTarget(String clientSourceTarget) {
        this.clientSourceTarget = clientSourceTarget;
    }

    protected String makeLoginCallBackUrl(String defaultUrl, String source, HttpServletRequest request, HttpServletResponse response) {
        return defaultUrl;
    }

    protected String makeSourceTarget(HttpServletRequest request, HttpServletResponse response) {
        return this.clientSourceTarget;
    }

    public final void setGatewayStorage(GatewayResolver gatewayStorage) {
        this.gatewayStorage = gatewayStorage;
    }

    private boolean isRequestUrlExcluded(HttpServletRequest request) {
        if (this.ignoreUrlPatternMatcherStrategyClass == null) {
            return false;
        }
        StringBuffer urlBuffer = request.getRequestURL();
        if (request.getQueryString() != null) {
            urlBuffer.append("?").append(request.getQueryString());
        }
        String requestUri = urlBuffer.toString();
        return this.ignoreUrlPatternMatcherStrategyClass.matches(requestUri);
    }

    static {
        PATTERN_MATCHER_TYPES.put("CONTAINS", ContainsPatternUrlPatternMatcherStrategy.class);
        PATTERN_MATCHER_TYPES.put("REGEX", RegexUrlPatternMatcherStrategy.class);
        PATTERN_MATCHER_TYPES.put("EXACT", ExactUrlPatternMatcherStrategy.class);
    }
}

