/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.session;

import java.util.Arrays;
import java.util.List;
import java.util.zip.Inflater;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.binary.Base64;
import org.jasig.cas.client.Protocol;
import org.jasig.cas.client.configuration.ConfigurationKeys;
import org.jasig.cas.client.session.HashMapBackedSessionMappingStorage;
import org.jasig.cas.client.session.SessionMappingStorage;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.util.XmlUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SingleSignOutHandler {
    private static final int DECOMPRESSION_FACTOR = 10;
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private SessionMappingStorage sessionMappingStorage = new HashMapBackedSessionMappingStorage();
    private String artifactParameterName = Protocol.CAS2.getArtifactParameterName();
    private String logoutParameterName = ConfigurationKeys.LOGOUT_PARAMETER_NAME.getDefaultValue();
    private String frontLogoutParameterName = ConfigurationKeys.FRONT_LOGOUT_PARAMETER_NAME.getDefaultValue();
    private String relayStateParameterName = ConfigurationKeys.RELAY_STATE_PARAMETER_NAME.getDefaultValue();
    private String casServerUrlPrefix = "";
    private boolean artifactParameterOverPost = false;
    private boolean eagerlyCreateSessions = true;
    private List<String> safeParameters;
    private LogoutStrategy logoutStrategy = SingleSignOutHandler.isServlet30() ? new Servlet30LogoutStrategy() : new Servlet25LogoutStrategy();

    public void setSessionMappingStorage(SessionMappingStorage storage) {
        this.sessionMappingStorage = storage;
    }

    public void setArtifactParameterOverPost(boolean artifactParameterOverPost) {
        this.artifactParameterOverPost = artifactParameterOverPost;
    }

    public SessionMappingStorage getSessionMappingStorage() {
        return this.sessionMappingStorage;
    }

    public void setArtifactParameterName(String name) {
        this.artifactParameterName = name;
    }

    public void setLogoutParameterName(String name) {
        this.logoutParameterName = name;
    }

    public void setCasServerUrlPrefix(String casServerUrlPrefix) {
        this.casServerUrlPrefix = casServerUrlPrefix;
    }

    public void setFrontLogoutParameterName(String name) {
        this.frontLogoutParameterName = name;
    }

    public void setRelayStateParameterName(String name) {
        this.relayStateParameterName = name;
    }

    public void setEagerlyCreateSessions(boolean eagerlyCreateSessions) {
        this.eagerlyCreateSessions = eagerlyCreateSessions;
    }

    public synchronized void init() {
        if (this.safeParameters == null) {
            CommonUtils.assertNotNull(this.artifactParameterName, "artifactParameterName cannot be null.");
            CommonUtils.assertNotNull(this.logoutParameterName, "logoutParameterName cannot be null.");
            CommonUtils.assertNotNull(this.frontLogoutParameterName, "frontLogoutParameterName cannot be null.");
            CommonUtils.assertNotNull(this.sessionMappingStorage, "sessionMappingStorage cannot be null.");
            CommonUtils.assertNotNull(this.relayStateParameterName, "relayStateParameterName cannot be null.");
            CommonUtils.assertNotNull(this.casServerUrlPrefix, "casServerUrlPrefix cannot be null.");
            if (CommonUtils.isBlank(this.casServerUrlPrefix)) {
                this.logger.warn("Front Channel single sign out redirects are disabled when the 'casServerUrlPrefix' value is not set.");
            }
            this.safeParameters = this.artifactParameterOverPost ? Arrays.asList(this.logoutParameterName, this.artifactParameterName) : Arrays.asList(this.logoutParameterName);
        }
    }

    private boolean isTokenRequest(HttpServletRequest request) {
        return CommonUtils.isNotBlank(CommonUtils.safeGetParameter(request, this.artifactParameterName, this.safeParameters));
    }

    private boolean isBackChannelLogoutRequest(HttpServletRequest request) {
        return "POST".equals(request.getMethod()) && !this.isMultipartRequest(request) && CommonUtils.isNotBlank(CommonUtils.safeGetParameter(request, this.logoutParameterName, this.safeParameters));
    }

    private boolean isFrontChannelLogoutRequest(HttpServletRequest request) {
        return "GET".equals(request.getMethod()) && CommonUtils.isNotBlank(this.casServerUrlPrefix) && CommonUtils.isNotBlank(CommonUtils.safeGetParameter(request, this.frontLogoutParameterName));
    }

    public boolean process(HttpServletRequest request, HttpServletResponse response) {
        if ("GET".equals(request.getMethod()) && "true".equals(request.getParameter("logout"))) {
            request.getSession(false).invalidate();
            return true;
        }
        if (this.isTokenRequest(request)) {
            this.logger.trace("Received a token request");
            this.recordSession(request);
            return true;
        }
        if (this.isBackChannelLogoutRequest(request)) {
            this.logger.trace("Received a back channel logout request");
            this.destroySession(request);
            return false;
        }
        if (this.isFrontChannelLogoutRequest(request)) {
            this.logger.trace("Received a front channel logout request");
            this.destroySession(request);
            String redirectionUrl = this.computeRedirectionToServer(request);
            if (redirectionUrl != null) {
                CommonUtils.sendRedirect(response, redirectionUrl);
            }
            return false;
        }
        this.logger.trace("Ignoring URI for logout: {}", (Object)request.getRequestURI());
        return true;
    }

    private void recordSession(HttpServletRequest request) {
        HttpSession session = request.getSession(this.eagerlyCreateSessions);
        if (session == null) {
            this.logger.debug("No session currently exists (and none created).  Cannot record session information for single sign out.");
            return;
        }
        String token = CommonUtils.safeGetParameter(request, this.artifactParameterName, this.safeParameters);
        this.logger.debug("Recording session for token {}", (Object)token);
        try {
            this.sessionMappingStorage.removeBySessionById(session.getId());
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sessionMappingStorage.addSessionById(token, session);
    }

    private String uncompressLogoutMessage(String originalMessage) {
        byte[] binaryMessage = Base64.decodeBase64((String)originalMessage);
        Inflater decompresser = null;
        try {
            decompresser = new Inflater();
            decompresser.setInput(binaryMessage);
            byte[] result = new byte[binaryMessage.length * 10];
            int resultLength = decompresser.inflate(result);
            String string = new String(result, 0, resultLength, "UTF-8");
            return string;
        }
        catch (Exception e) {
            this.logger.error("Unable to decompress logout message", (Throwable)e);
            throw new RuntimeException(e);
        }
        finally {
            if (decompresser != null) {
                decompresser.end();
            }
        }
    }

    private void destroySession(HttpServletRequest request) {
        HttpSession session;
        String logoutMessage = this.isFrontChannelLogoutRequest(request) ? this.uncompressLogoutMessage(CommonUtils.safeGetParameter(request, this.frontLogoutParameterName)) : CommonUtils.safeGetParameter(request, this.logoutParameterName, this.safeParameters);
        this.logger.trace("Logout request:\n{}", (Object)logoutMessage);
        String token = XmlUtils.getTextForElement(logoutMessage, "SessionIndex");
        if (CommonUtils.isNotBlank(token) && (session = this.sessionMappingStorage.removeSessionByMappingId(token)) != null) {
            String sessionID = session.getId();
            this.logger.debug("Invalidating session [{}] for token [{}]", (Object)sessionID, (Object)token);
            try {
                session.invalidate();
            }
            catch (IllegalStateException e) {
                this.logger.debug("Error invalidating session.", (Throwable)e);
            }
            this.logoutStrategy.logout(request);
        }
    }

    private String computeRedirectionToServer(HttpServletRequest request) {
        String relayStateValue = CommonUtils.safeGetParameter(request, this.relayStateParameterName);
        if (CommonUtils.isNotBlank(relayStateValue)) {
            StringBuilder buffer = new StringBuilder();
            buffer.append(this.casServerUrlPrefix);
            if (!this.casServerUrlPrefix.endsWith("/")) {
                buffer.append("/");
            }
            buffer.append("logout?_eventId=next&");
            buffer.append(this.relayStateParameterName);
            buffer.append("=");
            buffer.append(CommonUtils.urlEncode(relayStateValue));
            String redirectUrl = buffer.toString();
            this.logger.debug("Redirection url to the CAS server: {}", (Object)redirectUrl);
            return redirectUrl;
        }
        return null;
    }

    private boolean isMultipartRequest(HttpServletRequest request) {
        return request.getContentType() != null && request.getContentType().toLowerCase().startsWith("multipart");
    }

    private static boolean isServlet30() {
        try {
            return HttpServletRequest.class.getMethod("logout", new Class[0]) != null;
        }
        catch (NoSuchMethodException e) {
            return false;
        }
    }

    private class Servlet30LogoutStrategy
    implements LogoutStrategy {
        private Servlet30LogoutStrategy() {
        }

        @Override
        public void logout(HttpServletRequest request) {
            try {
                request.logout();
            }
            catch (ServletException e) {
                SingleSignOutHandler.this.logger.debug("Error performing request.logout.");
            }
        }
    }

    private class Servlet25LogoutStrategy
    implements LogoutStrategy {
        private Servlet25LogoutStrategy() {
        }

        @Override
        public void logout(HttpServletRequest request) {
        }
    }

    private static interface LogoutStrategy {
        public void logout(HttpServletRequest var1);
    }
}

