/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.validation;

import java.util.Collections;
import java.util.Date;
import java.util.Map;
import org.jasig.cas.client.authentication.AttributePrincipal;
import org.jasig.cas.client.authentication.AttributePrincipalImpl;
import org.jasig.cas.client.util.CommonUtils;
import org.jasig.cas.client.validation.Assertion;

public final class AssertionImpl
implements Assertion {
    private static final long serialVersionUID = -7767943925833639221L;
    private final Date validFromDate;
    private final Date validUntilDate;
    private final Date authenticationDate;
    private final Map<String, Object> attributes;
    private final AttributePrincipal principal;

    public AssertionImpl(String name) {
        this(new AttributePrincipalImpl(name));
    }

    public AssertionImpl(AttributePrincipal principal) {
        this(principal, Collections.emptyMap());
    }

    public AssertionImpl(AttributePrincipal principal, Map<String, Object> attributes) {
        this(principal, new Date(), null, new Date(), attributes);
    }

    public AssertionImpl(AttributePrincipal principal, Date validFromDate, Date validUntilDate, Date authenticationDate, Map<String, Object> attributes) {
        this.principal = principal;
        this.validFromDate = validFromDate;
        this.validUntilDate = validUntilDate;
        this.attributes = attributes;
        this.authenticationDate = authenticationDate;
        CommonUtils.assertNotNull(this.principal, "principal cannot be null.");
        CommonUtils.assertNotNull(this.validFromDate, "validFromDate cannot be null.");
        CommonUtils.assertNotNull(this.attributes, "attributes cannot be null.");
    }

    @Override
    public Date getAuthenticationDate() {
        return this.authenticationDate;
    }

    @Override
    public Date getValidFromDate() {
        return this.validFromDate;
    }

    @Override
    public Date getValidUntilDate() {
        return this.validUntilDate;
    }

    @Override
    public Map<String, Object> getAttributes() {
        return this.attributes;
    }

    @Override
    public AttributePrincipal getPrincipal() {
        return this.principal;
    }

    @Override
    public boolean isValid() {
        if (this.validFromDate == null) {
            return true;
        }
        Date now = new Date();
        return this.validFromDate.before(now) && (this.validUntilDate == null || this.validUntilDate.after(now));
    }
}

