/*
 * Licensed to Jasig under one or more contributor license
 * agreements. See the NOTICE file distributed with this work
 * for additional information regarding copyright ownership.
 * Jasig licenses this file to you under the Apache License,
 * Version 2.0 (the "License"); you may not use this file
 * except in compliance with the License.  You may obtain a
 * copy of the License at the following location:
 *
 *   http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */
package org.jasig.cas.client.authentication;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.IOException;

/**
 * Implementation of the {@link AuthenticationRedirectStrategy} class that preserves the original behavior that existed prior to 3.3.0.
 *
 * @author Scott Battaglia
 * @since 3.3.0
 */
public final class DefaultAuthenticationRedirectStrategy implements AuthenticationRedirectStrategy {

    public void redirect(final HttpServletRequest request, final HttpServletResponse response,
            final String potentialRedirectUrl) throws IOException {

        //X-Requested-With:XMLHttpRequest
        //当时ajax 请求时返回401 ，并返回登录地址
        if("XMLHttpRequest".equals(request.getHeader("X-Requested-With"))){
            response.setStatus(401);
            response.getWriter().write("{\"success\":false,\"url\":\""+potentialRedirectUrl+"\"}");
            return;
        }

        response.sendRedirect(potentialRedirectUrl);
    }

    public void redirect(HttpServletRequest request, HttpServletResponse response, String potentialRedirectUrl, boolean cookieUuidFlag) throws IOException {
        //当时ajax 请求时返回401 ，并返回登录地址

        if("XMLHttpRequest".equals(request.getHeader("X-Requested-With"))&&!cookieUuidFlag){
            response.setStatus(402);
            response.getWriter().write("{\"success\":false,\"url\":\""+potentialRedirectUrl+"\"}");
            return;
        }else if("XMLHttpRequest".equals(request.getHeader("X-Requested-With"))){
            response.setStatus(401);
            response.getWriter().write("{\"success\":false,\"url\":\""+potentialRedirectUrl+"\"}");
            return;
        }

        response.sendRedirect(potentialRedirectUrl);
    }
}
