package org.jasig.cas.client.statuscheck;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.servlet.*;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.net.URLEncoder;

import static org.jasig.cas.client.util.AbstractCasFilter.CONST_CAS_ASSERTION;
import static org.jasig.cas.client.util.AbstractCasFilter.PRINCIPAL_UU_ID;

/**
 * Created by huang on 2017/9/17.
 */
public class LoginStatusCheckFilter implements Filter {

    public static final String ALREADY_FILTERED_SUFFIX = "LoginStatusCheckFilter.FILTERED";

    private String casServerLoginUrl;

    private String serverName;

    private String defaultClientUrl;

    private String autoCheckLoginStatusUrlPrefix;

    private String autoCheckLoginFlag = "true";

    private Logger logger = LoggerFactory.getLogger(LoginStatusCheckFilter.class);

    public void init(FilterConfig filterConfig) throws ServletException {
        casServerLoginUrl = filterConfig.getInitParameter("casServerLoginUrl");
        serverName = filterConfig.getInitParameter("serverName");
        defaultClientUrl = filterConfig.getInitParameter("defaultClientUrl");
        autoCheckLoginStatusUrlPrefix = filterConfig.getInitParameter("autoCheckLoginStatusUrlPrefix");
        if (filterConfig.getInitParameter("autoCheckLoginFlag") != null) {
            autoCheckLoginFlag = filterConfig.getInitParameter("autoCheckLoginFlag");
        }

        if (casServerLoginUrl == null || "".equals(casServerLoginUrl.trim())) {
            throw new RuntimeException("cas 服务前缀不能为空");
        }
        if (casServerLoginUrl == null || "".equals(casServerLoginUrl.trim())) {
            throw new RuntimeException("默认客户服务退出地址不能为空");
        }

    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {

        //直接通过filter 不处理
        if (servletRequest.getAttribute("__pass_sso") != null) {
            filterChain.doFilter(servletRequest, servletResponse);
            return;
        }

        HttpServletRequest request = (HttpServletRequest) servletRequest;
        HttpServletResponse response = (HttpServletResponse) servletResponse;
        boolean hasAlreadyFilteredAttribute = request.getAttribute(ALREADY_FILTERED_SUFFIX) != null;

        if (hasAlreadyFilteredAttribute) {
            filterChain.doFilter(request, response);
        } else {
            if(request.getRequestURI().endsWith("_client_version")){
                response.setContentType("text/html");
                InputStream inputStream =null;
                try {
                    inputStream = LoginStatusCheckFilter.class.getResourceAsStream("/META-INF/maven/piccgd.sso.client/cas-client-core/pom.properties");
                    ByteArrayOutputStream outStream = new ByteArrayOutputStream();
                    byte[] data = new byte[4096];
                    int count = -1;
                    while((count = inputStream.read(data,0,4096)) != -1)
                        outStream.write(data, 0, count);

                    response.getWriter().write(new String(data));
                    data = null;
                }catch (Exception e){
                    logger.warn("异常信息：{}", e);
                }finally {
                    if(inputStream!=null){
                        inputStream.close();
                    }
                }
                return;
            }

            request.setAttribute(ALREADY_FILTERED_SUFFIX, Boolean.TRUE);
            try {
                //登录状态判断
                Boolean cookLoginFlag = false;
                Cookie[] cookies = request.getCookies();
                if (cookies != null) {
                    for (Cookie cookie : cookies) {
                        if ("__l".equals(cookie.getName())) {
                            if ("true".equals(cookie.getValue())) {
                                cookLoginFlag = true;
                                break;
                            }
                        }
                    }
                }
                Boolean sessionLoginFlag = false;
                Boolean cookieUuidFlag = false;
                String uuid = null;
                String cookieUid = null;
                if (request.getAttribute(CONST_CAS_ASSERTION) != null || (request.getSession() != null && request.getSession().getAttribute(CONST_CAS_ASSERTION) != null)) {
                    sessionLoginFlag = true;
                    uuid = (String) request.getSession().getAttribute(PRINCIPAL_UU_ID);
                    if (request.getCookies() != null && uuid != null && !"".equals(uuid)) {
                        for (Cookie cookie : request.getCookies()) {
                            if ("__u".equals(cookie.getName())) {
                                cookieUid = cookie.getValue();
                                break;
                            }
                        }

                    }
                }
                if (uuid == null || "".equals(uuid) || cookieUid == null || "".equals(cookieUid) || cookieUid.equals(uuid)) {
                    cookieUuidFlag = true;
                }
//                logger.info("cookieUuidFlag:{}",cookieUuidFlag);
                //logger.info(PRINCIPAL_UU_ID+":{}", request.getSession().getAttribute(PRINCIPAL_UU_ID));

                //登录状态为false ，强制退出
                if((!cookieUuidFlag || !cookLoginFlag) && sessionLoginFlag ){
                    request.getSession().invalidate();
                }


                //前后端通过嵌入js方式处理，当_checkStatus.js 在受保护路径，未100%确定已经登录，会直接生定向到登录页面，下面为在未保护页面处理过程
                if (request.getRequestURI().endsWith("_checkStatus.js")) {
                    if (!sessionLoginFlag && cookLoginFlag /*&& cookieUuidFlag*/) {
                        //cookie 状态为已经登录，没会话，自己登录
                        response.setContentType("application/javascript");
                        response.getWriter().write(getLoginImgStr(autoCheckLoginStatusUrlPrefix + "/_autologin_/a.jpg"));
                    }else if ((!cookLoginFlag ||!cookieUuidFlag) && sessionLoginFlag ) {
                        response.setContentType("application/javascript");
                        //fix for 动静分离的情况
//                        String url = "//"+request.getServerName()+((request.getServerPort()==80|| request.getServerPort()==443) ?"":":"+request.getServerPort())+request.getContextPath()+"/logout";
//                        response.getWriter().write(getLoginImgStr(casServerLoginUrl + "/checkStatus?service="+URLEncoder.encode(url,"UTF-8")));
                        //result = result.replace("</body>", "<img style=\"display: none;\" src=\"" + casServerLoginUrl + "/checkStatus\"></body>");
                        if(!cookLoginFlag){
                            request.getSession().invalidate();
                            response.getWriter().write("");
                        }else if(!cookieUuidFlag){
                            request.getSession().invalidate();
                            response.getWriter().write(getLoginImgStr(autoCheckLoginStatusUrlPrefix + "/_autologin_/a.jpg"));
                        }
                    } else {
                        response.setContentType("application/javascript");
                        response.getWriter().write("");
                    }
                    return;
                }

                //添加如果其他系统已登录则往服务端获取用户信息

                // 后端渲染方式处理
                if ("GET".equals(request.getMethod()) && "true".equals(request.getParameter("logout"))) {
                    if (request.getSession(false) != null) request.getSession(false).invalidate();
                    return;
                }

                if (request.getRequestURI().toLowerCase().endsWith("/logout")) {
                    request.getSession().invalidate();
                    String service = request.getParameter("service");
                    service = service == null || "".equals(service) ? request.getHeader("Referer") : service;
                    if (service == null) {
                        service = defaultClientUrl;
                    }
                    String loginOutCallBackUrl = makeLogoutUrl(service, request, response);
                    if (loginOutCallBackUrl == null || "".equals(loginOutCallBackUrl.trim())) {
                        response.sendRedirect(casServerLoginUrl + "/logout?service=" + URLEncoder.encode(service,"UTF-8"));
                    } else {
                        response.sendRedirect(casServerLoginUrl + "/logout?service=" + URLEncoder.encode(loginOutCallBackUrl,"UTF-8") + "&redirect=true");
                    }
                    return;
                }else if (request.getHeader("Accept") != null && request.getHeader("Accept").toLowerCase().indexOf("text/html") < 0) {
                    filterChain.doFilter(request, response);
                    return;
                }else {

                    if (!cookieUuidFlag && request.getUserPrincipal() != null && "GET".equals(request.getMethod())) {
                        request.getSession().invalidate();
                        serverLogin(request, response);
                        return;
                    }
                    //已经确认已经登录或者退出  ,或者不自动生成检查图片
                    if ((sessionLoginFlag && cookLoginFlag && cookieUuidFlag) || (!sessionLoginFlag && !cookLoginFlag && !cookieUuidFlag) || !"true".equals(autoCheckLoginFlag)) {
                        filterChain.doFilter(servletRequest, servletResponse);
                        return;
                    }

                    ResponseWrapper mr = new ResponseWrapper(response);
                    filterChain.doFilter(request, mr);
//                    mr.getWriter().flush();
                    //response.getStatus() 只有servlet 3 有这个方法 ，需要屏蔽
                    if (response.getWriter() != null /*&& response.getStatus() == 200*/ && response.getContentType() != null &&
                            response.getContentType().toLowerCase().indexOf("text/html") >= 0) {
                        if (response.isCommitted()) return;
                        PrintWriter out = response.getWriter();
                        String result = mr.getResult();
                        if (result.toLowerCase().indexOf("</body>") > 0) {
                            if (/*cookieUuidFlag &&*/ cookLoginFlag && !sessionLoginFlag) {
                                //cookie 状态已经登录，session 没会话
                                result = result.replace("</body>", "<img style=\"display: none;\" src=\"" + autoCheckLoginStatusUrlPrefix + "/_autologin_/a.jpg\"></body>");
                            } else if ((!cookLoginFlag ||!cookieUuidFlag) && sessionLoginFlag ) {
                                result = result.replace("</body>", "<img style=\"display: none;\" src=\"" + casServerLoginUrl + "/checkStatus\"></body>");
                            }
                        }
                        if(result==null || "".equals(result)){
                            logger.error("================== result is null :{}",result);
                        }
//                        System.out.println("+++++++++++长度为："+result.getBytes().length);
//                        System.out.println(result);
                        response.setContentLength(-1);
                        out.write(result);
                    }else{
                        PrintWriter out = response.getWriter();
                        out.write(mr.getResult());
                    }
                    return;
                }
            } finally {
                request.removeAttribute(ALREADY_FILTERED_SUFFIX);
            }
        }
    }

    /**
     * 自定义生成退出地址
     *
     * @param defaultUrl
     * @param request
     * @param response
     * @return 还回null 或者 "' ,表示按默认行为处理
     */
    protected String makeLogoutUrl(String defaultUrl, HttpServletRequest request, HttpServletResponse response) {
        return null;
    }

    private final String getLoginImgStr(String url) {
        String script = "(function(){\n" +
                "\tvar body = document.getElementsByTagName('body')[0];\n" +
                "\tvar img = document.createElement(\"img\");\n" +
                "\timg.src = '" + url + "';\n" +
                "\timg.style.display='none'\n" +
                "\tbody.appendChild(img); \n" +
                "})();\n";
        return script;
    }


    public void serverLogin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String suffix = (request.getQueryString() == null || "".equals(request.getQueryString())) ? "" : "?" + request.getQueryString();
        String service = URLEncoder.encode(request.getRequestURL() + suffix, "utf-8");
        String redirectLoginUrl = casServerLoginUrl + "?service=" + service;
        response.sendRedirect(redirectLoginUrl);
    }

    public void destroy() {

    }


}
