package org.jasig.cas.client.statuscheck;

import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;

//import javax.servlet.WriteListener;

/**
 * Created by huang on 2017/9/17.
 *
 */
public class ResponseWrapper extends HttpServletResponseWrapper {

    private PrintWriter cachedWriter;
    ByteArrayOutputStream byteArrayOutputStream ;

    public ResponseWrapper(HttpServletResponse response) throws IOException {
        super(response);
        byteArrayOutputStream = new ByteArrayOutputStream();
        cachedWriter = new PrintWriter(byteArrayOutputStream);
    }

    @Override
    public ServletOutputStream getOutputStream() throws IOException {
        return new ServletOutputStream() {
//            @Override
            public boolean isReady() {
                return true;
            }
//            @Override
//            public void setWriteListener(WriteListener listener) {}

            @Override
            public void write(int b) throws IOException {
//                cachedWriter.write(b);
                byteArrayOutputStream.write(b);
            }
        };
    }

    public PrintWriter getWriter() throws IOException {
        return cachedWriter;
    }

    public byte[] getBytes(){
        return byteArrayOutputStream.toByteArray();
    }

    public String getResult() throws UnsupportedEncodingException {
        cachedWriter.flush();
        byte[] bytes = byteArrayOutputStream.toByteArray();
        return new String(bytes, "UTF-8");
    }
}
