/*
 * Decompiled with CFR 0.152.
 */
package pl.project13.maven.git;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.Lists;
import com.google.common.io.Closeables;
import com.google.common.io.Files;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Reader;
import java.io.Writer;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.TimeZone;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.Mojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import pl.project13.maven.git.CommitIdGenerationMode;
import pl.project13.maven.git.GitCommitIdExecutionException;
import pl.project13.maven.git.GitDataProvider;
import pl.project13.maven.git.GitDescribeConfig;
import pl.project13.maven.git.GitDirLocator;
import pl.project13.maven.git.JGitProvider;
import pl.project13.maven.git.NativeGitProvider;
import pl.project13.maven.git.log.LoggerBridge;
import pl.project13.maven.git.log.MavenLoggerBridge;
import pl.project13.maven.git.util.PropertyManager;

@org.apache.maven.plugins.annotations.Mojo(name="revision", defaultPhase=LifecyclePhase.INITIALIZE, threadSafe=true)
public class GitCommitIdMojo
extends AbstractMojo {
    public static final String BRANCH = "branch";
    public static final String DIRTY = "dirty";
    public static final String COMMIT_ID_FLAT = "commit.id";
    public static final String COMMIT_ID_FULL = "commit.id.full";
    public static final String COMMIT_ID_ABBREV = "commit.id.abbrev";
    public static final String COMMIT_DESCRIBE = "commit.id.describe";
    public static final String COMMIT_SHORT_DESCRIBE = "commit.id.describe-short";
    public static final String BUILD_AUTHOR_NAME = "build.user.name";
    public static final String BUILD_AUTHOR_EMAIL = "build.user.email";
    public static final String BUILD_TIME = "build.time";
    public static final String BUILD_VERSION = "build.version";
    public static final String BUILD_HOST = "build.host";
    public static final String COMMIT_AUTHOR_NAME = "commit.user.name";
    public static final String COMMIT_AUTHOR_EMAIL = "commit.user.email";
    public static final String COMMIT_MESSAGE_FULL = "commit.message.full";
    public static final String COMMIT_MESSAGE_SHORT = "commit.message.short";
    public static final String COMMIT_TIME = "commit.time";
    public static final String REMOTE_ORIGIN_URL = "remote.origin.url";
    public static final String TAGS = "tags";
    public static final String CLOSEST_TAG_NAME = "closest.tag.name";
    public static final String CLOSEST_TAG_COMMIT_COUNT = "closest.tag.commit.count";
    @Parameter(defaultValue="${project}", readonly=true, required=true)
    MavenProject project;
    @Parameter(defaultValue="${reactorProjects}", readonly=true)
    private List<MavenProject> reactorProjects;
    @Parameter(property="session", required=true, readonly=true)
    private MavenSession session;
    @Parameter(defaultValue="false")
    private boolean injectAllReactorProjects;
    @Parameter(defaultValue="false")
    private boolean verbose;
    @Parameter(defaultValue="true")
    private boolean skipPoms;
    @Parameter(defaultValue="false")
    private boolean generateGitPropertiesFile;
    @Parameter(defaultValue="${project.build.outputDirectory}/git.properties")
    private String generateGitPropertiesFilename;
    @Parameter(defaultValue="${project.basedir}/.git")
    private File dotGitDirectory;
    @Parameter
    private GitDescribeConfig gitDescribe;
    @Parameter(defaultValue="7")
    private int abbrevLength;
    @Parameter(defaultValue="properties")
    private String format;
    @Parameter(defaultValue="git")
    private String prefix;
    private String prefixDot = "";
    @Parameter(defaultValue="dd.MM.yyyy '@' HH:mm:ss z")
    private String dateFormat;
    @Parameter
    private String dateFormatTimeZone;
    @Parameter(defaultValue="true")
    private boolean failOnNoGitDirectory;
    @Parameter(defaultValue="true")
    private boolean failOnUnableToExtractRepoInfo;
    @Parameter(defaultValue="false")
    private boolean useNativeGit;
    @Parameter(defaultValue="false")
    private boolean skip;
    @Parameter(defaultValue="false")
    private boolean runOnlyOnce;
    @Parameter
    private List<String> excludeProperties;
    @Parameter
    private List<String> includeOnlyProperties;
    @Parameter(defaultValue="flat")
    private String commitIdGenerationMode;
    private CommitIdGenerationMode commitIdGenerationModeEnum;
    private Properties properties;
    private Charset sourceCharset = StandardCharsets.UTF_8;
    @NotNull
    private final LoggerBridge log = new MavenLoggerBridge((Mojo)this, false);

    public void execute() throws MojoExecutionException {
        try {
            this.log.setVerbose(this.verbose);
            String sourceEncoding = this.project.getProperties().getProperty("project.build.sourceEncoding");
            this.sourceCharset = null != sourceEncoding ? Charset.forName(sourceEncoding) : Charset.defaultCharset();
            if (this.skip) {
                this.log.info("skip is enabled, skipping execution!");
                return;
            }
            if (this.runOnlyOnce && !this.session.getExecutionRootDirectory().equals(this.session.getCurrentProject().getBasedir().getAbsolutePath())) {
                this.log.info("runOnlyOnce is enabled and this project is not the top level project, skipping execution!");
                return;
            }
            if (this.isPomProject(this.project) && this.skipPoms) {
                this.log.info("isPomProject is true and skipPoms is true, return");
                return;
            }
            this.dotGitDirectory = this.lookupGitDirectory();
            if (this.failOnNoGitDirectory && !this.directoryExists(this.dotGitDirectory)) {
                throw new GitCommitIdExecutionException(".git directory is not found! Please specify a valid [dotGitDirectory] in your pom.xml");
            }
            if (this.gitDescribe == null) {
                this.gitDescribe = new GitDescribeConfig();
            }
            if (this.dotGitDirectory == null) {
                this.log.info("dotGitDirectory is null, aborting execution!");
                return;
            }
            this.log.info("dotGitDirectory {}", (Object)this.dotGitDirectory.getAbsolutePath());
            try {
                try {
                    this.commitIdGenerationModeEnum = CommitIdGenerationMode.valueOf(this.commitIdGenerationMode.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    this.log.warn("Detected wrong setting for 'commitIdGenerationMode'. Falling back to default 'flat' mode!");
                    this.commitIdGenerationModeEnum = CommitIdGenerationMode.FLAT;
                }
                this.properties = this.initProperties();
                String trimmedPrefix = this.prefix.trim();
                this.prefixDot = trimmedPrefix.equals("") ? "" : trimmedPrefix + ".";
                this.loadGitData(this.properties);
                this.loadBuildVersionAndTimeData(this.properties);
                this.loadBuildHostData(this.properties);
                this.loadShortDescribe(this.properties);
                this.filter(this.properties, this.includeOnlyProperties);
                this.filterNot(this.properties, this.excludeProperties);
                this.logProperties(this.properties);
                if (this.generateGitPropertiesFile) {
                    this.maybeGeneratePropertiesFile(this.properties, this.project.getBasedir(), this.generateGitPropertiesFilename);
                }
                if (this.injectAllReactorProjects) {
                    this.appendPropertiesToReactorProjects(this.properties, this.prefixDot);
                }
            }
            catch (Exception e) {
                this.handlePluginFailure(e);
            }
        }
        catch (GitCommitIdExecutionException e) {
            throw new MojoExecutionException(e.getMessage(), (Exception)e);
        }
    }

    private void filterNot(Properties properties, @Nullable List<String> exclusions) {
        if (exclusions == null || exclusions.isEmpty()) {
            return;
        }
        List excludePredicates = Lists.transform(exclusions, (Function)new Function<String, Predicate<CharSequence>>(){

            public Predicate<CharSequence> apply(String exclude) {
                return Predicates.containsPattern((String)exclude);
            }
        });
        Predicate shouldExclude = Predicates.alwaysFalse();
        for (Predicate predicate : excludePredicates) {
            shouldExclude = Predicates.or((Predicate)shouldExclude, (Predicate)predicate);
        }
        for (String key : properties.stringPropertyNames()) {
            if (!shouldExclude.apply((Object)key)) continue;
            this.log.debug("shouldExclude.apply({}) = {}", (Object)key, (Object)shouldExclude.apply((Object)key));
            properties.remove(key);
        }
    }

    private void filter(Properties properties, @Nullable List<String> inclusions) {
        if (inclusions == null || inclusions.isEmpty()) {
            return;
        }
        List includePredicates = Lists.transform(inclusions, (Function)new Function<String, Predicate<CharSequence>>(){

            public Predicate<CharSequence> apply(String exclude) {
                return Predicates.containsPattern((String)exclude);
            }
        });
        Predicate shouldInclude = Predicates.alwaysFalse();
        for (Predicate predicate : includePredicates) {
            shouldInclude = Predicates.or((Predicate)shouldInclude, (Predicate)predicate);
        }
        for (String key : properties.stringPropertyNames()) {
            if (shouldInclude.apply((Object)key)) continue;
            this.log.debug("!shouldInclude.apply({}) = {}", (Object)key, (Object)shouldInclude.apply((Object)key));
            properties.remove(key);
        }
    }

    private void handlePluginFailure(Exception e) throws GitCommitIdExecutionException {
        if (this.failOnUnableToExtractRepoInfo) {
            throw new GitCommitIdExecutionException("Could not complete Mojo execution...", e);
        }
        this.log.error(e.getMessage(), e);
    }

    private void appendPropertiesToReactorProjects(@NotNull Properties properties, @NotNull String trimmedPrefixWithDot) {
        for (MavenProject mavenProject : this.reactorProjects) {
            Properties mavenProperties = mavenProject.getProperties();
            this.log.info("{}] project {}", (Object)mavenProject.getName(), (Object)mavenProject.getName());
            for (Object key : properties.keySet()) {
                if (!key.toString().startsWith(trimmedPrefixWithDot)) continue;
                mavenProperties.put(key, properties.get(key));
            }
        }
    }

    @VisibleForTesting
    File lookupGitDirectory() throws GitCommitIdExecutionException {
        return new GitDirLocator(this.project, this.reactorProjects).lookupGitDirectory(this.dotGitDirectory);
    }

    private Properties initProperties() throws GitCommitIdExecutionException {
        if (this.generateGitPropertiesFile) {
            this.properties = new Properties();
            return this.properties;
        }
        this.properties = this.project.getProperties();
        return this.properties;
    }

    private void logProperties(@NotNull Properties properties) {
        for (Object key : properties.keySet()) {
            String keyString = key.toString();
            if (!this.isOurProperty(keyString)) continue;
            this.log.info("found property {}", (Object)keyString);
        }
    }

    private boolean isOurProperty(@NotNull String keyString) {
        return keyString.startsWith(this.prefixDot);
    }

    void loadBuildVersionAndTimeData(@NotNull Properties properties) {
        Date buildDate = new Date();
        SimpleDateFormat smf = new SimpleDateFormat(this.dateFormat);
        if (this.dateFormatTimeZone != null) {
            smf.setTimeZone(TimeZone.getTimeZone(this.dateFormatTimeZone));
        }
        this.put(properties, BUILD_TIME, smf.format(buildDate));
        this.put(properties, BUILD_VERSION, this.project.getVersion());
    }

    void loadBuildHostData(@NotNull Properties properties) {
        String buildHost = null;
        try {
            buildHost = InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            this.log.info("Unable to get build host, skipping property {}. Error message: {}", (Object)BUILD_HOST, (Object)e.getMessage());
        }
        this.put(properties, BUILD_HOST, buildHost);
    }

    void loadShortDescribe(@NotNull Properties properties) {
        String commitDescribe = properties.getProperty(this.prefixDot + COMMIT_DESCRIBE);
        if (commitDescribe != null) {
            int startPos = commitDescribe.indexOf("-g");
            if (startPos > 0) {
                int endPos = commitDescribe.indexOf(45, startPos + 1);
                String commitShortDescribe = endPos < 0 ? commitDescribe.substring(0, startPos) : commitDescribe.substring(0, startPos) + commitDescribe.substring(endPos);
                this.put(properties, COMMIT_SHORT_DESCRIBE, commitShortDescribe);
            } else {
                this.put(properties, COMMIT_SHORT_DESCRIBE, commitDescribe);
            }
        }
    }

    void loadGitData(@NotNull Properties properties) throws GitCommitIdExecutionException {
        if (this.useNativeGit) {
            this.loadGitDataWithNativeGit(properties);
        } else {
            this.loadGitDataWithJGit(properties);
        }
    }

    void loadGitDataWithNativeGit(@NotNull Properties properties) throws GitCommitIdExecutionException {
        try {
            File basedir = this.project.getBasedir().getCanonicalFile();
            GitDataProvider nativeGitProvider = NativeGitProvider.on(basedir, this.log).setPrefixDot(this.prefixDot).setAbbrevLength(this.abbrevLength).setDateFormat(this.dateFormat).setDateFormatTimeZone(this.dateFormatTimeZone).setGitDescribe(this.gitDescribe).setCommitIdGenerationMode(this.commitIdGenerationModeEnum);
            nativeGitProvider.loadGitData(properties);
        }
        catch (IOException e) {
            throw new GitCommitIdExecutionException(e);
        }
    }

    void loadGitDataWithJGit(@NotNull Properties properties) throws GitCommitIdExecutionException {
        GitDataProvider jGitProvider = JGitProvider.on(this.dotGitDirectory, this.log).setPrefixDot(this.prefixDot).setAbbrevLength(this.abbrevLength).setDateFormat(this.dateFormat).setDateFormatTimeZone(this.dateFormatTimeZone).setGitDescribe(this.gitDescribe).setCommitIdGenerationMode(this.commitIdGenerationModeEnum);
        jGitProvider.loadGitData(properties);
    }

    void maybeGeneratePropertiesFile(@NotNull Properties localProperties, File base, String propertiesFilename) throws GitCommitIdExecutionException {
        block14: {
            try {
                File gitPropsFile = this.craftPropertiesOutputFile(base, propertiesFilename);
                boolean isJsonFormat = "json".equalsIgnoreCase(this.format);
                boolean shouldGenerate = true;
                if (gitPropsFile.exists()) {
                    try {
                        Properties persistedProperties;
                        if (isJsonFormat) {
                            this.log.info("Reading existing json file [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.project.getName());
                            persistedProperties = this.readJsonProperties(gitPropsFile);
                        } else {
                            this.log.info("Reading existing properties file [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.project.getName());
                            persistedProperties = this.readProperties(gitPropsFile);
                        }
                        Properties propertiesCopy = (Properties)localProperties.clone();
                        String buildTimeProperty = this.prefixDot + BUILD_TIME;
                        propertiesCopy.remove(buildTimeProperty);
                        persistedProperties.remove(buildTimeProperty);
                        shouldGenerate = !propertiesCopy.equals(persistedProperties);
                    }
                    catch (CannotReadFileException ex) {
                        this.log.info("Cannot read properties file [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.project.getName());
                        shouldGenerate = true;
                    }
                }
                if (shouldGenerate) {
                    Files.createParentDirs((File)gitPropsFile);
                    OutputStreamWriter outputWriter = null;
                    boolean threw = true;
                    try {
                        outputWriter = new OutputStreamWriter((OutputStream)new FileOutputStream(gitPropsFile), this.sourceCharset);
                        if (isJsonFormat) {
                            this.log.info("Writing json file to [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.project.getName());
                            ObjectMapper mapper = new ObjectMapper();
                            mapper.writeValue((Writer)outputWriter, (Object)localProperties);
                        } else {
                            this.log.info("Writing properties file to [{}] (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.project.getName());
                            localProperties.store(outputWriter, "Generated by Git-Commit-Id-Plugin");
                        }
                        threw = false;
                    }
                    catch (IOException ex) {
                        try {
                            throw new RuntimeException("Cannot create custom git properties file: " + gitPropsFile, ex);
                        }
                        catch (Throwable throwable) {
                            Closeables.close(outputWriter, (boolean)threw);
                            throw throwable;
                        }
                    }
                    Closeables.close((Closeable)outputWriter, (boolean)threw);
                    break block14;
                }
                this.log.info("Properties file [{}] is up-to-date (for module {})...", (Object)gitPropsFile.getAbsolutePath(), (Object)this.project.getName());
            }
            catch (IOException e) {
                throw new GitCommitIdExecutionException(e);
            }
        }
    }

    @VisibleForTesting
    File craftPropertiesOutputFile(File base, String propertiesFilename) {
        File returnPath = new File(base, propertiesFilename);
        File currentPropertiesFilepath = new File(propertiesFilename);
        if (currentPropertiesFilepath.isAbsolute()) {
            returnPath = currentPropertiesFilepath;
        }
        return returnPath;
    }

    boolean isPomProject(@NotNull MavenProject project) {
        return project.getPackaging().equalsIgnoreCase("pom");
    }

    private void put(@NotNull Properties properties, String key, String value) {
        String keyWithPrefix = this.prefixDot + key;
        this.log.info(keyWithPrefix + " " + value);
        PropertyManager.putWithoutPrefix(properties, keyWithPrefix, value);
    }

    private boolean directoryExists(@Nullable File fileLocation) {
        return fileLocation != null && fileLocation.exists() && fileLocation.isDirectory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readJsonProperties(@NotNull File jsonFile) throws CannotReadFileException {
        HashMap propertiesMap;
        Closeable closeable = null;
        try {
            boolean threw = true;
            try {
                FileInputStream fis;
                closeable = fis = new FileInputStream(jsonFile);
                InputStreamReader reader = new InputStreamReader((InputStream)fis, this.sourceCharset);
                closeable = reader;
                ObjectMapper mapper = new ObjectMapper();
                TypeReference<HashMap<String, Object>> mapTypeRef = new TypeReference<HashMap<String, Object>>(){};
                propertiesMap = (HashMap)mapper.readValue((Reader)reader, (TypeReference)mapTypeRef);
                threw = false;
            }
            catch (Throwable throwable) {
                Closeables.close(closeable, (boolean)threw);
                throw throwable;
            }
            Closeables.close((Closeable)closeable, (boolean)threw);
        }
        catch (Exception ex) {
            throw new CannotReadFileException(ex);
        }
        Properties retVal = new Properties();
        for (Map.Entry entry : propertiesMap.entrySet()) {
            retVal.setProperty((String)entry.getKey(), String.valueOf(entry.getValue()));
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Properties readProperties(@NotNull File propertiesFile) throws CannotReadFileException {
        Properties properties;
        Closeable closeable = null;
        boolean threw = true;
        try {
            FileInputStream fis;
            closeable = fis = new FileInputStream(propertiesFile);
            InputStreamReader reader = new InputStreamReader((InputStream)fis, this.sourceCharset);
            closeable = reader;
            Properties retVal = new Properties();
            retVal.load(reader);
            threw = false;
            properties = retVal;
        }
        catch (Throwable throwable) {
            try {
                Closeables.close(closeable, (boolean)threw);
                throw throwable;
            }
            catch (Exception ex) {
                throw new CannotReadFileException(ex);
            }
        }
        Closeables.close((Closeable)closeable, (boolean)threw);
        return properties;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public void setDotGitDirectory(File dotGitDirectory) {
        this.dotGitDirectory = dotGitDirectory;
    }

    public void setPrefix(String prefix) {
        this.prefix = prefix;
    }

    public void setDateFormat(String dateFormat) {
        this.dateFormat = dateFormat;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setGitDescribe(GitDescribeConfig gitDescribe) {
        this.gitDescribe = gitDescribe;
    }

    public void setAbbrevLength(int abbrevLength) {
        this.abbrevLength = abbrevLength;
    }

    public void setExcludeProperties(List<String> excludeProperties) {
        this.excludeProperties = excludeProperties;
    }

    public void setIncludeOnlyProperties(List<String> includeOnlyProperties) {
        this.includeOnlyProperties = includeOnlyProperties;
    }

    public void useNativeGit(boolean useNativeGit) {
        this.useNativeGit = useNativeGit;
    }

    public void setCommitIdGenerationMode(String commitIdGenerationMode) {
        this.commitIdGenerationMode = commitIdGenerationMode;
    }

    static class CannotReadFileException
    extends Exception {
        private static final long serialVersionUID = -6290782570018307756L;

        CannotReadFileException(Throwable cause) {
            super(cause);
        }
    }
}

