package provider.api.gateway.business.good.controller;


import goods.dto.product.CategoryQueryDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import pool.dto.*;
import pool.dto.requestParamsEntry.*;
import provider.api.gateway.business.good.service.ProviderGoodsService;
import provider.api.gateway.util.ProviderInfoUtil;
import provider.api.gateway.vo.OauthInfoVo;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

import javax.servlet.http.HttpServletRequest;


/**
 * 供应商商品接口
 *
 * @author wangtao.
 * @date 2018-7-1
 */
@RestController
public class ProviderGoodsController {

    private static final Logger logger = LoggerFactory.getLogger(ProviderGoodsController.class);

    @Autowired
    private ProviderGoodsService providerGoodsService;
    @RequestMapping(value = "test", method = RequestMethod.GET)
    public void test() {

        logger.info("this is a test method.");
    }


    /**
     * pageNo	String	非必须	页数。
     * pageSize	String	非必须	页大小
     * parentId	String	非必须	父ID
     * catClass	String	非必须	分类等级（0:一级； 1:二级；2：三级）
     * 分类查询接口
     */
    @RequestMapping(value = "/get/categories", method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse categories(@RequestBody CategoryQueryDto categoryDto) {
        logger.info("query categories.");
        //  TODO  直接通过工具获取storeId,类别不按供应商区分，故不需要providerId
        return providerGoodsService.categories(categoryDto);
    }

    /**
     * name 必须
     * categoryId 必须
     * 商品品牌创建接口
     */
    @RequestMapping(value = "/create/brands", method = RequestMethod.POST)
    public BaseResponse createBrands(@RequestBody BrandDto brandDto, HttpServletRequest request) {
        logger.info("create brands.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo(request);
        if(Lang.isEmpty(oauthInfoVo)){
            return new BaseResponse(false,"accessToken错误","","110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        brandDto.setStoreId(storeId);
       return providerGoodsService.createBrands(brandDto);
    }

    /**
     * 商品品牌查询列表接口
     */
    @RequestMapping(value = "/get/brands", method = RequestMethod.POST)
    public BaseResponse brands(@RequestBody BrandQueryDto brandQueryDto, HttpServletRequest request) {
        logger.info("query brands.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo(request);
        if(Lang.isEmpty(oauthInfoVo)){
            return new BaseResponse(false,"accessToken错误","","110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        brandQueryDto.setStoreId(storeId);
        return providerGoodsService.brands(brandQueryDto);
    }

    /**
     * 商品品牌删除接口
     */
    @RequestMapping(value = "/delete/brands", method = RequestMethod.POST)
    public BaseResponse deleteBrands(@RequestBody BrandDeleteQueryDto brandDeleteQueryDto) {
        logger.info("delete brands.");
        if(Lang.isEmpty(brandDeleteQueryDto)){
            return new BaseResponse(false,"accessToken错误","","110012");
        }
        return providerGoodsService.deleteBrands(brandDeleteQueryDto.getBrandId());
    }

    /**
     * 商品模型查询列表接口
     */
    @RequestMapping(value = "/get/models", method = RequestMethod.POST)
    public BaseResponse getModels(@RequestBody ProductModelQueryDto productModelQueryDto, HttpServletRequest request) {
        logger.info("get models.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo(request);
        if(Lang.isEmpty(oauthInfoVo)){
            return new BaseResponse(false,"accessToken错误","","110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        productModelQueryDto.setStoreId(storeId);
        return providerGoodsService.getModels(productModelQueryDto);
    }

    /**
     * 商品模型创建接口
     */
    @RequestMapping(value = "/create/models", method = RequestMethod.POST)
    public BaseResponse createModels(@RequestBody ProductModelDto productModelDto, HttpServletRequest request) {
        logger.info("create model.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo(request);
        if(Lang.isEmpty(oauthInfoVo)){
            return new BaseResponse(false,"accessToken错误","","110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        productModelDto.setStoreId(storeId);
        return providerGoodsService.createModels(productModelDto);
    }

    /**
     * 商品模型修改接口
     */
    @RequestMapping(value = "/modify/models", method = RequestMethod.POST)
    public BaseResponse modifyModels(@RequestBody ProductModelDto productModelDto, HttpServletRequest request) {
        logger.info("modify model.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo(request);
        if(Lang.isEmpty(oauthInfoVo)){
            return new BaseResponse(false,"accessToken错误","","110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        productModelDto.setStoreId(storeId);
        return providerGoodsService.modifyModels(productModelDto);
    }

    /**
     * 商品模型删除接口
     *
     * @param modelDeleteQueryDto
     * @return
     */
    @RequestMapping(value = "/delete/models", method = RequestMethod.POST)
    public BaseResponse deleteModels(@RequestBody ModelDeleteQueryDto modelDeleteQueryDto, HttpServletRequest request) {
        logger.info("delete model.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo(request);
        if(Lang.isEmpty(oauthInfoVo)){
            return new BaseResponse(false,"accessToken错误","","110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        modelDeleteQueryDto.setStoreId(storeId);
        return providerGoodsService.deleteModels(modelDeleteQueryDto.getModelSku(),modelDeleteQueryDto.getStoreId());
    }

    /**
     * 商品列表查询接口
     */
    @RequestMapping(value = "/get/products", method = RequestMethod.POST)
    public BaseResponse products(@RequestBody ProductQueryDto productQueryDto, HttpServletRequest request) {
        logger.info("query products.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo(request);
        if(Lang.isEmpty(oauthInfoVo)){
            return new BaseResponse(false,"accessToken错误","","110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        productQueryDto.setStoreId(storeId);
        return providerGoodsService.products(productQueryDto);
    }


    /**
     * 查询单个商品接口
     *
     * @param
     * @param request 请求
     * @return 返回值
     */
    @RequestMapping(value = "/get/product", method = RequestMethod.POST)
    public BaseResponse product(@RequestBody ProductSingleQueryDto productSingleQueryDto, HttpServletRequest request) {
        logger.info("query product.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo(request);
        if(Lang.isEmpty(oauthInfoVo)){
            return new BaseResponse(false,"accessToken错误","","110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        productSingleQueryDto.setStoreId(storeId);
        return providerGoodsService.product(productSingleQueryDto.getSku(),storeId);
    }

    /**
     * 创建商品接口
     *
     * @param providerGoodsDto
     * @return
     */
    @RequestMapping(value = "/create/product", method = RequestMethod.POST)
    public BaseResponse createProduct(@RequestBody ProviderGoodsDto providerGoodsDto, HttpServletRequest request) {
        logger.info("create product.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo(request);
        if(Lang.isEmpty(oauthInfoVo)){
            return new BaseResponse(false,"accessToken错误","","110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        providerGoodsDto.setStoreId(storeId);
        return providerGoodsService.createProduct(providerGoodsDto);
    }

    /**
     * 商品修改接口
     */
    @RequestMapping(value = "/modify/product", method = RequestMethod.POST)
    public BaseResponse updateProviderProduct(@RequestBody ProviderGoodsDto providerGoodsDto, HttpServletRequest request) {
        logger.info("modify product.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo(request);
        if(Lang.isEmpty(oauthInfoVo)){
            return new BaseResponse(false,"accessToken错误","","110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        providerGoodsDto.setStoreId(storeId);
        return providerGoodsService.updateProviderProduct(providerGoodsDto);
    }

    /**
     * 商品上下架状态变更接口
     *
     * @param updateProductStatusRequestVo
     * @return
     */
    @RequestMapping(value = "modify/products/status", method = RequestMethod.POST)
    public BaseResponse modifyProductStatus(@RequestBody UpdateProductStatusRequestVo updateProductStatusRequestVo, HttpServletRequest request) {
        logger.info("modify productStatus.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo(request);
        if(Lang.isEmpty(oauthInfoVo)){
            return new BaseResponse(false,"accessToken错误","","110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        if(Lang.isEmpty(updateProductStatusRequestVo)||Lang.isEmpty(updateProductStatusRequestVo.getUpdownStatus())||updateProductStatusRequestVo.getUpdownStatus().size()==0){
            return new BaseResponse(false,"请求参数缺失","","3001");
        }
        return providerGoodsService.modifyProductStatus(updateProductStatusRequestVo.getUpdownStatus(),storeId);
    }

    /**
     * 商品价格变更接口
     */
    @RequestMapping(value = "modify/products/price", method = RequestMethod.POST)
    public BaseResponse modifyProductPrice(@RequestBody UpdateProductPriceRequestVo updateProductPriceRequestVo, HttpServletRequest request) {
        logger.info("modify productPrice.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo(request);
        if(Lang.isEmpty(oauthInfoVo)){
            return new BaseResponse(false,"accessToken错误","","110012");
        }
        String storeId = oauthInfoVo.getProviderId();

        if(Lang.isEmpty(updateProductPriceRequestVo)||Lang.isEmpty(updateProductPriceRequestVo.getPrices())||updateProductPriceRequestVo.getPrices().size()==0){
            return new BaseResponse(false,"请求参数缺失","","3001");
        }
       return providerGoodsService.modifyProductPrice(updateProductPriceRequestVo.getPrices(),storeId);
    }

    /**
     * 商品库存变更接口
     *
     * @param updateProductStockRequestVo
     * @return
     */
    @RequestMapping(value = "modify/products/stock", method = RequestMethod.POST)
    public BaseResponse modifyProductStock(@RequestBody UpdateProductStockRequestVo updateProductStockRequestVo, HttpServletRequest request) {
        logger.info("modify productStock.");
        OauthInfoVo oauthInfoVo = ProviderInfoUtil.getProviderInfo(request);
        if(Lang.isEmpty(oauthInfoVo)){
            return new BaseResponse(false,"accessToken错误","","110012");
        }
        String storeId = oauthInfoVo.getProviderId();
        if(Lang.isEmpty(updateProductStockRequestVo)||Lang.isEmpty(updateProductStockRequestVo.getStocks())||updateProductStockRequestVo.getStocks().size()==0){
            return new BaseResponse(false,"请求参数缺失","","3001");
        }
        return providerGoodsService.modifyProductStock(updateProductStockRequestVo.getStocks(),storeId);
    }
}