package provider.api.gateway.business.good.service.impl;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.springframework.stereotype.Service;
import pool.api.ProviderAddressApi;
import provider.api.gateway.business.good.commonUtil.ConstantDictionary;
import provider.api.gateway.business.good.service.ProviderAddressApiService;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

@Service
public class ProviderAddressApiServiceImpl implements ProviderAddressApiService {

    @MotanReferer
    private ProviderAddressApi providerAddressApi;
    @Override
    public BaseResponse getProvinces() {
        String parentId = ConstantDictionary.ADDRESS_TOP_PARENT_ID;
        String levelType = ConstantDictionary.ADDRESS_LEVELTYPE_FIRST;
        return providerAddressApi.findAddressByParentIdAndLevelType(parentId,levelType);
    }
    @Override
    public BaseResponse getCitys(String province_id){
        if (Lang.isEmpty(province_id)) {
           return new BaseResponse(false, ConstantDictionary.RETURN_NULL_PARAM_ERROR_MESSAGE,"", ConstantDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
        }
        String levelType = ConstantDictionary.ADDRESS_LEVELTYPE_SECOND;
        String parentId = province_id;
        return providerAddressApi.findAddressByParentIdAndLevelType(parentId,levelType);
    }
    @Override
    public BaseResponse getCountys(String city_id) {
        if (Lang.isEmpty(city_id)) {
            return  new BaseResponse(false, ConstantDictionary.RETURN_NULL_PARAM_ERROR_MESSAGE,"", ConstantDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
        }
        String levelType = ConstantDictionary.ADDRESS_LEVELTYPE_THIRD;
        String parentId = city_id;
        return providerAddressApi.findAddressByParentIdAndLevelType(parentId,levelType);
    }
    @Override
    public BaseResponse getTowns(String county_id) {
        if (Lang.isEmpty(county_id)) {
            return  new BaseResponse(false, ConstantDictionary.RETURN_NULL_PARAM_ERROR_MESSAGE,"", ConstantDictionary.RETURN_RUNTIME_CONDITION_MISSING_CODE);
        }
        String levelType = ConstantDictionary.ADDRESS_LEVELTYPE_FOURTH;
        String parentId = county_id;
        return providerAddressApi.findAddressByParentIdAndLevelType(parentId,levelType);
    }
}
