package provider.api.gateway.business.good.service.impl;

import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import goods.api.ProductCategoryApi;
import goods.dto.product.CategoryQueryDto;
import org.springframework.stereotype.Service;
import pool.api.ProviderGoodsApi;
import pool.api.ProviderProductBrandApi;
import pool.api.ProviderProductModelApi;
import pool.dto.*;
import provider.api.gateway.business.good.service.ProviderGoodsService;
import sinomall.global.common.response.BaseResponse;

import java.util.List;

/**
 * @author wangtao.
 * @date 2018-7-1
 */
@Service
public class ProviderGoodsServiceImpl implements ProviderGoodsService {
    @MotanReferer
    private ProviderProductBrandApi productBrandApi;
    @MotanReferer
    private ProductCategoryApi productCategoryApi;
    @MotanReferer
    private ProviderProductModelApi productModelApi;
    @MotanReferer
    private ProviderGoodsApi productApi;

    @Override
    public BaseResponse categories(CategoryQueryDto categoryDto) {
        BaseResponse baseResponse = productCategoryApi.findByCategoryQuery(categoryDto);
        return baseResponse;
    }

    @Override
    public BaseResponse createBrands(BrandDto brandDto) {
        BaseResponse baseResponse;
        baseResponse = productBrandApi.saveBrand(brandDto);
        return baseResponse;
    }

    @Override
    public BaseResponse brands(BrandQueryDto brandQueryDto) {
        BaseResponse baseResponse;
        baseResponse = productBrandApi.queryBrands(brandQueryDto);
        return baseResponse;
    }

    @Override
    public BaseResponse deleteBrands(String brandId) {
        BaseResponse baseResponse;
        baseResponse = productBrandApi.deleteBrand(brandId);
        return baseResponse;
    }

    public BaseResponse getModels(ProductModelQueryDto productModelQueryDto) {
        BaseResponse baseResponse;
        baseResponse = productModelApi.queryModels(productModelQueryDto);
        return baseResponse;
    }

    public BaseResponse createModels(ProductModelDto productModelDto) {
        BaseResponse baseResponse;
        baseResponse = productModelApi.saveModel(productModelDto);
        return baseResponse;
    }

    public BaseResponse modifyModels(ProductModelDto productModelDto) {
        BaseResponse baseResponse;
        baseResponse = productModelApi.updateModel(productModelDto);
        return baseResponse;
    }

    public BaseResponse deleteModels(String modelSku, String storeId) {
        BaseResponse baseResponse;
        baseResponse = productModelApi.deleteModel(modelSku, storeId);
        return baseResponse;
    }

    public BaseResponse products(ProductQueryDto productQueryDto) {
        BaseResponse baseResponse;
        baseResponse = productApi.queryProviderGoodsPage(productQueryDto);
        return baseResponse;
    }

    public BaseResponse product(String sku, String storeId) {
        BaseResponse baseResponse;
        baseResponse = productApi.queryProviderGoods(sku, storeId);
        return baseResponse;
    }

    public BaseResponse createProduct(ProviderGoodsDto providerGoodsDto) {
        BaseResponse baseResponse;
        baseResponse = productApi.saveProviderGoods(providerGoodsDto);
        return baseResponse;
    }

    public BaseResponse updateProviderProduct(ProviderGoodsDto providerGoodsDto) {
        BaseResponse baseResponse;
        baseResponse = productApi.updateProviderGoods(providerGoodsDto);
        return baseResponse;
    }

    public BaseResponse modifyProductStatus(List<ProviderGoodsStatus> providerGoodsStatusList, String storeId) {
        BaseResponse baseResponse;
        baseResponse = productApi.modifyGoodsStatus(providerGoodsStatusList, storeId);
        return baseResponse;
    }

    public BaseResponse modifyProductPrice(List<ProviderGoodsPrice> providerGoodsPriceList, String storeId) {
        BaseResponse baseResponse;
        baseResponse = productApi.modifyGoodsPrice(providerGoodsPriceList, storeId);
        return baseResponse;
    }

    public BaseResponse modifyProductStock(List<ProviderGoodsStock> providerGoodsStockList, String storeId) {
        BaseResponse baseResponse;
        baseResponse = productApi.modifyGoodsStock(providerGoodsStockList, storeId);
        return baseResponse;
    }
}
