package provider.api.gateway.business.message.controller;

import com.alibaba.fastjson.JSON;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import provider.api.gateway.business.message.service.ProviderMessageService;
import provider.api.gateway.business.message.vo.TypeVo;
import provider.api.gateway.util.ProviderInfoUtil;
import provider.api.gateway.util.ReturnMessage;
import provider.api.gateway.vo.OauthInfoVo;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author Lans
 * @date 2018-7-3 10:40
 */

@RestController
@RequestMapping("/")
public class ProviderMessageController {

    @Autowired
    private ProviderMessageService providerMessageService;

    public static  Logger logger = LoggerFactory.getLogger(ProviderMessageController.class);

    /**
     * 删除消息接口
     * @param ids
     * @return 删除消息结果
     */
    @RequestMapping(value = "/delete/messages", method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse deleteMessages(@RequestBody List<String> ids,HttpServletRequest request) {
        OauthInfoVo providerInfo = ProviderInfoUtil.getProviderInfo(request);
        String appId = providerInfo.getAppId();
        String providerId = providerInfo.getProviderId();
        logger.info("request  appId is {} and providerId is {} and ids is {}",appId,providerId, JSON.toJSONString(ids));
        BaseResponse baseResponse = providerMessageService.deleteByIdsAndProviderId(ids,providerId);
        return baseResponse;
    }


    /**
     * 获取消息接口
     * @param type
     * @param request
     * @return 订单变更消息vo
     */
    @RequestMapping(value = "/get/messages", method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse getMessages(@RequestBody TypeVo type, HttpServletRequest request) {
        if (Lang.isEmpty(type)) {
            return new BaseResponse<>(false, ReturnMessage.PARAMS_WRONG);
        } else {
            OauthInfoVo providerInfo = ProviderInfoUtil.getProviderInfo(request);
            String appId = providerInfo.getAppId();
            String providerId = providerInfo.getProviderId();
            logger.info("request  appId is {} and providerId is {} and type is {}",appId,providerId, JSON.toJSONString(type));
            BaseResponse baseResponse = providerMessageService.getMessagesByTypeAndProvider(type.getType(), providerId);
            return baseResponse;
        }
    }


}
