package provider.api.gateway.business.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import provider.api.gateway.business.message.service.ProviderMessageService;
import provider.api.gateway.business.message.vo.ProviderMessageVo;
import provider.api.gateway.util.ReturnCode;
import provider.api.gateway.util.ReturnMessage;
import provider.message.api.ProviderMessageApi;
import provider.message.config.Const;
import provider.message.dto.ProviderMessageQueueDto;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Lans
 * @date 2018-7-3 10:44
 */
@Service
public class ProviderMessageServiceImpl implements ProviderMessageService {
    @MotanReferer
    ProviderMessageApi providerMessageApi;
    public Logger logger = LoggerFactory.getLogger(ProviderMessageServiceImpl.class);

    @Override
    public BaseResponse deleteByIds(List<String> ids) {
        if(Lang.isEmpty(ids) ){
            return new BaseResponse<>(false,ReturnMessage.PARAMS_WRONG,null,ReturnCode.PARAMS_WRONG);
        }
        if(ids.size()> Const.MESSAGE_OPEREATE_LIMIT){
            return new BaseResponse<>(false,ReturnMessage.PARAMS_LIMITED_100,null,ReturnCode.PARAMS_LIMITED_100);
        }
        int i = providerMessageApi.deleteMessagesByIds(ids);
        return new BaseResponse<>(true, String.valueOf(i) + ReturnMessage.MESSAGES_DELETED, true, ReturnMessage.SUCCESS_CODE);
    }

    @Override
    public BaseResponse deleteByIdsAndProviderId(List<String> ids, String providerId) {
        if(Lang.isEmpty(ids)||Lang.isEmpty(providerId) ){
            return new BaseResponse<>(false,ReturnMessage.PARAMS_WRONG,null,ReturnCode.PARAMS_WRONG);
        }
        if(ids.size()> Const.MESSAGE_OPEREATE_LIMIT){
            return new BaseResponse<>(false,ReturnMessage.PARAMS_LIMITED_100,null,ReturnCode.PARAMS_LIMITED_100);
        }
        int i = providerMessageApi.deleteMessageByIdsAndProviderId(ids,providerId);
        return new BaseResponse<>(true, String.valueOf(i) + ReturnMessage.MESSAGES_DELETED, true, ReturnMessage.SUCCESS_CODE);
    }

    @Override
    public BaseResponse getMessagesByType(String type, String appId, String providerId) {

        List<ProviderMessageQueueDto> pmqds = providerMessageApi.getMessagesByType(type, appId, providerId);


        if (pmqds == null) {
            return new BaseResponse<>( true,ReturnMessage.PARAMS_WRONG,null,ReturnCode.PARAMS_WRONG);
        } else {
            List<ProviderMessageVo> pmvs = new ArrayList<>();
            for (ProviderMessageQueueDto pmqd:pmqds) {
                ProviderMessageVo pmv = copyToProvderMessageVo(pmqd);
                pmvs.add(pmv);
            }
            return new BaseResponse<>(true, ReturnMessage.QUERY_SUCCESS, pmvs, ReturnMessage.SUCCESS_CODE);
        }
    }
    @Override
    public BaseResponse getMessagesByTypeAndProvider(String type,  String providerId) {

        List<ProviderMessageQueueDto> pmqds = providerMessageApi.getMessagesByTypeAndProvider(type, providerId);


        if (pmqds == null) {
            return new BaseResponse<>(true,ReturnMessage.PARAMS_WRONG,null,ReturnCode.PARAMS_WRONG);
        } else {
            List<ProviderMessageVo> pmvs = new ArrayList<>();
            for (ProviderMessageQueueDto pmqd:pmqds) {
                ProviderMessageVo pmv = copyToProvderMessageVo(pmqd);
                pmvs.add(pmv);
            }
            return new BaseResponse<>(true, ReturnMessage.QUERY_SUCCESS, pmvs, ReturnMessage.SUCCESS_CODE);
        }
    }

    private ProviderMessageVo copyToProvderMessageVo(ProviderMessageQueueDto pmqd){
        ProviderMessageVo pmv = new ProviderMessageVo();
        pmv.setMessageId(pmqd.getId());
        pmv.setMessageBody(JSON.parse(pmqd.getMessageContent()));
        pmv.setTime(pmqd.getDateCreated());
        pmv.setType(pmqd.getType());
        return pmv;

    }
}
