package provider.api.gateway.business.order.controller;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;
import provider.api.gateway.business.order.service.ProviderOrderService;
import provider.api.gateway.business.order.vo.LogisticsVo;
import provider.api.gateway.business.order.vo.OrderNoVo;
import provider.api.gateway.business.order.vo.SubOrderNoVo;
import provider.api.gateway.business.order.vo.SubOrderVo;
import provider.api.gateway.util.ProviderInfoUtil;
import provider.api.gateway.util.ReturnCode;
import provider.api.gateway.util.ReturnMessage;
import provider.api.gateway.vo.OauthInfoVo;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

/**
 * @author Lans
 * @date 2018-6-28 11:16
 */

@RestController
@RequestMapping("/")
public class ProviderOrderController {


    @Autowired
    private ProviderOrderService providerOrderService;
    public static Logger logger = LoggerFactory.getLogger(ProviderOrderController.class);
    /**
     *查询订单信息
     * @param orderNo
     * @return　订单信息Ｖｏ
     */
    @RequestMapping(value = "/get/order",method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse getOrder(@RequestBody OrderNoVo orderNo,HttpServletRequest request){

        logger.info("------------------------getOrderContollerBegin");
        if(Lang.isEmpty(orderNo)){
            return new BaseResponse<>(false, ReturnMessage.PARAMS_WRONG, ReturnCode.PARAMS_WRONG);
        }
        else {
            OauthInfoVo providerInfo = ProviderInfoUtil.getProviderInfo(request);
            String providerId = providerInfo.getProviderId();
            if(Lang.isEmpty(providerId)){
                return new BaseResponse<>(false, ReturnMessage.PARAMS_WRONG, ReturnCode.PARAMS_WRONG);
            }
            BaseResponse baseResponse = providerOrderService.getOrderDetailByOrderNo(orderNo.getOrderNo(),providerId );
            return baseResponse;
        }
    }

    /**
     * 发货回写物流信息
     * @param logisticsVo
     * @return true/false
     */
      @RequestMapping(value = "/modify/orders/logistics",method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse setOrderLogistics(@RequestBody LogisticsVo logisticsVo,HttpServletRequest request){

        if(Lang.isEmpty(logisticsVo)){
            return new BaseResponse<>(false, ReturnMessage.PARAMS_WRONG, ReturnCode.PARAMS_WRONG);
        }
        String orderNo= logisticsVo.getOrderNo();
        List<SubOrderVo> subOrderVos =  logisticsVo.getSubOrders();
          OauthInfoVo providerInfo = ProviderInfoUtil.getProviderInfo(request);
          String providerId = providerInfo.getProviderId();
          if(Lang.isEmpty(providerId)){
              return new BaseResponse<>(false, ReturnMessage.PARAMS_WRONG, ReturnCode.PARAMS_WRONG);
          }
        BaseResponse baseResponse = providerOrderService.setOrderLogistics(orderNo,subOrderVos,providerId );
        return baseResponse;
    }


    /**
     * 订单妥投
     * @param subOrderNo
     * @param request
     * @return　true/false
     */
    @RequestMapping(value = "/modify/orders/received",method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse setSubOrderReceived(@RequestBody SubOrderNoVo subOrderNo, HttpServletRequest request){

        if(Lang.isEmpty(subOrderNo)){
            return new BaseResponse<>(false, ReturnMessage.PARAMS_WRONG, ReturnCode.PARAMS_WRONG);
        }
       // String providerId = request.get
        OauthInfoVo providerInfo = ProviderInfoUtil.getProviderInfo(request);
        String providerId = providerInfo.getProviderId();
        if(Lang.isEmpty(providerId)){
            return new BaseResponse<>(false, ReturnMessage.PARAMS_WRONG, ReturnCode.PARAMS_WRONG);
        }
        BaseResponse baseResponse = providerOrderService.setSubOrderAccepted(subOrderNo.getSubOrderNo(),providerId );
        return baseResponse;
    }

    /**
     * 订单拒收
     * @param subOrderNo
     * @return true/false
     */
    @RequestMapping(value = "/modify/rejected/orders",method = RequestMethod.POST)
    @ResponseBody
    public BaseResponse setSubOrderRejected(@RequestBody SubOrderNoVo subOrderNo,HttpServletRequest request){

        if(Lang.isEmpty(subOrderNo)){
            return new BaseResponse<>(false, ReturnMessage.PARAMS_WRONG, ReturnCode.PARAMS_WRONG);
        }
        OauthInfoVo providerInfo = ProviderInfoUtil.getProviderInfo(request);
        String providerId = providerInfo.getProviderId();
        if(Lang.isEmpty(providerId)){
            return new BaseResponse<>(false, ReturnMessage.PARAMS_WRONG, ReturnCode.PARAMS_WRONG);
        }

        BaseResponse baseResponse = providerOrderService.setSubOrderRejected(subOrderNo.getSubOrderNo(),providerId );
        return baseResponse;
    }
}
