package provider.api.gateway.business.order.service.impl;


import cart.api.OrderMainApi;
import cart.api.SubOrderApi;
import cart.api.TrdSpOrderStatusApi;
import cart.api.difinication.TrdSpOrderStatus;
import cart.api.dto.order.OrderItemDto;
import cart.api.dto.order.OrderMainDto;
import cart.api.dto.order.SubOrderDto;
import cart.api.dto.order.SubOrderItemDto;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import member.api.MemberAddressApi;
import member.api.dto.shop.MemberAddressDto;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import provider.api.gateway.business.order.service.ProviderOrderService;
import provider.api.gateway.business.order.vo.*;
import cart.api.exception.BusinessException;
import provider.api.gateway.util.ReturnCode;
import provider.api.gateway.util.ReturnMessage;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

import java.util.ArrayList;
import java.util.List;

/**
 * @author Lans
 * @date 2018-6-27 17:23
 */

@Service
public class ProviderOrderServiceImpl implements ProviderOrderService {
    @MotanReferer
    private OrderMainApi orderMainApi;
    @MotanReferer
    private MemberAddressApi memberAddressApi;
    @MotanReferer
    private SubOrderApi subOrderApi;
    @MotanReferer
    private TrdSpOrderStatusApi trdSpOrderStatusApi;

    public static Logger logger = LoggerFactory.getLogger(ProviderOrderServiceImpl.class);


    @Override
    public BaseResponse getOrderDetailByOrderNo(String orderNo, String providerId) {

        OrderMainDto orderMainDto;

        if (Lang.isEmpty(orderNo)) {
            //return wrong params
            return new BaseResponse<>(false, ReturnMessage.PARAMS_WRONG, null,ReturnCode.PARAMS_WRONG);

        } else {
            logger.info("=====================查询订单信息接口被调用，对方请求参数orderNo:{},providerId{})",orderNo,providerId);

            orderMainDto = orderMainApi.findByOrderNoAndProviderId(orderNo,providerId);
            if (Lang.isEmpty(orderMainDto)) {
                //未找到主订单
                return new BaseResponse<>(false, ReturnMessage.ORDER_MAIN_CANNOT_FIND, null,ReturnCode.CANNOT_FIND_ORDERMAIN);
            } else {
                List<OrderItemDto> orderItemDtos = new ArrayList<>();
                String AddressId = "";
                MemberAddressDto memberAddressDto = new MemberAddressDto();
                MemberAddressVo memberAddressVo = new MemberAddressVo();
                OrderVo orderVo = new OrderVo();

                // orderItemDtos = orderService.findByOrderId(orderMain.getId());
                orderItemDtos = orderMainDto.getOrderItems();
                List<OrderItemVo> orderItemVos = new ArrayList<>();
                OrderItemVo tempItemVo = new OrderItemVo();

                for (OrderItemDto orderItem : orderItemDtos
                        ) {
                    tempItemVo.setSku(orderItem.getSku());
                    tempItemVo.setCostPrice(orderItem.getCostPrice());
                    tempItemVo.setCount(orderItem.getCount());
                    tempItemVo.setName(orderItem.getProductName());
                    orderItemVos.add(tempItemVo);
                }
                AddressId = orderMainApi.findAddressIdByOrderNo(orderNo);
                memberAddressDto = memberAddressApi.findById(AddressId);
                memberAddressVo = copyAddressVo(memberAddressDto);
                orderVo.setCreateTime( orderMainDto.getCreateTime());
                orderVo.setFreight(orderMainDto.getFreight());
                orderVo.setMemberAddress(memberAddressVo);
                orderVo.setOrderItems(orderItemVos);
                orderVo.setOrderNo(orderNo);
                orderVo.setPrice(orderMainDto.getOrderPrice());
                orderVo.setStatus(orderMainDto.getStatus());
                orderVo.setSumPrice(orderMainDto.getSumPrice());

                logger.info("=====================查询订单信息接口返回，响应参数:{})", JSON.toJSONString(orderVo,SerializerFeature.WriteMapNullValue));
                return new BaseResponse<>(true, ReturnMessage.QUERY_SUCCESS, orderVo);
            }


        }

    }


    //保存拆单信息和物流
    @Override
    public BaseResponse setOrderLogistics(String orderNo, List<SubOrderVo> subOrders, String providerId) {
        //如果没有拆单，suborderNo即为第trdOrderNo，相当于主订单只拆了一单。
        //如果二次（二次以上）拆单，删除原有子订单信息，以最后一次为准.但已妥投的订单不再拆单
        Boolean result = false;
//        OrderMainDto omd = orderMainApi.findOrderByThirdOrderNoAndProviderId(orderNo,providerId);
        OrderMainDto omd = orderMainApi.findByOrderNoAndProviderId(orderNo,providerId);

        if (Lang.isEmpty(omd)) {
            //找不到主订单
            return new BaseResponse<>(false, ReturnMessage.ORDER_MAIN_CANNOT_FIND, result,ReturnCode.ORDER_MAIN_CANNOT_FIND);
        }
        //判断如果主订单已经是妥投的，拒绝二次拆单。否则删除原有子订单，进行二次拆单。
        else if (TrdSpOrderStatus.Received.getCode().equalsIgnoreCase(omd.getTrdSpStatus())) {
            logger.error("已妥投的主订单{}不允许二次拆单",omd.getOrderNo());
            return new BaseResponse<>(false, ReturnMessage.ORDER_DIVIDE_AGAIN, result,ReturnCode.STATE_ERROR);
        } else {
            //删除之前的suborder信息
            subOrderApi.deleteSubOrdersByOrderMainId(omd.getId());
            //保存suborders
            for (SubOrderVo sov : subOrders
                    ) {
                SubOrderDto sod = new SubOrderDto();
                //bean 拷贝SubOrderVo->SubOrderDto
                sod = copyToSubOderDto(sov);
                //将subOrder置为已发货状态
                sod.setTrdOrderState(TrdSpOrderStatus.Sent.getCode());
               // sod.setTrdOrderState(TrdSpOrderStatus.Sent.getCode());
                //保存到sub_orders表,同时级联保存到sub_order_items表
                subOrderApi.saveSubOrder(sod, omd.getId());
            }
        }
        result = true;
        return new BaseResponse<>(true, ReturnMessage.ORDER_SENT_WRITEBACK, result, ReturnMessage.SUCCESS_CODE);
    }


    @Override
    public BaseResponse setSubOrderAccepted(String subOrderNo, String providerId) {
        try {
            subOrderApi.setSubOrderAccepted(subOrderNo,providerId);
        } catch (BusinessException e) {
            return new BaseResponse<>(false, e.getMessage());

        } catch (Exception e) {
            e.printStackTrace();
            return new BaseResponse<>(false, ReturnMessage.NETWORK_ERROR, null,ReturnCode.UNKNOWN_ERROR);
        }
        return new BaseResponse<>(true, ReturnMessage.ORDER_ACCETED_WRITEBACK, true, ReturnMessage.SUCCESS_CODE);
    }

    @Override
    public BaseResponse setSubOrderRejected(String subOrderNo, String providerId) {
        try {
            subOrderApi.setSubOrderRejected(subOrderNo,providerId);
        } catch (BusinessException e) {
            return new BaseResponse<>(false, e.getMessage());
        } catch (Exception e) {
            e.printStackTrace();
            return new BaseResponse<>(false, ReturnMessage.NETWORK_ERROR,null,ReturnCode.UNKNOWN_ERROR);
        }
        return new BaseResponse<>(true, ReturnMessage.ORDER_REJECTED_WRITEBACK, true, ReturnMessage.SUCCESS_CODE);
    }

    private MemberAddressVo copyAddressVo(MemberAddressDto mad) {
        MemberAddressVo mav = new MemberAddressVo();
        mav.setReceiverName(mad.getUsername());
        mav.setReceiverPhone(mad.getPhone());
        mav.setReceiverAddressDetails(mad.getAddressDetail());
        mav.setReceiverCounty(mad.getAreaCode());
        mav.setReceiverCountyCode(mad.getAreaCode());
        mav.setReceiverCtiy(mad.getCityName());
        mav.setReceiverCityCode(mad.getCityCode());
        mav.setReceiverProvince(mad.getProvinceName());
        mav.setReceiverProvinceCode(mad.getPostCode());
        mav.setReceivertown(mad.getTownName());
        mav.setReceivertownCode(mad.getTownCode());
        return mav;
    }

    private SubOrderDto copyToSubOderDto(SubOrderVo sov) {
        SubOrderDto sod = new SubOrderDto();
        sod.setLogisticsNo(sov.getLogisticsNo());
        sod.setSubOrderNo(sov.getSubOrderNo());
        List<SubOrderItemVo> subOderItemVos = sov.getSubOrderItems();
        List<SubOrderItemDto> subOderItemDtos = new ArrayList<SubOrderItemDto>();
        for (SubOrderItemVo soiv : subOderItemVos
                ) {
            SubOrderItemDto subOrderItemDto = new SubOrderItemDto();
            subOrderItemDto.setCount(soiv.getCount());
            subOrderItemDto.setSkuId(soiv.getSku());
            subOrderItemDto.setName(soiv.getName());
            subOderItemDtos.add(subOrderItemDto);
        }
        sod.setSubOrderItems(subOderItemDtos);
        return sod;
    }

}
