package provider.api.gateway.business.order.service.impl;

import cart.api.OrderMainApi;
import cart.api.dto.order.OrderMainDto;
import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import provider.api.gateway.business.order.service.TestMessageService;
import provider.api.gateway.business.order.vo.TestResponseVo;
import provider.message.api.TestProviderApi;
import provider.message.dto.TestResponseDto;
import provider.message.query.TestMessageQuery;

import javax.annotation.PostConstruct;
import java.math.BigDecimal;

/**
 * @author torvalds on 2018/6/27 14:46.
 * @version 1.0
 */
@Service
public class TestMessageServiceImpl implements TestMessageService {
    @MotanReferer
    TestProviderApi testProviderApi;
    private final static Logger logger = LoggerFactory.getLogger(TestMessageServiceImpl.class);
    @MotanReferer
    OrderMainApi orderMainApi;

    @Override
    public TestResponseVo testMessage(String message) {
        TestMessageQuery testMessageQuery = new TestMessageQuery();
        testMessageQuery.setMessage(message);
        testMessageQuery.setScore(new BigDecimal(100));
//        TestResponseDto testResponseDto = testProviderApi.testMessage(testMessageQuery);
        TestResponseDto testResponseDto=new TestResponseDto();
        testResponseDto.setRespMessage("response message");
        logger.info("===========testResponseDto={}", JSON.toJSONString(testResponseDto));
        TestResponseVo testResponseVo = new TestResponseVo();
        testResponseVo.setRespMessage(testResponseDto.getRespMessage());
        return testResponseVo;
    }
    @Override
    public String testOrderApi() {
        OrderMainDto byOrderNo = orderMainApi.findByOrderNo("0000000");
        return null;
    }


}
