package provider.api.gateway.config;

import com.security.exception.Oauth2ExceptionTranslator;
import com.security.oauthfilter.Oauth2AccessDeniedExceptionFilter;
//import com.security.oauthfilter.Oauth2ApiRequestTimeValidateFilter;
import com.security.oauthfilter.Oauth2ApiRequestTimeValidateFilter;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Configuration;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.config.annotation.web.builders.HttpSecurity;
import org.springframework.security.oauth2.config.annotation.web.configuration.EnableResourceServer;
import org.springframework.security.oauth2.config.annotation.web.configuration.ResourceServerConfigurerAdapter;
import org.springframework.security.oauth2.config.annotation.web.configurers.ResourceServerSecurityConfigurer;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import org.springframework.security.web.access.ExceptionTranslationFilter;
import provider.api.gateway.filter.ProviderInfoWapperFilter;

/**
 * Created by 陈圣融 on 2017-07-23.
 */
@Configuration
@EnableResourceServer
public class ResourceServerConfiguration extends ResourceServerConfigurerAdapter {


    @Autowired
    RedisTemplate redisTemplate;
    @Autowired
    ClientDetailsService clientDetailsService;

    @Override
    public void configure(HttpSecurity http) throws Exception {

        http
                .csrf().disable()
                .requestMatchers().anyRequest().and()  //拦截url
                .authorizeRequests()
                .antMatchers("/favicon.ico", "/error").permitAll()
                .antMatchers("/**").access("#oauth2.hasScope('provider_api')")  //配置权限
                .anyRequest().access("#oauth2.hasScope('admin')").and()
                .addFilterAfter(new Oauth2ApiRequestTimeValidateFilter(), ExceptionTranslationFilter.class)
                .addFilterAfter(new Oauth2AccessDeniedExceptionFilter(), ExceptionTranslationFilter.class)
                .addFilterBefore(providerInfoWapperFilter(), ExceptionTranslationFilter.class);
    }

    @Override
    public void configure(ResourceServerSecurityConfigurer resources) throws Exception {
        resources
                .authenticationEntryPoint(new Oauth2ExceptionTranslator());
//                .tokenExtractor(new Oauth2BearerTokenExtractor());
    }

    public ProviderInfoWapperFilter providerInfoWapperFilter() {
        ProviderInfoWapperFilter providerInfoWapperFilter = new ProviderInfoWapperFilter();
        providerInfoWapperFilter.setRedisTemplate(redisTemplate);
        providerInfoWapperFilter.setClientDetailsService(clientDetailsService);
        return providerInfoWapperFilter;
    }

}
