/*
 * Decompiled with CFR 0.152.
 */
package provider.api.gateway.business.message.service.impl;

import com.alibaba.fastjson.JSON;
import com.weibo.api.motan.config.springsupport.annotation.MotanReferer;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import provider.api.gateway.business.message.service.ProviderMessageService;
import provider.api.gateway.business.message.vo.ProviderMessageVo;
import provider.message.api.ProviderMessageApi;
import provider.message.config.Const;
import provider.message.dto.ProviderMessageQueueDto;
import sinomall.global.common.response.BaseResponse;
import utils.Lang;

@Service
public class ProviderMessageServiceImpl
implements ProviderMessageService {
    @MotanReferer
    ProviderMessageApi providerMessageApi;
    public Logger logger = LoggerFactory.getLogger(ProviderMessageServiceImpl.class);

    public BaseResponse deleteByIds(List<String> ids) {
        if (Lang.isEmpty(ids)) {
            return new BaseResponse(false, "\u53c2\u6570\u9519\u8bef", null, "3001");
        }
        if (ids.size() > Const.MESSAGE_OPEREATE_LIMIT) {
            return new BaseResponse(false, "\u53c2\u6570\u9519\u8bef,\u4e0d\u80fd\u8d85\u8fc7100\u6761", null, "3002");
        }
        int i = this.providerMessageApi.deleteMessagesByIds(ids);
        return new BaseResponse(true, String.valueOf(i) + "\u6761\u6d88\u606f\u5220\u9664\u6210\u529f", (Object)true, "0000");
    }

    public BaseResponse deleteByIdsAndProviderId(List<String> ids, String providerId) {
        if (Lang.isEmpty(ids) || Lang.isEmpty((Object)providerId)) {
            return new BaseResponse(false, "\u53c2\u6570\u9519\u8bef", null, "3001");
        }
        if (ids.size() > Const.MESSAGE_OPEREATE_LIMIT) {
            return new BaseResponse(false, "\u53c2\u6570\u9519\u8bef,\u4e0d\u80fd\u8d85\u8fc7100\u6761", null, "3002");
        }
        int i = this.providerMessageApi.deleteMessageByIdsAndProviderId(ids, providerId);
        return new BaseResponse(true, String.valueOf(i) + "\u6761\u6d88\u606f\u5220\u9664\u6210\u529f", (Object)true, "0000");
    }

    public BaseResponse getMessagesByType(String type, String appId, String providerId) {
        List pmqds = this.providerMessageApi.getMessagesByType(type, appId, providerId);
        if (pmqds == null) {
            return new BaseResponse(true, "\u53c2\u6570\u9519\u8bef", null, "3001");
        }
        ArrayList<ProviderMessageVo> pmvs = new ArrayList<ProviderMessageVo>();
        for (ProviderMessageQueueDto pmqd : pmqds) {
            ProviderMessageVo pmv = this.copyToProvderMessageVo(pmqd);
            pmvs.add(pmv);
        }
        return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", pmvs, "0000");
    }

    public BaseResponse getMessagesByTypeAndProvider(String type, String providerId) {
        List pmqds = this.providerMessageApi.getMessagesByTypeAndProvider(type, providerId);
        if (pmqds == null) {
            return new BaseResponse(true, "\u53c2\u6570\u9519\u8bef", null, "3001");
        }
        ArrayList<ProviderMessageVo> pmvs = new ArrayList<ProviderMessageVo>();
        for (ProviderMessageQueueDto pmqd : pmqds) {
            ProviderMessageVo pmv = this.copyToProvderMessageVo(pmqd);
            pmvs.add(pmv);
        }
        return new BaseResponse(true, "\u67e5\u8be2\u6210\u529f", pmvs, "0000");
    }

    private ProviderMessageVo copyToProvderMessageVo(ProviderMessageQueueDto pmqd) {
        ProviderMessageVo pmv = new ProviderMessageVo();
        pmv.setMessageId(pmqd.getId());
        pmv.setMessageBody(JSON.parse((String)pmqd.getMessageContent()));
        pmv.setTime(pmqd.getDateCreated());
        pmv.setType(pmqd.getType());
        return pmv;
    }
}

