/*
 * Decompiled with CFR 0.152.
 */
package provider.api.gateway.config;

import com.alibaba.fastjson.JSON;
import java.util.Arrays;
import java.util.List;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

@Component
@Aspect
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);

    @Pointcut(value="execution(* provider.api.gateway.business.*.controller.*.*(..))")
    public void callTpApi() {
    }

    @Around(value="callTpApi()")
    public Object showLog(ProceedingJoinPoint point) {
        Object[] args = point.getArgs();
        String storeId = "unknown";
        List<Object> asList = Arrays.asList(args);
        Signature signature = point.getSignature();
        String name = signature.getName();
        Object result = null;
        try {
            log.info("---store--{}-{}-{}\u65b9\u6cd5\u8c03\u7528\u5f00\u59cb\uff0c\u53c2\u6570\u4e3a{}", new Object[]{storeId, signature.getDeclaringTypeName(), name, asList});
            result = point.proceed(args);
            log.info("---store--{}-{}-{}\u65b9\u6cd5\u8fd4\u56de\u503c\u4e3a{}", new Object[]{storeId, signature.getDeclaringTypeName(), name, JSON.toJSON((Object)result)});
        }
        catch (Throwable e) {
            log.info("---store--{}-{}-{}\u65b9\u6cd5\u51fa\u5f02\u5e38\u4e86\uff0c\u5f02\u5e38\u5bf9\u8c61{}", new Object[]{signature.getDeclaringTypeName(), storeId, name, e});
            throw new RuntimeException(e.getMessage());
        }
        return result;
    }
}

