/*
 * Decompiled with CFR 0.152.
 */
package provider.api.gateway.filter;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundValueOperations;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.security.access.AccessDeniedException;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.User;
import org.springframework.security.oauth2.provider.ClientDetails;
import org.springframework.security.oauth2.provider.ClientDetailsService;
import provider.api.gateway.filter.ProviderRequestInfoWrapper;

public class ProviderInfoWapperFilter
implements Filter {
    private static final Logger logger = LoggerFactory.getLogger(ProviderInfoWapperFilter.class);
    RedisTemplate redisTemplate;
    ClientDetailsService clientDetailsService;
    private static final String OAUTH_INFO_PROVIDER_ID_REDIS_KEY = "MALL-PROVIDER-API-GATEWAY:OAUTH_INFO_PROVIDER_ID_REDIS_KEY";

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse servletResponse, FilterChain filterChain) throws IOException, ServletException {
        Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
        if (authentication == null) {
            logger.error("\u8ba4\u8bc1\u4fe1\u606f\u4e3a\u7a7a");
            throw new AccessDeniedException("\u8ba4\u8bc1\u4fe1\u606f\u4e3a\u7a7a");
        }
        User principal = (User)authentication.getPrincipal();
        BoundValueOperations boundValueOperations = this.redisTemplate.boundValueOps((Object)("MALL-PROVIDER-API-GATEWAY:OAUTH_INFO_PROVIDER_ID_REDIS_KEY:" + principal.getUsername()));
        String providerId = null;
        if (boundValueOperations.get() != null) {
            providerId = String.valueOf(boundValueOperations.get());
        } else {
            ClientDetails clientDetails = this.clientDetailsService.loadClientByClientId(principal.getUsername());
            Object providerIdObj = clientDetails.getAdditionalInformation().get("providerId");
            if (providerIdObj != null) {
                providerId = String.valueOf(providerIdObj);
            }
            boundValueOperations.set((Object)providerId, 1L, TimeUnit.DAYS);
        }
        ProviderRequestInfoWrapper providerRequestInfoWrapper = new ProviderRequestInfoWrapper((HttpServletRequest)servletRequest);
        providerRequestInfoWrapper.setAppId(principal.getUsername());
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{providerId})) {
            providerRequestInfoWrapper.setProviderId(providerId);
        }
        filterChain.doFilter((ServletRequest)providerRequestInfoWrapper, servletResponse);
    }

    public void destroy() {
    }

    public RedisTemplate getRedisTemplate() {
        return this.redisTemplate;
    }

    public void setRedisTemplate(RedisTemplate redisTemplate) {
        this.redisTemplate = redisTemplate;
    }

    public ClientDetailsService getClientDetailsService() {
        return this.clientDetailsService;
    }

    public void setClientDetailsService(ClientDetailsService clientDetailsService) {
        this.clientDetailsService = clientDetailsService;
    }
}

