package provider.message.model.po;

import org.hibernate.annotations.GenericGenerator;
import provider.message.model.po.base.BaseDomain;

import javax.persistence.*;
import java.io.Serializable;
import java.util.Objects;

/**
 * @author Lans
 * @date 2018-7-2 15:04
 */
@Entity
@Table
public class ProviderMessageQueue extends BaseDomain implements Serializable {
    private String id;
    private String providerId;
    private String businessNo;
    private String type;
    private String typeDescription;
    private String appId;
    private String messageContent;

    @Id
    @GenericGenerator(name = "PKUUID", strategy = "uuid2")
    @GeneratedValue(generator = "PKUUID")
    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id;
    }

    @Basic
    @Column(name = "PROVIDER_ID", nullable = true, length = 36)
    public String getProviderId() {
        return providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    @Basic
    @Column(name = "BUSINESS_NO", nullable = true, length = 255)
    public String getBusinessNo() {
        return businessNo;
    }

    public void setBusinessNo(String businessNo) {
        this.businessNo = businessNo;
    }

    @Basic
    @Column(name = "TYPE", nullable = true, length = 50)
    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    @Basic
    @Column(name = "TYPE_DESCRIPTION", nullable = true, length = 255)
    public String getTypeDescription() {
        return typeDescription;
    }

    public void setTypeDescription(String typeDescription) {
        this.typeDescription = typeDescription;
    }

    @Basic
    @Column(name = "APP_ID", nullable = true, length = 255)
    public String getAppId() {
        return appId;
    }

    public void setAppId(String appId) {
        this.appId = appId;
    }

    @Basic
    @Column(name = "MESSAGE_CONTENT", nullable = true)
    public String getMessageContent() {
        return messageContent;
    }

    public void setMessageContent(String messageContent) {
        this.messageContent = messageContent;
    }



    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (o == null || getClass() != o.getClass()) return false;
        ProviderMessageQueue that = (ProviderMessageQueue) o;
        return Objects.equals(id, that.id) &&
                Objects.equals(providerId, that.providerId) &&
                Objects.equals(businessNo, that.businessNo) &&
                Objects.equals(type, that.type) &&
                Objects.equals(typeDescription, that.typeDescription) &&
                Objects.equals(appId, that.appId) &&
                Objects.equals(messageContent, that.messageContent);

    }

    @Override
    public int hashCode() {

        return Objects.hash(id, providerId, businessNo, type, typeDescription, appId, messageContent);
    }
}
