package provider.message.model.repository;

import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.transaction.annotation.Transactional;
import provider.message.model.po.ProviderMessageQueue;

import java.util.List;

/**
 * @author Lans
 * @date 2018-7-2 15:45
 */
public interface ProviderMessageQueueRepos extends JpaRepository<ProviderMessageQueue,String> {
     @Transactional
     @Modifying()
    int deleteByIdIn(List<String> ids);

    @Transactional
    @Modifying()
    int deleteByIdInAndProviderId(List<String> ids,String providerId);


    @Query("select t from ProviderMessageQueue t where t.type=?1 and t.appId=?2 and t.providerId=?3 and ROWNUM<=100")
    List<ProviderMessageQueue> findByTypeAndAppIdAndProviderId(String type,String appId,String providerId);

    @Query("select t from ProviderMessageQueue t where t.type=?1  and t.providerId=?2 and ROWNUM<=100")
    List<ProviderMessageQueue> findByTypeAndProviderId(String type,String providerId);

/*
    @Query(value="update SUB_ORDER t set t.TRD_SP_STATE =?1 ,t.LAST_UPDATED=?3 , t.TRD_ORDER_STATE=?4 where t.ORDER_ID in ( ?2 )",nativeQuery = true)
    @Transactional()
    @Modifying()
    int batchUpdateSubOrderStatusByOrderIds(String status, List<String> ids, Date lastUpdated, String trdOrderState);

*/


    @Query(value = "insert into PROVIDER_OBSOLETE_MES_QUEUE (ID,PROVIDER_ID,BUSINESS_NO,TYPE,TYPE_DESCRIPTION,APP_ID,MESSAGE_CONTENT) select ID,PROVIDER_ID,BUSINESS_NO,TYPE,TYPE_DESCRIPTION,APP_ID,MESSAGE_CONTENT from PROVIDER_MESSAGE_QUEUE q where q.ID in (?1)",nativeQuery = true)
    @Modifying
    @Transactional
   int batchInsertByIds(List<String> ids);

        @Query(value = "insert into PROVIDER_OBSOLETE_MES_QUEUE (ID,PROVIDER_ID,BUSINESS_NO,TYPE,TYPE_DESCRIPTION,APP_ID,MESSAGE_CONTENT) select ID,PROVIDER_ID,BUSINESS_NO,TYPE,TYPE_DESCRIPTION,APP_ID,MESSAGE_CONTENT from PROVIDER_MESSAGE_QUEUE q where q.ID in (?1) and q.PROVIDER_ID=?2",nativeQuery = true)
    @Modifying
    @Transactional
    int batchInsertByIdsAndProviderId(List<String> ids,String providerId);

}
