package provider.message.service.apiimpl;

import com.weibo.api.motan.config.springsupport.annotation.MotanService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import provider.message.api.ProviderMessageApi;
import provider.message.dto.ProviderMessageQueueDto;
import provider.message.service.service.ProviderMessageService;

import java.util.List;


/**
 * @author Lans
 * @date 2018-7-3 10:21
 */
@MotanService
public class ProviderMessageApiImpl implements ProviderMessageApi {
    @Autowired
    private ProviderMessageService providerMessageService;



    private static Logger logger=LoggerFactory.getLogger(ProviderMessageApiImpl.class);
    @Override
    public List<ProviderMessageQueueDto> getMessagesByType(String type, String appId, String providerId) {

       return  providerMessageService.getMessagesByType(type,appId,providerId);
    }

    @Override
    public List<ProviderMessageQueueDto> getMessagesByTypeAndProvider(String type, String providerId) {

        return  providerMessageService.getMessagesByTypeAndProvider(type,providerId);
    }

    @Override
    public int deleteMessagesByIds(List<String> ids) {

      return providerMessageService.deleteMessagesByIds(ids) ;

    }

    @Override
    public int deleteMessageByIdsAndProviderId(List<String> ids, String providerId) {
        return providerMessageService.deleteMessagesByIdsAndProviderId(ids,providerId);
    }

    @Override
    public void saveMessage(ProviderMessageQueueDto providerMessageQueueDto) {
        providerMessageService.saveMessage(providerMessageQueueDto);
    }

//    private ProviderObsoleteMesQueue copyToProviderObsoleteMesQueue(ProviderMessageQueue pmq){
//        ProviderObsoleteMesQueue pomq= new ProviderObsoleteMesQueue();
//        pomq.setAppId(pmq.getAppId());
//        pomq.setBusinessNo(pmq.getBusinessNo());
//        pomq.setId(pmq.getId());
//        pomq.setMessageContent(pmq.getMessageContent());
//        pomq.setProviderId(pmq.getProviderId());
//        pomq.setType(pmq.getType());
//        pomq.setTypeDescription(pmq.getTypeDescription());
//        return  pomq;
//    }
}
